/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.webmanager.utils;

import java.io.File;
import java.io.FileWriter;
import java.util.Calendar;

/**
 * Quelques fonctions utiles pour les mise  jour
 */
public class ToolsMAJ {

	/**
	 * Type de mise  jour
	 */
	public static final int TYPE_UPLOAD_COMMANDES = 0;

	/**
	 * Type de mise  jour
	 */
	public static final int TYPE_MAJ_ARTICLES = 1;

	/**
	 * Type de mise  jour
	 */
	public static final int TYPE_MAJ_PRIX = 2;

	/**
	 * Type de mise  jour
	 */
	public static final int TYPE_MAJ_STOCKS = 3;

	/**
	 * Type de mise  jour
	 */
	public static final int TYPE_MAJ_INFO = 4;

	/**
	 * Type de mise  jour
	 */
	public static final int TYPE_UPLOAD_ART = 5;

	/**
	 * Type de mise  jour
	 */
	public static final int TYPE_MAJ_STATUT = 6;

	public static final int TYPE_MAJ_FACTU = 7;

	public static final int TYPE_UPLOAD_CLIENTS = 8;

	/**
	 * 
	 * @param type_service
	 * @param dossier_id
	 * @param site_id
	 * @return
	 */
	public static String getNomService(String type_service, String dossier_id, String site_id) {
		return type_service + "_" + dossier_id + "_s" + site_id;
	}

	/**
	 * 
	 * @param dossier_id
	 * @param site_id
	 * @return
	 */
	public static String getNomGroupeService(String dossier_id, String site_id) {
		return dossier_id + "_s" + site_id;
	}

	/**
	 * 
	 * @param type_maj
	 * @return
	 */
	public static String getCodeMaj(int type_maj) {

		if (type_maj == ToolsMAJ.TYPE_UPLOAD_COMMANDES) {
			return "COM";
		}
		else if (type_maj == ToolsMAJ.TYPE_UPLOAD_CLIENTS) {
			return "CLI";
		}
		else if (type_maj == ToolsMAJ.TYPE_MAJ_PRIX) {
			return "PRIX";
		}
		else if (type_maj == ToolsMAJ.TYPE_MAJ_STOCKS) {
			return "STOCK";
		}
		else if (type_maj == ToolsMAJ.TYPE_MAJ_INFO) {
			return "INFO";
		}
		else if (type_maj == ToolsMAJ.TYPE_MAJ_STATUT) {
			return "STAT";
		}
		else {
			return ( type_maj == ToolsMAJ.TYPE_MAJ_FACTU ) ? "FACTU" : null;
		}
	}
	public static String sqlEncode(String s) {
		return s.replaceAll("'", "''");
	}
	
	public static void ecrireLog(File file, String type,String log) {
		try {
			Calendar calendar = Calendar.getInstance();

			FileWriter fichier = new FileWriter(file, true);
			fichier.write('\n'+'\n'+calendar.getTimeInMillis() +" : " + calendar.getTime().toString());
			fichier.write('\n'+type +" : " + log);
			fichier.close();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	public static String convertirJour(String jour)
	{
		if(jour.equals("lun"))
		{
			return "MON";
		}
		else if(jour.equals("mar"))
		{
			return "TUE";
		}
		else if(jour.equals("mer"))
		{
			return "WED";
		}
		else if(jour.equals("jeu"))
		{
			return "THU";
		}
		else if(jour.equals("ven"))
		{
			return "FRI";
		}
		else if(jour.equals("sam"))
		{
			return "SAT";
		}
		else {
			return ( jour.equals("dim") ) ? "SUN" : null;
		}
	}
}
