package org.opensi.webmanager.utils;

/**
 * Permet de rcuprer les informations du rapport retourn par le service
 */

import java.util.Vector;

/**
 * Fusionne les diffrents rapports, et les parcours comme si il y en avait un
 * seul
 */
public class MultiRapports {

	/* ******* Constantes de russite ********** */

	// SQL
	/**
	 * Connection au serveur russie
	 */
	public final int CONNEXION_SERVEUR_BASE_OK = 10;

	/**
	 * Connection a la BD russie
	 */
	public final int CONNEXION_BASE_OK = 11;

	/**
	 * Insertion russie
	 */
	public final int INSERT_OK = 12;

	/**
	 * mise a jour russie
	 */
	public final int UPDATE_OK = 13;

	/**
	 * Suppression russie
	 */
	public final int DELETE_OK = 14;

	/**
	 * Selection russie
	 */
	public final int SELECT_OK = 15;

	/**
	 * Autre russite
	 */
	public final int AUTRE_OK = 0;

	/* ******** Constante d'echec *********** */
	// SQL
	/**
	 * Connection au serveur choue
	 */
	public final int CONNEXION_SERVEUR_BASE_KO = 110;

	/**
	 * Connection  la BD choue
	 */
	public final int CONNEXION_BASE_KO = 111;

	/**
	 * Insertion choue
	 */
	public final int INSERT_KO = 112;

	/**
	 * Mise  jour choue
	 */
	public final int UPDATE_KO = 113;

	/**
	 * Suppression choue
	 */
	public final int DELETE_KO = 114;

	/**
	 * Selection choue
	 */
	public final int SELECT_KO = 115;

	/**
	 * Autre echec
	 */
	public final int AUTRE_KO = 200;

	Vector<Object[]> tousRapports;

	int tailleTotale;

	int parcourantGlobal;

	int parcourantRapport;

	int indexRapportEnCours;

	Object[] rapportEnCours;

	/**
	 * Constructeur
	 */
	public MultiRapports() {
		// ////System.out.println("[MultiRapports] constructeur");
		tousRapports = new Vector<Object[]>();
		tailleTotale = 0;
		parcourantGlobal = -1;
		parcourantRapport = -1;
		indexRapportEnCours = 0;
	}

	/**
	 * 
	 * @param lerapport
	 */
	public void addRapport(Object[] lerapport) {
		// System.out.println("[MultiRapports] addRapport");
		tailleTotale += lerapport.length;
		tousRapports.add(lerapport);

		rapportEnCours = tousRapports.elementAt(0);
	}

	/**
	 * 
	 * @return
	 */
	public boolean next() {
		// System.out.println("[MultiRapports] next");

		if (tailleTotale == 0) {
			return false;
		}
		parcourantGlobal++;
		parcourantRapport++;

		if (parcourantRapport >= rapportEnCours.length && parcourantGlobal < tailleTotale) {
			indexRapportEnCours++;
			parcourantRapport = 0;

			rapportEnCours = tousRapports.elementAt(indexRapportEnCours);
		}

		return parcourantGlobal < tailleTotale;

	}

	/**
	 * 
	 * @return
	 */
	public boolean aReussi() {
		// System.out.println("[MultiRapports] aReussi");
		Object[] contenu = (Object[]) rapportEnCours[parcourantRapport];
		int code = Integer.parseInt("" + contenu[0]);
		return (code < 100);
	}

	/**
	 * Donne la source de la ligne du rapport
	 * 
	 * @param num_de_ligne
	 *          numro de ligne du rapport
	 * @return l'objet  la source de la cration de cette ligne de rapport
	 */
	public String getSource() {
		// System.out.println("[MultiRapports] getSource");
		Object[] contenu = (Object[]) rapportEnCours[parcourantRapport];
		return "" + contenu[1];
	}

	/**
	 * Donne des dtails sur la russite ou l'echec
	 * 
	 * @param num_de_ligne
	 *          numro de ligne concerne
	 * @return le commentaire associ  cette ligne
	 */
	public String getCommentaire() {
		// System.out.println("[MultiRapports] getCommentaire");

		Object[] contenu = (Object[]) rapportEnCours[parcourantRapport];
		return "" + contenu[2];
	}

	/**
	 * Donne un message humainement comprehensible
	 * 
	 * @param num_de_ligne
	 *          numro de ligne concerne
	 * @return le message
	 */
	public String getMessageUtilisateur() {
		// System.out.println("[MultiRapports] getMessageUtilisateur");

		Object[] contenu = (Object[]) rapportEnCours[parcourantRapport];
		int code = Integer.parseInt("" + contenu[0]);
		String source = "" + contenu[1];

		switch (code) {
			/* les russites */
			case CONNEXION_SERVEUR_BASE_OK:
				return "Connexion au serveur de la base de donne '" + source + "' russie";

			case CONNEXION_BASE_OK:
				return "Connexion  la base de donne '" + source + "' russie";

			case INSERT_OK:
				return "Insertion de '" + source + "' russie";

			case UPDATE_OK:
				return "Modification de '" + source + "' russie";

			case DELETE_OK:
				return "Suppression de '" + source + "' russie";

			case SELECT_OK:
				return "Lecture de '" + source + "' russie";

				/* Les echecs */
			case CONNEXION_SERVEUR_BASE_KO:
				return "Connexion au serveur de la base de donne '" + source + "' choue";

			case CONNEXION_BASE_KO:
				return "Connexion  la base de donne '" + source + "' choue";

			case INSERT_KO:
				return "Insertion de '" + source + "' choue";

			case UPDATE_KO:
				return "Modification de '" + source + "' choue";

			case DELETE_KO:
				return "Suppression de '" + source + "' choue";

			case SELECT_KO:
				return "Lecture de '" + source + "' choue";

			default:
				return " russite ou echec, telle est la question:" + code;

		}

	}

}
