package org.opensi.webmanager.utils;

import org.apache.axis.Constants;
import org.apache.axis.encoding.Base64;

/**
 * Gestion des appels au webservice du site.
 */
public class AppelServices {
	private static Integer timeout = new Integer(2000000);

	public static Object majFactures(String url_serveur, Object[] liste_factures) throws org.apache.axis.AxisFault, java.lang.Exception {

		// System.out.println("\n***************");
		// System.out.println( "* MAJStatutCom *");
		// System.out.println( "***************\n");

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");

		SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

		appelSoap.ajouterTypeParametre("liste", Constants.SOAP_ARRAY, SoapFacile.mode_in);
		appelSoap.ajouterValeurParametre(liste_factures);

		appelSoap.setTypeRetour(Constants.SOAP_ARRAY);

		result = appelSoap.appelerMethode(nomServeur, "majInfosFacture");

		// System.out.println("rponse:"+result);
		Object[] rep = (Object[]) result;

		Object[] rapport = (Object[]) rep[0];

		// System.out.println("Contenu du rapport:(\n");
		for (int i = 0; i < rapport.length; i++) {
			// System.out.print("[ ");
			Object[] contenu = (Object[]) rapport[i];
			System.out.print("code ERREUR: " + contenu[0]);
			System.out.print(", source: " + contenu[1]);
			System.out.print(", commentaire: " + contenu[2]);
			System.out.println(" ]");
		}
		// System.out.println("\n)");

		// System.out.println(" Rponse: "+rep[1]);

		return result;

	}

	/**
	 * Appel du service de mise  jour des statuts des commandes.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @param liste_statut
	 *          liste de (article_id, statut)
	 * @return le rapport d'erreur
	 * @throws org.apache.axis.AxisFault
	 *           en cas d'erreur de Axis (SOAP)
	 * @throws java.lang.Exception
	 *           erreur quelconque
	 */
	public static Object MAJStatutCom(String url_serveur, Object[] liste_statut) throws org.apache.axis.AxisFault, java.lang.Exception {

		// System.out.println("\n***************");
		// System.out.println( "* MAJStatutCom *");
		// System.out.println( "***************\n");

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");

		SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

		// param vide pour pas planter le php
		appelSoap.ajouterTypeParametre("liste", Constants.SOAP_ARRAY, SoapFacile.mode_in);
		appelSoap.ajouterValeurParametre(liste_statut);

		appelSoap.setTypeRetour(Constants.SOAP_ARRAY);

		result = appelSoap.appelerMethode(nomServeur, "majStatutCom");

		// System.out.println("rponse:"+result);

		return result;

	}

	
	/**
	 * Appel du service de mise  jour des statuts des commandes.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @param liste_statut
	 *          liste de (article_id, statut)
	 * @return le rapport d'erreur
	 * @throws org.apache.axis.AxisFault
	 *           en cas d'erreur de Axis (SOAP)
	 * @throws java.lang.Exception
	 *           erreur quelconque
	 */
	public static Object MAJClients(String url_serveur, Object[] liste_statut) throws org.apache.axis.AxisFault, java.lang.Exception {

		// System.out.println("\n***************");
		// System.out.println( "* MAJStatutCom *");
		// System.out.println( "***************\n");

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");

		SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

		// param vide pour pas planter le php
		appelSoap.ajouterTypeParametre("liste", Constants.SOAP_ARRAY, SoapFacile.mode_in);
		appelSoap.ajouterValeurParametre(liste_statut);

		appelSoap.setTypeRetour(Constants.SOAP_ARRAY);

		result = appelSoap.appelerMethode(nomServeur, "majClients");

		// System.out.println("rponse:"+result);

		return result;

	}

	/**
	 * Appel du service de mise  jour des informations des articles.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @param liste_info
	 *          liste de ArticleStruct
	 * @return le rapport d'erreur
	 * @throws org.apache.axis.AxisFault
	 *           en cas d'erreur de Axis (SOAP)
	 * @throws java.lang.Exception
	 *           erreur quelconque
	 */
	public static Object majInfos(String url_serveur, Object[] liste_info) throws org.apache.axis.AxisFault, java.lang.Exception {

		// System.out.println("\n************");
		// System.out.println( "* majInfos *");
		// System.out.println( "************\n");

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");

		SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

		// param vide pour pas planter le php
		appelSoap.ajouterTypeParametre("liste", Constants.SOAP_ARRAY, SoapFacile.mode_in);
		appelSoap.ajouterValeurParametre(liste_info);

		appelSoap.setTypeRetour(Constants.SOAP_ARRAY);

		result = appelSoap.appelerMethode(nomServeur, "majInfos");

		return result;
	}

	/**
	 * Appel du service de mise  jour des stocks des articles.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @param liste_idStock
	 *          liste de (id_article, stock)
	 * @return le rapport d'erreur
	 * @throws org.apache.axis.AxisFault
	 *           en cas d'erreur de Axis (SOAP)
	 * @throws java.lang.Exception
	 *           erreur quelconque
	 */
	public static Object majStocks(String url_serveur, Object[] liste_idStock) throws org.apache.axis.AxisFault, java.lang.Exception {

		// System.out.println("\n************");
		// System.out.println( "* majStock *");
		// System.out.println( "************\n");

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");

		SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

		// param vide pour pas planter le php
		appelSoap.ajouterTypeParametre("liste", Constants.SOAP_ARRAY, SoapFacile.mode_in);
		appelSoap.ajouterValeurParametre(liste_idStock);

		appelSoap.setTypeRetour(Constants.SOAP_ARRAY);

		result = appelSoap.appelerMethode(nomServeur, "majStocks");

		return result;

	}

	/**
	 * Appel du service de mise  jour des prix des articles.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @param liste_idPrix
	 *          liste de (id_article,prix)
	 * @return le rapport d'erreur
	 * @throws org.apache.axis.AxisFault
	 *           en cas d'erreur de Axis (SOAP)
	 * @throws java.lang.Exception
	 *           erreur quelconque
	 */
	public static Object majPrix(String url_serveur, Object[] liste_idPrix) throws org.apache.axis.AxisFault, java.lang.Exception {

		// System.out.println("\n***********");
		// System.out.println( "* majPrix *");
		// System.out.println( "***********\n");

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");

		SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

		// param vide pour pas planter le php
		appelSoap.ajouterTypeParametre("liste", Constants.SOAP_ARRAY, SoapFacile.mode_in);
		appelSoap.ajouterValeurParametre(liste_idPrix);

		appelSoap.setTypeRetour(Constants.SOAP_ARRAY);

		result = appelSoap.appelerMethode(nomServeur, "majPrix");

		return result;

	}

	/**
	 * Appel du service de rcupration des commandes.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @return le rapport d'erreur et la liste des commandes sous forme de
	 *         CommandeStruct.
	 * @throws org.apache.axis.AxisFault
	 *           en cas d'erreur de Axis (SOAP)
	 * @throws java.lang.Exception
	 *           erreur quelconque
	 */
	public static Object uploadCommandes(String url_serveur) throws org.apache.axis.AxisFault, java.lang.Exception {

		// //System.out.println("\n************************");
		// //System.out.println( "* upload des commandes *");
		// //System.out.println( "************************\n");

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");

		
		System.out.println("uploadCommandes");
		
		SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

		// param vide pour pas planter le php
		appelSoap.ajouterTypeParametre("vide", Constants.XSD_STRING, SoapFacile.mode_in);
		appelSoap.ajouterValeurParametre("");

		appelSoap.setTypeRetour(Constants.SOAP_ARRAY);
		System.out.println("ok1");

		result = appelSoap.appelerMethode(nomServeur, "uploadCommandes");
		System.out.println("ok2");

		return result;

	}

	public static Object uploadClients(String url_serveur) throws org.apache.axis.AxisFault, java.lang.Exception {

		System.out.println("\n************************");
		System.out.println("* upload des clients *");
		System.out.println("************************\n");

		String nomServeur = "ServeurWebManager";
		Object result = new String("rien");

		SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

		// param vide pour pas planter le php
		appelSoap.ajouterTypeParametre("vide", Constants.XSD_STRING, SoapFacile.mode_in);
		appelSoap.ajouterValeurParametre("");

		appelSoap.setTypeRetour(Constants.SOAP_ARRAY);

		result = appelSoap.appelerMethode(nomServeur, "uploadClients");

		return result;

	}

	// ------------------------------------
	// ----------------------- Ajout d'articles
	// ----------------------------------------
	// ------------------------------------

	/**
	 * Appel du service d'ajout d'articles au site.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @param articles
	 *          le rapport d'erreur
	 * @return le rapport d'erreur
	 */
	public static Object ajoutArticles(String url_serveur, Object[] articles) {

		// System.out.println("\n****************");
		// System.out.println("* Ajout d'articles *");
		// System.out.println("*****************\n");

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");

		try {

			// System.out.println("[AppelServices] -1-");

			SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

			// listeArticle
			appelSoap.ajouterTypeParametre("articles", Constants.SOAP_ARRAY, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(articles);

			appelSoap.setTypeRetour(Constants.SOAP_ARRAY);

			// System.out.println("[AppelServices] -2-");

			result = appelSoap.appelerMethode(nomServeur, "ajouterArticles");
			// System.out.println("[AppelServices] -3-");

		}
		catch (org.apache.axis.AxisFault e) {
			// System.out.println("[AppelServices.ajoutArticles] ERREUR: "+e);

		}
		catch (Exception e2) {
			// System.out.println("[AppelServices.ajoutArticles] ERREUR:"+e2);

		}

		return result;

	}

	// ---------------------------------------
	// ----------------------- Upload d'images Famille
	// ----------------------------------------
	// ---------------------------------------

	/**
	 * Appel du service de rcupration de l'image de la famille.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @param famille
	 *          Nom de la famille pour laquelle on souhaite rcuprer l'image.
	 * @return le rapport d'erreur et une ImageStruct reprsentant l'image
	 */
	public static Object uploadImageFamille(String url_serveur, String famille) {
		// Paramtres de la connection au web service
		// System.out.println("\n(OpenSi)***************************");
		// System.out.println( "(OpenSi)* UPLOAD D'IMAGES FAMILLE*");
		// System.out.println( "(OpenSi)***************************\n");

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");
		try {

			SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

			// ID
			appelSoap.ajouterTypeParametre("famille", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(famille);

			appelSoap.setTypeRetour(Constants.SOAP_ARRAY);
			result = appelSoap.appelerMethode(nomServeur, "uploadImageFamille");

		}
		catch (org.apache.axis.AxisFault e) {
			// System.out.println("(OpenSi)[AppelServices.uploadImageFamille]
			// ERREUR: "+e);

		}
		catch (Exception e2) {
			// System.out.println("(OpenSi)[AppelServices.uploadImageFamille]
			// ERREUR:"+e2);

		}
		return result;

	}

	// -------------------------------------------------
	// ----------------------- Upload d'images sous_famille
	// ----------------------------------------
	// -------------------------------------------------

	/**
	 * Appel du service de rcupration de l'image de la sous-famille.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @param famille
	 *          Nom de la famille
	 * @param sousfamille
	 *          Nom de la sous famille.
	 * @return le rapport d'erreur et une ImageStruct reprsentant l'image
	 */
	public static Object uploadImageSousFamille(String url_serveur, String famille, String sousfamille) {
		// Paramtres de la connection au web service
		// System.out.println("\n(OpenSi)*********************************");
		// System.out.println( "(OpenSi)* UPLOAD D'IMAGES SOUS FAMILLE *");
		// System.out.println( "(OpenSi)*********************************\n");

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");
		try {

			SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

			// ID
			appelSoap.ajouterTypeParametre("famille", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(famille);

			appelSoap.ajouterTypeParametre("sousfamille", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(sousfamille);

			appelSoap.setTypeRetour(Constants.SOAP_ARRAY);
			result = appelSoap.appelerMethode(nomServeur, "uploadImageSousFamille");

		}
		catch (org.apache.axis.AxisFault e) {
			// System.out.println("(OpenSi)[AppelServices.uploadImage] ERREUR:
			// "+e);

		}
		catch (Exception e2) {
			// System.out.println("(OpenSi)[AppelServices.uploadImage]
			// ERREUR:"+e2);

		}

		return result;

	}

	// ------------------------------------
	// ----------------------- Upload d'images
	// ----------------------------------------
	// ------------------------------------

	/**
	 * Appel du service de rcupration de l'image de marque.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @param marque
	 *          Nom de la marque
	 * @return le rapport d'erreur et une ImageStruct reprsentant l'image
	 */
	public static Object uploadImageMarque(String url_serveur, String marque) {
		// Paramtres de la connection au web service
		// System.out.println("\n(OpenSi)***************************");
		// System.out.println( "(OpenSi)* UPLOAD D'IMAGES MARQUE *");
		// System.out.println( "(OpenSi)***************************\n");

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");
		try {

			SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

			appelSoap.ajouterTypeParametre("marque", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(marque);

			appelSoap.setTypeRetour(Constants.SOAP_ARRAY);
			result = appelSoap.appelerMethode(nomServeur, "uploadImageMarque");

		}
		catch (org.apache.axis.AxisFault e) {
			// System.out.println("(OpenSi)[AppelServices.uploadImage] ERREUR:
			// "+e);

		}
		catch (Exception e2) {
			// System.out.println("(OpenSi)[AppelServices.uploadImage]
			// ERREUR:"+e2);

		}
		return result;

	}

	// ------------------------------------
	// ----------------------- Upload d'images
	// ----------------------------------------
	// ------------------------------------

	/**
	 * Appel du service de rcupration de l'image d'un article.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @param articleId
	 *          Rfrence de l'article.
	 * @return le rapport d'erreur et une ImageStruct reprsentant l'image
	 */
	public static Object uploadImage(String url_serveur, String articleId) {
		// Paramtres de la connection au web service
		// ////System.out.println("\n*******************");
		// ////System.out.println( "* UPLOAD D'IMAGES *");
		// ////System.out.println( "*******************\n");

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");
		try {

			SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

			// ID
			appelSoap.ajouterTypeParametre("id", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(articleId);

			appelSoap.setTypeRetour(Constants.SOAP_ARRAY);
			result = appelSoap.appelerMethode(nomServeur, "uploadImage");

		}
		catch (org.apache.axis.AxisFault e) {
			// System.out.println("[AppelServices.uploadImage] ERREUR: "+e);

		}
		catch (Exception e2) {
			// System.out.println("[AppelServices.uploadImage] ERREUR:"+e2);

		}

		return result;

	}

	// ------------------------------------
	// ----------------------- Envoi d'images Famille
	// ----------------------------------------
	// ------------------------------------

	/**
	 * Appel du service d'ajout d'image de famille au site.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @param famille
	 *          Nom de la famille
	 * @param taille
	 *          Taille de l'image
	 * @param image
	 *          Contenu de l'image
	 * @param nomImage
	 *          Nom de l'image
	 * @return le rapport d'erreur
	 */
	public static Object envoyerImageFamille(String url_serveur, String famille, int taille, byte[] image, String nomImage) {
		// Paramtres de la connection au web service
		// //System.out.println("\n**************************");
		// //System.out.println( "* ENVOI D'IMAGES FAMILLE*");
		// //System.out.println( "**************************\n");

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");

		try {

			SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

			// famille
			appelSoap.ajouterTypeParametre("famille", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre("" + famille);

			// Tailleimage petite
			appelSoap.ajouterTypeParametre("taille", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre("" + taille);

			// Image petite
			appelSoap.ajouterTypeParametre("image", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(Base64.encode(image));

			// Nom petite
			appelSoap.ajouterTypeParametre("nom", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(nomImage);

			appelSoap.setTypeRetour(Constants.SOAP_ARRAY);

			result = appelSoap.appelerMethode(nomServeur, "ajouterImageFamille");

		}
		catch (org.apache.axis.AxisFault e) {
			// System.out.println("[AppelServices.envoyerImage] ERREUR: "+e);

		}
		catch (Exception e2) {
			// System.out.println("[AppelServices.envoyerImage] ERREUR:"+e2);

		}

		return result;

	}

	// ------------------------------------
	// ----------------------- Envoi d'images Sous_Famille
	// ----------------------------------------
	// ------------------------------------

	/**
	 * Appel du service d'ajout d'image de sous famille au site.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @param famille
	 *          Nom de la famille
	 * @param sous_famille
	 *          Nom de la sous famille
	 * @param taille
	 *          Taille de l'image
	 * @param image
	 *          Contenu de l'image
	 * @param nomImage
	 *          Nom de l'image
	 * @return le rapport d'erreur
	 */
	public static Object envoyerImageSousFamille(String url_serveur, String famille, String sous_famille, int taille, byte[] image,
			String nomImage) {
		// Paramtres de la connection au web service
		/*
		 * //System.out.println("\n********************************");
		 * //System.out.println( "* ENVOI D'IMAGES SOUS-FAMILLE *");
		 * //System.out.println( "********************************\n");
		 */

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");

		try {

			SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

			// famille
			appelSoap.ajouterTypeParametre("famille", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre("" + famille);

			// sousfamille
			appelSoap.ajouterTypeParametre("sousfamille", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre("" + sous_famille);

			// Tailleimage petite
			appelSoap.ajouterTypeParametre("taille", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre("" + taille);

			// Image petite
			appelSoap.ajouterTypeParametre("image", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(Base64.encode(image));

			// Nom petite
			appelSoap.ajouterTypeParametre("nom", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(nomImage);

			appelSoap.setTypeRetour(Constants.SOAP_ARRAY);

			result = appelSoap.appelerMethode(nomServeur, "ajouterImageSousFamille");

		}
		catch (org.apache.axis.AxisFault e) {
			// System.out.println("[AppelServices.envoyerImage] ERREUR: "+e);

		}
		catch (Exception e2) {
			// System.out.println("[AppelServices.envoyerImage] ERREUR:"+e2);

		}
		return result;

	}

	// ------------------------------------
	// ----------------------- Envoi d'images Marque
	// ----------------------------------------
	// ------------------------------------

	/**
	 * Appel du service d'ajout d'image de marque au site.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @param marque
	 *          Nom de la marque
	 * @param taille
	 *          Taille de l'image
	 * @param image
	 *          Contenu de l'image
	 * @param nomImage
	 *          Nom de l'image
	 * @return le rapport d'erreur
	 */
	public static Object envoyerImageMarque(String url_serveur, String marque, int taille, byte[] image, String nomImage) {
		// Paramtres de la connection au web service
		/*
		 * //System.out.println("\n**************************");
		 * //System.out.println( "* ENVOI D'IMAGES FAMILLE*"); //System.out.println(
		 * "**************************\n");
		 */

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");

		try {

			SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

			// famille
			appelSoap.ajouterTypeParametre("marque", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre("" + marque);

			// Tailleimage petite
			appelSoap.ajouterTypeParametre("taille", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre("" + taille);

			// Image petite
			appelSoap.ajouterTypeParametre("image", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(Base64.encode(image));

			// Nom petite
			appelSoap.ajouterTypeParametre("nom", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(nomImage);

			appelSoap.setTypeRetour(Constants.SOAP_ARRAY);

			result = appelSoap.appelerMethode(nomServeur, "ajouterImageMarque");

		}
		catch (org.apache.axis.AxisFault e) {
			// System.out.println("[AppelServices.envoyerImage] ERREUR: "+e);

		}
		catch (Exception e2) {
			// System.out.println("[AppelServices.envoyerImage] ERREUR:"+e2);

		}
		return result;

	}

	// ------------------------------------
	// ----------------------- Envoi d'images
	// ----------------------------------------
	// ------------------------------------

	/**
	 * Appel du service d'ajout d'image d'article au site.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @param article_Id
	 *          Rfrence de l'article
	 * @param taille_petiteImage
	 *          Taille de l'image
	 * @param petiteImage
	 *          Contenu de l'image
	 * @param nom_petiteImage
	 *          Nom de l'image
	 * @param taille_grandeImage
	 *          Taille de l'image
	 * @param grandeImage
	 *          Contenu de l'image
	 * @param nom_grandeImage
	 *          Nom de l'image
	 * @return le rapport d'erreur
	 */
	public static Object envoyerImage(String url_serveur, String article_Id, int taille_petiteImage, byte[] petiteImage,
			String nom_petiteImage, int taille_grandeImage, byte[] grandeImage, String nom_grandeImage) {
		// Paramtres de la connection au web service
		/*
		 * //System.out.println("\n*******************"); //System.out.println( "*
		 * ENVOI D'IMAGES *"); //System.out.println( "*******************\n");
		 */

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");

		try {

			SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

			// article id
			appelSoap.ajouterTypeParametre("article_Id", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre("" + article_Id);

			// Tailleimage petite
			appelSoap.ajouterTypeParametre("petite_taille", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre("" + taille_petiteImage);

			// Image petite
			appelSoap.ajouterTypeParametre("petite_image", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(Base64.encode(petiteImage));

			// Nom petite
			appelSoap.ajouterTypeParametre("nom_petite", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(nom_petiteImage);

			// Tailleimage grande
			appelSoap.ajouterTypeParametre("grande_taille", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre("" + taille_grandeImage);

			// Image grande
			appelSoap.ajouterTypeParametre("grande_image", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(Base64.encode(grandeImage));

			// Nom grande
			appelSoap.ajouterTypeParametre("nom_grande", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre(nom_grandeImage);

			appelSoap.setTypeRetour(Constants.SOAP_ARRAY);

			result = appelSoap.appelerMethode(nomServeur, "ajouterImageAuSite");

		}
		catch (org.apache.axis.AxisFault e) {
			// System.out.println("[AppelServices.envoyerImage] ERREUR: "+e);

		}
		catch (Exception e2) {
			// System.out.println("[AppelServices.envoyerImage] ERREUR:"+e2);

		}
		return result;

	}

	// ------------------------------------
	// ----------------------- Publication
	// ----------------------------------------
	// ------------------------------------

	/**
	 * Appel du service de prparation du site
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @return le rapport d'erreur
	 */
	public static Object preparerSite(String url_serveur) {
		// Paramtres de la connection au web service
		// System.out.println("\n**************");
		// System.out.println("* Prpa du site *");
		// System.out.println("***************\n");

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");

		try {

			SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

			// listeArticle
			appelSoap.ajouterTypeParametre("vide", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre("");

			appelSoap.setTypeRetour(Constants.SOAP_ARRAY);

			result = appelSoap.appelerMethode(nomServeur, "preparerSite");

		}
		catch (org.apache.axis.AxisFault e) {
			// System.out.println("[AppelServices.preparerSite] ERREUR: "+e);

		}
		catch (Exception e2) {
			// System.out.println("[AppelServices.preparerSite] ERREUR:"+e2);

		}
		return result;

	}

	// ------------------------------------
	// ----------------------- Upload ----------------------------------------
	// ------------------------------------

	/**
	 * Appel du service de rcupration des articles du site.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @return le rapport d'erreur et la liste d'articles sous la forme de
	 *         ArticleStrcut
	 */
	public static Object uploadArticlesExistant(String url_serveur) {
		// Paramtres de la connection au web service
		// System.out.println("\n******************");
		// System.out.println("* Upload articles *");
		// System.out.println("******************\n");

		// System.out.println("url_serveur:"+url_serveur);

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");

		try {

			SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

			// URL de la BD
			appelSoap.ajouterTypeParametre("vide", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre("");

			appelSoap.setTypeRetour(Constants.SOAP_ARRAY);

			result = appelSoap.appelerMethode(nomServeur, "uploadArticlesExistant");

		}
		catch (org.apache.axis.AxisFault e) {
			System.out.println("[AppelServices.uploadArticlesExistant]AXISERREUR: "+e);
		}
		catch (Exception e2) {
			System.out.println("[AppelServices.uploadArticlesExistant]ERREUR:"+e2);
		}
		return result;

	}

	// ------------------------------------
	// ----------------------- Tests Initiaux
	// ----------------------------------------
	// ------------------------------------

	/**
	 * Appel du service de test initiaux.
	 * 
	 * @param url_serveur
	 *          url du web service
	 * @return le rapport d'erreur
	 */
	public static Object testInitiaux(String url_serveur) {
		// Paramtres de la connection au web service
		// System.out.println("\n******************");
		// System.out.println("* Tests Initiaux *");
		// System.out.println("******************\n");

		String nomServeur = "ServeurWebManager";

		Object result = new String("rien");

		try {

			SoapFacile appelSoap = new SoapFacile(url_serveur, timeout);

			// truc vide
			appelSoap.ajouterTypeParametre("vide", Constants.XSD_STRING, SoapFacile.mode_in);
			appelSoap.ajouterValeurParametre("");

			appelSoap.setTypeRetour(Constants.SOAP_ARRAY);

			result = appelSoap.appelerMethode(nomServeur, "testsInitiaux");

		}
		catch (org.apache.axis.AxisFault e) {
			 System.out.println("[AppelServices.testInitiaux] ERREURAxis "+url_serveur+" d "+nomServeur+"g : "+e);

		}
		catch (Exception e2) {
			 System.out.println("[AppelServices.testInitiaux] ERREURExcep :"+e2);

		}

		return result;

	}

	/**
	 * Paramtre le timeout d'appel du service.
	 * 
	 * @param nouveauTimeout
	 *          nouveau timeout
	 */
	public static void setTimeout(Integer nouveauTimeout) {
		// System.out.println(" ----------- Je change le timeout
		// --------------------");
		timeout = nouveauTimeout;
	}

}
