/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Regarde si les services sont actifs ou non
 */

package org.opensi.webmanager.modifications;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.webmanager.fonctions_periodiques.ManagerMAJAuto;

public class getEtatServices extends Action {

	/**
	 * 
	 * @return
	 */
	public boolean serverSide() {
		return true;
	}

	/**
	 * 
	 * @param s
	 * @param r
	 * @param info
	 * @throws java.lang.Exception
	 * @return
	 */
	public boolean service(Session s, ServletRequest r, Object info) {
		try {
			String port_serveur = s.getAppConfiguration().get("weblink.port");
			int port_int = Integer.parseInt(port_serveur);
	
			String site_id = r.getParameter("site_id");
			String base = r.getParameter("base");
	
			String requete = "SELECT Nom_Service, Groupe_Service, Type_Maj FROM " + base + ".MAJ_AUTO ";
			requete += " WHERE Site_Id=" + site_id;
			Connection con = s.getConnection(null);
			Statement state = con.createStatement();
	
			ResultSet res = state.executeQuery(requete);
	
			while (res.next()) {
	
				String nom_job = res.getString("Nom_Service");
				String groupe_job = res.getString("Groupe_Service");
	
				boolean reponse = ManagerMAJAuto.estServiceDemarre(port_int, nom_job, groupe_job);
	
				r.addParameter("etat_" + res.getString("Type_Maj"), "" + reponse);
	
			}
			res.close();
			state.close();
			s.closeConnection(con, null);
	
			return true;
		}
		catch (Exception e) {
			return false;
		}
	}

}
