/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Requetes multiples d'insertion ou de suppression d'articles web.
 */

package org.opensi.webmanager.modifications;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

public class ModifEtatGroupeArticlesWeb extends Action {

	/**
	 * 
	 * @return
	 */
	public boolean serverSide() {
		return true;
	}

	/**
	 * 
	 * @param s
	 * @param r
	 * @param info
	 * @throws java.lang.Exception
	 * @return
	 */
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		String famille1 = r.getParameter("famille1");
		String famille2 = r.getParameter("famille2");
		String base = r.getParameter("base");
		String site_id = r.getParameter("site_id");
		String modeOp = r.getParameter("modeOp");

		Connection con = s.getConnection(null);
		Statement state = con.createStatement();

		if (modeOp.equals("DEL")) {
			String reqDel = "UPDATE " + base + ".FICHE_ARTICLE_WEB ";
			reqDel += "SET Etat_Existance=-1 WHERE";
			reqDel += " Site_Id='" + site_id + "'";

			if (!famille1.equals("")) {
				reqDel += " AND Article_Id IN ";
				reqDel += " (";
				reqDel += " SELECT Article_Id FROM " + base + ".FICHE_ARTICLE ";
				reqDel += " WHERE Famille_1=" + famille1;

				if (!famille2.equals("")) {
					reqDel += " AND Famille_2=" + famille2;
				}
				reqDel += " )";

			}

			System.out.println("[ModifEtatGroupeArticlesWeb] req de DEL:" + reqDel);
			state.executeUpdate(reqDel);

		}
		else if (modeOp.equals("CREER")) {
			// 1.Update de tous ceux existants
			
			String labSousFamille = "";

			String reqUpdate = "UPDATE " + base + ".FICHE_ARTICLE_WEB w, " + base + ".FICHE_ARTICLE f";
			reqUpdate += " SET Etat_Existance=1 ";
			reqUpdate += " WHERE Site_Id=" + site_id + " AND w.Article_Id=f.Article_Id";

			if (!famille1.equals("")) {
				reqUpdate += " AND Famille_1=" + famille1;

				if (!famille2.equals("")) {
					reqUpdate += " AND Famille_2=" + famille2;
					
					String reqSF = "select Libelle from "+ base +".FAMILLE_ARTICLE where Famille_Id="+ famille2 +" and Parent_Id="+ famille1;
					ResultSet rset = state.executeQuery(reqSF);
					if (rset.next()) {
						labSousFamille = rset.getString("Libelle");
					}
					rset.close();
				}

			}
			
			

			System.out.println("[ModifEtatGroupeArticlesWeb] req de UPDATE(CREER):" + reqUpdate + " sous_famille:" + labSousFamille);
			state.executeUpdate(reqUpdate);

			// 2. Creation des nouvelles fiches
			String reqCount = "SELECT Count(Article_Id)as nb FROM " + base + ".FICHE_ARTICLE ";
			ResultSet res = state.executeQuery(reqCount);

			int nbOpenSi = 0;
			int nbEnLigne = 0;
			if (res.next()) {
				nbOpenSi = res.getInt("nb");
			}
			res.close();

			reqCount = "SELECT Count(Article_Id)as nb FROM " + base + ".FICHE_ARTICLE_WEB WHERE Site_Id=" + site_id;
			res = state.executeQuery(reqCount);

			if (res.next()) {
				nbEnLigne = res.getInt("nb");
			}
			res.close();

			if (nbOpenSi > nbEnLigne) {

				String lesIds = "SELECT Article_Id ";
				lesIds += " FROM " + base + ".FICHE_ARTICLE f";
				lesIds += " WHERE Article_Id NOT IN ";
				lesIds += " (";
				lesIds += " SELECT Article_Id ";
				lesIds += " FROM " + base + ".FICHE_ARTICLE_WEB ";
				lesIds += " WHERE Site_Id=" + site_id;
				lesIds += " )";

				if (!famille1.equals("")) {
					lesIds += " AND Famille_1=" + famille1;

					if (!famille2.equals("")) {
						lesIds += " AND Famille_2=" + famille2;
					}

				}

				String reqInsert = "INSERT INTO " + base + ".FICHE_ARTICLE_WEB ";
				reqInsert += "(Article_Id, Site_Id, Etat_Existance) ";
				reqInsert += " VALUES ";
				reqInsert += "(?, " + site_id + ", 1) ";

				System.out.println("[ModifEtatGroupeArticlesWeb] req de Ids:" + lesIds);

				System.out.println("[ModifEtatGroupeArticlesWeb] req de Insert:" + reqInsert);

				ResultSet resultIds = state.executeQuery(lesIds);

				PreparedStatement ps = con.prepareStatement(reqInsert);

				while (resultIds.next()) {
					System.out.println("[ModifEtatGroupeArticlesWeb] INSERT Etat=1 pour id=:" + resultIds.getString("Article_Id"));
					ps.setString(1, resultIds.getString("Article_Id"));
					ps.addBatch();
				}

				ps.executeBatch();

				// On affecte un id web pour les nouveaux cres, on met un
				// entier car on ne sait pas si c'est pour OsCommerce ou
				// ExperShop
				String reqMajId = "UPDATE " + base + ".FICHE_ARTICLE_WEB SET Article_Id_Site=Article_Web_Id WHERE Article_Id_Site IS NULL";
				state.executeUpdate(reqMajId);

			}

		}

		s.closeConnection(con, null);

		return true;

	}

}
