/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  gestion des mises  jour automatiques
 */

package org.opensi.webmanager.modifications;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.webmanager.fonctions_periodiques.ManagerMAJAuto;
import org.opensi.webmanager.utils.ToolsMAJ;

public class ActionGestionMAJAuto extends Action {

	/**
	 * 
	 * @return
	 */
	public boolean serverSide() {
		return true;
	}

	/**
	 * 
	 * @param s
	 * @param r
	 * @param info
	 * @throws java.lang.Exception
	 * @return
	 */
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		String port_serveur = s.getAppConfiguration().get("weblink.port");
		int port_int = Integer.parseInt(port_serveur);

		String dossierRoot = s.getAppConfiguration().get("opensi.absdir");

		// On teste si le serveur de mise  jour auto est lanc
		if (!ManagerMAJAuto.serveurDemarre(port_int)) {
			System.out.println("[ActionGestionMAJ] Le serveur n'est pas dmarr");

			String driver_bd = s.getAppConfiguration().get("jdbc.Driver");
			String url_bd = s.getAppConfiguration().get("opensi.serveurdb");
			String login_bd = s.getAppConfiguration().get("jdbc.User");
			String mdp_bd = s.getAppConfiguration().get("jdbc.Password");
			String dossier_maj = s.getAppConfiguration().get("weblink.majautoDir");

			ManagerMAJAuto.demarrerServeur(port_int, url_bd, driver_bd, login_bd, mdp_bd, dossierRoot, dossier_maj);
		}

		// On demarre ou arrete le service voulu
		String site_id = r.getParameter("site_id");
		String base = r.getParameter("base");
		String dossierId = r.getParameter("dossierId");

		String type_maj = r.getParameter("type_maj");
		String action = r.getParameter("action");

		Connection con = s.getConnection(null);

		if (action.equals("STOP")) {
			String where = "";
			if (!type_maj.equals("TOUT")) {
				where = " AND Type_Maj='" + type_maj + "'";
			}

			String requete = "SELECT Nom_Service, Groupe_Service FROM " + base + ".MAJ_AUTO WHERE Site_Id=" + site_id + " " + where;
			Statement state = con.createStatement();

			ResultSet res = state.executeQuery(requete);
			while (res.next()) {
				String nom_service = res.getString("Nom_Service");
				String groupe = res.getString("Groupe_Service");

				System.out.println("[ActionGestionMaj] Je vais stopper " + nom_service);
				ManagerMAJAuto.arreterService(port_int, nom_service, groupe);
			}

		}
		else {

			String where = "";
			if (!type_maj.equals("TOUT")) {
				where = " AND Type_Maj='" + type_maj + "'";
			}

			String requete = "SELECT Maj_Id, Type_Maj";
			requete += " FROM " + base + ".MAJ_AUTO WHERE Site_Id=" + site_id + " " + where;
			System.out.println(requete);
			Statement state = con.createStatement();
			Statement state2 = con.createStatement();
			ResultSet resultSet = state.executeQuery(requete);

			int timeout = Integer.parseInt(s.getAppConfiguration().get("weblink.timeout"));
			int max = Integer.parseInt(s.getAppConfiguration().get("weblink.maxitem"));
			int nb_raps = Integer.parseInt(s.getAppConfiguration().get("weblink.nbrapports"));

			String groupe_service = ToolsMAJ.getNomGroupeService(dossierId, site_id);
			while (resultSet.next()) {
				String nom_service = ToolsMAJ.getNomService(resultSet.getString("Type_Maj"), dossierId, site_id);
				System.out.println(""+resultSet.getInt("Maj_Id"));

				// Creation du nom et du groupe du service
				String reqUpdate = "UPDATE " + base + ".MAJ_AUTO SET Nom_Service='" + nom_service + "', Groupe_Service='" + groupe_service + "'";
				reqUpdate += " WHERE Type_Maj='" + resultSet.getString("Type_Maj") + "' AND Site_Id=" + site_id;

				state2.executeUpdate(reqUpdate);

				System.out.println("[ActionGestionMaj] Je vais lancer le service");
				System.out.println(""+resultSet.getInt("Maj_Id"));
				ManagerMAJAuto.lancerService(port_int, resultSet.getInt("Maj_Id"), base, dossierId, timeout, nb_raps, max);

			}
		}

		s.closeConnection(con, null);

		return true;

	}

}
