/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Mise a jour des prix
 */

package org.opensi.webmanager.fonctions_periodiques;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;

import org.opensi.webmanager.utils.AppelServices;
import org.opensi.webmanager.utils.ArticleStruct;
import org.opensi.webmanager.utils.CalculCaracsWeb;
import org.opensi.webmanager.utils.MultiRapports;
import org.opensi.webmanager.utils.RedactionRapport;
import org.opensi.webmanager.utils.ToolsMAJ;

/**
 * Procdure de mise  jour des prix
 */
public class MAJPrix {

	private boolean appelServiceReussi;
	private boolean appelToutServiceReussi;
	private boolean noErreurRapport;
	String dateDebut;
	String dateFin;
	int nbArticlesParEnvoi = 100;
	MultiRapports lesRapports;
	private int timeout;
	private int nbEchecs;
	private int nbArticles;
	private int nbRapports;
	Vector<String> listeId;
	private File aEcrire;
	private String type;

	/**
	 * Procdure de mise  jour des prix
	 * 
	 * @param nbArticles
	 *          nombre d'articles maximum par envoi
	 * @param timeoutService
	 *          timeout en milisecondes
	 * @param lenbRapports
	 *          nombre de rapport  conserver
	 */
	public MAJPrix(int nbArticles, int timeoutService, int lenbRapports,String fichier, String nomtype) {
		this(nbArticles,timeoutService,lenbRapports);
		aEcrire = new File(fichier);// le fichier de log
		this.type=nomtype;
	}
	public MAJPrix(int nbArticles, int timeoutService, int lenbRapports) {
		aEcrire = new File("Lancer_Maintenant.log");// le fichier de log
		this.type="";
		appelServiceReussi = true;
		appelToutServiceReussi = true;
		noErreurRapport = true;
		lesRapports = new MultiRapports();

		nbRapports = (lenbRapports > 0)?lenbRapports:10;
		nbArticlesParEnvoi = (nbArticles > 0)?nbArticles:100;
		timeout = (timeoutService >= 0)?timeoutService:20000;
		nbEchecs = 0;
		AppelServices.setTimeout(Integer.valueOf(timeout));
	}

	/**
	 * Lance la mise  jour.
	 * 
	 * La mise  jour est faite en plusieurs tapes: On regarde si il y a des prix
	 *  mettre  jour, puis on cre la liste d'article a envoyer au serveur, si
	 * tout s'est bien pass, on enregistre dans OpenSi que les prix sont
	 * maintenant  jour.
	 * 
	 * La connexion  la base de donne n'est ni ouverte ni ferme.
	 * 
	 * @param serveur
	 *          adresse du web service
	 * @param dossierRoot
	 *          chemin absolu vers le seveur de OpenSi (opensi-serveur)
	 * @param dossierId
	 *          identifiant du dossier
	 * @param con
	 *          Connexion  la base de donne
	 * @param base
	 *          Nom de la base de donne FACT_qquechose
	 * @param site_id
	 *          identifiant du site
	 * @return vrai si la mise  jour s'est bien passe, faux sinon.
	 */
	public boolean lancerMAJ(String serveur, String dossierRoot, String dossierId, Connection con, String base, String site_id) {
		try {
			ToolsMAJ.ecrireLog(aEcrire,type,"\nDebut du lancerMAj");
			java.util.Date date = new java.util.Date();
			Timestamp stamp = new Timestamp(date.getTime());
			dateDebut = "" + stamp;

			ToolsMAJ.ecrireLog(aEcrire,type,"Appel du webservice....");
			appelService(serveur, con, base, site_id);

			date = new java.util.Date();
			stamp = new Timestamp(date.getTime());
			dateFin = "" + stamp;

			try {
				String requete = "UPDATE " + base + ".MAJ_AUTO SET Derniere_Maj=" + date.getTime() + " WHERE Site_Id=" + site_id
						+ " AND Type_Maj='PRIX'";
				Statement state = con.createStatement();
				state.executeUpdate(requete);
			}
			catch (Exception e) {
				e.printStackTrace();
			}

			ToolsMAJ.ecrireLog(aEcrire,type,"Ecriture du rapport....");
			ecrireRapport(dossierRoot, dossierId, site_id);
			ToolsMAJ.ecrireLog(aEcrire,type,"Fin du lancerMaj");
		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"ERREUR:" + e);
		}

		return appelToutServiceReussi;

	}

	private void appelService(String serveur, Connection con, String base, String site_id) {
		try {

			ToolsMAJ.ecrireLog(aEcrire,type,"calcul des prix");
			// Recalcul des prix web
			CalculCaracsWeb.calculPrix(con, base, site_id);

			String reqPrix = "SELECT Prix_Web, Tarif_1, Tarif_1_TTC, Tarif_2, Tarif_2_TTC, Tarif_3, Tarif_3_TTC, Tarif_4, Tarif_4_TTC, Tarif_5, Tarif_5_TTC, Article_Web_Id, fa.Article_Id, Article_Id_Site FROM " + base + ".FICHE_ARTICLE_WEB faw, " + base + ".FICHE_ARTICLE fa ";
			reqPrix += " WHERE Site_Id=" + site_id + " AND Prix_Modifie=1 and fa.Article_Id=faw.Article_Id";
			ToolsMAJ.ecrireLog(aEcrire,type,"Creation du statement");
			Statement state = con.createStatement();
			ResultSet resPrix = state.executeQuery(reqPrix);

			Vector<Object> liste = new Vector<Object>();
			listeId = new Vector<String>();

			int compteur = 0;
			ToolsMAJ.ecrireLog(aEcrire,type,"Avant le while");
			
			while (resPrix.next()) {
				ArticleStruct id_prix = new ArticleStruct();
				id_prix.setString(id_prix.REFERENCE,"" + resPrix.getString("Article_Id_Site"));
				id_prix.setDouble(id_prix.PRIX_WEB,resPrix.getDouble("Prix_Web"));
				id_prix.setDouble(id_prix.TARIF_1,resPrix.getDouble("Tarif_1"));
				id_prix.setDouble(id_prix.TARIF_1_TTC,resPrix.getDouble("Tarif_1_TTC"));
				id_prix.setDouble(id_prix.TARIF_2,resPrix.getDouble("TARIF_2"));
				id_prix.setDouble(id_prix.TARIF_2_TTC,resPrix.getDouble("TARIF_2_TTC"));
				id_prix.setDouble(id_prix.TARIF_3,resPrix.getDouble("TARIF_3"));
				id_prix.setDouble(id_prix.TARIF_3_TTC,resPrix.getDouble("TARIF_3_TTC"));
				id_prix.setDouble(id_prix.TARIF_4,resPrix.getDouble("TARIF_4"));
				id_prix.setDouble(id_prix.TARIF_4_TTC,resPrix.getDouble("TARIF_4_TTC"));
				id_prix.setDouble(id_prix.TARIF_5,resPrix.getDouble("TARIF_5"));
				id_prix.setDouble(id_prix.TARIF_5_TTC,resPrix.getDouble("TARIF_5_TTC"));
				
				liste.add(id_prix.getStruct());
				listeId.add(resPrix.getString("Article_Id"));
				// On envoi tout les nbArticlesParEnvoi articles
				if ((compteur % nbArticlesParEnvoi) == 0 && compteur > 0) {
					ToolsMAJ.ecrireLog(aEcrire,type,"Appel du service pour " + nbArticlesParEnvoi + " articles.");
					envoyerMaj(serveur, liste.toArray());
					ToolsMAJ.ecrireLog(aEcrire,type,"Retour de la maj");
					appelToutServiceReussi = appelToutServiceReussi && appelServiceReussi;

					if (appelServiceReussi) {
						ToolsMAJ.ecrireLog(aEcrire,type,"Je valide ");
						validerDansOpenSi(con, base, site_id);
					}
					else {
						nbEchecs += nbArticlesParEnvoi;
					}

					liste = new Vector<Object>();
					listeId = new Vector<String>();// pour valider
				}
				compteur++;

			}
			nbArticles = compteur;

			// la fin de la liste
			if (nbArticles > 0) {
				ToolsMAJ.ecrireLog(aEcrire,type,"Appel du service pour " + nbArticlesParEnvoi + " articles.");
				envoyerMaj(serveur, liste.toArray());

				if (appelServiceReussi) {
					ToolsMAJ.ecrireLog(aEcrire,type,"[MAJInfos(appelService)] Je valide");
					validerDansOpenSi(con, base, site_id);
				}
				else {
					nbEchecs += nbArticlesParEnvoi;
				}
			}

		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJPrix(appelService)] ERREUR " + e);
			e.printStackTrace();
		}

	}

	private void envoyerMaj(String serveur, Object[] liste) {
		appelServiceReussi = true;
		try {
			Object resultat = AppelServices.majPrix(serveur, liste);
			Object[] rep = (Object[]) resultat;

			Object[] rapport = (Object[]) rep[0];

			lesRapports.addRapport(rapport);

		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"ERREUR:" + e);
			appelServiceReussi = false;
		}

	}

	private void ecrireRapport(String dossierRoot, String dossierId, String site_id) {

		try {
			RedactionRapport ecriveur = new RedactionRapport(ToolsMAJ.TYPE_MAJ_PRIX, nbRapports, dossierRoot, dossierId, site_id);

			ecriveur.ajouterLigne(dateDebut + ":La mise a jour des prix a t lance", true);
			if (nbArticles > 0) {
				if (!appelToutServiceReussi) {
					ecriveur.ajouterLigne("\nUne erreur s'est produite.", false);
				}

				String lesDetails = "";

				int cptErreur = 0;
				int cptOk = 0;

				while (lesRapports.next()) {
					if (lesRapports.aReussi()) {
						lesDetails += "\n<br>" + lesRapports.getMessageUtilisateur();
						cptOk++;
					}
					else {
						lesDetails += "\n<br><span class=\"echec\">" + lesRapports.getMessageUtilisateur() + "</span>";
						cptErreur++;
					}

					noErreurRapport = noErreurRapport && (lesRapports.aReussi());
				}

				if (noErreurRapport && nbEchecs == 0) {
					ecriveur.ajouterLigne(dateFin + ":Tous les prix ont t mis a jour", true);
				}
				else {
					ecriveur.ajouterLigne(dateFin + ":" + nbEchecs + " articles n'ont pas t mis a jour sur " + nbArticles + ".", false);
					ecriveur.ajouterLigne(dateFin + ":Fin de la transmission.", true);
				}

				if (!lesDetails.equals("")) {
					ecriveur.ajouterLigne(" ****************** DETAILS **************", true);
					ecriveur.ajouterLigne(lesDetails, true);
				}
			}
			else {
				ecriveur.ajouterLigne("Pas d'articles a mettre  jour", true);
			}

			ecriveur.fermerFichier();

		}
		catch (java.io.IOException e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"ERREUR:" + e);
		}

	}

	private void validerDansOpenSi(Connection con, String base, String site_id) {
		try {
			String listeId_str = "";

			if (listeId.size() > 0) {
				listeId_str += "'" + ToolsMAJ.sqlEncode("" + listeId.elementAt(0)) + "'";
			}

			for (int i = 1; i < listeId.size(); i++) {
				listeId_str += ",'" + ToolsMAJ.sqlEncode("" + listeId.elementAt(i)) + "'";
			}

			String req = "UPDATE " + base + ".FICHE_ARTICLE_WEB SET Prix_Modifie=0 WHERE Site_Id=" + site_id;
			req += " AND Article_Id IN (" + listeId_str + ")";
			Statement state = con.createStatement();
			state.executeUpdate(req);
		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"ERREUR " + e);
		}
	}
}
