/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Classe qui gre la taille des colonnes dans un document
 */

package org.opensi.util.pdf;

import java.util.ArrayList;


public class PdfWidths {
	
	protected ArrayList<LignePdfWidths> lignes = new ArrayList<LignePdfWidths>(10);
	
	
	public void addColonneFixe(float taille) {
		LignePdfWidths lpw = new LignePdfWidths();
		lpw.setTailleFixe(taille);
		this.lignes.add(lpw);
	}
	
	public void addColonneVariableMin(int poids, float tailleMin) {
		LignePdfWidths lpw = new LignePdfWidths();
		lpw.setPoids(poids);
		lpw.setTailleMin(tailleMin);
		this.lignes.add(lpw);
	}
	
	public void addColonneVariableMax(int poids, float tailleMax) {
		LignePdfWidths lpw = new LignePdfWidths();
		lpw.setPoids(poids);
		lpw.setTailleMax(tailleMax);
		this.lignes.add(lpw);
	}
	
	public void addColonneVariableMinMax(int poids, float tailleMin, float tailleMax) {
		LignePdfWidths lpw = new LignePdfWidths();
		lpw.setPoids(poids);
		lpw.setTailleMin(tailleMin);
		lpw.setTailleMax(tailleMax);
		this.lignes.add(lpw);
	}
	
	public void addColonneVariable(int poids) {
		LignePdfWidths lpw = new LignePdfWidths();
		lpw.setPoids(poids);
		this.lignes.add(lpw);
	}
	
	public int getNbCols() {
		return this.lignes.size();
	}
	
	
	public float[] getWidthsCols() {
		int size = this.lignes.size();
		float[] widths = new float[size];
		
		float largeurVariable = 100;
		int poidsTotal = 0;
		
		// On rserve l'espace pour les colonnes fixes
		for (int i=0; i<size; i++) {
			if (this.lignes.get(i).tailleFixe != 0) {
				largeurVariable -= this.lignes.get(i).tailleFixe;
				widths[i] = this.lignes.get(i).tailleFixe;
			} else {
				poidsTotal += this.lignes.get(i).poids;
			}
		}
		
		// On calcule les largeurs des colonnes par rapport  leur poids
		for (int i=0; i<size; i++) {
			if (this.lignes.get(i).tailleFixe == 0) {
				widths[i] = largeurVariable * ((float)this.lignes.get(i).poids / poidsTotal);
			}
		}
		
		// On rajuste les largeurs des colonnes selon leur taille min et max
		for (int i=0; i<size; i++) {
			if (this.lignes.get(i).tailleFixe == 0) {
				if (widths[i] < this.lignes.get(i).tailleMin) {
					this.lignes.get(i).tailleFixe = this.lignes.get(i).tailleMin;
					largeurVariable -= this.lignes.get(i).tailleMin;
					poidsTotal -= this.lignes.get(i).poids;
					widths[i] = this.lignes.get(i).tailleMin;
				} else if (widths[i] > this.lignes.get(i).tailleMax) {
					this.lignes.get(i).tailleFixe = this.lignes.get(i).tailleMax;
					largeurVariable -= this.lignes.get(i).tailleMax;
					poidsTotal -= this.lignes.get(i).poids;
					widths[i] = this.lignes.get(i).tailleMax;
				}
			}
		}
		
		// On rajuste les autres colonnes
		for (int i=0; i<size; i++) {
			if (this.lignes.get(i).tailleFixe == 0) {
				widths[i] = largeurVariable * ((float)this.lignes.get(i).poids / poidsTotal);
			}
		}
		
		
		return widths;
	}



} // fin PdfWidths
