/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.util.calcul;

import org.opensi.util.tools.Arrondi;


public abstract class CalculVentilTVACommission {

	protected double tauxTVA;
	protected double baseMontantC = 0;
	protected double baseHTbC = 0;
	protected double baseTTCbC = 0;
	protected double baseHTnC = 0;
	protected double montantTVAC = 0;
	protected double mRemisebC = 0;
	protected double baseTTCNC = 0;
	protected boolean npr = false;
	
	protected Arrondi r2 = new Arrondi(2);
	
	public CalculVentilTVACommission() {}
	
	public void addLigne(double tauxTVA, double montantBase,double pRemise, boolean ttc) {

		this.tauxTVA = tauxTVA;
		this.add(montantBase,pRemise, ttc);
	}
	
	public abstract void add(double montantBase,double pRemise, boolean ttc);
	
	public void setNPR(boolean npr) {
		this.npr = npr;
	}
		
 	public double getTauxTVA() { return tauxTVA; }    
 	public boolean getNPR() { return npr; }    
 	
	public double getTotalHTC() { return baseHTnC; }   
 	public double getTotalTTCC() { return baseTTCNC; }    
 	public double getTotalTVAC() { return montantTVAC; }    


}
