/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.util;

import org.opensi.util.tools.DateTime;


public class PeriodesExo {


	private long debutExercice;
	private long finExercice;


  public PeriodesExo(long debutExercice, long finExercice) {

		this.debutExercice = debutExercice;
		this.finExercice = finExercice;
	}


	/** renvoi les periodes en mois (date au 1er jour du mois) en millisecondes contenues entre les dates d'exercices donnes */

	public String getPeriodes() {
		
		String periodes = "";
		
		DateTime dt = new DateTime(finExercice);
		dt.setDay(1);
		long lastPeriode = dt.getDateInMillis();
		dt = new DateTime(debutExercice);
		
		do {
			dt.setDay(1);
			periodes += dt.getDateInMillis() +",";
			dt.addMonth(1);
			
		} while (dt.getDateInMillis()<=lastPeriode);
		
		return periodes;
	}

	
	/** renvoi les periodes en mois (date au 1er jour du mois) en millisecondes contenues entre les dates d'exercices donnes et infrieur  la priode courante */

	public String getPeriodesRB() {

		String periodes = "";
		
		DateTime dt = new DateTime(finExercice);
		dt.setDay(1);
		long lastPeriode = dt.getDateInMillis();
		dt = new DateTime();
		dt.setDay(1);
		long currentPeriode = dt.getDateInMillis();
		dt = new DateTime(debutExercice);
		
		do {
			dt.setDay(1);
			if (dt.getDateInMillis()<currentPeriode) {
				periodes += dt.getDateInMillis() +",";
			}
			dt.addMonth(1);
			
		} while (dt.getDateInMillis()<=lastPeriode);
		
		return periodes;
	}
		

} // fin PeriodesExo
