/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.facturation.reglements.clients;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;


public class GenPdfListeRelances extends Action {

	private String dossierId;
	private ResultSet rset;
	private PreparedStatement psReglement;
	private PreparedStatement psCountRel;

	class MyPageEvent implements PdfPageEvent {
		private String dossierId;

		private String dateCourante;

		private String raisonSociale;
		private String adresse1;
		private String adresse2;
		private String adresse3;
		private String codePostal;
		private String ville;
		private boolean premiereEdition;

		private ResultSet rset;


		public MyPageEvent(String dossierId, boolean premiereEdition) throws SQLException {

			this.dossierId = dossierId;
			this.premiereEdition = premiereEdition;

			Statement stt = con.createStatement();
			rset = stt.executeQuery("select * from "+ base +".SOCIETE");

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");

			rset.close();

			stt.close();

			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
		}



		public void onStartPage(PdfWriter writer, Document document) {

			try {

				// Entete G\u00E9n\u00E9rale


				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);

				cellEntete.setPhrase(new Phrase("Dossier : " + this.dossierId, fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Date : " + this.dateCourante, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(adresse1, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("", fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(adresse2, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);
				
				if (!adresse3.equals("")) {
					cellEntete.setPhrase(new Phrase(adresse3, fontGen));
					cellEntete.setColspan(2);
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
					entete.addCell(cellEntete);
					cellEntete.setColspan(1);
					
					cellEntete.setPhrase(new Phrase("", fontGen));
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
					entete.addCell(cellEntete);
				}

				cellEntete.setPhrase(new Phrase(codePostal + " " + ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				if (!premiereEdition) {
					cellEntete.setPhrase(new Phrase("Liste des relances en cours", new Font(Font.HELVETICA, 16, Font.BOLD)));
					cellEntete.setColspan(3);
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
					entete.addCell(cellEntete);
				}
				else {
					cellEntete.setPhrase(new Phrase("Liste des derni\u00E8res relances g\u00E9n\u00E9r\u00E9es", new Font(Font.HELVETICA, 16, Font.BOLD)));
					cellEntete.setColspan(3);
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
					entete.addCell(cellEntete);
				}
				cellEntete.setPhrase(new Phrase(""));
				cellEntete.setFixedHeight(10);
				entete.addCell(cellEntete);

				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);

				// fin Entete G\u00E9n\u00E9rale


				// Titres de colonnes
				PdfPTable titresColonnes;
				titresColonnes = new PdfPTable(8);
				titresColonnes.setWidthPercentage(100);
				titresColonnes.setWidths(widths);

				PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

				cellTitre.setFixedHeight(6);
				cellTitre.setBorder(PdfPCell.NO_BORDER);
				cellTitre.setPhrase(new Phrase(""));
				cellTitre.setColspan(8);
				titresColonnes.addCell(cellTitre);
				cellTitre.setColspan(1);

				cellTitre.setFixedHeight(20);
				cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
				cellTitre.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
				cellTitre.setPhrase(new Phrase(""));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				cellTitre.setPhrase(new Phrase("CLIENT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setPhrase(new Phrase("ECHEANCE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("N\u00B0 PIECE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("N\u00B0 RELANCE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("MONTANT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("REGLE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("RESTANT DU", fontLine));
				titresColonnes.addCell(cellTitre);

				document.add(titresColonnes);

				// fin Titres de colonnes

			} catch(DocumentException de) {
				de.printStackTrace();
			}
		}

		public void onEndPage(PdfWriter writer, Document document) {}
		public void onOpenDocument(PdfWriter writer, Document document) {}
		public void onCloseDocument(PdfWriter writer, Document document) {}
		public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
		public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
		public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
		public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
		public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
		public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
		public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

	}
	private int widths[] = {10,28,9,11,11,11,11,11}; // largeurs des colonnes du listing
	private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);		// font pour lignes de listing
	private static final Font fontTotal = new Font(Font.HELVETICA , 8, Font.BOLD);		// font pour lignes de listing
	private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);		// font pour lignes d'entete

	private DecimalFormat numFormat = new DecimalFormat("0.00");
	private DecimalFormat numFormatCap = new DecimalFormat("0.##");
	private Connection con;
	
	private String base;


	public boolean serverSide() { return true; }

	public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		this.dossierId = s.getCookie().get("Dossier_Id");
		base = s.getCookie().get("BaseDossier");

		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("-");
		numFormat.setNegativePrefix("");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);

		numFormatCap.setDecimalFormatSymbols(dfs);
		numFormatCap.setGroupingUsed(true);
		numFormatCap.setGroupingSize(3);

		con = s.getConnection(null);

		String reqReglement = "select ec.Date_Echeance, ec.Montant as Montant_Du, ec.Montant_Restant, (ec.Montant-ec.Montant_Restant) as Montant_Regle,";
		reqReglement += " coalesce(ec.Client_Id,'') as Client_Id, ec.Denomination, f.Num_Entier as Numero";
		reqReglement += " from "+ base +".ECHEANCE_CLIENT ec join "+ base +".FACTURE_ECHEANCE_CLIENT fec on ec.Echeance_Id=fec.Echeance_Id";
		reqReglement += " join "+ base +".FACTURE f on fec.Facture_Id=f.Facture_Id where ec.Echeance_Id=?";
		reqReglement += " union";
		reqReglement += " select ec.Date_Echeance, ec.Montant as Montant_Du, ec.Montant_Restant, (ec.Montant-ec.Montant_Restant) as Montant_Regle,";
		reqReglement += " coalesce(ec.Client_Id,'') as Client_Id, ec.Denomination, ac.Numero";
		reqReglement += " from "+ base +".ECHEANCE_CLIENT ec join "+ base +".ACOMPTE_ECHEANCE_CLIENT aec on ec.Echeance_Id=aec.Echeance_Id";
		reqReglement += " join "+ base +".ACOMPTE_CLIENT ac on aec.Acompte_Id=ac.Acompte_Id where ec.Echeance_Id=?";
		
		
		String reqCountRel = "select count(*) as n from "+ base +".RELANCE where Echeance_Id = ?";

		psReglement = con.prepareStatement(reqReglement);
		psCountRel = con.prepareStatement(reqCountRel);
		PdfPTable listing;
		listing = new PdfPTable(8);
		listing.setWidthPercentage(100);
		listing.setWidths(widths);

		Document document = new Document(PageSize.A4, 20, 20, 20, 20);
		String chemin = s.getAppConfiguration().get("opensi.absdir") + "/pdf/";

		String fichierPdf = "relances_"+ r.getParameter("id") +".pdf";

		PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));
		MyPageEvent event;
		boolean premiereEdition = r.getParameter("Premiere_Edition").equals("1");

		event = new MyPageEvent(dossierId, premiereEdition);
		writer.setPageEvent(event);

		if (!document.isOpen()) {
			document.open();
		}
		boolean Premier=true;
		String Client_Id="";
		String Denomination="";
		String[] relance = r.getParameter("ListeRelances").split(",");
		double tempMont =0;
		double tempRegle =0;
		double tempRest =0;
		double total=0;
		double totalRegle=0;
		double totalRest=0;
		double montant=0;
		double montantRegl=0;
		double montantRest=0;
		for (int z=0;z<relance.length;z++) {
			String idregl = relance[z];
			if (!idregl.equals("")) {
				int id=Integer.parseInt(idregl);
				psCountRel.setInt(1, id);
				rset = psCountRel.executeQuery();
				rset.next();
				String nb=rset.getString("n");
				psReglement.setInt(1, id);
				psReglement.setInt(2, id);
				rset = psReglement.executeQuery();
				rset.next();
				montant=rset.getDouble("Montant_Du");
				montantRegl=rset.getDouble("Montant_Regle");
				montantRest=rset.getDouble("Montant_Restant");
				if (Premier) {
					putLigneEcheanceTop(listing,rset.getLong("Date_Echeance"),rset.getString("Client_Id"),rset.getString("Denomination"), rset.getString("Numero"),nb,rset.getDouble("Montant_Du"),rset.getDouble("Montant_Regle"), rset.getDouble("Montant_Restant"));
					Premier=false;
				}
				else if (z+1==relance.length) {
					putLigneEcheanceBox(listing,rset.getLong("Date_Echeance"),rset.getString("Client_Id"),rset.getString("Denomination"), rset.getString("Numero"),nb,rset.getDouble("Montant_Du"),rset.getDouble("Montant_Regle"), rset.getDouble("Montant_Restant"));
				}
				else if (Client_Id.equals(rset.getString("Client_Id")) && Denomination.equals(rset.getString("Denomination"))) {
					putLigneEcheance(listing,rset.getLong("Date_Echeance"),rset.getString("Client_Id"),rset.getString("Denomination"), rset.getString("Numero"),nb,rset.getDouble("Montant_Du"),rset.getDouble("Montant_Regle"), rset.getDouble("Montant_Restant"));
				}
				else {
					putLigneTempTotal(listing,tempMont,tempRegle,tempRest);
					tempMont =0;
					tempRegle =0;
					tempRest =0;
					putLigneEcheanceTop(listing,rset.getLong("Date_Echeance"),rset.getString("Client_Id"),rset.getString("Denomination"), rset.getString("Numero"),nb,rset.getDouble("Montant_Du"),rset.getDouble("Montant_Regle"), rset.getDouble("Montant_Restant"));
				}
				Client_Id=rset.getString("Client_Id");
				Denomination=rset.getString("Denomination");
			}
			tempMont += montant;
			tempRegle += montantRegl;
			tempRest += montantRest;
			total += montant;
			totalRegle += montantRegl;
			totalRest += montantRest;
		}
		putLigneTotal(listing,total,totalRegle,totalRest);

		rset.close();

		document.add(listing);
		s.closeConnection(con, null);
		document.close();
		try {
			File filePdf = new File(chemin, fichierPdf);
			filePdf.deleteOnExit();
		} catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier \u00E0 supprimer");
			se.printStackTrace();
		}

		return true;

	} // fin service


	private PdfPTable putLigneEcheanceBox(PdfPTable listing,
			long dateEch,
			String Client_Id,
			String Denomination,
			String Numero,
			String Nombre,
			double du,
			double regle,
			double rest) {

		SimpleDateFormat formatDatePoint = new SimpleDateFormat("dd.MM.yy");

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setBorder(PdfPCell.BOX-PdfPCell.RIGHT);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase(Client_Id, fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.BOX-PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase(Denomination, fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(formatDatePoint.format(new Date(dateEch)), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(Numero, fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(Nombre, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(du), fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(regle!=0?numFormat.format(regle):"", fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(rest!=0?numFormat.format(rest):"", fontLine));
		listing.addCell(cellListing);
		return listing;
	}

	private PdfPTable putLigneEcheanceTop(PdfPTable listing,
			long dateEch,
			String Client_Id,
			String Denomination,
			String Numero,
			String Nombre,
			double du,
			double regle,
			double rest) {

		SimpleDateFormat formatDatePoint = new SimpleDateFormat("dd.MM.yy");

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setBorder(PdfPCell.LEFT+PdfPCell.TOP);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase(Client_Id, fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.RIGHT+PdfPCell.TOP);
		cellListing.setPhrase(new Phrase(Denomination, fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.RIGHT+PdfPCell.LEFT+PdfPCell.TOP);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(formatDatePoint.format(new Date(dateEch)), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(Numero, fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(Nombre, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(du), fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(regle!=0?numFormat.format(regle):"", fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(rest!=0?numFormat.format(rest):"", fontLine));
		listing.addCell(cellListing);
		return listing;
	}

	private PdfPTable putLigneEcheance(PdfPTable listing,
			long dateEch,
			String Client_Id,
			String Denomination,
			String Numero,
			String Nombre,
			double du,
			double regle,
			double rest) {

		SimpleDateFormat formatDatePoint = new SimpleDateFormat("dd.MM.yy");

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setBorder(PdfPCell.LEFT);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.RIGHT);
		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.RIGHT+PdfPCell.LEFT);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(formatDatePoint.format(new Date(dateEch)), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(Numero, fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(Nombre, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(du), fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(regle!=0?numFormat.format(regle):"", fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(rest!=0?numFormat.format(rest):"", fontLine));
		listing.addCell(cellListing);
		return listing;
	}
	private void putLigneTempTotal(PdfPTable listing,
			double montant,
			double regle,
			double rest) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBorder(PdfPCell.BOX-PdfPCell.BOTTOM);
		cellListing.setPaddingRight(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setColspan(2);
		cellListing.setPhrase(new Phrase("",fontTotal));
		listing.addCell(cellListing);

		cellListing.setColspan(1);
		cellListing.setPhrase(new Phrase("",fontTotal));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase("",fontTotal));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase("Total ", fontTotal));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(montant==0?PdfPCell.ALIGN_LEFT:PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(montant),fontTotal ));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(regle!=0?numFormat.format(regle):"", fontTotal));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(rest!=0?numFormat.format(rest):"", fontTotal));
		listing.addCell(cellListing);
	}
	/** Ajoute une ligne de total de la periode d'edition du journal au listing */

	private void putLigneTotal(PdfPTable listing, double totalTTC, double totalRegle, double totalRest) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(new Color(210,210,210));
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setColspan(2);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);

		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);

		cellListing.setColspan(3);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase("Total relances", fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setColspan(1);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(totalTTC), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(numFormat.format(totalRegle), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(numFormat.format(totalRest), fontLine));
		listing.addCell(cellListing);
	}

} // fin GenPdfRelances



