/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'une liste d'chances
 */

package org.opensi.facturation.reglements.clients;


import org.opensi.api.SessionOSI;
import org.opensi.util.pdf.GlobalDocument;
import org.opensi.util.tools.DateTime;


public class GenPdfEcheances {
	

	public GenPdfEcheances(SessionOSI sosi, String nomFichier, String etat, String dateDebut, String dateFin, int modeReglement, String clientId, boolean detail, String tri, boolean sousTotaux) throws Exception {
		
		long dateD = 0;
		long dateF = 0;

		if (!dateDebut.equals("")) {
			DateTime dt = new DateTime(DateTime.parseDate(dateDebut, "yyyy:MM:dd"));
			dateD = dt.getDateInMillis();
		}
		if (!dateFin.equals("")) {
			DateTime dt = new DateTime(DateTime.parseDate(dateFin, "yyyy:MM:dd"));
			dateF = dt.getDateFullTime();
		}
		
		DataEcheances de = new DataEcheances(sosi, etat, dateD, dateF, modeReglement, clientId, detail, tri, sousTotaux);
		
		String repPdf = sosi.getPdfDirectory();
		String repTemp = repPdf;
	
		PdfEcheances pdfEcheances = new PdfEcheances(repTemp, de);
		GlobalDocument gd = new GlobalDocument(repPdf, nomFichier);
		gd.addInternal(pdfEcheances);
		gd.close(GlobalDocument.ON_EXIT);
	}


} // fin GenPdfEcheances
