/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'une remise d'espces
 */

package org.opensi.facturation.reglements.clients;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.opensi.api.SessionOSI;
import org.opensi.util.tools.DateTime;

public class DataRemiseEspeces {

	// les lignes de la remise d'espces
	protected ArrayList<LigneRemiseEspeces> lignesPieces = new ArrayList<LigneRemiseEspeces>(10);
	protected ArrayList<LigneRemiseEspeces> lignesBillets = new ArrayList<LigneRemiseEspeces>(10);
	
	protected String dateCourante;
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String typer;
	protected String adresseBanque;
	protected String codeAgence;
	protected String codeGuichet;
	protected String compte;
	protected String cleRib;
	protected String iban;
	protected String bic;
	
	protected double totalBillets;
	protected double totalPieces;
	
	
	public DataRemiseEspeces(SessionOSI sosi, int remiseId) {

		try {
			Connection con = sosi.getConnection();
			Statement stt = con.createStatement();
			String base = sosi.getBaseDossier();
			
			this.dateCourante = DateTime.formatTime(new DateTime().getTimeInMillis(), "dd/MM/yyyy");
			
			String reqLeDossier = "select * from "+ base +".SOCIETE";
			ResultSet rset = stt.executeQuery(reqLeDossier);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			rset.close();
			
			String reqRemise = "select tr.Libelle as Type_Reglement, rb.Banque_Remise from "+ base +".REMISE_BANQUE rb join "+ base +".TYPE_REGLEMENT tr on rb.Type_Reg_Id=tr.Type_Reg_Id";
			reqRemise += " where rb.Remise_Id="+ remiseId;
			rset = stt.executeQuery(reqRemise);
			rset.next();
			int banqueRemise = rset.getInt("Banque_Remise");
			this.typer = rset.getString("Type_Reglement");
			rset.close();
			
			String reqbanque = "select * from "+ base +".BANQUE where Banque_Id="+ banqueRemise;
			rset = stt.executeQuery(reqbanque);
			rset.next();
			this.adresseBanque = rset.getString("Adresse");
			this.codeAgence = rset.getString("Code_Agence");
			this.codeGuichet = rset.getString("Code_Guichet");
			this.compte = rset.getString("Num_Compte");
			this.cleRib = rset.getString("Cle_RIB");
			this.iban = rset.getString("IBAN");
			this.bic = rset.getString("BIC");
			rset.close();
			
			String reqLignesRemise = "select md.Valeur, md.Type, md.Qte_Remise, lre.Quantite from " + base + ".LIGNE_REMISE_ESPECE lre join MONNAIE_DEVISE md on lre.Monnaie_Id=md.Monnaie_Id";
			reqLignesRemise += " where lre.Remise_Id="+ remiseId;

			rset = stt.executeQuery(reqLignesRemise);
			while (rset.next()) {
				LigneRemiseEspeces lre = new LigneRemiseEspeces();
				lre.setValeurFaciale(rset.getDouble("Valeur"));
				lre.setType(rset.getString("Type"));
				
				if (lre.type.equals("P")) {
					lre.setNbPiecesParRouleau(rset.getInt("Qte_Remise"));
					lre.setValeurRouleau(lre.valeurFaciale*lre.nbPiecesParRouleau);
					lre.setNombre(rset.getInt("Quantite")/lre.nbPiecesParRouleau);
					lre.setMontant(lre.nombre*lre.valeurFaciale*lre.nbPiecesParRouleau);
					totalPieces += lre.montant;
					
					lignesPieces.add(lre);
				} else {
					lre.setNombre(rset.getInt("Quantite"));
					lre.setMontant(lre.nombre*lre.valeurFaciale);
					totalBillets += lre.montant;
					
					lignesBillets.add(lre);
				}
			}
			rset.close();
			stt.close();

		}
		catch(Exception e) {
			e.printStackTrace();
		}			
	}
	
	public int getNbLignesPieces() {
		return lignesPieces.size();
	}
	
	public int getNbLignesBillets() {
		return lignesBillets.size();
	}


} // fin DataRemiseEspeces
