/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *   Export des expditions
 */

package org.opensi.facturation.expedition;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.util.tools.Arrondi;


public class DataExpedition {

	// les lignes de l'export
	protected ArrayList<LigneExpedition> lignes = new ArrayList<LigneExpedition>(10);

	protected String compteClient;
	protected boolean colis;

	protected String nomDossier;
	protected String emailDossier;
	protected String adresse1Dossier;
	protected String adresse2Dossier;
	protected String adresse3Dossier;
	protected String codePostalDossier;
	protected String villeDossier;
	protected String codePaysDossier;
	protected String telDossier;
	
	protected PreparedStatement psPoidsBL;


	public DataExpedition(Session s, String periode, String numClient, long debutPeriode, long finPeriode, String expediteur, boolean colis, String provenance) {
		try {
		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();

			String base = s.getCookie().get("BaseDossier");
			
			this.compteClient = numClient;
			this.colis = colis;
			
			String reqSociete = "select Denomination, Adresse_1, Adresse_2, Adresse_3, Code_Postal, Ville, 'FR' as Code_Pays, Telephone, Email";
			reqSociete += " from "+ base + ".SOCIETE";
			ResultSet rset = stt.executeQuery(reqSociete);
			rset.next();
			this.nomDossier = rset.getString("Denomination");
			this.adresse1Dossier = rset.getString("Adresse_1");
			this.adresse2Dossier = rset.getString("Adresse_2");
			this.adresse3Dossier = rset.getString("Adresse_3");
			this.codePostalDossier = rset.getString("Code_Postal");
			this.villeDossier = rset.getString("Ville");
			this.codePaysDossier = rset.getString("Code_Pays");
			this.telDossier = rset.getString("Telephone");
			this.emailDossier = rset.getString("Email");
			rset.close();

			String bons = "select bl.*, if(cc.Assujetti_TVA=1,cc.Num_TVA_Intra,'') as Num_TVA_Intra, p.Nom_FR, p.Zone_UE, m.Relais, c.Civ_Courte as Civ_Courte_Liv, cc.Ref_Commande, cc.Client_Id, coalesce(ccw.Code_Porte, '') as Code_Porte, cc.Denomination, cc.Nom_Inter, cc.Prenom_Inter, cc.Tel_Inter from "+ base +".BON_LIVRAISON bl, PAYS p,"+ base +".MODE_LIVRAISON m, CIVILITE c,"+ base +".COMMANDE_CLIENT cc left join  "+ base +".COMMANDE_CLIENT_WEB ccw on cc.Commande_Id=ccw.Commande_Id";
			bons += " where bl.Commande_Id=cc.Commande_Id and bl.Civ_Inter_Liv=c.Civ_Id and m.Mode_Liv_Id=bl.Mode_Expedition and bl.Code_Pays_Liv=p.Code_Pays and bl.Com_Fournisseur_Id is null and";
			
			if (provenance.equals("HL")) { bons += " ccw.Site_Web_Id is null and"; }
			else if (provenance.equals("SW")) { bons += " ccw.Site_Web_Id is not null and"; }
			
			if (periode.equals("A") || periode.equals("M")) {
				bons+=" bl.Date_Liv>="+debutPeriode+" and ";
			} else if (periode.equals("dd")) {
				bons+=" bl.Date_Liv>="+debutPeriode+" and bl.Date_Liv<"+finPeriode+" and ";
			}
			
			if (colis) {
				bons+=" bl.Bon_Id not in (select Bon_Id from "+ base +".COLIS where Ident_Suivi<>'') and ";						
			}
			
			if (expediteur.length()>0) {
				bons += " bl.Mode_Expedition in ("+ expediteur +") and";
			}
			
			bons+=" bl.Numero>0 and bl.Etat='V' order by bl.Num_Entier";
						

			String requetePoids = " select sum(if(f.Mesure_Poids='K',f.Poids_Brut,if(f.Mesure_Poids='G',f.Poids_Brut/1000,f.Poids_Brut*1000))* abl.Quantite) as poids from "+ base +".FICHE_ARTICLE f, "+ base +".LIGNE_BON_LIVRAISON abl,"+ base +".LIGNE_COMMANDE_CLIENT acc"
												 + " where f.Article_Id=acc.Reference and Type_Ligne='S' and acc.Statut='V' and abl.Statut='V' and acc.Ligne_Id=abl.Ref_Ligne and abl.Bon_Id=?";

			psPoidsBL = con.prepareStatement(requetePoids);

			rset = stt.executeQuery(bons);
			while (rset.next()) {
				this.ajouterLigne(rset);
			}
			rset.close();
			psPoidsBL.close();
			stt.close();
			s.closeConnection(con, null);

		} catch(Exception e) {
			e.printStackTrace();
		}
	}


	public void ajouterLigne(ResultSet rset) {
		try {
			LigneExpedition le = new LigneExpedition();
			
			double poids = 0;
			psPoidsBL.setInt(1, rset.getInt("Bon_Id"));
			ResultSet rsPBL = psPoidsBL.executeQuery();
			if (rsPBL.next()) {
				poids = rsPBL.getDouble("poids");
			}
			rsPBL.close();

			String clientId = rset.getString("Client_Id");
			boolean relaisColis = (rset.getInt("Relais")==1);

			String nomPrenomDestFinal = "";
			if (relaisColis) {
				if (!rset.getString("Nom_Inter").equals("")) {
					nomPrenomDestFinal = formaterChaine(rset.getString("Nom_Inter"),17) +" "+ formaterChaine(rset.getString("Prenom_Inter"),12);
				}
				else {
					nomPrenomDestFinal = formaterChaine(rset.getString("Denomination"),17);
				}
			}

			le.setNumEntier(rset.getString("Num_Entier"));
			le.setNomLiv(relaisColis?"RELAIS COLIS":rset.getString("Denomination_Liv"));
			le.setAdresseLiv(relaisColis?rset.getString("Denomination_Liv"):rset.getString("Adresse_1_Liv"));
			le.setCompAdresseLiv(relaisColis?rset.getString("Adresse_1_Liv"):rset.getString("Adresse_2_Liv"));
			le.setAdresse3Liv(rset.getString("Adresse_3_Liv"));
			le.setCPLiv(rset.getString("Code_Postal_Liv"));
			le.setVilleLiv(rset.getString("Ville_Liv"));
			le.setPaysLiv(rset.getString("Nom_FR"));
			le.setCivInterLiv(rset.getString("Civ_Courte_Liv"));
			le.setNomInterLiv(rset.getString("Nom_Inter_Liv"));
			le.setPrenomInterLiv(rset.getString("Prenom_Inter_Liv"));
			le.setTelInterLiv(rset.getString("Tel_Inter_Liv"));
			le.setEmailInterLiv(rset.getString("Email_Inter_Liv"));
			le.setCodePorteLiv(rset.getString("Code_Porte"));
			le.setInfosLiv("");
			le.setCompteClient(this.compteClient);
			le.setTypeExpedition('C');
			le.setPoids(poids<0.1?0.1:(poids>999.9?999.9:poids));
			le.setRefClient(rset.getString("Num_Entier"));
			le.setRefCommande(rset.getString("Ref_Commande"));
			le.setValeurDeclaree(0); // doit tre  0 si relais colis
			le.setNbColis(1);
			le.setCodeDestinataire(relaisColis?formaterChaine(rset.getString("Nom_Inter_Liv"),5):(clientId!=null?clientId:""));			
			le.setCodePaysLiv(rset.getString("Code_Pays_Liv"));
			le.setRelaisColis(relaisColis);
			le.setInstruction(nomPrenomDestFinal);
			le.setCompInstruction(relaisColis?formaterTel(rset.getString("Tel_Inter"),10):"");
			le.setZoneUtilisateur(formaterChaine(rset.getString("Civ_Courte_Liv") +" "+ rset.getString("Nom_Inter_Liv"),13) +"  "+ formaterTel(rset.getString("Tel_Inter_Liv"),10));
			le.setMontantReglement(0);
			le.setDateDepartColis("");
			le.setNomDossier(this.nomDossier);
			le.setEmailDossier(this.emailDossier);
			le.setAdresse1Dossier(this.adresse1Dossier);
			le.setAdresse2Dossier(this.adresse2Dossier);
			le.setAdresse3Dossier(this.adresse3Dossier);
			le.setCodePostalDossier(this.codePostalDossier);
			le.setVilleDossier(this.villeDossier);
			le.setCodePaysDossier(this.codePaysDossier);
			le.setTelDossier(this.telDossier);
			le.setNumTVAIntra(rset.getString("Num_TVA_Intra"));
			le.setTotalHT(rset.getDouble("Total_HT"));
			le.setZoneUE(rset.getString("Zone_UE").equals("1"));
			le.setDevise("EUR");

			lignes.add(le);
		} catch(Exception e) {
			e.printStackTrace();
		}		
	}

	public String formaterChaine(String chaine, int longueur_max) {
		String nouv_chaine = chaine;
		if (nouv_chaine.length() < longueur_max) {
			for (int i=nouv_chaine.length(); i<longueur_max; i++)
				nouv_chaine += " ";
		} else {
			nouv_chaine = nouv_chaine.substring(0,longueur_max);
		}
		return nouv_chaine;
	}
	
	
	public String formaterDouble(double nombre, int longueur_max, int nb_decimales) {
		String nouv_chaine = "";
		
		if (nb_decimales==0) {
			int nb = (int)nombre;
			nouv_chaine += nb;
		} else {
			Arrondi arrondi = new Arrondi(nb_decimales);
			String pattern = "0.0";
			for (int i=1; i<nb_decimales; i++)
				pattern += "0";
			DecimalFormatSymbols dfs = new DecimalFormatSymbols();
			dfs.setDecimalSeparator('.');
			DecimalFormat numFormat = new DecimalFormat(pattern);			
			numFormat.setDecimalFormatSymbols(dfs);
			nouv_chaine += numFormat.format(arrondi.round(nombre));
		}		
		
		for (int i=nouv_chaine.length(); i<longueur_max; i++)
			nouv_chaine = "0" + nouv_chaine;
		
		return nouv_chaine;
	}
	
	
	public String formaterEntier(int nombre, int longueur_max) {
		String nouv_chaine = "" + nombre;
		
		for (int i=nouv_chaine.length(); i<longueur_max; i++)
			nouv_chaine = "0" + nouv_chaine;
		
		return nouv_chaine;
	}
	
	public String purgeSpecialChars(String source) {
		StringBuffer result = new StringBuffer();
		int index = -1;
		char current_char = (char)0;
		String chars_src = "";
		String chars_dst = "aaaeeeeiioouuuc";
		for(int i=0; i<source.length(); i++) {
			current_char = source.charAt(i);
			index = chars_src.indexOf(current_char);
			if (index!=-1)
				result.append(chars_dst.charAt(index));
			else
				result.append(current_char);
		}
		return result.toString();
	}
	

	public String formaterTel(String chaine, int nbChiffres) {
		String nouv_chaine = "";

		for (int i=0; i<chaine.length(); i++) {
			if (chaine.charAt(i)>='0' && chaine.charAt(i)<='9') {
				nouv_chaine += chaine.charAt(i);
			}
		}
		
		int lg = nouv_chaine.length();
		if (lg>nbChiffres) {
			nouv_chaine = nouv_chaine.substring(lg-nbChiffres); // on ne garde que les 'nbChiffres' derniers chiffres
		}

		return formaterChaine(nouv_chaine,nbChiffres);
	}
	

	public ArrayList<LigneExpedition> getLignes() {
		return lignes;
	}


	public int getNbLignes() {
		return lignes.size();
	}

} // fin DataExpedition
