/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.commerciaux;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;

import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;


public class VentesCommercial {
	
	
	private class VenteArticlePeriode {
		public ArrayList<VenteArticle> ventes;
		public double totalCommission;
		public long dateDebut;
		public long dateFin;
		
		public VenteArticlePeriode(ArrayList<VenteArticle> ventes, double totalCommission, long dateDebut, long dateFin) {
			this.ventes = ventes;
			this.totalCommission = totalCommission;
			this.dateDebut = dateDebut;
			this.dateFin = dateFin;
		}
	}
	
	private class VenteArticle implements Comparable<VenteArticle> {
		public String refClient;
		public String refArticle;
		public int marque;
		public int famille1;
		public int famille2;
		public int famille3;
		public double totalCommission;
		public boolean enStock;
		// spcifie si on peut calculer la somme des commissions des factures pour un client donn,
		// suppose que le dtail pour toutes les factures est possible
		public boolean totalClientCalculable;
		public ArrayList<DetailVenteFacture> details;
		
		public VenteArticle(String refArticle, int marque, int famille1, int famille2, int famille3, double totalCommission, boolean enStock, ArrayList<DetailVenteFacture> details) {
			this.refClient = "";
			this.refArticle = refArticle;
			this.marque = marque;
			this.famille1 = famille1;
			this.famille2 = famille2;
			this.famille3 = famille3;
			this.totalClientCalculable = false;
			this.totalCommission = totalCommission;
			this.enStock = enStock;
			this.details = details;
		}
		
		public VenteArticle(String refClient, boolean totalClientCalculable, double totalCommission, ArrayList<DetailVenteFacture> details) {
			this.refClient = refClient;
			this.refArticle = "";
			this.marque = 0;
			this.famille1 = 0;
			this.famille2 = 0;
			this.famille3 = 0;
			this.totalClientCalculable = totalClientCalculable;
			this.totalCommission = totalCommission;
			this.enStock = true;
			this.details = details;
		}
		
		public int compareTo(VenteArticle temp) { 
			return this.refClient.compareTo(temp.refClient);
		}
	}
	
	
	private class DetailVenteFacture implements Comparable<DetailVenteFacture> {
		public String refFacture;
		public double commission;
		public boolean detailPossible;
		
		public DetailVenteFacture(String refFacture, double commission, boolean detailPossible) {
			this.refFacture = refFacture;
			this.commission = commission;
			this.detailPossible = detailPossible;
		}
		
		public int compareTo(DetailVenteFacture temp) { 
			return this.refFacture.compareTo(temp.refFacture);
		}
	}
	
	
	private Connection con;
	private String base;
	private int commercialId;
	private String filtre;
	private ArrayList<Regle> regles;
	private ArrayList<long[]> periodes;	
	protected ArrayList<VenteArticlePeriode> ventesArticlesPeriodes;
	protected double totalTTC;
	protected double totalHT;
	protected double totalCommission;
	protected double valAjustement;
	protected String commentaires;
	
	/* FONCTIONS APPELEES DEPUIS LES TEMPLATES */
	public double getTotalHT() { return this.totalHT; }
	public double getTotalTTC() { return this.totalTTC; }
	public double getTotalCommission() { return this.totalCommission; }
	public double getValAjustement() { return this.valAjustement; }
	public int getNbVentesArticlesPeriodes() { return this.ventesArticlesPeriodes.size(); }
	public double getTotalCommissionMois(int rg) { return this.ventesArticlesPeriodes.get(rg).totalCommission; }
	public long getDateDebut(int rg) { return this.ventesArticlesPeriodes.get(rg).dateDebut; }
	public long getDateFin(int rg) { return this.ventesArticlesPeriodes.get(rg).dateFin; }
	public int getNbVentes(int rg) { return this.ventesArticlesPeriodes.get(rg).ventes.size(); }
	public String getRefClient(int rg1, int rg2) { return this.ventesArticlesPeriodes.get(rg1).ventes.get(rg2).refClient; }
	public String getRefArticle(int rg1, int rg2) { return this.ventesArticlesPeriodes.get(rg1).ventes.get(rg2).refArticle; }
	public int getMarque(int rg1, int rg2) { return this.ventesArticlesPeriodes.get(rg1).ventes.get(rg2).marque; }
	public int getFamille1(int rg1, int rg2) { return this.ventesArticlesPeriodes.get(rg1).ventes.get(rg2).famille1; }
	public int getFamille2(int rg1, int rg2) { return this.ventesArticlesPeriodes.get(rg1).ventes.get(rg2).famille2; }
	public int getFamille3(int rg1, int rg2) { return this.ventesArticlesPeriodes.get(rg1).ventes.get(rg2).famille3; }
	public boolean getTotalClientCalculable(int rg1, int rg2) { return this.ventesArticlesPeriodes.get(rg1).ventes.get(rg2).totalClientCalculable; }
	public double getTotalCommission(int rg1, int rg2) { return this.ventesArticlesPeriodes.get(rg1).ventes.get(rg2).totalCommission; }
	public boolean getEnStock(int rg1, int rg2) { return this.ventesArticlesPeriodes.get(rg1).ventes.get(rg2).enStock; }
	public int getNbDetails(int rg1, int rg2) { return this.ventesArticlesPeriodes.get(rg1).ventes.get(rg2).details.size(); }
	public String getRefFacture(int rg1, int rg2, int rg3) { return this.ventesArticlesPeriodes.get(rg1).ventes.get(rg2).details.get(rg3).refFacture; }
	public double getCommission(int rg1, int rg2, int rg3) { return this.ventesArticlesPeriodes.get(rg1).ventes.get(rg2).details.get(rg3).commission; }
	public boolean getDetailCommissionPossible(int rg1, int rg2, int rg3) { return this.ventesArticlesPeriodes.get(rg1).ventes.get(rg2).details.get(rg3).detailPossible; }
	/* --------------------------------------- */
	

	public VentesCommercial(String s, int commercialId, long dateDebut, long dateFin, String filtre) {
		this(org.experlog.openeas.api.Session.findClient(s), commercialId, dateDebut, dateFin, filtre, 0, "");
	}

	public VentesCommercial(Session s, int commercialId, long dateDebut, long dateFin, String filtre, double ajustement, String commentaires) {
		try {
			this.con = s.getConnection(null);
			this.base = s.getCookie().get("BaseDossier");
			this.commercialId = commercialId;
			this.filtre = filtre;
			this.valAjustement = ajustement;
			this.commentaires = commentaires;
			
			chargerRegles();
			chargerPeriodes(dateDebut, dateFin);
			chargerVentes(dateDebut, dateFin);
			
			s.closeConnection(con, null);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	public void chargerRegles() {
		try {
			this.regles = new ArrayList<Regle>();
			String reqRegles = "select rc.Commission_Id, rc.Type, rc.Base_Calcul, coalesce(rc.Marque_Id,0) as Marque_Id, coalesce(rc.Famille_1,0) as Famille_1, coalesce(rc.Famille_2,0) as Famille_2, coalesce(rc.Famille_3,0) as Famille_3,";
			reqRegles += " rc.Article_Id, rc.Mode_Calcul_Qte, rc.Base_Calcul_Qte,";
			reqRegles += " coalesce(ma.Libelle,'') as LblMarque, coalesce(fa1.Libelle,'') as LblFamille1, coalesce(fa2.Libelle,'') as LblFamille2, coalesce(fa3.Libelle,'') as LblFamille3,";
			reqRegles += " if(rc.Type='A',1,if(rc.Type='FA' and rc.Famille_2 is not null and rc.Famille_3 is not null,2,if(rc.Type='FA' and rc.Famille_2 is not null,3,if(rc.Type='FA',4,if(rc.Type='MQ',5,if(rc.Type='AS',6,if(rc.Type='HS',7,8))))))) as Priorite";
			reqRegles += " from "+ this.base +".REGLE_COMMISSION rc left join "+ this.base +".MARQUE_ARTICLE ma on rc.Marque_Id=ma.Marque_Id";
			reqRegles += " left join "+ this.base +".FAMILLE_ARTICLE fa1 on rc.Famille_1=fa1.Famille_Id left join "+ this.base +".FAMILLE_ARTICLE fa2 on rc.Famille_2=fa1.Famille_Id left join "+ this.base +".FAMILLE_ARTICLE fa3 on rc.Famille_3=fa1.Famille_Id";
			reqRegles += " where rc.Commercial_Id="+ this.commercialId;
			reqRegles += " order by Priorite, rc.Base_Calcul, if(Priorite=1 or Priorite>5,rc.Article_Id,if(Priorite=2 or Priorite=3 or Priorite=4, LblFamille1, LblMarque)), if(Priorite=2 or Priorite=3,LblFamille2,0), if(Priorite=3,LblFamille3,0)";
			String reqTranches = "select * from "+ this.base +".TRANCHE_COMMISSION where Commission_Id=? order by Borne_Inf";
			
			Statement stt = this.con.createStatement();
			PreparedStatement psTranches = this.con.prepareStatement(reqTranches);			
			ResultSet rset = stt.executeQuery(reqRegles);
			while (rset.next()) {
				int regleId = rset.getInt("Commission_Id");
				String typeCommission = rset.getString("Type");
				String baseCalcul = rset.getString("Base_Calcul");
				int marque = rset.getInt("Marque_Id");
				int famille1 = rset.getInt("Famille_1");
				int famille2 = rset.getInt("Famille_2");
				int famille3 = rset.getInt("Famille_3");
				String article = rset.getString("Article_Id");
				String modeCalculQte = rset.getString("Mode_Calcul_Qte");
				String baseCalculQte = rset.getString("Base_Calcul_Qte");
				
				ArrayList<Tranche> tranches = new ArrayList<Tranche>();
				psTranches.setInt(1, regleId);
				ResultSet rset2 = psTranches.executeQuery();
				while (rset2.next()) {
					Tranche tranche = new Tranche(rset2.getDouble("Borne_Inf"), rset2.getDouble("Borne_Sup"), rset2.getDouble("Valeur"));
					tranches.add(tranche);
				}
				rset2.close();
				this.regles.add(new Regle(typeCommission, baseCalcul, marque, famille1, famille2, famille3, article, modeCalculQte, baseCalculQte, tranches));
			}
			rset.close();
			stt.close();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	public void chargerPeriodes(long dateDebut, long dateFin) {
		this.periodes = new ArrayList<long[]>();
		// Dcoupage mensuel de la priode
		DateTime dd = new DateTime(dateDebut);
		DateTime df = new DateTime(dateFin);
		int anneeDeb = dd.getYear();
		int anneeFin = df.getYear();
		for (int i=anneeDeb; i<=anneeFin; i++) {
			long dateDebutAnnee = (i>anneeDeb?new DateTime(01, 01, i).getDateInMillis():dateDebut);
			long dateFinAnnee = (i<anneeFin?new DateTime(31, 12, i).getDateFullTime():dateFin);
			dd.setTimeInMillis(dateDebutAnnee);
			df.setTimeInMillis(dateFinAnnee);
			int moisDeb = dd.getMonth();
			int moisFin = df.getMonth();
			for (int j=moisDeb; j<=moisFin; j++) {
				long dateDebutMois = (j>moisDeb?new DateTime(01,j,i).getDateInMillis():dateDebutAnnee);
				dd.setTimeInMillis(dateDebutMois);
				long dateFinMois = (j<moisFin?new DateTime(dd.currentMaxDay(),j,i).getDateFullTime():dateFinAnnee);
				long[] interval = {dateDebutMois, dateFinMois};
				this.periodes.add(interval);
			}
		}
	}
	
	
	public void chargerVentes(long dateDebut, long dateFin) {
		try {
			this.ventesArticlesPeriodes = new ArrayList<VenteArticlePeriode>();
			// on recalcule manuellement pour NE PAS tenir compte des frais de ports
			String reqTotaux = "select sum(if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne / (1+af.Taux_TVA/100)) * (1-f.Remise/100)) as TotalHT,";
			reqTotaux += " sum(if(f.Edition_TTC=1,af.Montant_Ligne,af.Montant_Ligne * (1+af.Taux_TVA/100)) * (1-f.Remise/100) * (1-f.Escompte/100)) as TotalTTC";
			reqTotaux += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af where f.Facture_Id=af.Facture_Id and f.Util_R="+ this.commercialId;
			reqTotaux += " and f.Numero<>0 and f.Date_Facture>="+ dateDebut +" and f.Date_Facture<="+ dateFin;
			
			Statement stt = this.con.createStatement();
			ResultSet rset = stt.executeQuery(reqTotaux);
			rset.next();
			this.totalHT = rset.getDouble("TotalHT");
			this.totalTTC = rset.getDouble("TotalTTC");
			rset.close();
			
			this.totalCommission = 0;
			for (int i=0; i<this.periodes.size(); i++) {
				double totalCommissionMois = 0;
				ArrayList<VenteArticle> ventesArticles = new ArrayList<VenteArticle>();
				long[] periode = this.periodes.get(i);			
				
				// 1er cas : rgle globale sur le Chiffre d'Affaires Encaiss
				if (this.regles.size()==1 && this.regles.get(0).baseCalcul.equals("CAE")) {
					
					// modle de requte pour les dtails par facture
					String reqDetailsCAE = "select f.Num_Entier as RefFacture, (erc.Montant / (f.Total_TTC/f.Total_HT)) as MontantCAE";
					reqDetailsCAE += " from "+ this.base +".FACTURE f,"+ this.base +".ECHEANCE_REGLEMENT_CLIENT erc,"+ this.base +".ECHEANCE_CLIENT ec";
					reqDetailsCAE += " where f.Numero<>0 and f.Util_R="+ this.commercialId +" and f.Num_Entier=ec.Numero and ec.Provenance='Facture' and ec.Echeance_Id=erc.Echeance_Id";
					reqDetailsCAE += " and erc.Date_Affectation>="+periode[0]+" and erc.Date_Affectation<="+periode[1]+" and ec.Client_Id=? and ec.Denomination=? group by f.Num_Entier";
					PreparedStatement psDetailsCAE=this.con.prepareStatement(reqDetailsCAE);
					
					// Pour le CAE on ne prend en compte que les chances rgles
					String reqCAE = "select ec.Client_Id, ec.Denomination, sum(erc.Montant / (f.Total_TTC/f.Total_HT)) as TotalCAE";
					reqCAE += " from "+ this.base +".FACTURE f,"+ this.base +".ECHEANCE_REGLEMENT_CLIENT erc,"+ this.base +".ECHEANCE_CLIENT ec";
					reqCAE += " where f.Util_R="+ this.commercialId +" and f.Num_Entier=ec.Numero and ec.Provenance='Facture' and ec.Echeance_Id=erc.Echeance_Id";
					reqCAE += " and f.Numero<>0 and erc.Date_Affectation>="+periode[0]+" and erc.Date_Affectation<="+periode[1]+" group by ec.Client_Id, ec.Denomination";

					rset = stt.executeQuery(reqCAE);
				
					while (rset.next()) {
						String refClient = rset.getString("Client_Id");
						String raisonSociale = rset.getString("Denomination");
						Regle regle = this.regles.get(0);
						double total = rset.getDouble("TotalCAE");
						double commission = 0;
						boolean detailCommissionPossible = (!regle.hasTranches);
						Tranche tranche = regle.tranches.get(0);
						if (regle.hasTranches) {
							double granulariteTranche = 0.01;
							int j=0;
							while (tranche.binf<total && j<regle.tranches.size()) {
								double montant = 0;
								if (tranche.bsup<=total) { montant = tranche.bsup-tranche.binf+granulariteTranche; }
								else { montant = total-tranche.binf+granulariteTranche; }
								commission += montant*(tranche.val/100);
								j++;
								if (j<regle.tranches.size()) {
									tranche = regle.tranches.get(j);
								}
							}
						} else {						
							commission = total*(tranche.val/100);
						}
						
						totalCommissionMois += commission;
						
						// si il y a un filtre sur les clients, alors on fait le dtail par factures
						// sert de base pour le filtre sans dtail
						ArrayList<DetailVenteFacture> details = new ArrayList<DetailVenteFacture>();
						if (this.filtre.equals("C") || this.filtre.equals("ND")) {
							psDetailsCAE.setString(1,refClient);
							psDetailsCAE.setString(2,raisonSociale);
							ResultSet rset2 = psDetailsCAE.executeQuery();
							while (rset2.next()) {
								double detailCommission = 0;
								if (!regle.hasTranches) {
									detailCommission = rset2.getDouble("MontantCAE")*(tranche.val/100);
								}
								details.add(new DetailVenteFacture(rset2.getString("RefFacture"), detailCommission, detailCommissionPossible));
							}
							rset2.close();
						}
						
						if (!detailCommissionPossible && (details.size()==1)) {
							DetailVenteFacture d = details.get(0);								
							d.commission=commission;
							d.detailPossible=true;
							details.set(0,d);
						}
						ventesArticles.add(new VenteArticle(raisonSociale, true, commission, details));
					}
					rset.close();
					psDetailsCAE.close();
					
					if (filtre.equals("ND")) {
						ventesArticles = trierFactures(ventesArticles, totalCommissionMois);
					}
					
				} else if (this.filtre.equals("MQ") || this.filtre.equals("ND") || this.filtre.equals("C")) {
				// 2e cas : la granularit du filtre de tri est sur les marques
				// Algorithme de dpart pour le filtre sans dtail ou le filtre par clients
					
					// Modle de requte pour les ventes par articles
					String reqVentesArticles = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqVentesArticles += " sum(if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as TotalCA,";
					reqVentesArticles += " sum(if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite)) as TotalMarge,";
					reqVentesArticles += " sum(af.Quantite) as TotalQuantite";
					reqVentesArticles += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqVentesArticles += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqVentesArticles += " and f.Numero<>0 and af.Reference=fa.Article_Id and af.Type_Ligne='S' and fa.Marque_Id=? group by af.Reference";
					PreparedStatement psVentesArticles = con.prepareStatement(reqVentesArticles);
					
					String reqVentesArticlesNull = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqVentesArticlesNull += " sum(if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as TotalCA,";
					reqVentesArticlesNull += " sum(if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite)) as TotalMarge,";
					reqVentesArticlesNull += " sum(af.Quantite) as TotalQuantite";
					reqVentesArticlesNull += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqVentesArticlesNull += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqVentesArticlesNull += " and f.Numero<>0 and af.Reference=fa.Article_Id and af.Type_Ligne='S' and fa.Marque_Id is null group by af.Reference";
					PreparedStatement psVentesArticlesNull = con.prepareStatement(reqVentesArticlesNull);
					
					String reqFacturesMarques = "select distinct f.Facture_Id, f.Num_Entier as RefFacture from "+ this.base +".FACTURE f,"+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqFacturesMarques += " where f.Util_R="+ this.commercialId +" and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqFacturesMarques += " and f.Numero<>0 and f.Facture_Id=af.Facture_Id and af.Type_Ligne='S' and fa.Article_Id=af.Reference and fa.Marque_Id=?";
					reqFacturesMarques += " order by f.Facture_Id";
					PreparedStatement psFacturesMarques = con.prepareStatement(reqFacturesMarques);
					
					String reqFacturesMarquesNull = "select distinct f.Facture_Id, f.Num_Entier as RefFacture from "+ this.base +".FACTURE f,"+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqFacturesMarquesNull += " where f.Util_R="+ this.commercialId +" and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqFacturesMarquesNull += " and f.Numero<>0 and f.Facture_Id=af.Facture_Id and af.Type_Ligne='S' and fa.Article_Id=af.Reference and fa.Marque_Id is null";
					reqFacturesMarquesNull += " order by f.Facture_Id";
					PreparedStatement psFacturesMarquesNull = con.prepareStatement(reqFacturesMarquesNull);
					
					String reqDetailsVentesMarques = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqDetailsVentesMarques += " (if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as MontantCA,";
					reqDetailsVentesMarques += " if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite) as Marge";
					reqDetailsVentesMarques += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqDetailsVentesMarques += " where af.Reference=fa.Article_Id and af.Type_Ligne='S' and f.Facture_Id=af.Facture_Id and f.Facture_Id=?";
					reqDetailsVentesMarques += " and fa.Marque_Id=?";									
					PreparedStatement psDetailsVentesMarques = con.prepareStatement(reqDetailsVentesMarques);
					
					String reqDetailsVentesMarquesNull = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqDetailsVentesMarquesNull += " (if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as MontantCA,";
					reqDetailsVentesMarquesNull += " if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite) as Marge";
					reqDetailsVentesMarquesNull += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqDetailsVentesMarquesNull += " where af.Reference=fa.Article_Id and af.Type_Ligne='S' and f.Facture_Id=af.Facture_Id and f.Facture_Id=?";
					reqDetailsVentesMarquesNull += " and fa.Marque_Id is null";									
					PreparedStatement psDetailsVentesMarquesNull = con.prepareStatement(reqDetailsVentesMarquesNull);
					
					// Liste des marques vendues
					String reqMarquesVentes = "select distinct coalesce(fa.Marque_Id, 0) as Marque_Id";
					reqMarquesVentes += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqMarquesVentes += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqMarquesVentes += " and f.Numero<>0 and af.Reference=fa.Article_Id";

					rset = stt.executeQuery(reqMarquesVentes);
					
					while (rset.next()) {
						int marque = rset.getInt("Marque_Id");						
						
						double commissionMarque = 0;
						boolean detailCommissionPossible = true;
						boolean marqueTraitee = false;
						
						ResultSet rset2;
						if (marque!=0) {
							psVentesArticles.setInt(1,marque);
							rset2 = psVentesArticles.executeQuery();
						} else {
							rset2 = psVentesArticlesNull.executeQuery();
						}
						while (rset2.next()) {
							String refArticle = rset2.getString("RefArticle");
							String typeLigne = rset2.getString("Type_Ligne");
							
							int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

							Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
							double commission = 0;
							if (regle != null) {
								marqueTraitee = true;
								if (regle.hasTranches || regle.baseCalcul.equals("Q")) { detailCommissionPossible=false; }
								Tranche tranche = regle.tranches.get(0);
								if (regle.hasTranches) {
									int j=0;
									double total = 0;
									double granulariteTranche = 0.01;
									if (regle.baseCalcul.equals("CA")) { total = rset2.getDouble("TotalCA"); }
									else if (regle.baseCalcul.equals("M")) { total = rset2.getDouble("TotalMarge"); }
									else if (regle.baseCalcul.equals("Q")) {
										total = rset2.getDouble("TotalQuantite");
										granulariteTranche = 1;
									}
									
									// La rgle est tranche : dans le cas d'une commission sur les quantits,
									// la valeur de la commission est soit en euros, soit en % sur le CA ou la marge
									while (tranche.binf<total && j<regle.tranches.size()) {
										double montant = 0;
										if (tranche.bsup<=total) { montant = tranche.bsup-tranche.binf+granulariteTranche; }
										else { montant = total-tranche.binf+granulariteTranche; }
										if (regle.baseCalcul.equals("CA") || regle.baseCalcul.equals("M")) {
											commission += montant*(tranche.val/100);
										} else if (regle.baseCalcul.equals("Q")) {
											if (regle.modeCalculQte.equals("E")) { commission += tranche.val; }
											else if (regle.baseCalculQte.equals("CA")) { commission += rset2.getDouble("TotalCA")*(tranche.val/100); }
											else { commission += rset2.getDouble("TotalMarge")*(tranche.val/100); }
										}
										j++;
										if (j<regle.tranches.size()) {
											tranche = regle.tranches.get(j);
										}
									}
								} else {
									// La rgle n'est pas tranche : dans le cas d'une commission sur les quantits,
									// la valeur de la commission est toujours en euros
									if (regle.baseCalcul.equals("CA")) { commission = rset2.getDouble("TotalCA")*(tranche.val/100); }
									else if (regle.baseCalcul.equals("M")) { commission = rset2.getDouble("TotalMarge")*(tranche.val/100); }
									else if (regle.baseCalcul.equals("Q")) { commission = (rset2.getDouble("TotalQuantite")>0?tranche.val:0); }
								}
							}
							commissionMarque += commission;
						}
						rset2.close();
						
						
						
						if (marqueTraitee) {
							ArrayList<DetailVenteFacture> details = new ArrayList<DetailVenteFacture>();

							if (marque != 0) {
								psFacturesMarques.setInt(1, marque);
								rset2 = psFacturesMarques.executeQuery();
							} else {
								rset2 = psFacturesMarquesNull.executeQuery();
							}
								
							while (rset2.next()) {
								int factureId = rset2.getInt("Facture_Id");
								String refFacture = rset2.getString("RefFacture");
								double detailCommission = 0;
								
								if (detailCommissionPossible) {
									// calcul des commissions par facture
									
									psDetailsVentesMarques.setInt(1, factureId);
									
									
									ResultSet rset3;
									if (marque != 0) {
										psDetailsVentesMarques.setInt(2, marque);
										rset3 = psDetailsVentesMarques.executeQuery();
									} else {
										rset3 = psDetailsVentesMarquesNull.executeQuery();
									}
									
									while (rset3.next()) {
										String refArticle = rset3.getString("RefArticle");
										String typeLigne = rset3.getString("Type_Ligne");
										
										int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

										Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
										double commission = 0;
										if (regle != null) {
											Tranche tranche = regle.tranches.get(0);
											if (regle.baseCalcul.equals("CA")) { commission = rset3.getDouble("MontantCA")*(tranche.val/100); }
											else if (regle.baseCalcul.equals("M")) { commission = rset3.getDouble("Marge")*(tranche.val/100); }
										}
										detailCommission += commission;
									}
									rset3.close();
								}
								details.add(new DetailVenteFacture(refFacture, detailCommission, detailCommissionPossible));
							}
							rset2.close();
							
							totalCommissionMois += commissionMarque;
							if (!detailCommissionPossible && (details.size()==1)) {
								DetailVenteFacture d = details.get(0);								
								d.commission=commissionMarque;
								d.detailPossible=true;
								details.set(0,d);
							}
							ventesArticles.add(new VenteArticle("", marque, 0, 0, 0, commissionMarque, true, details));
						}
					}
					rset.close();
					
					
					// Ventes des articles Hors Stock
					String reqVentesArticlesHS = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqVentesArticlesHS += " sum(if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as TotalCA";
					reqVentesArticlesHS += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af";
					reqVentesArticlesHS += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqVentesArticlesHS += " and f.Numero<>0 and af.Type_Ligne='I' group by af.Reference";
					
					double commissionHS = 0;
					boolean detailCommissionPossible = true;
					boolean commissionHSTraitee = false;
					
					rset = stt.executeQuery(reqVentesArticlesHS);
					while (rset.next()) {
						
						String refArticle = rset.getString("RefArticle");
						String typeLigne = rset.getString("Type_Ligne");
						
						int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

						Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
						double commission = 0;
						if (regle != null) {
							commissionHSTraitee = true;
							Tranche tranche = regle.tranches.get(0);
							if (regle.hasTranches) {
								detailCommissionPossible=false;
								int j=0;
								double total = rset.getDouble("TotalCA");
								double granulariteTranche = 0.01;
								while (tranche.binf<total && j<regle.tranches.size()) {
									double montant = 0;
									if (tranche.bsup<=total) { montant = tranche.bsup-tranche.binf+granulariteTranche; }
									else { montant = total-tranche.binf+granulariteTranche; }									
									commission += montant*(tranche.val/100);									
									j++;
									if (j<regle.tranches.size()) {
										tranche = regle.tranches.get(j);
									}
								}
							} else {
								commission = rset.getDouble("TotalCA")*(tranche.val/100);
							}
						}
						commissionHS += commission;						
					}
					rset.close();
					
					if (commissionHSTraitee) {
						ArrayList<DetailVenteFacture> details = new ArrayList<DetailVenteFacture>();
						
						String reqFacturesHS = "select distinct f.Facture_Id, f.Num_Entier as RefFacture from "+ this.base +".FACTURE f,"+ this.base +".LIGNE_FACTURE af";
						reqFacturesHS += " where f.Util_R="+ this.commercialId +" and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
						reqFacturesHS += " and f.Numero<>0 and f.Facture_Id=af.Facture_Id and af.Type_Ligne='I'";
						reqFacturesHS += " order by f.Facture_Id";
						
						rset = stt.executeQuery(reqFacturesHS);
						while (rset.next()) {
							int factureId = rset.getInt("Facture_Id");
							String refFacture = rset.getString("RefFacture");
							double detailCommission = 0;
							
							if (detailCommissionPossible) {
								// calcul des commissions par facture
								
								String reqDetailsVentesArticlesHS = "select af.Reference as RefArticle, af.Type_Ligne,";
								reqDetailsVentesArticlesHS += " (if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as MontantCA";
								reqDetailsVentesArticlesHS += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af";
								reqDetailsVentesArticlesHS += " where af.Type_Ligne='I' and f.Facture_Id="+factureId+" and f.Facture_Id=af.Facture_Id";
								
								Statement stt2 = this.con.createStatement();
								ResultSet rset2 = stt2.executeQuery(reqDetailsVentesArticlesHS);
								while (rset2.next()) {
									String refArticle = rset2.getString("RefArticle");
									String typeLigne = rset2.getString("Type_Ligne");
									
									int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

									Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
									double commission = 0;
									if (regle != null) {
										Tranche tranche = regle.tranches.get(0);
										commission = rset2.getDouble("MontantCA")*(tranche.val/100);
									}
									detailCommission += commission;
								}
								rset2.close();
								stt2.close();
							}
							details.add(new DetailVenteFacture(refFacture, detailCommission, detailCommissionPossible));
						}
						rset.close();
						
						totalCommissionMois += commissionHS;
						if (!detailCommissionPossible && (details.size()==1)) {
							DetailVenteFacture d = details.get(0);								
							d.commission=commissionHS;
							d.detailPossible=true;
							details.set(0,d);
						}
						ventesArticles.add(new VenteArticle("", 0, 0, 0, 0, commissionHS, false, details));
					}
					
				} else if (this.filtre.equals("F1")) {
				// 3e cas : la granularit du filtre de tri est sur les familles 1
					// Modle de requte pour les ventes par articles ; un article ne peut pas avoir sa famille 1  NULL
					String reqVentesArticles = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqVentesArticles += " sum(if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as TotalCA,";
					reqVentesArticles += " sum(if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite)) as TotalMarge,";
					reqVentesArticles += " sum(af.Quantite) as TotalQuantite";
					reqVentesArticles += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqVentesArticles += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqVentesArticles += " and f.Numero<>0 and af.Reference=fa.Article_Id and af.Type_Ligne='S' and fa.Famille_1=? group by af.Reference";
					PreparedStatement psVentesArticles = con.prepareStatement(reqVentesArticles);
					
					String reqFacturesFamilles = "select distinct f.Facture_Id, f.Num_Entier as RefFacture from "+ this.base +".FACTURE f,"+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqFacturesFamilles += " where f.Util_R="+ this.commercialId +" and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqFacturesFamilles += " and f.Numero<>0 and f.Facture_Id=af.Facture_Id and af.Type_Ligne='S' and fa.Article_Id=af.Reference and fa.Famille_1=?";
					reqFacturesFamilles += " order by f.Facture_Id";
					PreparedStatement psFacturesFamilles = con.prepareStatement(reqFacturesFamilles);
					
					String reqDetailsVentesFamilles = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqDetailsVentesFamilles += " (if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as MontantCA,";
					reqDetailsVentesFamilles += " if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite) as Marge";
					reqDetailsVentesFamilles += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqDetailsVentesFamilles += " where af.Reference=fa.Article_Id and af.Type_Ligne='S' and f.Facture_Id=af.Facture_Id and f.Facture_Id=?";
					reqDetailsVentesFamilles += " and fa.Famille_1=?";
					PreparedStatement psDetailsVentesFamilles = con.prepareStatement(reqDetailsVentesFamilles);
					
					// Liste des familles 1 vendues
					String reqFamillesVentes = "select distinct fa.Famille_1";
					reqFamillesVentes += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqFamillesVentes += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqFamillesVentes += " and f.Numero<>0 and af.Reference=fa.Article_Id";

					rset = stt.executeQuery(reqFamillesVentes);
					
					while (rset.next()) {
						int famille1 = rset.getInt("Famille_1");						

						psVentesArticles.setInt(1, famille1);
						
						double commissionFamille = 0;
						boolean detailCommissionPossible = true;
						boolean familleTraitee = false;
						
						ResultSet rset2 = psVentesArticles.executeQuery();
						while (rset2.next()) {
							String refArticle = rset2.getString("RefArticle");
							String typeLigne = rset2.getString("Type_Ligne");
							
							int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

							Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
							double commission = 0;
							if (regle != null) {
								familleTraitee = true;
								if (regle.hasTranches || regle.baseCalcul.equals("Q")) { detailCommissionPossible=false; }
								Tranche tranche = regle.tranches.get(0);
								if (regle.hasTranches) {
									int j=0;
									double total = 0;
									double granulariteTranche = 0.01;
									if (regle.baseCalcul.equals("CA")) { total = rset2.getDouble("TotalCA"); }
									else if (regle.baseCalcul.equals("M")) { total = rset2.getDouble("TotalMarge"); }
									else if (regle.baseCalcul.equals("Q")) {
										total = rset2.getDouble("TotalQuantite");
										granulariteTranche = 1;
									}
									
									// La rgle est tranche : dans le cas d'une commission sur les quantits,
									// la valeur de la commission est soit en euros, soit en % sur le CA ou la marge
									while (tranche.binf<total && j<regle.tranches.size()) {
										double montant = 0;
										if (tranche.bsup<=total) { montant = tranche.bsup-tranche.binf+granulariteTranche; }
										else { montant = total-tranche.binf+granulariteTranche; }
										if (regle.baseCalcul.equals("CA") || regle.baseCalcul.equals("M")) {
											commission += montant*(tranche.val/100);
										} else if (regle.baseCalcul.equals("Q")) {
											if (regle.modeCalculQte.equals("E")) { commission += tranche.val; }
											else if (regle.baseCalculQte.equals("CA")) { commission += rset2.getDouble("TotalCA")*(tranche.val/100); }
											else { commission += rset2.getDouble("TotalMarge")*(tranche.val/100); }
										}
										j++;
										if (j<regle.tranches.size()) {
											tranche = regle.tranches.get(j);
										}
									}
								} else {
									// La rgle n'est pas tranche : dans le cas d'une commission sur les quantits,
									// la valeur de la commission est toujours en euros
									if (regle.baseCalcul.equals("CA")) { commission = rset2.getDouble("TotalCA")*(tranche.val/100); }
									else if (regle.baseCalcul.equals("M")) { commission = rset2.getDouble("TotalMarge")*(tranche.val/100); }
									else if (regle.baseCalcul.equals("Q")) { commission = (rset2.getDouble("TotalQuantite")>0?tranche.val:0); }
								}
							}
							commissionFamille += commission;
						}
						rset2.close();
						
						
						
						if (familleTraitee) {
							ArrayList<DetailVenteFacture> details = new ArrayList<DetailVenteFacture>();
							
							psFacturesFamilles.setInt(1, famille1);
							
							rset2 = psFacturesFamilles.executeQuery();
							while (rset2.next()) {
								int factureId = rset2.getInt("Facture_Id");
								String refFacture = rset2.getString("RefFacture");
								double detailCommission = 0;
								
								if (detailCommissionPossible) {
									// calcul des commissions par facture
									
									psDetailsVentesFamilles.setInt(1, factureId);
									psDetailsVentesFamilles.setInt(2, famille1);
									
									ResultSet rset3 = psDetailsVentesFamilles.executeQuery();
									while (rset3.next()) {
										String refArticle = rset3.getString("RefArticle");
										String typeLigne = rset3.getString("Type_Ligne");
										
										int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

										Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
										double commission = 0;
										if (regle != null) {
											Tranche tranche = regle.tranches.get(0);
											if (regle.baseCalcul.equals("CA")) { commission = rset3.getDouble("MontantCA")*(tranche.val/100); }
											else if (regle.baseCalcul.equals("M")) { commission = rset3.getDouble("Marge")*(tranche.val/100); }
										}
										detailCommission += commission;
									}
									rset3.close();
								}
								details.add(new DetailVenteFacture(refFacture, detailCommission, detailCommissionPossible));
							}
							rset2.close();
							
							totalCommissionMois += commissionFamille;
							if (!detailCommissionPossible && (details.size()==1)) {
								DetailVenteFacture d = details.get(0);								
								d.commission=commissionFamille;
								d.detailPossible=true;
								details.set(0,d);
							}
							ventesArticles.add(new VenteArticle("", 0, famille1, 0, 0, commissionFamille, true, details));
						}
					}
					rset.close();
					
					
					// Ventes des articles Hors Stock
					String reqVentesArticlesHS = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqVentesArticlesHS += " sum(if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as TotalCA";
					reqVentesArticlesHS += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af";
					reqVentesArticlesHS += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqVentesArticlesHS += " and f.Numero<>0 and af.Type_Ligne='I' group by af.Reference";
					
					double commissionHS = 0;
					boolean detailCommissionPossible = true;
					boolean commissionHSTraitee = false;
					
					rset = stt.executeQuery(reqVentesArticlesHS);
					while (rset.next()) {
						
						String refArticle = rset.getString("RefArticle");
						String typeLigne = rset.getString("Type_Ligne");
						
						int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

						Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
						double commission = 0;
						if (regle != null) {
							commissionHSTraitee = true;
							Tranche tranche = regle.tranches.get(0);
							if (regle.hasTranches) {
								detailCommissionPossible=false;
								int j=0;
								double total = rset.getDouble("TotalCA");
								double granulariteTranche = 0.01;
								while (tranche.binf<total && j<regle.tranches.size()) {
									double montant = 0;
									if (tranche.bsup<=total) { montant = tranche.bsup-tranche.binf+granulariteTranche; }
									else { montant = total-tranche.binf+granulariteTranche; }									
									commission += montant*(tranche.val/100);									
									j++;
									if (j<regle.tranches.size()) {
										tranche = regle.tranches.get(j);
									}
								}
							} else {
								commission = rset.getDouble("TotalCA")*(tranche.val/100);
							}
						}
						commissionHS += commission;						
					}
					rset.close();
					
					if (commissionHSTraitee) {
						ArrayList<DetailVenteFacture> details = new ArrayList<DetailVenteFacture>();
						
						String reqFacturesHS = "select distinct f.Facture_Id, f.Num_Entier as RefFacture from "+ this.base +".FACTURE f,"+ this.base +".LIGNE_FACTURE af";
						reqFacturesHS += " where f.Util_R="+ this.commercialId +" and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
						reqFacturesHS += " and f.Numero<>0 and f.Facture_Id=af.Facture_Id and af.Type_Ligne='I'";
						reqFacturesHS += " order by f.Facture_Id";
						
						rset = stt.executeQuery(reqFacturesHS);
						while (rset.next()) {
							int factureId = rset.getInt("Facture_Id");
							String refFacture = rset.getString("RefFacture");
							double detailCommission = 0;
							
							if (detailCommissionPossible) {
								// calcul des commissions par facture
								
								String reqDetailsVentesArticlesHS = "select af.Reference as RefArticle, af.Type_Ligne,";
								reqDetailsVentesArticlesHS += " (if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as MontantCA";
								reqDetailsVentesArticlesHS += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af";
								reqDetailsVentesArticlesHS += " where af.Type_Ligne='I' and f.Facture_Id="+factureId+" and f.Facture_Id=af.Facture_Id";
								
								Statement stt2 = this.con.createStatement();
								ResultSet rset2 = stt2.executeQuery(reqDetailsVentesArticlesHS);
								while (rset2.next()) {
									String refArticle = rset2.getString("RefArticle");
									String typeLigne = rset2.getString("Type_Ligne");
									
									int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

									Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
									double commission = 0;
									if (regle != null) {
										Tranche tranche = regle.tranches.get(0);
										commission = rset2.getDouble("MontantCA")*(tranche.val/100);
									}
									detailCommission += commission;
								}
								rset2.close();
								stt2.close();
							}
							details.add(new DetailVenteFacture(refFacture, detailCommission, detailCommissionPossible));
						}
						rset.close();
						
						totalCommissionMois += commissionHS;
						if (!detailCommissionPossible && (details.size()==1)) {
							DetailVenteFacture d = details.get(0);								
							d.commission=commissionHS;
							d.detailPossible=true;
							details.set(0,d);
						}
						ventesArticles.add(new VenteArticle("", 0, 0, 0, 0, commissionHS, false, details));
					}
					
				} else if (this.filtre.equals("F2")) {
				// 4e cas : la granularit du filtre de tri est sur les familles 2
					
					// Ventes par articles
					String reqVentesArticles = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqVentesArticles += " sum(if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as TotalCA,";
					reqVentesArticles += " sum(if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite)) as TotalMarge,";
					reqVentesArticles += " sum(af.Quantite) as TotalQuantite";
					reqVentesArticles += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqVentesArticles += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqVentesArticles += " and f.Numero<>0 and af.Reference=fa.Article_Id and af.Type_Ligne='S' and fa.Famille_1=? and fa.Famille_2=? group by af.Reference";
					PreparedStatement psVentesArticles = con.prepareStatement(reqVentesArticles);
					
					String reqVentesArticlesNull = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqVentesArticlesNull += " sum(if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as TotalCA,";
					reqVentesArticlesNull += " sum(if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite)) as TotalMarge,";
					reqVentesArticlesNull += " sum(af.Quantite) as TotalQuantite";
					reqVentesArticlesNull += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqVentesArticlesNull += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqVentesArticlesNull += " and f.Numero<>0 and af.Reference=fa.Article_Id and af.Type_Ligne='S' and fa.Famille_1=? and fa.Famille_2 is null group by af.Reference";
					PreparedStatement psVentesArticlesNull = con.prepareStatement(reqVentesArticlesNull);
					
					String reqFacturesFamilles2 = "select distinct f.Facture_Id, f.Num_Entier as RefFacture from "+ this.base +".FACTURE f,"+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqFacturesFamilles2 += " where f.Util_R="+ this.commercialId +" and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqFacturesFamilles2 += " and f.Numero<>0 and f.Facture_Id=af.Facture_Id and af.Type_Ligne='S' and fa.Article_Id=af.Reference and fa.Famille_1=? and fa.Famille_2=?";
					reqFacturesFamilles2 += " order by f.Facture_Id";
					PreparedStatement psFacturesFamilles2 = con.prepareStatement(reqFacturesFamilles2);
					
					String reqFacturesFamilles2Null = "select distinct f.Facture_Id, f.Num_Entier as RefFacture from "+ this.base +".FACTURE f,"+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqFacturesFamilles2Null += " where f.Util_R="+ this.commercialId +" and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqFacturesFamilles2Null += " and f.Numero<>0 and f.Facture_Id=af.Facture_Id and af.Type_Ligne='S' and fa.Article_Id=af.Reference and fa.Famille_1=? and fa.Famille_2 is null";
					reqFacturesFamilles2Null += " order by f.Facture_Id";
					PreparedStatement psFacturesFamilles2Null = con.prepareStatement(reqFacturesFamilles2Null);
					
					String reqDetailsVentesFamilles2 = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqDetailsVentesFamilles2 += " (if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as MontantCA,";
					reqDetailsVentesFamilles2 += " if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite) as Marge";
					reqDetailsVentesFamilles2 += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqDetailsVentesFamilles2 += " where af.Reference=fa.Article_Id and af.Type_Ligne='S' and f.Facture_Id=af.Facture_Id and f.Facture_Id=?";
					reqDetailsVentesFamilles2 += " and fa.Famille_1=? and fa.Famille_2=?";
					PreparedStatement psDetailsVentesFamilles2 = con.prepareStatement(reqDetailsVentesFamilles2);
					
					String reqDetailsVentesFamilles2Null = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqDetailsVentesFamilles2Null += " (if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as MontantCA,";
					reqDetailsVentesFamilles2Null += " if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite) as Marge";
					reqDetailsVentesFamilles2Null += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqDetailsVentesFamilles2Null += " where af.Reference=fa.Article_Id and af.Type_Ligne='S' and f.Facture_Id=af.Facture_Id and f.Facture_Id=?";
					reqDetailsVentesFamilles2Null += " and fa.Famille_1=? and fa.Famille_2 is null";
					PreparedStatement psDetailsVentesFamilles2Null = con.prepareStatement(reqDetailsVentesFamilles2Null);
					
					// Liste des familles 2 vendues
					String reqFamillesVentes = "select distinct fa.Famille_1, coalesce(fa.Famille_2,0) as Famille_2";
					reqFamillesVentes += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqFamillesVentes += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqFamillesVentes += " and f.Numero<>0 and af.Reference=fa.Article_Id";

					rset = stt.executeQuery(reqFamillesVentes);
					
					while (rset.next()) {
						int famille1 = rset.getInt("Famille_1");
						int famille2 = rset.getInt("Famille_2");
						
						double commissionFamille2 = 0;
						boolean detailCommissionPossible = true;
						boolean famille2Traitee = false;
						
						ResultSet rset2;
						if (famille2 != 0) {
							psVentesArticles.setInt(1, famille1);
							psVentesArticles.setInt(2, famille2);
							rset2 = psVentesArticles.executeQuery();
						} else {
							psVentesArticlesNull.setInt(1, famille1);
							rset2 = psVentesArticlesNull.executeQuery();
						}
						while (rset2.next()) {
							String refArticle = rset2.getString("RefArticle");
							String typeLigne = rset2.getString("Type_Ligne");
							
							int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

							Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
							double commission = 0;
							if (regle != null) {
								famille2Traitee = true;
								if (regle.hasTranches || regle.baseCalcul.equals("Q")) { detailCommissionPossible=false; }
								Tranche tranche = regle.tranches.get(0);
								if (regle.hasTranches) {
									int j=0;
									double total = 0;
									double granulariteTranche = 0.01;
									if (regle.baseCalcul.equals("CA")) { total = rset2.getDouble("TotalCA"); }
									else if (regle.baseCalcul.equals("M")) { total = rset2.getDouble("TotalMarge"); }
									else if (regle.baseCalcul.equals("Q")) {
										total = rset2.getDouble("TotalQuantite");
										granulariteTranche = 1;
									}
									
									// La rgle est tranche : dans le cas d'une commission sur les quantits,
									// la valeur de la commission est soit en euros, soit en % sur le CA ou la marge
									while (tranche.binf<total && j<regle.tranches.size()) {
										double montant = 0;
										if (tranche.bsup<=total) { montant = tranche.bsup-tranche.binf+granulariteTranche; }
										else { montant = total-tranche.binf+granulariteTranche; }
										if (regle.baseCalcul.equals("CA") || regle.baseCalcul.equals("M")) {
											commission += montant*(tranche.val/100);
										} else if (regle.baseCalcul.equals("Q")) {
											if (regle.modeCalculQte.equals("E")) { commission += tranche.val; }
											else if (regle.baseCalculQte.equals("CA")) { commission += rset2.getDouble("TotalCA")*(tranche.val/100); }
											else { commission += rset2.getDouble("TotalMarge")*(tranche.val/100); }
										}
										j++;
										if (j<regle.tranches.size()) {
											tranche = regle.tranches.get(j);
										}
									}
								} else {
									// La rgle n'est pas tranche : dans le cas d'une commission sur les quantits,
									// la valeur de la commission est toujours en euros
									if (regle.baseCalcul.equals("CA")) { commission = rset2.getDouble("TotalCA")*(tranche.val/100); }
									else if (regle.baseCalcul.equals("M")) { commission = rset2.getDouble("TotalMarge")*(tranche.val/100); }
									else if (regle.baseCalcul.equals("Q")) { commission = (rset2.getDouble("TotalQuantite")>0?tranche.val:0); }
								}
							}
							commissionFamille2 += commission;
						}
						rset2.close();
						
						
						
						if (famille2Traitee) {
							ArrayList<DetailVenteFacture> details = new ArrayList<DetailVenteFacture>();
							
							if (famille2 != 0) {
								psFacturesFamilles2.setInt(1, famille1);
								psFacturesFamilles2.setInt(2, famille2);
								rset2 = psFacturesFamilles2.executeQuery();
							} else {
								psFacturesFamilles2Null.setInt(1, famille1);
								rset2 = psFacturesFamilles2Null.executeQuery();
							}
							
							while (rset2.next()) {
								int factureId = rset2.getInt("Facture_Id");
								String refFacture = rset2.getString("RefFacture");
								double detailCommission = 0;
								
								if (detailCommissionPossible) {
									// calcul des commissions par facture

									ResultSet rset3;
									if (famille2 != 0) {
										psDetailsVentesFamilles2.setInt(1, factureId);
										psDetailsVentesFamilles2.setInt(2, famille1);
										psDetailsVentesFamilles2.setInt(3, famille2);
										rset3 = psDetailsVentesFamilles2.executeQuery();
									} else {
										psDetailsVentesFamilles2Null.setInt(1, factureId);
										psDetailsVentesFamilles2Null.setInt(2, famille1);
										rset3 = psDetailsVentesFamilles2Null.executeQuery();
									}
									
									while (rset3.next()) {
										String refArticle = rset3.getString("RefArticle");
										String typeLigne = rset3.getString("Type_Ligne");
										
										int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

										Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
										double commission = 0;
										if (regle != null) {
											Tranche tranche = regle.tranches.get(0);
											if (regle.baseCalcul.equals("CA")) { commission = rset3.getDouble("MontantCA")*(tranche.val/100); }
											else if (regle.baseCalcul.equals("M")) { commission = rset3.getDouble("Marge")*(tranche.val/100); }
										}
										detailCommission += commission;
									}
									rset3.close();
								}
								details.add(new DetailVenteFacture(refFacture, detailCommission, detailCommissionPossible));
							}
							rset2.close();
							
							totalCommissionMois += commissionFamille2;
							if (!detailCommissionPossible && (details.size()==1)) {
								DetailVenteFacture d = details.get(0);								
								d.commission=commissionFamille2;
								d.detailPossible=true;
								details.set(0,d);
							}
							ventesArticles.add(new VenteArticle("", 0, famille1, famille2, 0, commissionFamille2, true, details));
						}
					}
					rset.close();
					
					
					// Ventes des articles Hors Stock
					String reqVentesArticlesHS = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqVentesArticlesHS += " sum(if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100))) as TotalCA";
					reqVentesArticlesHS += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af";
					reqVentesArticlesHS += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqVentesArticlesHS += " and f.Numero<>0 and af.Type_Ligne='I' group by af.Reference";
					
					double commissionHS = 0;
					boolean detailCommissionPossible = true;
					boolean commissionHSTraitee = false;
					
					rset = stt.executeQuery(reqVentesArticlesHS);
					while (rset.next()) {
						
						String refArticle = rset.getString("RefArticle");
						String typeLigne = rset.getString("Type_Ligne");
						
						int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

						Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
						double commission = 0;
						if (regle != null) {
							commissionHSTraitee = true;
							Tranche tranche = regle.tranches.get(0);
							if (regle.hasTranches) {
								detailCommissionPossible=false;
								int j=0;
								double total = rset.getDouble("TotalCA");
								double granulariteTranche = 0.01;
								while (tranche.binf<total && j<regle.tranches.size()) {
									double montant = 0;									
									if (tranche.bsup<=total) { montant = tranche.bsup-tranche.binf+granulariteTranche; }
									else { montant = total-tranche.binf+granulariteTranche; }									
									commission += montant*(tranche.val/100);									
									j++;
									if (j<regle.tranches.size()) {
										tranche = regle.tranches.get(j);
									}
								}
							} else {
								commission = rset.getDouble("TotalCA")*(tranche.val/100);
							}
						}
						commissionHS += commission;						
					}
					rset.close();
					
					if (commissionHSTraitee) {
						ArrayList<DetailVenteFacture> details = new ArrayList<DetailVenteFacture>();
						
						String reqFacturesHS = "select distinct f.Facture_Id, f.Num_Entier as RefFacture from "+ this.base +".FACTURE f,"+ this.base +".LIGNE_FACTURE af";
						reqFacturesHS += " where f.Util_R="+ this.commercialId +" and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
						reqFacturesHS += " and f.Numero<>0 and f.Facture_Id=af.Facture_Id and af.Type_Ligne='I'";
						reqFacturesHS += " order by f.Facture_Id";
						
						rset = stt.executeQuery(reqFacturesHS);
						while (rset.next()) {
							int factureId = rset.getInt("Facture_Id");
							String refFacture = rset.getString("RefFacture");
							double detailCommission = 0;
							
							if (detailCommissionPossible) {
								// calcul des commissions par facture
								
								String reqDetailsVentesArticlesHS = "select af.Reference as RefArticle, af.Type_Ligne,";
								reqDetailsVentesArticlesHS += " (if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as MontantCA";
								reqDetailsVentesArticlesHS += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af";
								reqDetailsVentesArticlesHS += " where af.Type_Ligne='I' and f.Facture_Id="+factureId+" and f.Facture_Id=af.Facture_Id";
								
								Statement stt2 = this.con.createStatement();
								ResultSet rset2 = stt2.executeQuery(reqDetailsVentesArticlesHS);
								while (rset2.next()) {
									String refArticle = rset2.getString("RefArticle");
									String typeLigne = rset2.getString("Type_Ligne");
									
									int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

									Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
									double commission = 0;
									if (regle != null) {
										Tranche tranche = regle.tranches.get(0);
										commission = rset2.getDouble("MontantCA")*(tranche.val/100);
									}
									detailCommission += commission;
								}
								rset2.close();
								stt2.close();
							}
							details.add(new DetailVenteFacture(refFacture, detailCommission, detailCommissionPossible));
						}
						rset.close();
						
						totalCommissionMois += commissionHS;
						if (!detailCommissionPossible && (details.size()==1)) {
							DetailVenteFacture d = details.get(0);								
							d.commission=commissionHS;
							d.detailPossible=true;
							details.set(0,d);
						}
						ventesArticles.add(new VenteArticle("", 0, 0, 0, 0, commissionHS, false, details));
					}
					
				} else if (this.filtre.equals("F3")) {
				// 5e cas : la granularit du filtre de tri est sur les familles 3
					
					// Ventes par articles
					String reqVentesArticles = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqVentesArticles += " sum(if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as TotalCA,";
					reqVentesArticles += " sum(if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite)) as TotalMarge,";
					reqVentesArticles += " sum(af.Quantite) as TotalQuantite";
					reqVentesArticles += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqVentesArticles += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqVentesArticles += " and f.Numero<>0 and af.Reference=fa.Article_Id and af.Type_Ligne='S' and fa.Famille_1=? and fa.Famille_2=? and fa.Famille_3=? group by af.Reference";
					PreparedStatement psVentesArticles = con.prepareStatement(reqVentesArticles);
					
					String reqVentesArticlesF3Null = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqVentesArticlesF3Null += " sum(if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as TotalCA,";
					reqVentesArticlesF3Null += " sum(if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite)) as TotalMarge,";
					reqVentesArticlesF3Null += " sum(af.Quantite) as TotalQuantite";
					reqVentesArticlesF3Null += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqVentesArticlesF3Null += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqVentesArticlesF3Null += " and f.Numero<>0 and af.Reference=fa.Article_Id and af.Type_Ligne='S' and fa.Famille_1=? and fa.Famille_2=? and fa.Famille_3 is null group by af.Reference";
					PreparedStatement psVentesArticlesF3Null = con.prepareStatement(reqVentesArticlesF3Null);
					
					String reqVentesArticlesF2Null = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqVentesArticlesF2Null += " sum(if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as TotalCA,";
					reqVentesArticlesF2Null += " sum(if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite)) as TotalMarge,";
					reqVentesArticlesF2Null += " sum(af.Quantite) as TotalQuantite";
					reqVentesArticlesF2Null += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqVentesArticlesF2Null += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqVentesArticlesF2Null += " and f.Numero<>0 and af.Reference=fa.Article_Id and af.Type_Ligne='S' and fa.Famille_1=? and fa.Famille_2 is null group by af.Reference";
					PreparedStatement psVentesArticlesF2Null = con.prepareStatement(reqVentesArticlesF2Null);
					
					String reqFacturesFamilles3 = "select distinct f.Facture_Id, f.Num_Entier as RefFacture from "+ this.base +".FACTURE f,"+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqFacturesFamilles3 += " where f.Util_R="+ this.commercialId +" and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqFacturesFamilles3 += " and f.Numero<>0 and f.Facture_Id=af.Facture_Id and af.Type_Ligne='S' and fa.Article_Id=af.Reference and fa.Famille_1=? and fa.Famille_2=? and fa.Famille_3=?";
					reqFacturesFamilles3 += " order by f.Facture_Id";
					PreparedStatement psFacturesFamilles3 = con.prepareStatement(reqFacturesFamilles3);
					
					String reqFacturesFamilles3F3Null = "select distinct f.Facture_Id, f.Num_Entier as RefFacture from "+ this.base +".FACTURE f,"+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqFacturesFamilles3F3Null += " where f.Util_R="+ this.commercialId +" and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqFacturesFamilles3F3Null += " and f.Numero<>0 and f.Facture_Id=af.Facture_Id and af.Type_Ligne='S' and fa.Article_Id=af.Reference and fa.Famille_1=? and fa.Famille_2=? and fa.Famille_3 is null";
					reqFacturesFamilles3F3Null += " order by f.Facture_Id";
					PreparedStatement psFacturesFamilles3F3Null = con.prepareStatement(reqFacturesFamilles3F3Null);
					
					String reqFacturesFamilles3F2Null = "select distinct f.Facture_Id, f.Num_Entier as RefFacture from "+ this.base +".FACTURE f,"+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqFacturesFamilles3F2Null += " where f.Util_R="+ this.commercialId +" and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqFacturesFamilles3F2Null += " and f.Numero<>0 and f.Facture_Id=af.Facture_Id and af.Type_Ligne='S' and fa.Article_Id=af.Reference and fa.Famille_1=? and fa.Famille_2 is null";
					reqFacturesFamilles3F2Null += " order by f.Facture_Id";
					PreparedStatement psFacturesFamilles3F2Null = con.prepareStatement(reqFacturesFamilles3F2Null);
					
					String reqDetailsVentesFamilles3 = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqDetailsVentesFamilles3 += " (if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as MontantCA,";
					reqDetailsVentesFamilles3 += " if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite) as Marge";
					reqDetailsVentesFamilles3 += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqDetailsVentesFamilles3 += " where af.Reference=fa.Article_Id and af.Type_Ligne='S' and f.Facture_Id=af.Facture_Id and f.Facture_Id=?";
					reqDetailsVentesFamilles3 += " and fa.Famille_1=? and fa.Famille_2=? and fa.Famille_3=?";
					PreparedStatement psDetailsVentesFamilles3 = con.prepareStatement(reqDetailsVentesFamilles3);
					
					String reqDetailsVentesFamilles3F3Null = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqDetailsVentesFamilles3F3Null += " (if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as MontantCA,";
					reqDetailsVentesFamilles3F3Null += " if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite) as Marge";
					reqDetailsVentesFamilles3F3Null += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqDetailsVentesFamilles3F3Null += " where af.Reference=fa.Article_Id and af.Type_Ligne='S' and f.Facture_Id=af.Facture_Id and f.Facture_Id=?";
					reqDetailsVentesFamilles3F3Null += " and fa.Famille_1=? and fa.Famille_2=? and fa.Famille_3 is null";
					PreparedStatement psDetailsVentesFamilles3F3Null = con.prepareStatement(reqDetailsVentesFamilles3F3Null);
					
					String reqDetailsVentesFamilles3F2Null = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqDetailsVentesFamilles3F2Null += " (if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as MontantCA,";
					reqDetailsVentesFamilles3F2Null += " if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite) as Marge";
					reqDetailsVentesFamilles3F2Null += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqDetailsVentesFamilles3F2Null += " where af.Reference=fa.Article_Id and af.Type_Ligne='S' and f.Facture_Id=af.Facture_Id and f.Facture_Id=?";
					reqDetailsVentesFamilles3F2Null += " and fa.Famille_1=? and fa.Famille_2 is null";
					PreparedStatement psDetailsVentesFamilles3F2Null = con.prepareStatement(reqDetailsVentesFamilles3F2Null);
					
					// Liste des familles 3 vendues
					String reqFamillesVentes = "select distinct fa.Famille_1, coalesce(fa.Famille_2,0) as Famille_2, coalesce(fa.Famille_3,0) as Famille_3";
					reqFamillesVentes += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqFamillesVentes += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqFamillesVentes += " and f.Numero<>0 and af.Reference=fa.Article_Id";

					rset = stt.executeQuery(reqFamillesVentes);
					
					while (rset.next()) {
						int famille1 = rset.getInt("Famille_1");
						int famille2 = rset.getInt("Famille_2");
						int famille3 = rset.getInt("Famille_3");
						
						double commissionFamille3 = 0;
						boolean detailCommissionPossible = true;
						boolean famille3Traitee = false;
						
						ResultSet rset2;
						if (famille3 != 0) {
							psVentesArticles.setInt(1, famille1);
							psVentesArticles.setInt(2, famille2);
							psVentesArticles.setInt(3, famille3);
							rset2 = psVentesArticles.executeQuery();
						} else if (famille2 != 0) {
							psVentesArticlesF3Null.setInt(1, famille1);
							psVentesArticlesF3Null.setInt(2, famille2);
							rset2 = psVentesArticlesF3Null.executeQuery();
						} else {
							psVentesArticlesF2Null.setInt(1, famille1);
							rset2 = psVentesArticlesF2Null.executeQuery();
						}
						while (rset2.next()) {
							String refArticle = rset2.getString("RefArticle");
							String typeLigne = rset2.getString("Type_Ligne");
							
							int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

							Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
							double commission = 0;
							if (regle != null) {
								famille3Traitee = true;
								if (regle.hasTranches || regle.baseCalcul.equals("Q")) { detailCommissionPossible=false; }
								Tranche tranche = regle.tranches.get(0);
								if (regle.hasTranches) {
									int j=0;
									double total = 0;
									double granulariteTranche = 0.01;
									if (regle.baseCalcul.equals("CA")) { total = rset2.getDouble("TotalCA"); }
									else if (regle.baseCalcul.equals("M")) { total = rset2.getDouble("TotalMarge"); }
									else if (regle.baseCalcul.equals("Q")) {
										total = rset2.getDouble("TotalQuantite");
										granulariteTranche = 1;
									}
									
									// La rgle est tranche : dans le cas d'une commission sur les quantits,
									// la valeur de la commission est soit en euros, soit en % sur le CA ou la marge
									while (tranche.binf<total && j<regle.tranches.size()) {
										double montant = 0;
										if (tranche.bsup<=total) { montant = tranche.bsup-tranche.binf+granulariteTranche; }
										else { montant = total-tranche.binf+granulariteTranche; }
										if (regle.baseCalcul.equals("CA") || regle.baseCalcul.equals("M")) {
											commission += montant*(tranche.val/100);
										} else if (regle.baseCalcul.equals("Q")) {
											if (regle.modeCalculQte.equals("E")) { commission += tranche.val; }
											else if (regle.baseCalculQte.equals("CA")) { commission += rset2.getDouble("TotalCA")*(tranche.val/100); }
											else { commission += rset2.getDouble("TotalMarge")*(tranche.val/100); }
										}
										j++;
										if (j<regle.tranches.size()) {
											tranche = regle.tranches.get(j);
										}
									}
								} else {
									// La rgle n'est pas tranche : dans le cas d'une commission sur les quantits,
									// la valeur de la commission est toujours en euros
									if (regle.baseCalcul.equals("CA")) { commission = rset2.getDouble("TotalCA")*(tranche.val/100); }
									else if (regle.baseCalcul.equals("M")) { commission = rset2.getDouble("TotalMarge")*(tranche.val/100); }
									else if (regle.baseCalcul.equals("Q")) { commission = (rset2.getDouble("TotalQuantite")>0?tranche.val:0); }
								}
							}
							commissionFamille3 += commission;
						}
						rset2.close();
						
						
						
						if (famille3Traitee) {
							ArrayList<DetailVenteFacture> details = new ArrayList<DetailVenteFacture>();
							
							if (famille3 != 0) {
								psFacturesFamilles3.setInt(1, famille1);
								psFacturesFamilles3.setInt(2, famille2);
								psFacturesFamilles3.setInt(3, famille3);
								rset2 = psFacturesFamilles3.executeQuery();
							} else if (famille2 != 0) {
								psFacturesFamilles3F3Null.setInt(1, famille1);
								psFacturesFamilles3F3Null.setInt(2, famille2);
								rset2 = psFacturesFamilles3F3Null.executeQuery();
							} else {
								psFacturesFamilles3F2Null.setInt(1, famille1);
								rset2 = psFacturesFamilles3F2Null.executeQuery();
							}
							
							while (rset2.next()) {
								int factureId = rset2.getInt("Facture_Id");
								String refFacture = rset2.getString("RefFacture");
								double detailCommission = 0;
								
								if (detailCommissionPossible) {
									// calcul des commissions par facture

									ResultSet rset3;
									if (famille3 != 0) {
										psDetailsVentesFamilles3.setInt(1, factureId);
										psDetailsVentesFamilles3.setInt(2, famille1);
										psDetailsVentesFamilles3.setInt(3, famille2);
										psDetailsVentesFamilles3.setInt(4, famille3);
										rset3 = psDetailsVentesFamilles3.executeQuery();
									} else if (famille2 != 0) {
										psDetailsVentesFamilles3F3Null.setInt(1, factureId);
										psDetailsVentesFamilles3F3Null.setInt(2, famille1);
										psDetailsVentesFamilles3F3Null.setInt(3, famille2);
										rset3 = psDetailsVentesFamilles3F3Null.executeQuery();
									} else {
										psDetailsVentesFamilles3F2Null.setInt(1, factureId);
										psDetailsVentesFamilles3F2Null.setInt(2, famille1);
										rset3 = psDetailsVentesFamilles3F2Null.executeQuery();
									}
									
									while (rset3.next()) {
										String refArticle = rset3.getString("RefArticle");
										String typeLigne = rset3.getString("Type_Ligne");
										
										int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

										Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
										double commission = 0;
										if (regle != null) {
											Tranche tranche = regle.tranches.get(0);
											if (regle.baseCalcul.equals("CA")) { commission = rset3.getDouble("MontantCA")*(tranche.val/100); }
											else if (regle.baseCalcul.equals("M")) { commission = rset3.getDouble("Marge")*(tranche.val/100); }
										}
										detailCommission += commission;
									}
									rset3.close();
								}
								details.add(new DetailVenteFacture(refFacture, detailCommission, detailCommissionPossible));
							}
							rset2.close();
							
							totalCommissionMois += commissionFamille3;
							if (!detailCommissionPossible && (details.size()==1)) {
								DetailVenteFacture d = details.get(0);								
								d.commission=commissionFamille3;
								d.detailPossible=true;
								details.set(0,d);
							}
							ventesArticles.add(new VenteArticle("", 0, famille1, famille2, famille3, commissionFamille3, true, details));
						}
					}
					rset.close();
					
					
					// Ventes des articles Hors Stock
					String reqVentesArticlesHS = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqVentesArticlesHS += " sum(if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100))) as TotalCA";
					reqVentesArticlesHS += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af";
					reqVentesArticlesHS += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqVentesArticlesHS += " and f.Numero<>0 and af.Type_Ligne='I' group by af.Reference";
					
					double commissionHS = 0;
					boolean detailCommissionPossible = true;
					boolean commissionHSTraitee = false;
					
					rset = stt.executeQuery(reqVentesArticlesHS);
					while (rset.next()) {
						
						String refArticle = rset.getString("RefArticle");
						String typeLigne = rset.getString("Type_Ligne");
						
						int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

						Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
						double commission = 0;
						if (regle != null) {
							commissionHSTraitee = true;
							Tranche tranche = regle.tranches.get(0);
							if (regle.hasTranches) {
								detailCommissionPossible=false;
								int j=0;
								double total = rset.getDouble("TotalCA");
								double granulariteTranche = 0.01;
								while (tranche.binf<total && j<regle.tranches.size()) {
									double montant = 0;									
									if (tranche.bsup<=total) { montant = tranche.bsup-tranche.binf+granulariteTranche; }
									else { montant = total-tranche.binf+granulariteTranche; }									
									commission += montant*(tranche.val/100);									
									j++;
									if (j<regle.tranches.size()) {
										tranche = regle.tranches.get(j);
									}
								}
							} else {
								commission = rset.getDouble("TotalCA")*(tranche.val/100);
							}
						}
						commissionHS += commission;						
					}
					rset.close();
					
					if (commissionHSTraitee) {
						ArrayList<DetailVenteFacture> details = new ArrayList<DetailVenteFacture>();
						
						String reqFacturesHS = "select distinct f.Facture_Id, f.Num_Entier as RefFacture from "+ this.base +".FACTURE f,"+ this.base +".LIGNE_FACTURE af";
						reqFacturesHS += " where f.Util_R="+ this.commercialId +" and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
						reqFacturesHS += " and f.Numero<>0 and f.Facture_Id=af.Facture_Id and af.Type_Ligne='I'";
						reqFacturesHS += " order by f.Facture_Id";
						
						rset = stt.executeQuery(reqFacturesHS);
						while (rset.next()) {
							int factureId = rset.getInt("Facture_Id");
							String refFacture = rset.getString("RefFacture");
							double detailCommission = 0;
							
							if (detailCommissionPossible) {
								// calcul des commissions par facture
								
								String reqDetailsVentesArticlesHS = "select af.Reference as RefArticle, af.Type_Ligne,";
								reqDetailsVentesArticlesHS += " (if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as MontantCA";
								reqDetailsVentesArticlesHS += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af";
								reqDetailsVentesArticlesHS += " where af.Type_Ligne='I' and f.Facture_Id="+factureId+" and f.Facture_Id=af.Facture_Id";
								
								Statement stt2 = this.con.createStatement();
								ResultSet rset2 = stt2.executeQuery(reqDetailsVentesArticlesHS);
								while (rset2.next()) {
									String refArticle = rset2.getString("RefArticle");
									String typeLigne = rset2.getString("Type_Ligne");
									
									int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

									Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
									double commission = 0;
									if (regle != null) {
										Tranche tranche = regle.tranches.get(0);
										commission = rset2.getDouble("MontantCA")*(tranche.val/100);
									}
									detailCommission += commission;
								}
								rset2.close();
								stt2.close();
							}
							details.add(new DetailVenteFacture(refFacture, detailCommission, detailCommissionPossible));
						}
						rset.close();
						
						totalCommissionMois += commissionHS;
						if (!detailCommissionPossible && (details.size()==1)) {
							DetailVenteFacture d = details.get(0);								
							d.commission=commissionHS;
							d.detailPossible=true;
							details.set(0,d);
						}
						ventesArticles.add(new VenteArticle("", 0, 0, 0, 0, commissionHS, false, details));
					}
					
				} else if (this.filtre.equals("A")) {
				// 6e cas : la granularit du filtre de tri est sur les articles
					
					// modle de requte pour les factures par articles
					String reqFacturesArticles = "select distinct f.Facture_Id, f.Num_Entier as RefFacture from "+ this.base +".FACTURE f,"+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqFacturesArticles += " where f.Util_R="+ this.commercialId +" and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqFacturesArticles += " and f.Facture_Id=af.Facture_Id and af.Type_Ligne='S' and fa.Article_Id=af.Reference and fa.Article_Id=?";
					reqFacturesArticles += " order by f.Facture_Id";
					PreparedStatement psFacturesArticles = con.prepareStatement(reqFacturesArticles);
					
					String reqDetailsVentesArticles = "select";
					reqDetailsVentesArticles += " (if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as MontantCA,";
					reqDetailsVentesArticles += " if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite) as Marge";
					reqDetailsVentesArticles += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqDetailsVentesArticles += " where af.Reference=fa.Article_Id and af.Type_Ligne='S' and f.Facture_Id=af.Facture_Id and f.Facture_Id=?";
					reqDetailsVentesArticles += " and fa.Article_Id=?";
					PreparedStatement psDetailsVentesArticles = con.prepareStatement(reqDetailsVentesArticles);
					
					String reqFacturesHS = "select distinct f.Facture_Id, f.Num_Entier as RefFacture from "+ this.base +".FACTURE f,"+ this.base +".LIGNE_FACTURE af";
					reqFacturesHS += " where f.Util_R="+ this.commercialId +" and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqFacturesHS += " and f.Facture_Id=af.Facture_Id and af.Type_Ligne='I'";
					reqFacturesHS += " and f.Numero<>0 and af.Reference=? order by f.Facture_Id";
					PreparedStatement psFacturesHS = con.prepareStatement(reqFacturesHS);
					
					String reqDetailsVentesArticlesHS = "select";
					reqDetailsVentesArticlesHS += " (if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as MontantCA";
					reqDetailsVentesArticlesHS += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af";
					reqDetailsVentesArticlesHS += " where f.Facture_Id=? and af.Reference=? and af.Type_Ligne='I' and f.Facture_Id=af.Facture_Id";
					PreparedStatement psDetailsVentesArticlesHS = con.prepareStatement(reqDetailsVentesArticlesHS);

					// ventes par articles
					String reqVentesArticles = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqVentesArticles += " sum(if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as TotalCA,";
					reqVentesArticles += " sum(if(af.Prix=0,0,(if(f.Edition_TTC=0,af.Prix,af.Prix/(1+af.Taux_TVA/100))-fa.Prix_Achat) * (1-af.Ristourne/100) * (1-f.Remise/100) * af.Quantite)) as TotalMarge,";
					reqVentesArticles += " sum(af.Quantite) as TotalQuantite";
					reqVentesArticles += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af, "+ this.base +".FICHE_ARTICLE fa";
					reqVentesArticles += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and af.Reference=fa.Article_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqVentesArticles += " and f.Numero<>0 and af.Type_Ligne='S' group by af.Reference, af.Type_Ligne";
					
					rset = stt.executeQuery(reqVentesArticles);
					while (rset.next()) {
						String refArticle = rset.getString("RefArticle");
						String typeLigne = rset.getString("Type_Ligne");
						
						int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

						Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
						boolean detailCommissionPossible = true;
						boolean articleTraite = false;
						double commissionArticle = 0;
						
						if (regle != null) {
							articleTraite = true;
							if (regle.hasTranches || regle.baseCalcul.equals("Q")) { detailCommissionPossible = false; }
							Tranche tranche = regle.tranches.get(0);
							if (regle.hasTranches) {
								int j=0;
								double total = 0;
								double granulariteTranche = 0.01;
								if (regle.baseCalcul.equals("CA")) { total = rset.getDouble("TotalCA"); }
								else if (regle.baseCalcul.equals("M")) { total = rset.getDouble("TotalMarge"); }
								else if (regle.baseCalcul.equals("Q")) {
									total = rset.getDouble("TotalQuantite");
									granulariteTranche = 1;
								}
								
								// La rgle est tranche : dans le cas d'une commission sur les quantits,
								// la valeur de la commission est soit en euros, soit en % sur le CA ou la marge
								while (tranche.binf<total && j<regle.tranches.size()) {
									double montant = 0;
									if (tranche.bsup<=total) { montant = tranche.bsup-tranche.binf+granulariteTranche; }
									else { montant = total-tranche.binf+granulariteTranche; }
									if (regle.baseCalcul.equals("CA") || regle.baseCalcul.equals("M")) {
										commissionArticle += montant*(tranche.val/100);
									} else if (regle.baseCalcul.equals("Q")) {
										if (regle.modeCalculQte.equals("E")) { commissionArticle += tranche.val; }
										else if (regle.baseCalculQte.equals("CA")) { commissionArticle += rset.getDouble("TotalCA")*(tranche.val/100); }
										else { commissionArticle += rset.getDouble("TotalMarge")*(tranche.val/100); }
									}
									j++;
									if (j<regle.tranches.size()) {
										tranche = regle.tranches.get(j);
									}
								}
							} else {
								// La rgle n'est pas tranche : dans le cas d'une commission sur les quantits,
								// la valeur de la commission est toujours en euros
								if (regle.baseCalcul.equals("CA")) { commissionArticle = rset.getDouble("TotalCA")*(tranche.val/100); }
								else if (regle.baseCalcul.equals("M")) { commissionArticle = rset.getDouble("TotalMarge")*(tranche.val/100); }
								else if (regle.baseCalcul.equals("Q")) { commissionArticle = (rset.getDouble("TotalQuantite")>0?tranche.val:0); }
							}						
						
						
							if (articleTraite) {
								ArrayList<DetailVenteFacture> details = new ArrayList<DetailVenteFacture>();

								psFacturesArticles.setString(1, refArticle);
								
								ResultSet rset2 = psFacturesArticles.executeQuery();
								while (rset2.next()) {
									int factureId = rset2.getInt("Facture_Id");
									String refFacture = rset2.getString("RefFacture");
									double detailCommission = 0;
									
									if (detailCommissionPossible) {
										// calcul des commissions par facture
										
										psDetailsVentesArticles.setInt(1, factureId);
										psDetailsVentesArticles.setString(2, refArticle);										
										
										ResultSet rset3 = psDetailsVentesArticles.executeQuery();
										while (rset3.next()) {
											if (regle.baseCalcul.equals("CA")) { detailCommission += rset3.getDouble("MontantCA")*(tranche.val/100); }
											else if (regle.baseCalcul.equals("M")) { detailCommission += rset3.getDouble("Marge")*(tranche.val/100); }
										}
										rset3.close();
									}
									details.add(new DetailVenteFacture(refFacture, detailCommission, detailCommissionPossible));
								}
								rset2.close();
								
								totalCommissionMois += commissionArticle;
								if (!detailCommissionPossible && (details.size()==1)) {
									DetailVenteFacture d = details.get(0);								
									d.commission=commissionArticle;
									d.detailPossible=true;
									details.set(0,d);
								}
								ventesArticles.add(new VenteArticle(refArticle, 0, 0, 0, 0, commissionArticle, true, details));
							}
						}
					}
					rset.close();					
					
					
					// Ventes des articles Hors Stock
					String reqVentesArticlesHS = "select af.Reference as RefArticle, af.Type_Ligne,";
					reqVentesArticlesHS += " sum(if(f.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100)) * (1-f.Remise/100)) as TotalCA";
					reqVentesArticlesHS += " from "+ this.base +".FACTURE f, "+ this.base +".LIGNE_FACTURE af";
					reqVentesArticlesHS += " where f.Util_R="+ this.commercialId +" and f.Facture_Id=af.Facture_Id and f.Date_Facture>="+periode[0]+" and f.Date_Facture<="+periode[1];
					reqVentesArticlesHS += " and f.Numero<>0 and af.Type_Ligne='I' group by af.Reference";
					
					rset = stt.executeQuery(reqVentesArticlesHS);
					while (rset.next()) {
						
						String refArticle = rset.getString("RefArticle");
						String typeLigne = rset.getString("Type_Ligne");
						
						int numRegle = rechercherRegleApplicable(refArticle, typeLigne.equals("S"));

						Regle regle = (numRegle!=-1?this.regles.get(numRegle):null);
						double commission = 0;
						boolean detailCommissionPossible = true;
						boolean commissionHSTraitee = false;
						
						if (regle != null) {
							commissionHSTraitee = true;
							Tranche tranche = regle.tranches.get(0);
							if (regle.hasTranches) {
								detailCommissionPossible=false;
								int j=0;
								double total = rset.getDouble("TotalCA");
								double granulariteTranche = 0.01;
								while (tranche.binf<total && j<regle.tranches.size()) {
									double montant = 0;
									if (tranche.bsup<=total) { montant = tranche.bsup-tranche.binf+granulariteTranche; }
									else { montant = total-tranche.binf+granulariteTranche; }									
									commission += montant*(tranche.val/100);									
									j++;
									if (j<regle.tranches.size()) {
										tranche = regle.tranches.get(j);
									}
								}
							} else {
								commission = rset.getDouble("TotalCA")*(tranche.val/100);
							}
							
							if (commissionHSTraitee) {
								ArrayList<DetailVenteFacture> details = new ArrayList<DetailVenteFacture>();
								
								psFacturesHS.setString(1, refArticle);
								
								ResultSet rset2 = psFacturesHS.executeQuery();
								while (rset2.next()) {
									int factureId = rset2.getInt("Facture_Id");
									String refFacture = rset2.getString("RefFacture");
									double detailCommission = 0;
									
									if (detailCommissionPossible) {
										// calcul des commissions par facture
										psDetailsVentesArticlesHS.setInt(1, factureId);
										psDetailsVentesArticlesHS.setString(2, refArticle);
										
										ResultSet rset3 = psDetailsVentesArticlesHS.executeQuery();
										while (rset3.next()) {
											detailCommission += rset3.getDouble("MontantCA")*(tranche.val/100);
										}
										rset3.close();
									}
									details.add(new DetailVenteFacture(refFacture, detailCommission, detailCommissionPossible));
								}
								rset2.close();
								
								totalCommissionMois += commission;
								if (!detailCommissionPossible && (details.size()==1)) {
									DetailVenteFacture d = details.get(0);								
									d.commission=commission;
									d.detailPossible=true;
									details.set(0,d);
								}
								ventesArticles.add(new VenteArticle(refArticle, 0, 0, 0, 0, commission, false, details));
							}							
						}
					}
					rset.close();
				}				
				
				
				if (ventesArticles.size()>0 && (this.regles.size()!=1 || !this.regles.get(0).baseCalcul.equals("CAE"))) {
					if (this.filtre.equals("ND") || this.filtre.equals("C")) {
					// 6e cas : pas de filtre : on affiche les totaux par facture
					// algorithme de dpart pour le filtre par clients
					// on refait le tableau ventesArticles et il ne contiendra qu'un seul lment, lui-mme contenant les dtails par facture
						
						ventesArticles = trierFactures(ventesArticles, totalCommissionMois);
						
					}
					
					
					if (this.filtre.equals("C")) {
					// 7e cas : le filtre est sur le client
					// on refait le tableau ventesArticles et il contiendra pour chaque client les dtails par facture
						
						ArrayList<DetailVenteFacture> listeFactures = ventesArticles.get(0).details;
						
						ventesArticles = new ArrayList<VenteArticle>();
						
						String reqClient = "select Client_Id, Denomination from "+ this.base +".FACTURE where Num_Entier=?";
						PreparedStatement psClient = con.prepareStatement(reqClient);
						
						while (listeFactures.size()>0) {
							ArrayList<DetailVenteFacture> detailsFactures = new ArrayList<DetailVenteFacture>();
							
							int lastIndex = listeFactures.size()-1;
							DetailVenteFacture fact = listeFactures.get(lastIndex);
							listeFactures.remove(lastIndex);
							detailsFactures.add(fact);
							
							psClient.setString(1,fact.refFacture);
							ResultSet rset2 = psClient.executeQuery();
							rset2.next();
							String refClient = rset2.getString("Client_Id");
							String raisonSociale = rset2.getString("Denomination");
							double commissionClient = fact.commission;
							boolean totalClientCalculable = fact.detailPossible;
							
							for (int j=lastIndex-1; j>=0; j--) {
								DetailVenteFacture curElem = listeFactures.get(j);
								psClient.setString(1,curElem.refFacture);
								rset2 = psClient.executeQuery();
								rset2.next();
								if (rset2.getString("Client_Id").equals(refClient) && rset2.getString("Denomination").equals(raisonSociale)) {
									if (totalClientCalculable && !curElem.detailPossible) {
										totalClientCalculable = false;
										commissionClient = 0;
									} else if (totalClientCalculable && curElem.detailPossible) {
										commissionClient += curElem.commission;
									}
									listeFactures.remove(j);
									detailsFactures.add(curElem);
								}
							}
							rset2.close();
							
							Collections.sort(detailsFactures);
							ventesArticles.add(new VenteArticle(raisonSociale, totalClientCalculable, commissionClient, detailsFactures));
						}
						Collections.sort(ventesArticles);
						psClient.close();
					}
				}
				
				this.ventesArticlesPeriodes.add(new VenteArticlePeriode(ventesArticles, totalCommissionMois, periode[0], periode[1]));
				this.totalCommission += totalCommissionMois;
			}
			stt.close();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	public ArrayList<VenteArticle> trierFactures(ArrayList<VenteArticle> ventesArticles, double totalCommissionMois) {
		// 1. Rcupration de toutes les lignes de dtails
		ArrayList<DetailVenteFacture> detailsFactures = new ArrayList<DetailVenteFacture>();
		for (int j=0; j<ventesArticles.size(); j++) {
			VenteArticle vente = ventesArticles.get(j);
			for (int k=0; k<vente.details.size(); k++) {
				DetailVenteFacture detail = vente.details.get(k);
				detailsFactures.add(new DetailVenteFacture(detail.refFacture,detail.commission,detail.detailPossible));
			}
		}
		
		// 2. Traitement : regroupement et tri des factures
		ArrayList<DetailVenteFacture> regroupementFactures = new ArrayList<DetailVenteFacture>();
		while (detailsFactures.size()>0) {
			int lastIndex = detailsFactures.size()-1;
			DetailVenteFacture lastElem = detailsFactures.get(lastIndex);
			String refFacture = lastElem.refFacture;
			double commission = lastElem.commission;
			boolean detailPossible = lastElem.detailPossible;
			detailsFactures.remove(lastIndex);
			
			for (int j=lastIndex-1; j>=0; j--) {
				DetailVenteFacture curElem = detailsFactures.get(j);
				if (curElem.refFacture.equals(refFacture)) {
					if (detailPossible && !curElem.detailPossible) {
						detailPossible = false;
						commission = 0;
					} else if (detailPossible && curElem.detailPossible) {
						commission += curElem.commission;
					}
					detailsFactures.remove(j);
				}
			}
			
			regroupementFactures.add(new DetailVenteFacture(refFacture,commission,detailPossible));
		}
		Collections.sort(regroupementFactures);
		
		// 3. Rassemblage des donnes
		ventesArticles = new ArrayList<VenteArticle>();
		ventesArticles.add(new VenteArticle("", false, totalCommissionMois, regroupementFactures));
		
		return ventesArticles;
	}

	
	public int rechercherRegleApplicable(String refArticle, boolean enStock) {
		int rang = -1; // la recherche est termine ds que rang change de valeur
		try {
			if (enStock) {
				// L'article est en stock
				String reqArticle = "select coalesce(Marque_Id,0) as Marque_Id, Famille_1, coalesce(Famille_2,0) as Famille_2, coalesce(Famille_3,0) as Famille_3 from "+ this.base +".FICHE_ARTICLE";
				reqArticle += " where Article_Id=?";
				PreparedStatement psArticle = con.prepareStatement(reqArticle);
				psArticle.setString(1, refArticle);
				
				ResultSet rset = psArticle.executeQuery();
				if (rset.next()) {
				
					int marque = rset.getInt("Marque_Id");
					int famille1 = rset.getInt("Famille_1");
					int famille2 = rset.getInt("Famille_2");
					int famille3 = rset.getInt("Famille_3");

					int i=0; // 1re passe : sur les articles
					while (rang==-1 && i<this.regles.size()) {
						Regle r = this.regles.get(i);
						if (r.typeCommission.equals("A") && r.article.equals(refArticle)) {	rang = i; }
						i++;
					}
					i=0; // 2me passe : sur les familles
					while (rang==-1 && i<this.regles.size()) {
						Regle r = this.regles.get(i);
						if (r.typeCommission.equals("FA") && r.famille1 == famille1 && (r.famille2==0 || r.famille2 == famille2) && (r.famille3==0 || (r.famille2 == famille2 && r.famille3 == famille3))) { rang = i; }
						i++;
					}
					i=0; // 3me passe : sur les marques
					while (rang==-1 && i<this.regles.size()) {
						Regle r = this.regles.get(i);
						if (r.typeCommission.equals("MQ") && r.marque == marque) { rang = i; }
						i++;
					}
					i=0; // 4me passe : sur les articles en stock
					while (rang==-1 && i<this.regles.size()) {
						Regle r = this.regles.get(i);
						if (r.typeCommission.equals("AS")) { rang = i; }
						i++;
					}
				}
				rset.close();
			} else {
				// L'article n'est pas en stock
				int i=0; // 1re passe : sur les articles hors stock
				while (rang==-1 && i<this.regles.size()) {
					Regle r = this.regles.get(i);
					if (r.typeCommission.equals("HS")) { rang = i; }
					i++;
				}
			}			
			
			int i=0; // Dernire passe : globale
			while (rang==-1 && i<this.regles.size()) {
				Regle r = this.regles.get(i);
				if (r.typeCommission.equals("G")) { rang = i; }
				i++;
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}

		return rang;
	}

}
