/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.commerciaux;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;

public class DataCommission {
	
	// coordonnes socit mettrice
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;	
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	protected String web;
	protected double capital;
	protected String typeSociete;
	protected String tvaIntra;
	protected String rcs;
	protected String siren;
	protected String urlLogo = "";
	protected boolean logoAdr;

	// coordonnes commercial
	protected String codeCommercial;
	protected String loginCommercial;
	protected String nomCommercial;
	protected String adresse1Commercial;
	protected String adresse2Commercial;
	protected String codePostalCommercial;
	protected String villeCommercial;
	protected String paysCommercial;
	protected String secteurCommercial;
	protected String tel1Commercial;
	protected String tel2Commercial;
	protected String tel3Commercial;
	protected String fax1Commercial;
	protected String fax2Commercial;
	protected String email1Commercial;
	protected String email2Commercial;
	
	protected long dateCommission;
	protected long dateDebut;
	protected long dateFin;	
	protected String filtre;
	protected String commentaires;
	protected double totalHT;
	protected double totalTTC;
	protected double montantCommission;
	protected double ajustement;
	
	protected ArrayList<LigneCommission> lignes = new ArrayList<LigneCommission>(10);


	public DataCommission(Session s, int commissionId) {
		try {
			
			String base = s.getCookie().get("BaseDossier");
			String dossierId = s.getCookie().get("Dossier_Id");
			this.urlLogo = s.getAppConfiguration().get("opensi.absdir") +"/logos/"+ dossierId +".jpg";
			
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			// infos de l'entreprise
			String reqEntreprise = "select pd.Logo_Adr, d.Ville_RCS, Num_TVA_Intra, ts.Libelle as Type_Societe, d.Montant_Capital, d.Num_SIRET, d.Denomination, d.Adresse_1, d.Adresse_2, d.Adresse_3, d.Code_Postal, d.Ville, d.Telephone, d.Fax, d.Email, d.Site_Web";
			reqEntreprise += " from "+ base +".SOCIETE d join "+ base +".TYPE_SOCIETE ts on d.Type_Societe=ts.Type_Societe_Id, "+ base +".PARAM_DOSSIER pd";
			ResultSet rset = stt.executeQuery(reqEntreprise);			
			rset.next();
			this.logoAdr = (rset.getInt("Logo_Adr")==1);
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");			
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");
			rset.close();
			
			// rsum du commissionnement
			String reqInfosCommission = "select fc.Commercial_Id, fc.Code_Commercial, c.Date_Commission, c.Periode_Deb, c.Periode_Fin, c.Total_HT, c.Total_TTC, c.Montant_Commission, c.Montant_Ajustement, c.Commentaires, c.Filtre";
			reqInfosCommission += " from "+ base +".COMMISSIONNEMENT c, "+ base +".FICHE_COMMERCIAL fc where c.Commercial_Id=fc.Commercial_Id and c.Commissionnement_Id="+ commissionId;
			rset = stt.executeQuery(reqInfosCommission);
			rset.next();
			this.dateCommission = rset.getLong("Date_Commission");
			this.dateDebut = rset.getLong("Periode_Deb");
			this.dateFin = rset.getLong("Periode_Fin");
			this.totalHT = rset.getDouble("Total_HT");
			this.totalTTC = rset.getDouble("Total_TTC");
			this.montantCommission = rset.getDouble("Montant_Commission");
			this.ajustement = rset.getDouble("Montant_Ajustement");
			this.commentaires = rset.getString("Commentaires");
			this.filtre = rset.getString("Filtre");
			this.codeCommercial = rset.getString("Code_Commercial");
			int commercialId = rset.getInt("Commercial_Id");
			rset.close();
			
			// infos du commercial
			String reqCommercial = "select fc.*, u.Login, p.Nom_FR as Pays, c.Civ_Courte from "+ base +".FICHE_COMMERCIAL fc, UTILISATEUR u, PAYS p, CIVILITE c";
			reqCommercial += " where fc.Civilite=c.Civ_Id and fc.Commercial_Id=u.Utilisateur_Id and fc.Code_Pays=p.Code_Pays and fc.Commercial_Id=" + commercialId;
			rset = stt.executeQuery(reqCommercial);
			rset.next();			
			this.loginCommercial = rset.getString("Login");
			String civ_courte = rset.getString("Civ_Courte");
			if (!civ_courte.equals("")) civ_courte += " ";
			this.nomCommercial = civ_courte + rset.getString("Nom").toUpperCase() + " " + rset.getString("Prenom");
			this.adresse1Commercial = rset.getString("Adresse_1");
			this.adresse2Commercial = rset.getString("Adresse_2");
			this.codePostalCommercial = rset.getString("Code_Postal");
			this.villeCommercial = rset.getString("Ville").toUpperCase();
			this.paysCommercial = rset.getString("Pays");
			this.secteurCommercial = rset.getString("Secteur");
			this.tel1Commercial = rset.getString("Tel_1");
			this.tel2Commercial = rset.getString("Tel_2");
			this.tel3Commercial = rset.getString("Tel_3");
			this.fax1Commercial = rset.getString("Fax_1");
			this.fax2Commercial = rset.getString("Fax_2");
			this.email1Commercial = rset.getString("Email_1");
			this.email2Commercial = rset.getString("Email_2");			
			rset.close();

			String reqLignes = "select lc.Ref_Client, lc.Ref_Article, coalesce(ma.Libelle,'') as Marque,";
			reqLignes += " coalesce(fa1.Libelle,'') as Famille_1, coalesce(fa2.Libelle,'') as Famille_2, coalesce(fa3.Libelle,'') as Famille_3,";
			reqLignes += " lc.Detail_Commission, lc.Ref_Facture, lc.Type_Ligne, lc.Date_Deb, lc.Date_Fin, lc.Total_Commission, lc.Stock";
			reqLignes += " from "+ base +".LIGNE_COMMISSIONNEMENT lc left join "+ base +".MARQUE_ARTICLE ma on lc.Marque_Id=ma.Marque_Id";
			reqLignes += " left join "+ base +".FAMILLE_ARTICLE fa1 on lc.Famille_1=fa1.Famille_Id";
			reqLignes += " left join "+ base +".FAMILLE_ARTICLE fa2 on lc.Famille_2=fa1.Famille_Id";
			reqLignes += " left join "+ base +".FAMILLE_ARTICLE fa3 on lc.Famille_3=fa1.Famille_Id";
			reqLignes += " where lc.Commissionnement_Id="+ commissionId +" order by lc.Rank";
			rset = stt.executeQuery(reqLignes);			
			while (rset.next()) {
				LigneCommission lc = new LigneCommission();
				lc.setRefClient(rset.getString("Ref_Client"));
				lc.setRefArticle(rset.getString("Ref_Article"));
				lc.setMarque(rset.getString("Marque"));
				lc.setFamille1(rset.getString("Famille_1"));
				lc.setFamille2(rset.getString("Famille_2"));
				lc.setFamille3(rset.getString("Famille_3"));
				lc.setEnStock(rset.getInt("Stock")==1);
				lc.setTotalCommission(rset.getDouble("Total_Commission"));
				lc.setDetailCommissionPossible(rset.getInt("Detail_Commission")==1);
				lc.setRefFacture(rset.getString("Ref_Facture"));
				lc.setDateDebut(rset.getLong("Date_Deb"));
				lc.setDateFin(rset.getLong("Date_Fin"));
				lc.setType(rset.getString("Type_Ligne").charAt(0));
				this.lignes.add(lc);
			}
			rset.close();
			
			stt.close();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public int getNbLignes() {
		return this.lignes.size();
	}


} // fin DataCommission
