/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.transcompta;

import java.sql.*;

import org.opensi.data.exercice.Ecriture;
import org.opensi.api.SessionOSI;
import org.opensi.bo.BO_Ecritures;


public abstract class TransfertCompta {


  protected Connection con;
	protected String baseDossier;

	private PreparedStatement psBaseExo;
	private PreparedStatement psIntCpte;


  public TransfertCompta(SessionOSI sosi) throws Exception {

		this.baseDossier = sosi.getBaseDossier();

		this.con = sosi.getConnection();

		this.psBaseExo = con.prepareStatement("select Nom_Base from "+ baseDossier +".EXERCICE where Debut_Exercice<=? and Fin_Exercice>=?");

		this.psIntCpte = con.prepareStatement("select Intitule from "+ baseDossier +".COMPTE where Numero_Compte=?");
	}


	public abstract void transfert() throws Exception;

	protected abstract void marquerDocument(int documentId) throws SQLException;


	protected final void validerEcriture(Ecriture ecriture, int documentId, long dateDoc) throws SQLException {

		if (ecriture.isValid()) {

			String baseExo = getBaseExo(dateDoc);

			if (baseExo!=null) {
				BO_Ecritures boEcritures = new BO_Ecritures(con, baseDossier, baseExo);
				boEcritures.saveEcriture(ecriture);

				marquerDocument(documentId);
			}
		}
		else {
			System.out.println("\nTRANSFERT COMPTA: ECRITURE DESEQUILIBREE\n");
			ecriture.printEcriture();
		}
	}


	private final String getBaseExo(long dateDoc) throws SQLException {

		psBaseExo.setLong(1, dateDoc);
		psBaseExo.setLong(2, dateDoc);

		ResultSet rset = psBaseExo.executeQuery();

		return rset.next()?rset.getString("Nom_Base"):null;
	}


	protected final String getIntitule(String numCompte) throws SQLException {

		psIntCpte.setString(1, numCompte);
		ResultSet rset = psIntCpte.executeQuery();

		return rset.next()?rset.getString("Intitule"):"-";
	}


} // fin TransfertCompta

