/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *   Export des donnes pour Idep
 */

package org.opensi.facturation.actions.idep;

import java.io.BufferedWriter;
import java.io.FileWriter;


public class TxtExportIntracom {
		
	public TxtExportIntracom(String buffer, String fichier, DataExportIdep dei) throws Exception {
		try
		{
			// EXPORT AU FORMAT INTRACOM
			// Les units supplmentaires ne sont pas gres (par dfaut  0)
			// Donc la masse nette est toujours remplie
			
			// Paramtrer IDEP pour qu'il n'y ait 1 saut de ligne  l'import (c'est le cas par dfaut)
			
			BufferedWriter output = new BufferedWriter(new FileWriter(buffer + fichier, true));		
			int nbLignes = dei.getNbLignes();
			
			String ligne = formaterChaine("Premi\u00E8re ligne non utilis\u00E9e",27);
			ligne += formaterChaine("",109);
			ligne += "\r\n";
		
			output.write(ligne);
			
			if (dei.declarationIntro) {
				// INTRACOM INTRODUCTION				
				
				for (int i=0; i<nbLignes; i++) {
					LigneExportIdep lei = dei.lignes.get(i);
					
					ligne = formaterChaine("",38);
					
					ligne += (dei.niveauObligation==1?formaterEntier(dei.departement,2):formaterChaine("",2));
					ligne += (dei.niveauObligation==1?formaterEntier(dei.codeTransport,1):formaterChaine("",1));
					ligne += formaterChaine(lei.provenanceDestination,3);
					ligne += (!dei.declarationSimplifiee?formaterEntier(dei.codeTransactionA,1):formaterChaine("",1));
					ligne += (!dei.declarationSimplifiee?formaterEntier(dei.codeTransactionB,1):formaterChaine("",1));
					ligne += (dei.codeRegime!=19 || dei.declarationSimplifiee?formaterEntier(lei.valeur,11):formaterChaine("",11));
					ligne += (!dei.declarationSimplifiee?formaterChaine(dei.conditionsLiv,3):formaterChaine("",3));
					ligne += (!dei.declarationSimplifiee?formaterEntier(dei.situationLieu,1):formaterChaine("",1));
					ligne += (dei.niveauObligation==1?formaterEntier(dei.codeRegime,2):formaterChaine("",2));
					ligne += formaterEntier(dei.niveauObligation,1);
					ligne += formaterChaine(lei.referenceProduit,8);
					ligne += formaterChaine(lei.codeNGP9,1);
					ligne += (!dei.declarationSimplifiee?formaterEntier(lei.masseNette,10):formaterEntier(0,10));
					ligne += (dei.codeRegime==19 && !dei.declarationSimplifiee?formaterEntier(lei.valeurStatistique,11):formaterEntier(0,11));
					ligne += (!dei.declarationSimplifiee?formaterEntier(lei.unitesSupplementaires,10):formaterEntier(0,10));
					ligne += (!dei.declarationSimplifiee?formaterChaine(lei.paysOrigine,3):formaterChaine("",3));
					ligne += formaterChaine("",14);
					
					ligne += formaterChaine("",15);
					ligne += "\r\n";
				
					output.write(ligne);
				}
			} else {
				// INTRACOM EXPEDITION

				for (int i=0; i<nbLignes; i++) {
					LigneExportIdep lei = dei.lignes.get(i);
					
					ligne = formaterChaine("",38);
					
					ligne += (dei.niveauObligation==1 && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?formaterEntier(dei.departement,2):formaterChaine("",2));
					ligne += (dei.niveauObligation==1 && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?formaterEntier(dei.codeTransport,1):formaterChaine("",1));
					ligne += formaterChaine("",3);										
					ligne += (!dei.declarationSimplifiee && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?formaterEntier(dei.codeTransactionA,1):formaterChaine("",1));
					ligne += (!dei.declarationSimplifiee && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?formaterEntier(dei.codeTransactionB,1):formaterChaine("",1));
					ligne += (dei.codeRegime!=29 || dei.declarationSimplifiee?formaterEntier(lei.valeur,11):formaterChaine("",11));
					ligne += (!dei.declarationSimplifiee?formaterChaine(dei.conditionsLiv,3):formaterChaine("",3));
					ligne += (!dei.declarationSimplifiee?formaterEntier(dei.situationLieu,1):formaterChaine("",1));
					ligne += (dei.codeRegime!=29 || (dei.niveauObligation!=2 && dei.niveauObligation!=3)?formaterEntier(dei.codeRegime,2):formaterChaine("",2));
					ligne += formaterEntier(dei.niveauObligation,1);
					ligne += (dei.niveauObligation!=4 && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?formaterChaine(lei.referenceProduit,8):formaterChaine("",8));
					ligne += (dei.niveauObligation!=4 && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?formaterChaine(lei.codeNGP9,1):formaterChaine("",1));
					ligne += (!dei.declarationSimplifiee && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?formaterEntier(lei.masseNette,10):formaterEntier(0,10));
					ligne += (dei.codeRegime==29 && !dei.declarationSimplifiee?formaterEntier(lei.valeurStatistique,11):formaterEntier(0,11));
					ligne += (!dei.declarationSimplifiee && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?formaterEntier(lei.unitesSupplementaires,10):formaterEntier(0,10));
					ligne += (dei.niveauObligation!=4 && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?formaterChaine(lei.provenanceDestination,3):formaterChaine("",3));
					ligne += (dei.niveauObligation==4 || dei.codeRegime!=29?formaterChaine(lei.numTVAPartenaire,14):formaterChaine("",14));
					
					ligne += formaterChaine("",15);
					ligne += "\r\n";
					
					output.write(ligne);
				}
			}
			
			output.flush();
			output.close();
		}
		catch(Exception ioe) {
			System.out.println("erreur : " + ioe );
		}
	}
	
	
	public String formaterChaine(String chaine, int longueur_max) {
		String nouv_chaine = chaine;
		if (nouv_chaine.length() < longueur_max) {
			for (int i=nouv_chaine.length(); i<longueur_max; i++)
				nouv_chaine = " " + nouv_chaine;
		} else {
			nouv_chaine = nouv_chaine.substring(0,longueur_max);
		}
		return nouv_chaine;
	}
	
	public String formaterEntier(int nombre, int longueur_max) {
		String nouv_chaine = "" + nombre;
		
		for (int i=nouv_chaine.length(); i<longueur_max; i++)
			nouv_chaine = "0" + nouv_chaine;
		
		return nouv_chaine;
	}
	
	
	
} // fin TxtExportIntracom
