/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'une liste de fournisseurs
 */

package org.opensi.facturation.actions.editions;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.pdf.GlobalDocument;


public class GenListeFournisseurs extends Action {

	public boolean serverSide() { return true; }
	
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {
		
		String fichierPdf = r.getParameter("FichierPdf") != null ? r.getParameter("FichierPdf") : "";
		String fichierCsv = r.getParameter("FichierCsv") != null ? r.getParameter("FichierCsv") : "";
		String absdir = s.getAppConfiguration().get("opensi.absdir");
		
		int familleFournisseur = Integer.parseInt(r.getParameter("Famille"));
		String tri1 = r.getParameter("Tri1");
		String tri2 = r.getParameter("Tri2");
		String tri3 = r.getParameter("Tri3");
		
		
		DataListeFournisseurs dlf = new DataListeFournisseurs(s, familleFournisseur, tri1, tri2, tri3);
		
		if (!fichierPdf.equals("")) {
			// Cration d'un PDF
			String repPdf = absdir +"/pdf/";
			String repTemp = repPdf;
		
			PdfListeFournisseurs pdfListeFournisseurs = new PdfListeFournisseurs(repTemp, dlf);			
			GlobalDocument gd = new GlobalDocument(repPdf, fichierPdf);	
			gd.addInternal(pdfListeFournisseurs);	
			gd.close(GlobalDocument.ON_EXIT);
		} else if (!fichierCsv.equals("")) {
			// Cration d'un CSV
			String buffer = absdir +"/iobuffer/";
			new CsvListeFournisseurs(buffer, fichierCsv, dlf);
		}
		
		return true;
	}

} // fin GenListeFournisseurs
