/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un tableau des ventes par articles
 */

package org.opensi.facturation.actions.editions;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;
import org.opensi.util.tools.DateTime;

public class CsvVentesArticles {
	
	public CsvVentesArticles(String buffer, String fichier, DataVentesArticles dva) throws Exception {
		
		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("Date Facture");
		lf.addToLine("Num Facture");
		lf.addToLine("Raison Sociale");
		lf.addToLine("Mode R\u00E8glement");
		lf.addToLine("Total HT");
		lf.addToLine("Montant TVA");
		lf.addToLine("Montant TTC");
		lf.addToLine("Remise");
		lf.addToLine("R\u00E9f\u00E9rence");
		lf.addToLine("D\u00E9signation");
		lf.addToLine("Quantit\u00E9");
		lf.addToLine("Prix Unitaire");
		
		int nbLignes = dva.getNbLignes();		
		for (int i=0; i<nbLignes; i++) {
			LigneVentesArticles lva = dva.lignes.get(i);
			
			lf.newLine();
			lf.addToLine(DateTime.formatTime(lva.date_facture, "dd/MM/yyyy"));
			lf.addToLine(lva.num_facture);
			lf.addToLine("\"" + lva.raison_sociale + "\"");
			lf.addToLine("\"" + lva.mode_reglement + "\"");
			lf.addToLine(("" + lva.total_ht).replaceAll("\\.", ","));
			lf.addToLine(("" + lva.montant_tva).replaceAll("\\.", ","));
			lf.addToLine(("" + lva.montant_ttc).replaceAll("\\.", ","));
			lf.addToLine(("" + lva.remise).replaceAll("\\.", ","));
			lf.addToLine(lva.reference);
			lf.addToLine("\"" + lva.designation + "\"");
			lf.addToLine(("" + lva.quantite).replaceAll("\\.", ","));
			lf.addToLine(("" + lva.prix_unitaire).replaceAll("\\.", ","));
		}
		
		lf.write(buffer, fichier, true);
	}


} // fin CsvStatistiquesCA
