/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'une liste de fournisseurs en csv
 */

package org.opensi.facturation.actions.editions;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;

public class CsvListeFournisseurs {
	
	public CsvListeFournisseurs(String buffer, String fichier, DataListeFournisseurs dlf) throws Exception {
		
		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("Famille");
		lf.addToLine("Num\u00E9ro");
		lf.addToLine("Fournisseur");
		lf.addToLine("Adresse");
		lf.addToLine("CP");
		lf.addToLine("Ville");
		lf.addToLine("T\u00E9l.");
		
		int nbLignes = dlf.getNbLignes();
		
		for (int i=0; i<nbLignes; i++) {
			LigneListeFournisseurs llf = dlf.lignes.get(i);
			
			lf.newLine();
			lf.addToLine(llf.famille);
			lf.addToLine(llf.numero);
			lf.addToLine(llf.fournisseur);
			lf.addToLine(llf.adresse);
			lf.addToLine(llf.cp);
			lf.addToLine(llf.ville);
			lf.addToLine(llf.tel);
		}
		
		lf.write(buffer, fichier, true);
	}



} // fin CsvListeFournisseurs
