/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un bon de livraison et du bon de prparation correspondant
 */

package org.opensi.facturation.actions.documents;


import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.facturation.actions.documents.modeles.BonLivraisonPDF;
import org.opensi.facturation.actions.documents.modeles.BonLivraisonStd;
import org.opensi.facturation.actions.documents.modeles.DataBonLivraison;
import org.opensi.facturation.actions.documents.modeles.DataFacture;
import org.opensi.facturation.actions.documents.modeles.FacturePDF;
import org.opensi.facturation.actions.documents.modeles.FactureStd;
import org.opensi.util.pdf.GlobalDocument;


public class GenBLFacture extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
	
		String fichierPdf = r.getParameter("Document_Id") +".pdf";
		String absdir = s.getAppConfiguration().get("opensi.absdir");
		String base = s.getCookie().get("BaseDossier");
		
		String repPdf = absdir +"/pdf/";
		String repTemp = repPdf;
		
		Connection con = s.getConnection(null);
		Statement stt = con.createStatement();
		ResultSet rset;

		boolean multi = r.getParameter("MultiEx")!=null;
		String bonId = r.getParameter("Bon_Id");
		String factureId = r.getParameter("Facture_Id");
		
		String reqModeleBL = "select mbl.Modele_Id, mbl.Class from "+ base +".MODELE_BON_LIVRAISON mbl, "+ base +".PARAM_DOSSIER d";
		reqModeleBL += " where mbl.Modele_Id=d.Modele_Pdf_BL";
		rset = stt.executeQuery(reqModeleBL);
		rset.next();
		String modeleBL = rset.getString("Modele_Id");
		String cheminBL = rset.getString("Class");
		rset.close();
		
		String reqModeleFacture = "select mfc.Modele_Id, mfc.Class from "+ base +".MODELE_FACTURE_CLIENT mfc, "+ base +".PARAM_DOSSIER d";
		reqModeleFacture += " where mfc.Modele_Id=d.Modele_Pdf_FC";
		rset = stt.executeQuery(reqModeleFacture);
		rset.next();
		String modeleFacture = rset.getString("Modele_Id");
		String cheminFacture = rset.getString("Class");
		rset.close();
		
		stt.close();
		s.closeConnection(con, null);
		
		
		GlobalDocument gd = new GlobalDocument(repPdf, fichierPdf);
		
		BonLivraisonPDF bonLivraison;
		DataBonLivraison dbl = new DataBonLivraison(s, bonId);
		if (modeleBL.equals("STD01")) {
			bonLivraison = new BonLivraisonStd(repTemp, dbl);
		}
		else {
			Object[] o = {repTemp, dbl};
			Class<?> cl = Class.forName(cheminBL);
			Constructor<?> c = cl.getConstructors()[0];
			bonLivraison = (BonLivraisonPDF)c.newInstance(o);
		}
		bonLivraison.setMultiEx(multi);
		if (r.getParameter("Chiffre")!=null)
			bonLivraison.setBonChiffre(r.getParameter("Chiffre").equals("1"));
		gd.addInternal(bonLivraison);
		

		FacturePDF facture;
		DataFacture df = new DataFacture(s, factureId);
		if (modeleFacture.equals("STD01")) {
			facture = new FactureStd(repTemp, df);
		}
		else {
			Object[] o = {repTemp, df};
			Class<?> cl = Class.forName(cheminFacture);
			Constructor<?> c = cl.getConstructors()[0];
			facture = (FacturePDF)c.newInstance(o);
		}
		facture.setMultiEx(multi);
		gd.addInternal(facture);

		
		gd.close(GlobalDocument.ON_EXIT);
	
		return true;
		
	} // fin service


} // fin GenBLBP
