/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition de la liste des commandes fournisseurs
 */

package org.opensi.facturation.actions.commandes;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;


public class DataListeCommandesFournisseurs {

	
	// les lignes de la liste des commandes
	protected ArrayList<LigneListeCommandesFournisseurs> lignes = new ArrayList<LigneListeCommandesFournisseurs>(100);

	public DataListeCommandesFournisseurs(Session s, String numCommande, String refArticle, String numFournisseur, String nomFournisseur, String etatCommande, String numBR, String intitule, String dateCommandeDebut, String dateCommandeFin) {
		try {
			
			Connection con = s.getConnection(null);
			String base = s.getCookie().get("BaseDossier");
			

			String getCommandes = "select c.Commande_Id, c.Date_Commande, c.Num_Entier, c.Intitule, u.Login as Login_Createur, c.Fournisseur_Id, f.Denomination,";
			getCommandes += " c.Etat, c.Remise, c.Total_HT";
			getCommandes += " from "+ base +".COMMANDE_FOURNISSEUR c join UTILISATEUR u on c.Util_C=u.Utilisateur_Id";
			getCommandes += " join "+ base +".FICHE_FOURNISSEUR f on c.Fournisseur_Id=f.Fournisseur_Id";
			if (!numBR.equals("")) { getCommandes += " join "+ base +".BON_RECEPTION b on b.Commande_Id=c.Commande_Id and b.Num_Entier like ?"; }
			if (!refArticle.equals("")) { getCommandes += " join "+ base +".LIGNE_COMMANDE_FOURNISSEUR a on a.Commande_Id=c.Commande_Id and (a.Reference like ? or a.Ref_Fournisseur like ?)"; }
			getCommandes += " where 1";
			if (!numCommande.equals("")) { getCommandes += " and c.Num_Entier like ?"; }
			if (!intitule.equals("")) { getCommandes += " and c.Intitule like ?"; }
			if (!numFournisseur.equals("")) { getCommandes += " and c.Fournisseur_Id like ?"; }
			if (!nomFournisseur.equals("")) { getCommandes += " and f.Denomination like ?"; }
			if (!etatCommande.equals("TS")) { getCommandes += " and c.Etat = ?"; }
			if (!dateCommandeDebut.equals("")) { getCommandes += " and c.Date_Commande>=?"; }
			if (!dateCommandeFin.equals("")) { getCommandes += " and c.Date_Commande<=?"; }
			getCommandes += " group by c.Commande_Id";
			getCommandes += " order by Date_Commande desc";
			
			PreparedStatement psCommandes = con.prepareStatement(getCommandes);
			int posParam = 0;
			if (!numBR.equals("")) {
				posParam++;
				psCommandes.setString(posParam, "%"+numBR+"%");
			}
			if (!refArticle.equals("")) {
				posParam++;
				psCommandes.setString(posParam, "%"+refArticle+"%");
				posParam++;
				psCommandes.setString(posParam, "%"+refArticle+"%");
			}
			if (!numCommande.equals("")) {
				posParam++;
				psCommandes.setString(posParam, "%"+numCommande+"%");
			}
			if (!intitule.equals("")) {
				posParam++;
				psCommandes.setString(posParam, "%"+intitule+"%");
			}
			if (!numFournisseur.equals("")) {
				posParam++;
				psCommandes.setString(posParam, "%"+numFournisseur+"%");
			}
			if (!nomFournisseur.equals("")) {
				posParam++;
				psCommandes.setString(posParam, "%"+nomFournisseur+"%");
			}
			if (!etatCommande.equals("TS")) {
				posParam++;
				psCommandes.setString(posParam, etatCommande);
			}
			if (!dateCommandeDebut.equals("")) {
				posParam++;
				DateTime dt = new DateTime(DateTime.parseDate(dateCommandeDebut, "yyyy:MM:dd"));
				psCommandes.setLong(posParam, dt.getDateInMillis());
			}
			if (!dateCommandeFin.equals("")) {
				posParam++;
				DateTime dt = new DateTime(DateTime.parseDate(dateCommandeFin, "yyyy:MM:dd"));
				psCommandes.setLong(posParam, dt.getDateFullTime());
			}
			
			
			String getCAReceptionne = "select coalesce(sum(br.Total_HT),0) as CA_Receptionne";
			getCAReceptionne += " from "+ base +".BON_RECEPTION br";
			getCAReceptionne += " where br.Etat='V' and br.Commande_Id=?";
			PreparedStatement psCAReceptionne = con.prepareStatement(getCAReceptionne);
			
			String getCARestant = "select coalesce(sum(CA_Restant),0) as CA_Restant from";
			getCARestant += " ((select coalesce((sum(c.Montant_Ligne) * (1-?/100)), 0) as CA_Restant";
			getCARestant += " from "+ base +".LIGNE_COMMANDE_FOURNISSEUR c";
			getCARestant += " where c.Commande_Id=? and c.Ligne_Id not in";
			getCARestant += " (select Ref_Ligne from "+ base +".LIGNE_BON_RECEPTION abr, "+ base +".BON_RECEPTION b";
			getCARestant += " where b.Etat='V' and abr.BR_Id=b.BR_Id))";
			getCARestant += " union";
			getCARestant += " (select coalesce((sum(c.Prix*(1-c.Ristourne/100)*(c.Quantite-Recep.QteRecue)) * (1-?/100)), 0) as CA_Restant from";
			getCARestant += " (select b.Ref_Ligne, sum(b.Quantite) as QteRecue";
			getCARestant += " from "+ base +".LIGNE_COMMANDE_FOURNISSEUR c, "+ base +".LIGNE_BON_RECEPTION b, "+ base +".BON_RECEPTION br";
			getCARestant += " where c.Commande_Id=? and c.Ligne_Id=b.Ref_Ligne and b.BR_Id=br.BR_Id and br.Etat='V' group by Ref_Ligne) as Recep,";
			getCARestant += " "+ base +".LIGNE_COMMANDE_FOURNISSEUR c";
			getCARestant += " where c.Commande_Id=? and c.Ligne_Id=Recep.Ref_Ligne";
			getCARestant += " and (c.Quantite-Recep.QteRecue>0))) as t";
			PreparedStatement psCARestant = con.prepareStatement(getCARestant);

			
			ResultSet rset = psCommandes.executeQuery();
			while (rset.next()) {
				int commandeId = rset.getInt("Commande_Id");
				double remise = rset.getDouble("Remise");
				
				psCAReceptionne.setInt(1, commandeId);
				ResultSet rset2 = psCAReceptionne.executeQuery();
				rset2.next();
				double caReceptionne = rset2.getDouble("CA_Receptionne");
				rset2.close();
				
				psCARestant.setDouble(1, remise);
				psCARestant.setInt(2, commandeId);
				psCARestant.setDouble(3, remise);
				psCARestant.setInt(4, commandeId);
				psCARestant.setInt(5, commandeId);
				rset2 = psCARestant.executeQuery();
				rset2.next();
				double caRestant = rset2.getDouble("CA_Restant");
				if (caRestant<0) { caRestant=0; }
				rset2.close();

				
				String etat = rset.getString("Etat");
				if (etat.equals("N")) { etat = "En cours"; }
				else if (etat.equals("P")) { etat = "Prparation"; }
				else if (etat.equals("B")) { etat = "Bloque"; }
				else if (etat.equals("V")) { etat = "Attente rception"; }
				else { etat = "Termine"; }
				
				LigneListeCommandesFournisseurs llc = new LigneListeCommandesFournisseurs();
				llc.setDateCommande(rset.getLong("Date_Commande"));
				llc.setNumCommande(rset.getString("Num_Entier"));
				llc.setIntitule(rset.getString("Intitule"));
				llc.setNumFournisseur(rset.getString("Fournisseur_Id"));
				llc.setNomFournisseur(rset.getString("Denomination"));
				llc.setNomResponsable(rset.getString("Login_Createur"));
				llc.setEtatCommande(etat);
				llc.setCAReceptionne(caReceptionne);
				llc.setCARestant(caRestant);
				llc.setTotalHT(rset.getDouble("Total_HT"));

				this.lignes.add(llc);
			}
			rset.close();

			psCARestant.close();
			psCAReceptionne.close();
			psCommandes.close();
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}			
	}
	
	
	public int getNbLignes() {
		return lignes.size();
	}



} // fin DataListeCommandesFournisseurs
