/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.commandes;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;


public class CalculPrepCommande extends Action {


	private Connection con;
	private String base;


	public boolean serverSide() { return true; }

	public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		base = s.getCookie().get("BaseDossier");

		con = s.getConnection(null);

		String prepId = r.getParameter("Prep_Id");

		Statement stt = con.createStatement();


		String newArticlePrepCommande = "insert into "+ base +".ARTICLE_PREP_COMMANDE (Prep_Id, Article_Id, Qte_Theorique) values ("+ prepId +",?,?)";

		String reqFournisseurs = "select Fournisseur_Id, Principal, Qte_Minimum, Multiple, Pack from "+ base +".FOURNISSEUR_ARTICLE where Article_Id=? order by Principal desc, Prix_Achat, Delai_Reappro";

		String newLigneArticlePrep = "insert into "+ base +".LIGNE_ARTICLE_PREP (Ligne_Prep_Id, Fournisseur_Id, Quantite) values (?,?,?)";

		String majQteTheo = "update "+ base +".ARTICLE_PREP_COMMANDE set Qte_Theorique=? where Prep_Id="+ prepId +" and Article_Id=?";

		String majQtePrep = "update "+ base +".LIGNE_ARTICLE_PREP set Quantite=Quantite+? where Fournisseur_Id=? and Ligne_Prep_Id=?";

		String reqMaxQteLAP = "select Fournisseur_Id from "+ base +".LIGNE_ARTICLE_PREP where Ligne_Prep_Id=? order by Quantite desc limit 1";
		String reqLAP = "select Quantite, Fournisseur_Id from "+ base +".LIGNE_ARTICLE_PREP where Ligne_Prep_Id=? and Quantite>0 order by Quantite";


		PreparedStatement psNewAPC = con.prepareStatement(newArticlePrepCommande, Statement.RETURN_GENERATED_KEYS);
		PreparedStatement psNewLAP = con.prepareStatement(newLigneArticlePrep);
		PreparedStatement psFA = con.prepareStatement(reqFournisseurs);
		PreparedStatement psMajQT = con.prepareStatement(majQteTheo);
		PreparedStatement psMajQP = con.prepareStatement(majQtePrep);

		PreparedStatement psMaxQteLAP = con.prepareStatement(reqMaxQteLAP);
		PreparedStatement psLAP = con.prepareStatement(reqLAP);


		// articles  rassortir + articles dj prsents en prparation de commande 
		String reqReassort = "select s1.Article_Id, (Stock_Maximum - (Stock_Init + Entrees - Sorties - Com_Clients + Com_Fournisseurs)) as QteReassort, coalesce(p1.Ligne_Prep_Id, 0), coalesce(Qte_Theorique, 0) "
			+ "from "+ base +".FICHE_ARTICLE a,"+ base +".STOCKS_ARTICLE s1 left join "+ base +".ARTICLE_PREP_COMMANDE p1 on (s1.Article_Id=p1.Article_Id and p1.Prep_Id="+ prepId +") "
			+ "where (Stock_Init + Entrees - Sorties - Com_Clients + Com_Fournisseurs) <= Stock_Alerte "
			+ "and (Stock_Maximum - (Stock_Init + Entrees - Sorties - Com_Clients + Com_Fournisseurs)) > 0 "
			+ "and a.Article_Id=s1.Article_Id and a.Composition='U' and Supprime=0 "
			+ "union "
			+ "select s2.Article_Id, (Stock_Maximum - (Stock_Init + Entrees - Sorties - Com_Clients + Com_Fournisseurs)) as QteReassort, p2.Ligne_Prep_Id, Qte_Theorique "
			+ "from "+ base +".ARTICLE_PREP_COMMANDE p2, "+ base +".STOCKS_ARTICLE s2 where p2.Prep_Id="+ prepId +" and p2.Article_Id=s2.Article_Id";


		ResultSet rset = stt.executeQuery(reqReassort);

		while (rset.next()) {

			String articleId = rset.getString(1);
			double qteReassort = rset.getDouble(2);
			int lignePrepId = rset.getInt(3);

			if (lignePrepId==0) {

				psFA.setString(1, articleId);
				ResultSet rsFA = psFA.executeQuery();

				if (rsFA.next()) {

					// cration d'une nouvelle ligne de prparation de commande
					psNewAPC.setString(1, articleId);
					double pack = rsFA.getDouble(5);

					if (rsFA.getInt(2)==1) {
						double qteMinimum = rsFA.getDouble(3);
						double multiple = rsFA.getDouble(4);

						qteReassort = (qteReassort>=qteMinimum)?qteReassort:qteMinimum;
						if (multiple!=0) {
							//prend la valeur entire suprieure de  qte_Minimum/multiple et la multiplie par le multiple
							//marche pour qte_Minimum>=multiple et qte_Minimum<=multiple
							qteReassort=Math.ceil(qteReassort/multiple)*multiple; 
						}
					}

					psNewAPC.setDouble(2, qteReassort);
					qteReassort =  Math.ceil(qteReassort/pack);

					psNewAPC.executeUpdate();

					ResultSet rsAPC = psNewAPC.getGeneratedKeys();
					rsAPC.next();
					lignePrepId = rsAPC.getInt(1);
					rsAPC.close();				

					psNewLAP.setInt(1, lignePrepId);
					psNewLAP.setString(2, rsFA.getString("Fournisseur_Id"));
					psNewLAP.setDouble(3, qteReassort);
					psNewLAP.executeUpdate();

					psNewLAP.setDouble(3, 0);

					while (rsFA.next()) {
						psNewLAP.setString(2, rsFA.getString("Fournisseur_Id"));
						psNewLAP.executeUpdate();
					}				
				}		
			}
			else {
				psFA.setString(1, articleId);
				ResultSet rsFA = psFA.executeQuery();
				double pack = 1;

				if (rsFA.next()) {
					pack = rsFA.getDouble(5);
					if (rsFA.getInt(2)==1) {
						double qteMinimum = rsFA.getDouble(3);
						double multiple = rsFA.getDouble(4);
						qteReassort = (qteReassort>=qteMinimum)?qteReassort:qteMinimum;
						if (multiple!=0) {
							//prend la valeur entire suprieure de  qte_Minimum/multiple et la multiplie par le multiple
							//marche pour qte_Minimum>=multiple et qte_Minimum<=multiple
							qteReassort=Math.ceil(qteReassort/multiple)*multiple; 
						}
					}
				}
				psMajQT.setDouble(1, qteReassort);

				psMajQT.setString(2, articleId);
				psMajQT.executeUpdate();

				double qteTheorique = rset.getDouble(4);			
				double difference = qteReassort - qteTheorique;
				difference =  Math.ceil(difference/pack);

				psMajQP.setInt(3, lignePrepId);

				if (difference>0) {
					psMaxQteLAP.setInt(1, lignePrepId);		
					ResultSet rsMQ = psMaxQteLAP.executeQuery();

					if (rsMQ.next()) {
						psMajQP.setDouble(1, difference);
						psMajQP.setString(2, rsMQ.getString("Fournisseur_Id"));				
						psMajQP.executeUpdate();
					}
				}
				else if (difference<0) {
					psLAP.setInt(1, lignePrepId);
					ResultSet rsLAP = psLAP.executeQuery();

					while (rsLAP.next()) {

						double quantite = rsLAP.getDouble("Quantite");
						double qteMoins = -(quantite>=difference?difference:quantite);

						psMajQP.setDouble(1, qteMoins);
						psMajQP.setString(2, rsLAP.getString("Fournisseur_Id"));				
						psMajQP.executeUpdate();
					}
				}
			}
		}


		return true;
	}


} // fin CalculPrepCommande

