/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.facturation.actions.clients;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.Arrondi;


public class MajTarifsSpe extends Action {


	public boolean serverSide() { return true; }

	public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		Connection con = s.getConnection(null);

		Arrondi arrondi_2 = new Arrondi(2);
		Arrondi arrondi_4 = new Arrondi(4);
		Arrondi arrondi_5 = new Arrondi(5);

		// rcupration des paramtres
		int type = Integer.parseInt(r.getParameter("Type"));
		String pTarifHT = r.getParameter("Prix_HT");
		String pTarifTTC = r.getParameter("Prix_TTC");
		String pCoeff = r.getParameter("Coeff");
		String pMarge = r.getParameter("Marge");

		double tarifHT = pTarifHT==null?0:Double.parseDouble(pTarifHT);
		double tarifTTC = pTarifTTC==null?0:Double.parseDouble(pTarifTTC);
		double coeff = pCoeff==null?0:Double.parseDouble(pCoeff);
		double marge = pMarge==null?0:Double.parseDouble(pMarge);

		tarifHT = arrondi_4.round(tarifHT);
		tarifTTC = arrondi_4.round(tarifTTC);
		coeff = arrondi_5.round(coeff);
		marge = arrondi_2.round(marge);

		String listeArtConcat = r.getParameter("Liste_Articles_Select");
		String articleId = r.getParameter("Article_Id");
		String clientId = r.getParameter("Client_Id");
		String base = s.getCookie().get("BaseDossier");

		//Variables permettant de vrifier s'il y a eu insertion ou modification
		boolean modif = false;
		boolean ins = false;


		// requte qui vrifie si un tarif specifique existe pour un article
		String requeteChercheExiste = "select Prix from "+ base +".CLIENT_ARTICLE where Article_Id=? and Client_Id=?";
		PreparedStatement psRCE = con.prepareStatement(requeteChercheExiste);

		// requte qui insert un tarif specifique dans la base
		String inserTarifSpe = "insert into "+ base +".CLIENT_ARTICLE (Client_Id, Article_Id, Prix, Coeff, Prix_TTC, Marge) values (?,?,?,?,?,?)";
		PreparedStatement psITS = con.prepareStatement(inserTarifSpe);

		// requte qui met  jour un tarif specifique
		String majTarifSpe = "update "+ base +".CLIENT_ARTICLE set Prix=?, Coeff=?, Prix_TTC=?, Marge=? where Article_Id=? and Client_Id=?";
		PreparedStatement psMTS = con.prepareStatement(majTarifSpe);
		
		if (type == 1) {

			psRCE.setString(1, articleId);
			psRCE.setString(2, clientId);
			ResultSet rsRCE = psRCE.executeQuery();

			if (rsRCE.next()) {
				psMTS.setDouble(1, tarifHT);
				psMTS.setDouble(2, coeff);
				psMTS.setDouble(3, tarifTTC);
				psMTS.setDouble(4, marge);
				psMTS.setString(5, articleId);
				psMTS.setString(6, clientId);
				psMTS.executeUpdate();
			}
			else {
				psITS.setString(1, clientId);
				psITS.setString(2, articleId);
				psITS.setDouble(3, tarifHT);
				psITS.setDouble(4, coeff);
				psITS.setDouble(5, tarifTTC);
				psITS.setDouble(6, marge);
				psITS.executeUpdate();
			}
			rsRCE.close();
		}
		else {

			String listeArticlesSelect[] = listeArtConcat.split(",");

			// requte qui rcupre le code_tarif du client
			String requeteCodeTarif = "select Code_Tarif from "+ base +".FICHE_CLIENT where Client_Id=?";

			PreparedStatement psRCT = con.prepareStatement(requeteCodeTarif);
			psRCT.setString(1, clientId);
			
			ResultSet rsRCT = psRCT.executeQuery();
			rsRCT.next();
			int numTarif = rsRCT.getInt("Code_Tarif");
			psRCT.close();

			// requte qui rcupre le prix HT non spec d'un tarif
			String requeteTarifArticle = "select Tarif_"+ numTarif +" as Tarif, t.Taux_TVA, Prix_Achat from "+ base +".TAUX_TVA t,";
			requeteTarifArticle += base +".FICHE_ARTICLE fa where fa.Code_TVA=t.Code_TVA and fa.Article_Id=?";
			PreparedStatement psRTA = con.prepareStatement(requeteTarifArticle);


			for (int i=0; i<listeArticlesSelect.length; i++) {

				psRTA.setString(1, listeArticlesSelect[i]);
				ResultSet rsRTA = psRTA.executeQuery();
				rsRTA.next();
				double ancTarif = rsRTA.getDouble("Tarif");
				double prixAchat = rsRTA.getDouble("Prix_Achat");
				double tTVA = arrondi_2.round((rsRTA.getDouble("Taux_TVA")/100)+1);

				if (pTarifHT!=null) {
					double pourcPV = (tarifHT >= ancTarif ? (tarifHT / ancTarif -1) * 100 : (ancTarif / tarifHT -1) * (-100));
					tarifTTC = arrondi_4.round(tarifHT*tTVA);
					coeff = arrondi_5.round(pourcPV>=0?1+pourcPV/100:1-Math.abs(pourcPV)/100);
					marge = arrondi_2.round(tarifHT==0?100:(tarifHT-prixAchat)/tarifHT*100);
				}
				else if (pTarifTTC!=null) {
					tarifHT = arrondi_4.round(tarifTTC / tTVA);
					double pourcPV = (tarifHT >= ancTarif ? (tarifHT / ancTarif -1) * 100 : (ancTarif / tarifHT -1) * (-100));
					coeff = arrondi_5.round(pourcPV>=0?1+pourcPV/100:1-Math.abs(pourcPV)/100);
					marge = arrondi_2.round(tarifHT==0?100:(tarifHT-prixAchat)/tarifHT*100);
				}
				else if (pCoeff!=null) {
					tarifHT = arrondi_4.round(coeff * ancTarif);
					tarifTTC = arrondi_4.round(tarifHT*tTVA);
					marge = arrondi_2.round(tarifHT==0?100:(tarifHT-prixAchat)/tarifHT*100);
				}
				else if (pMarge!=null) {
					tarifHT=prixAchat/(1-marge/100);
					double pourcPV = (tarifHT >= ancTarif ? (tarifHT / ancTarif -1) * 100 : (ancTarif / tarifHT -1) * (-100));
					tarifTTC = arrondi_4.round(tarifHT*tTVA);
					coeff = arrondi_5.round(pourcPV>=0?1+pourcPV/100:1-Math.abs(pourcPV)/100);
				}

				psRCE.setString(1, listeArticlesSelect[i]);
				psRCE.setString(2, clientId);
				ResultSet rsRCE = psRCE.executeQuery();

				if (rsRCE.next()) {
					psMTS.setDouble(1, tarifHT);
					psMTS.setDouble(2, coeff);
					psMTS.setDouble(3, tarifTTC);
					psMTS.setDouble(4, marge);
					psMTS.setString(5, listeArticlesSelect[i]);
					psMTS.setString(6, clientId);
					psMTS.addBatch();
					modif = true;
				}
				else {
					psITS.setString(1, clientId);
					psITS.setString(2, listeArticlesSelect[i]);
					psITS.setDouble(3, tarifHT);
					psITS.setDouble(4, coeff);
					psITS.setDouble(5, tarifTTC);
					psITS.setDouble(6, marge);
					psITS.addBatch();
					ins = true;
				}
				rsRCE.close();
			}

			if (modif) { psMTS.executeBatch(); }
			if (ins) { psITS.executeBatch(); }
		}
		
		psRCE.close();
		psITS.close();
		psMTS.close();

		s.closeConnection(con, null);
		return true;
	}

} // fin MajTarifsSpe

