/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition de la liste des commandes clients
 */

package org.opensi.facturation.actions.affaires;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.bo.commandeclient.BOCommandeClient;
import org.opensi.facturation.CalculStock;
import org.opensi.util.tools.DateTime;


public class DataListeCommandes {

	
	// les lignes de la liste des commandes
	protected ArrayList<LigneListeCommandes> lignes = new ArrayList<LigneListeCommandes>(100);
	
	boolean existeSites;
	boolean calculStock;

	public DataListeCommandes(Session s, String numCommande, String loginWeb, String nomClient, String refArticle, String numFacture, String numAcompte, String numBL, String numRetour, String etatCommande, String etatLogistique, String commandeBloquee, String dateCommandeDebut, String dateCommandeFin, String dateDelaiDebut, String dateDelaiFin, String numClient, String montantTTC, String etatPaiement, String modeReglement, String provenance, String modeExpedition, String secteurActivite, boolean calculStock) {
		try {
			
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String base = s.getCookie().get("BaseDossier");
			BOCommandeClient boCommande = new BOCommandeClient(con, base);
			
			String reqExisteSites = "select count(*) as Nb_Sites from "+ base +".SITE_WEB where Status='a'";
			ResultSet rset = stt.executeQuery(reqExisteSites);
			rset.next();
			this.existeSites = (rset.getInt("Nb_Sites")!=0);
			rset.close();
			
			this.calculStock = calculStock;
			CalculStock calcul = null;
			if (calculStock) {
				String reqDisponibilite = "select Type_Calcul_Stock from "+ base +".PARAM_DOSSIER";
				PreparedStatement psDisponibilite = con.prepareStatement(reqDisponibilite);
				rset = psDisponibilite.executeQuery();
				rset.next();
				int disponibilite = rset.getInt("Type_Calcul_Stock");
				rset.close();
				psDisponibilite.close();
			
				calcul = new CalculStock(s, disponibilite);
			}

			String getCommandes = "select cc.Commande_Id, cc.Ref_Commande, cc.Numero, coalesce(cw.Client_Site_Id,'') as Login_Web, cc.Denomination, cc.Etat, cc.Statut_Logistique,";
			getCommandes += " if(cc.Date_Commande=0,cc.Date_C,cc.Date_Commande) as Date_Commande, cc.Delai, coalesce(cc.Client_Id,'') as Num_Client, cc.Commentaires_Int,";
			getCommandes += " cc.Total_HT, cc.Total_TTC, cc.Statut_Paiement, coalesce(mr.Libelle,'') as Mode_Reglement, coalesce(sw.Nom_Site,'Hors ligne') as Provenance,";
			getCommandes += " coalesce(ml.Nom, '') as Mode_Expedition, cc.Soldee";
			getCommandes += " from "+ base +".COMMANDE_CLIENT cc";
			
			if (!numAcompte.equals("")) {
				getCommandes += " join "+ base +".ACOMPTE_CLIENT ac on cc.Commande_Id=ac.Commande_Id and ac.Numero like ?";
			}
			
			if (!refArticle.equals("")) {
				getCommandes += " join "+ base +".LIGNE_COMMANDE_CLIENT lcc on cc.Commande_Id=lcc.Commande_Id and lcc.Statut='V' and lcc.Reference like ?";
			}
			
			if (!numBL.equals("")) {
				getCommandes += " join "+ base +".BON_LIVRAISON bl on cc.Commande_Id=bl.Commande_Id and bl.Num_Entier like ?";
			}
			
			if (!numRetour.equals("")) {
				if (numBL.equals("")) {
					getCommandes += " join "+ base +".BON_LIVRAISON bl on cc.Commande_Id=bl.Commande_Id";
				}
				getCommandes += " join "+ base +".BON_RETOUR_CLIENT brc on bl.Bon_Id=brc.BL_Id and brc.Numero like ?";
			}
			
			if (!numFacture.equals("")) {
				getCommandes += " join "+ base +".COMMANDE_CLIENT_FACTURE ccf on cc.Commande_Id=ccf.Commande_Id";
				getCommandes += " join "+ base +".FACTURE f on ccf.Facture_Id=f.Facture_Id and f.Num_Entier like ?";
			}
			getCommandes += " left join "+ base +".MODE_REGLEMENT mr on mr.Mode_Reg_Id=cc.Mode_Reg_Id";
			getCommandes += " left join "+ base +".MODE_LIVRAISON ml on cc.Mode_Expedition=ml.Mode_Liv_Id";
			getCommandes += " left join "+ base +".COMMANDE_CLIENT_WEB ccw on cc.Commande_Id=ccw.Commande_Id";
			getCommandes += " left join "+ base +".CLIENT_WEB cw on cw.Client_Web_Id=ccw.Client_Web_Id";
			getCommandes += " left join "+ base +".SITE_WEB sw on sw.Site_Id=ccw.Site_Web_Id";
			getCommandes += " where 1";
			
			// L'ordre des conditions est IMPORTANT car c'est le mme ordre qui servira
			// pour l'affectation des valeurs aux paramtres
			if (!numCommande.equals("")) { getCommandes += " and (cc.Ref_Commande like ? or cc.Numero like ?)"; }
			if (!loginWeb.equals("")) { getCommandes += " and cw.Client_Site_Id like ?"; }
			if (!nomClient.equals("")) { getCommandes += " and cc.Denomination like ?"; }
			if (!etatCommande.equals("TS")) {
				getCommandes += " and cc.Etat=?";
				if (etatCommande.equals("T") && !etatLogistique.equals("TS")) {
					if (etatLogistique.equals("C") || etatLogistique.equals("R")) { getCommandes += " and cc.Statut_Logistique='T'"; }
					else { getCommandes += " and cc.Statut_Logistique=?"; }
				}
			}
			if (!commandeBloquee.equals("T")) { getCommandes += " and cc.Bloque=?"; }
			if (!dateCommandeDebut.equals("")) { getCommandes += " and if(cc.Date_Commande=0,cc.Date_C,cc.Date_Commande)>=?"; }
			if (!dateCommandeFin.equals("")) { getCommandes += " and if(cc.Date_Commande=0,cc.Date_C,cc.Date_Commande)<=?"; }
			if (!dateDelaiDebut.equals("")) { getCommandes += " and cc.Delai>=?"; }
			if (!dateDelaiFin.equals("")) { getCommandes += " and cc.Delai<=?"; }
			if (!numClient.equals("")) { getCommandes += " and cc.Client_Id like ?"; }
			if (!montantTTC.equals("")) { getCommandes += " and cc.Total_TTC like ?"; }
			if (!etatPaiement.equals("T")) { getCommandes += " and cc.Statut_Paiement=?"; }
			if (!modeReglement.equals("T")) { getCommandes += " and cc.Mode_Reg_Id=?"; }
			if (!provenance.equals("T")) {
				if (provenance.equals("0")) { getCommandes += " and ccw.Site_Web_Id is null"; }
				else { getCommandes += " and ccw.Site_Web_Id=?"; }
			}
			if (!modeExpedition.equals("T")) { getCommandes += " and cc.Mode_Expedition=?"; }
			if (!secteurActivite.equals("T")) { getCommandes += " and cc.Secteur_Activite=?"; }
			
			getCommandes += " group by cc.Commande_Id";
			getCommandes += " order by if(cc.Date_Commande=0,cc.Date_C,cc.Date_Commande) desc";
			
			PreparedStatement psCommandes = con.prepareStatement(getCommandes);
			int posParam = 0;

			if (!numAcompte.equals("")) {
				posParam++;
				psCommandes.setString(posParam, numAcompte+"%");
			}
			if (!refArticle.equals("")) {
				posParam++;
				psCommandes.setString(posParam, "%"+refArticle+"%");
			}
			if (!numBL.equals("")) {
				posParam++;
				psCommandes.setString(posParam, numBL+"%");
			}
			if (!numRetour.equals("")) {
				posParam++;
				psCommandes.setString(posParam, numRetour+"%");
			}
			if (!numFacture.equals("")) {
				posParam++;
				psCommandes.setString(posParam, numFacture+"%");
			}
			if (!numCommande.equals("")) {
				posParam++;
				psCommandes.setString(posParam, "%"+numCommande+"%");
				posParam++;
				psCommandes.setString(posParam, "%"+numCommande+"%");
			}
			if (!loginWeb.equals("")) {
				posParam++;
				psCommandes.setString(posParam, "%"+loginWeb+"%");
			}
			if (!nomClient.equals("")) {
				posParam++;
				psCommandes.setString(posParam, "%"+nomClient+"%");
			}
			if (!etatCommande.equals("TS")) {
				posParam++;
				psCommandes.setString(posParam, etatCommande);
				if (etatCommande.equals("T") && !etatLogistique.equals("TS") && !etatLogistique.equals("C") && !etatLogistique.equals("R")) {
					posParam++;
					psCommandes.setString(posParam, etatLogistique);
				}
			}
			if (!commandeBloquee.equals("T")) {
				posParam++;
				psCommandes.setInt(posParam, Integer.parseInt(commandeBloquee));
			}
			if (!dateCommandeDebut.equals("")) {
				posParam++;
				DateTime dt = new DateTime(DateTime.parseDate(dateCommandeDebut, "yyyy:MM:dd"));
				psCommandes.setLong(posParam, dt.getDateInMillis());
			}
			if (!dateCommandeFin.equals("")) {
				posParam++;
				DateTime dt = new DateTime(DateTime.parseDate(dateCommandeFin, "yyyy:MM:dd"));
				psCommandes.setLong(posParam, dt.getDateFullTime());
			}
			if (!dateDelaiDebut.equals("")) {
				posParam++;
				DateTime dt = new DateTime(DateTime.parseDate(dateDelaiDebut, "yyyy:MM:dd"));
				psCommandes.setLong(posParam, dt.getDateInMillis());
			}
			if (!dateDelaiFin.equals("")) {
				posParam++;
				DateTime dt = new DateTime(DateTime.parseDate(dateDelaiFin, "yyyy:MM:dd"));
				psCommandes.setLong(posParam, dt.getDateFullTime());
			}
			if (!numClient.equals("")) {
				posParam++;
				psCommandes.setString(posParam, "%"+numClient+"%");
			}
			if (!montantTTC.equals("")) {
				posParam++;
				psCommandes.setString(posParam, montantTTC+"%");
			}
			if (!etatPaiement.equals("T")) {
				posParam++;
				psCommandes.setInt(posParam, Integer.parseInt(etatPaiement));
			}
			if (!modeReglement.equals("T")) {
				posParam++;
				psCommandes.setInt(posParam, Integer.parseInt(modeReglement));
			}
			if (!provenance.equals("T") && !provenance.equals("0")) {
				posParam++;
				psCommandes.setInt(posParam, Integer.parseInt(provenance));
			}
			if (!modeExpedition.equals("T")) {
				posParam++;
				psCommandes.setInt(posParam, Integer.parseInt(modeExpedition));
			}
			if (!secteurActivite.equals("T")) {
				posParam++;
				psCommandes.setInt(posParam, Integer.parseInt(secteurActivite));
			}
			
			String getDateDernierBL = "select coalesce(max(Date_C),0) as Date_Dernier_BL from "+ base +".BON_LIVRAISON where Commande_Id=?";
			PreparedStatement psDateDernierBL = con.prepareStatement(getDateDernierBL);

			String getCALivre = "select coalesce(sum(CA_Livre),0) as CA_Livre from (";
			getCALivre += " select bl.Bon_Id, (bl.Total_HT-coalesce(sum(brc.Total_HT),0)) as CA_Livre";
			getCALivre += " from "+ base +".BON_LIVRAISON bl left join "+ base +".BON_RETOUR_CLIENT brc on bl.Bon_Id=brc.BL_Id and brc.Etat='V'";
			getCALivre += " where bl.Etat='V' and bl.Commande_Id=? group by bl.Bon_Id) as t";
			PreparedStatement psCALivre = con.prepareStatement(getCALivre);
			
			String getCARestant = "select lcc.Ligne_Id, if(cc.Edition_TTC=0,lcc.Prix_Unitaire,lcc.Prix_Unitaire/(1+lcc.Taux_TVA/100)) * (1-lcc.Ristourne/100) * (1-cc.Remise/100) as Montant";
			getCARestant += " from "+ base +".LIGNE_COMMANDE_CLIENT lcc join "+ base +".COMMANDE_CLIENT cc on lcc.Commande_Id=cc.Commande_Id and lcc.Statut='V'";
			getCARestant += " where cc.Commande_Id=?";
			PreparedStatement psCARestant = con.prepareStatement(getCARestant);
			
			//String getBLs = "select bl.Bon_Id, bl.Nb_Colis from "+ base +".BON_LIVRAISON bl";
			String getBLs = "select count(*) as Nb from "+ base +".BON_LIVRAISON bl";
			getBLs += " where bl.Commande_Id=? and bl.Etat='V'";
			PreparedStatement psBLs = con.prepareStatement(getBLs);
			
			/*String getColis = "select c.* from "+ base +".COLIS c";
			getColis += " where c.Bon_Id=? and c.Numero!=NULL";
			PreparedStatement psColis = con.prepareStatement(getColis);*/
			
			String getCommandeFacturee = "select cc.Facturee, t.NbFactures from "+ base +".COMMANDE_CLIENT cc,";
			getCommandeFacturee += " (select count(*) as NbFactures from "+ base +".COMMANDE_CLIENT_FACTURE ccf, "+ base +".FACTURE f";
			getCommandeFacturee += " where ccf.Facture_Id=f.Facture_Id and f.Numero>0 and ccf.Commande_Id=?) as t";
			getCommandeFacturee += " where Commande_Id=?";
			PreparedStatement psCommandeFacturee = con.prepareStatement(getCommandeFacturee);
			
			rset = psCommandes.executeQuery();
			while (rset.next()) {
				
				String etatStock = "";
				String stockXY = "";
				double caLivre = 0;
				double caRestant = 0;
				
				if (calculStock) {
				
					double nbArticlesLivrables = calcul.stock(rset.getInt("Commande_Id"));
					double nbArticlesRestantTotal = calcul.total(rset.getInt("Commande_Id"));

					if (rset.getString("Etat").equals("T")) {
						stockXY = nbArticlesLivrables + "/" + nbArticlesRestantTotal;
						etatStock = (nbArticlesLivrables == nbArticlesRestantTotal?"C":"R");
					}
				}
				
				if (!etatCommande.equals("T") || etatLogistique.equals("TS") || etatLogistique.equals("E") || etatLogistique.equals("T") || etatLogistique.equals(etatStock)) {
				
					psDateDernierBL.setInt(1, rset.getInt("Commande_Id"));
					ResultSet rset2 = psDateDernierBL.executeQuery();
					rset2.next();
					long dateDernierBL = rset2.getLong("Date_Dernier_BL");
					rset2.close();

					psCALivre.setInt(1, rset.getInt("Commande_Id"));
					rset2 = psCALivre.executeQuery();
					rset2.next();
					caLivre = rset2.getDouble("CA_Livre");
					if (caLivre<0) { caLivre=0; }
					rset2.close();
					
					if (!rset.getString("Etat").equals("A") && rset.getInt("Soldee")==0) {
						psCARestant.setInt(1, rset.getInt("Commande_Id"));
						rset2 = psCARestant.executeQuery();
						while (rset2.next()) {
							double qteRestante = boCommande.getLigneQuantiteRestantLivree(rset2.getInt("Ligne_Id"));
							if (qteRestante>0) {
								caRestant += (qteRestante * rset2.getDouble("Montant"));
							}
						}
						rset2.close();
					}

					String etat = "";
					if (rset.getString("Etat").equals("N")) { etat = "Non valide"; }
					else if (rset.getString("Etat").equals("A")) { etat = "Annule"; }
					else if (rset.getString("Etat").equals("C")) { etat = "Clture"; }
					else if (rset.getString("Etat").equals("Z")) { etat = "Non aboutie"; }
					else if (rset.getString("Etat").equals("T")) { etat = "En cours"; }
					
					
					
					int nbBL = 0;
					psBLs.setInt(1, rset.getInt("Commande_Id"));
					rset2 = psBLs.executeQuery();
					rset2.next();
					nbBL = rset2.getInt("Nb");
					rset2.close();
					// code ci-dessous remplac par celui ci-dessus
					/*int nbBLExpedie = 0;
					psBLs.setInt(1, rset.getInt("Commande_Id"));
					rset2 = psBLs.executeQuery();
					while (rset2.next()) {
						nbBL++;
						if (rset2.getInt("Nb_Colis")>0) { nbBLExpedie++; }
						else {
							psColis.setInt(1, rset2.getInt("Bon_Id"));
							ResultSet rset3 = psColis.executeQuery();
							if (rset3.next()) {
								nbBLExpedie++;
							}
							rset3.close();
						}
					}
					rset2.close();*/
					
					String statutLogistique = "";
					if (rset.getString("Etat").equals("T") || rset.getString("Etat").equals("C")) {
						if (rset.getString("Statut_Logistique").equals("E")) { statutLogistique = "Expdie"; }
						else if (rset.getString("Statut_Logistique").equals("T")) {
							if (etatStock.equals("R")) { statutLogistique = "Rassort"; }
							else if (etatStock.equals("C")) { statutLogistique = "A expdier"; }
							if (nbBL>0) { statutLogistique += " (*)"; }
						}
					}
					
					// code non utilis, ncessite de dcommenter le code plus haut pour fonctionner
					/*String statutEnvoi = "";
					if (nbBLExpedie==0) { statutEnvoi = "Non expdie"; }
					else if (nbBLExpedie!=nbBL || rset.getInt("Soldee")!=1) { statutEnvoi = "Part. expdie"; }
					else { statutEnvoi = "Expdie"; }
					*/
					
					String statutPaiement = "";
					switch (rset.getInt("Statut_Paiement")) {
						case 0:
							statutPaiement = "Non paye";
						break;
						case 1:
							statutPaiement = "Paye";
						break;
						case 2:
							statutPaiement = "Part. paye";
						break;
					}
					
					String statutFacturation = "Non facture";
					psCommandeFacturee.setInt(1, rset.getInt("Commande_Id"));
					psCommandeFacturee.setInt(2, rset.getInt("Commande_Id"));
					rset2 = psCommandeFacturee.executeQuery();
					rset2.next();
					if (rset2.getInt("Facturee")==1) {
						statutFacturation = "Facture";
					} else if (rset2.getInt("NbFactures")==0) {
						statutFacturation = "Non facture";
					} else {
						statutFacturation = "Part. facture";
					}
					rset2.close();
					
					LigneListeCommandes llc = new LigneListeCommandes();
					llc.setNumCommande(rset.getString("Numero"));
					llc.setRefCommande(rset.getString("Ref_Commande"));
					llc.setLoginWeb(rset.getString("Login_Web"));
					llc.setNomClient(rset.getString("Denomination"));
					llc.setEtatCommande(etat);
					llc.setEtatLogistique(statutLogistique);
					llc.setDateCommande(rset.getLong("Date_Commande"));
					llc.setDateDelai(rset.getLong("Delai"));
					llc.setNumClient(rset.getString("Num_Client"));
					llc.setMontantHT(rset.getDouble("Total_HT"));
					llc.setMontantTTC(rset.getDouble("Total_TTC"));
					llc.setModeReglement(rset.getString("Mode_Reglement"));
					llc.setProvenance(rset.getString("Provenance"));
					llc.setModeExpedition(rset.getString("Mode_Expedition"));
					llc.setDateDernierBL(dateDernierBL);
					llc.setCALivre(caLivre);
					llc.setCARestant(caRestant);
					llc.setStockXY(stockXY);
					llc.setCommentairesInternes(rset.getString("Commentaires_Int"));
					llc.setStatutPaiement(statutPaiement);
					llc.setStatutFacturation(statutFacturation);
					this.lignes.add(llc);
				}
			}
			rset.close();
			
			psCommandeFacturee.close();
			//psColis.close();
			psBLs.close();
			psCALivre.close();
			psCARestant.close();
			psDateDernierBL.close();
			psCommandes.close();
			stt.close();
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}			
	}
	
	
	public int getNbLignes() {
		return lignes.size();
	}



} // fin DataListeCommandes
