/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition de la liste des affaires
 */

package org.opensi.facturation.actions.affaires;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.bo.commandeclient.BOCommandeClient;
import org.opensi.util.tools.DateTime;


public class DataListeAffaires {

	
	// les lignes de la liste des affaires
	protected ArrayList<LigneListeAffaires> lignes = new ArrayList<LigneListeAffaires>(100);


	public DataListeAffaires(Session s, String numCommande, String intituleAffaire, String loginWeb, String nomClient, String refArticle, String numFacture, String numAcompte, String numBL, String numRetour, String numAffaire, String etatAffaire, String dateCommandeDebut, String dateCommandeFin, String dateDelaiDebut, String dateDelaiFin, String numClient) {
		try {
			
			Connection con = s.getConnection(null);
			
			String base = s.getCookie().get("BaseDossier");
			BOCommandeClient boCommande = new BOCommandeClient(con, base);
			
			String getAffaires = "select a.Affaire_Id, a.Intitule, a.Denomination as Nom_Client, a.Num_Entier, a.Etat,";
			getAffaires += " a.Date_C, coalesce(a.Client_Id,'') as Num_Client";
			getAffaires += " from "+ base +".AFFAIRE a";
			getAffaires += " left join "+ base +".COMMANDE_CLIENT cc on a.Affaire_Id=cc.Affaire_Id";
			
			if (!numAcompte.equals("")) {
				getAffaires += " join "+ base +".ACOMPTE_CLIENT ac on cc.Commande_Id=ac.Commande_Id";
				getAffaires += " and ac.Numero like ?";
			}
			
			if (!loginWeb.equals("")) {
				getAffaires += " join "+ base +".COMMANDE_CLIENT_WEB ccw on cc.Commande_Id=ccw.Commande_Id";
				getAffaires += " join "+ base +".CLIENT_WEB cw on cw.Client_Web_Id=ccw.Client_Web_Id";
				getAffaires += " and cw.Client_Site_Id like ?";
			}
			
			if (!refArticle.equals("")) {
				getAffaires += " join "+ base +".LIGNE_COMMANDE_CLIENT lcc on cc.Commande_Id=lcc.Commande_Id";
				getAffaires += "  and lcc.Statut='V' and lcc.Reference like ?";
			}
			
			if (!numBL.equals("")) {
				getAffaires += " join "+ base +".BON_LIVRAISON bl on cc.Commande_Id=bl.Commande_Id";
				getAffaires += " and bl.Num_Entier like ?";
			}
			
			if (!numRetour.equals("")) {
				if (numBL.equals("")) {
					getAffaires += " join "+ base +".BON_LIVRAISON bl on cc.Commande_Id=bl.Commande_Id";
				}
				getAffaires += " join "+ base +".BON_RETOUR_CLIENT brc on bl.Bon_Id=brc.BL_Id";
				getAffaires += " and brc.Numero like ?";
			}
			
			if (!numFacture.equals("")) {
				getAffaires += " join "+ base +".AFFAIRE_FACTURE af on a.Affaire_Id=af.Affaire_Id";
				getAffaires += " join "+ base +".FACTURE f on af.Facture_Id=f.Facture_Id";
				getAffaires += " and f.Num_Entier like ?";
			}

			getAffaires += " where 1";
			
			// L'ordre des conditions est IMPORTANT car c'est le mme ordre qui servira
			// pour l'affectation des valeurs aux paramtres
			if (!numCommande.equals("")) { getAffaires += " and (cc.Ref_Commande like ? or cc.Numero like ?)"; }
			if (!intituleAffaire.equals("")) { getAffaires += " and a.Intitule like ?"; }
			if (!nomClient.equals("")) { getAffaires += " and a.Denomination like ?"; }
			if (!numAffaire.equals("")) { getAffaires += " and a.Num_Entier like ?"; }
			if (!etatAffaire.equals("TS")) {
				getAffaires += " and a.Etat=?";
				if (etatAffaire.equals("T")) {
					getAffaires += " and cc.Etat='T'";
				}
			}
			if (!dateCommandeDebut.equals("")) { getAffaires += " and if(cc.Date_Commande=0,cc.Date_C,cc.Date_Commande)>=?"; }
			if (!dateCommandeFin.equals("")) { getAffaires += " and if(cc.Date_Commande=0,cc.Date_C,cc.Date_Commande)<=?"; }
			if (!dateDelaiDebut.equals("")) { getAffaires += " and cc.Delai>=?"; }
			if (!dateDelaiFin.equals("")) { getAffaires += " and cc.Delai<=?"; }
			if (!numClient.equals("")) { getAffaires += " and cc.Client_Id like ?"; }

			getAffaires += " group by Affaire_Id";
			getAffaires += " order by Date_C desc";
			
			PreparedStatement psAffaires = con.prepareStatement(getAffaires);
			int posParam = 0;

			if (!numAcompte.equals("")) {
				posParam++;
				psAffaires.setString(posParam, numAcompte+"%");
			}
			if (!loginWeb.equals("")) {
				posParam++;
				psAffaires.setString(posParam, "%"+loginWeb+"%");
			}
			if (!refArticle.equals("")) {
				posParam++;
				psAffaires.setString(posParam, "%"+refArticle+"%");
			}
			if (!numBL.equals("")) {
				posParam++;
				psAffaires.setString(posParam, numBL+"%");
			}
			if (!numRetour.equals("")) {
				posParam++;
				psAffaires.setString(posParam, numRetour+"%");
			}
			if (!numFacture.equals("")) {
				posParam++;
				psAffaires.setString(posParam, numFacture+"%");
			}
			if (!numCommande.equals("")) {
				posParam++;
				psAffaires.setString(posParam, "%"+numCommande+"%");
				posParam++;
				psAffaires.setString(posParam, "%"+numCommande+"%");
			}
			if (!intituleAffaire.equals("")) {
				posParam++;
				psAffaires.setString(posParam, "%"+intituleAffaire+"%");
			}
			if (!nomClient.equals("")) {
				posParam++;
				psAffaires.setString(posParam, "%"+nomClient+"%");
			}
			if (!numAffaire.equals("")) {
				posParam++;
				psAffaires.setString(posParam, numAffaire+"%");
			}
			if (!etatAffaire.equals("TS")) {
				posParam++;
				psAffaires.setString(posParam, etatAffaire);
			}
			if (!dateCommandeDebut.equals("")) {
				posParam++;
				DateTime dt = new DateTime(DateTime.parseDate(dateCommandeDebut, "yyyy:MM:dd"));
				psAffaires.setLong(posParam, dt.getDateInMillis());
			}
			if (!dateCommandeFin.equals("")) {
				posParam++;
				DateTime dt = new DateTime(DateTime.parseDate(dateCommandeFin, "yyyy:MM:dd"));
				psAffaires.setLong(posParam, dt.getDateFullTime());
			}
			if (!dateDelaiDebut.equals("")) {
				posParam++;
				DateTime dt = new DateTime(DateTime.parseDate(dateDelaiDebut, "yyyy:MM:dd"));
				psAffaires.setLong(posParam, dt.getDateInMillis());
			}
			if (!dateDelaiFin.equals("")) {
				posParam++;
				DateTime dt = new DateTime(DateTime.parseDate(dateDelaiFin, "yyyy:MM:dd"));
				psAffaires.setLong(posParam, dt.getDateFullTime());
			}
			if (!numClient.equals("")) {
				posParam++;
				psAffaires.setString(posParam, "%"+numClient+"%");
			}
			
			String getTotalHT = "select coalesce(sum(Total_HT),0) as Total_HT from "+ base +".COMMANDE_CLIENT where Affaire_Id=?";
			PreparedStatement psTotalHT = con.prepareStatement(getTotalHT);
			
			String getDateDernierBL = "select coalesce(max(bl.Date_C),0) as Date_Dernier_BL";
			getDateDernierBL += " from "+ base +".BON_LIVRAISON bl, "+ base +".COMMANDE_CLIENT cc";
			getDateDernierBL += " where bl.Commande_Id=cc.Commande_Id and cc.Affaire_Id=?";
			PreparedStatement psDateDernierBL = con.prepareStatement(getDateDernierBL);
			
			String getCALivre = "select coalesce(sum(CA_Livre),0) as CA_Livre from (";
			getCALivre += " select bl.Bon_Id, (bl.Total_HT-coalesce(sum(brc.Total_HT),0)) as CA_Livre";
			getCALivre += " from "+ base +".BON_LIVRAISON bl join "+ base +".COMMANDE_CLIENT cc on bl.Commande_Id=cc.Commande_Id and bl.Etat='V'";
			getCALivre += " left join "+ base +".BON_RETOUR_CLIENT brc on bl.Bon_Id=brc.BL_Id and brc.Etat='V'";
			getCALivre += " where cc.Affaire_Id=? group by bl.Bon_Id) as t";
			PreparedStatement psCALivre = con.prepareStatement(getCALivre);
			
			String getCARestant = "select lcc.Ligne_Id, if(cc.Edition_TTC=0,lcc.Prix_Unitaire,lcc.Prix_Unitaire/(1+lcc.Taux_TVA/100)) * (1-lcc.Ristourne/100) * (1-cc.Remise/100) as Montant";
			getCARestant += " from "+ base +".LIGNE_COMMANDE_CLIENT lcc join "+ base +".COMMANDE_CLIENT cc on lcc.Commande_Id=cc.Commande_Id and lcc.Statut='V' and cc.Etat<>'A' and cc.Soldee=0";
			getCARestant += " where cc.Affaire_Id=?";
			PreparedStatement psCARestant = con.prepareStatement(getCARestant);

			ResultSet rset = psAffaires.executeQuery();
			while (rset.next()) {
				psTotalHT.setInt(1, rset.getInt("Affaire_Id"));
				ResultSet rset2 = psTotalHT.executeQuery();
				rset2.next();
				double montantHT = rset2.getDouble("Total_HT");
				rset2.close();
				
				psDateDernierBL.setInt(1, rset.getInt("Affaire_Id"));
				rset2 = psDateDernierBL.executeQuery();
				rset2.next();
				long dateDernierBL = rset2.getLong("Date_Dernier_BL");
				rset2.close();
				
				psCALivre.setInt(1, rset.getInt("Affaire_Id"));
				rset2 = psCALivre.executeQuery();
				rset2.next();
				double caLivre = rset2.getDouble("CA_Livre");
				if (caLivre<0) { caLivre=0; }
				rset2.close();
				
				double caRestant = 0;
				if (!rset.getString("Etat").equals("A")) {
					psCARestant.setInt(1, rset.getInt("Affaire_Id"));
					rset2 = psCARestant.executeQuery();
					while (rset2.next()) {
						double qteRestante = boCommande.getLigneQuantiteRestantLivree(rset2.getInt("Ligne_Id"));
						if (qteRestante>0) {
							caRestant += (qteRestante * rset2.getDouble("Montant"));
						}
					}
					rset2.close();
				}
				
				String etat = "";
				if (rset.getString("Etat").equals("N")) { etat = "Non valide"; }
				else if (rset.getString("Etat").equals("T")) { etat = "A traiter"; }
				else if (rset.getString("Etat").equals("A")) { etat = "Annule"; }
				else if (rset.getString("Etat").equals("C")) { etat = "Clture"; }
				
				LigneListeAffaires lla = new LigneListeAffaires();
				lla.setIntituleAffaire(rset.getString("Intitule"));
				lla.setNomClient(rset.getString("Nom_Client"));
				lla.setNumAffaire(rset.getString("Num_Entier"));
				lla.setEtatAffaire(etat);
				lla.setDateAffaire(rset.getLong("Date_C"));
				lla.setNumClient(rset.getString("Num_Client"));
				lla.setMontantHT(montantHT);
				lla.setDateDernierBL(dateDernierBL);
				lla.setCALivre(caLivre);
				lla.setCARestant(caRestant);
				this.lignes.add(lla);
			}
			
			rset.close();
			psCARestant.close();
			psCALivre.close();
			psDateDernierBL.close();
			psTotalHT.close();
			psAffaires.close();
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}			
	}
	
	
	public int getNbLignes() {
		return lignes.size();
	}



} // fin DataListeAffaires
