/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.dbm.exercice;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.data.exercice.Operation;
import org.opensi.data.exercice.PeriodeExercice;


public class DBM_PeriodeExercice implements DBM_Object {

	private Connection con;
	private String baseExo;
	

	public DBM_PeriodeExercice(Connection con, String baseExo) {
	
		this.con = con;
		this.baseExo = baseExo;
	}
	
	
	public PeriodeExercice load(int periodeId) throws SQLException {
		
		PeriodeExercice periodeExercice = null;
		
		PreparedStatement psPeriode = con.prepareStatement("select * from "+ baseExo +".PERIODE_EXERCICE where Periode_Id=?");

		psPeriode.setInt(1, periodeId);

		ResultSet rset = psPeriode.executeQuery();

		if (rset.next()) {

			periodeExercice = new PeriodeExercice();
			
			periodeExercice.setPeriode(rset.getLong("Periode"));
			periodeExercice.setCloture(rset.getBoolean("Cloture"));
			periodeExercice.setDateCloture(rset.getLong("Date_Cloture"));
		}
		rset.close();

		return periodeExercice;
	}
		
	
	public void insert(PeriodeExercice periodeExercice) throws SQLException {
		
		PreparedStatement psNewPE = con.prepareStatement("insert into "+ baseExo +".PERIODE_EXERCICE (Periode, Cloture, Date_Cloture) values (?,?,?)");
					
		psNewPE.setLong(1, periodeExercice.getPeriode());
		psNewPE.setBoolean(2, periodeExercice.getCloture());
		psNewPE.setLong(3, periodeExercice.getDateCloture());
		psNewPE.executeUpdate();
		psNewPE.close();
	}
	
	
	public void cloturer(long periode) throws SQLException {
		
		PreparedStatement psClot = con.prepareStatement("update "+ baseExo +".PERIODE_EXERCICE set Cloture=1, Date_Cloture=? where Periode=?");
		psClot.setLong(1, System.currentTimeMillis());
		psClot.setLong(2, periode);
		psClot.executeUpdate();
		psClot.close();
	}
	
	
} // fin DBM_PeriodeExercice
