/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.data.dossier;


public class LigneFactureFournisseur implements org.opensi.api.DataOSI {


	private int ligneId;
	private int refLigne;
	private int rank;
	private String typeLigne;
	private String reference;
	private String refFournisseur;
	private String designation;
	private String numLot;
	private double quantite;
	private String unite;
	private int nbPieces;
	private long datePeremption;
	private double prix;
	private double ristourne;
	private int codeTVA;
	private double tauxTVA;
	private double montantLigne;
	private String commentaireAvant;
	private String commentaireApres;
	private int brId;
	

	public LigneFactureFournisseur(int ligneId,
						int refLigne,
						int rank,
						String typeLigne,
						String reference,
						String refFournisseur,
						String designation,
						String codeStats,
						String numLot,
						String libelle,
						double quantite,
						String unite,
						int nbPieces,
						long datePeremption,
						double prix,
						double ristourne,
						int codeTVA,
						double tauxTVA,
						double commission,
						double montantLigne,
						String commentaireAvant,
						String commentaireApres,
						int brId) {
		
		this.ligneId = ligneId;
		this.refLigne = refLigne;
		this.rank = rank;
		this.typeLigne = typeLigne;
		this.reference = reference;
		this.refFournisseur = refFournisseur;
		this.designation = designation;
		this.numLot = numLot;
		this.quantite = quantite;
		this.unite = unite;
		this.nbPieces = nbPieces;
		this.datePeremption = datePeremption;
		this.prix = prix;
		this.ristourne = ristourne;
		this.codeTVA = codeTVA;
		this.tauxTVA = tauxTVA;
		this.montantLigne = montantLigne;
		this.commentaireAvant = commentaireAvant;
		this.commentaireApres = commentaireApres;
		this.brId = brId;
	}
	
	
	public boolean isValid() {
	
		return true;
	}
	
	
	public int getLigneId() { return ligneId; }
	public int getRefLigne() { return refLigne; }
	public int getRank() { return rank; }
	public String getTypeLigne() { return typeLigne; }
	public String getReference() { return reference; }
	public String getRefFournisseur() { return refFournisseur; }
	public String getDesignation() { return designation; }
	public String getNumLot() { return numLot; }
	public double getQuantite() { return quantite; }
	public String getUnite() { return unite; }
	public int getNbPieces() { return nbPieces; }
	public long getDatePeremption() { return datePeremption; }
	public double getPrix() { return prix; }
	public double getRistourne() { return ristourne; }
	public int getCodeTVA() { return codeTVA; }
	public double getTauxTVA() { return tauxTVA; }
	public double getMontantLigne() { return montantLigne; }
	public String getCommentaireAvant() { return commentaireAvant; }
	public String getCommentaireApres() { return commentaireApres; }
	public int getBRId() { return brId; }
	

} // fin LigneFactureFournisseur
