/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/
  
/**
 *  Cre le tableau en Ooo
 */

package org.opensi.compta.actions.suiviActivite;

import java.io.File;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.openoffice.CreateurOpenOffice;
import org.opensi.util.openoffice.OooCellule;
import org.opensi.util.openoffice.OooLigne;
import org.opensi.util.openoffice.OooStyleCellule;


public class budgetCAVersOoo extends Action {

	String chemin;
	String nomFichier, domaine;
	int nbMois, decalage;
		
	CreateurOpenOffice zeus;
	OooStyleCellule titreStyle, titreNombreStyle, caseStyle;
	String titre;

	String liste;
	String [] tabLib;
	String [][] tabPrevu; //[lib][mois]
	String [][] tabActu; //[lib][mois]
	String [][] tabRetenu; //[lib][mois]
	int []tabTotaux, tabPourcent;
	
	
  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {

	
		chemin = s.getAppConfiguration().get("opensi.absdir") ;
	
		nomFichier=r.getParameter("fichierSxc");
		liste=r.getParameter("liste");
		nbMois=Integer.parseInt(r.getParameter("nbMois"));
		decalage=Integer.parseInt(r.getParameter("decal"));
		domaine=r.getParameter("domaine");
		titre="Budget";

		separerLaListe();
		calculeTotaux();
		calculePourcents();

		genererOoo();
		
		return true;
	
	}
	
	public void calculePourcents()
	{


			tabPourcent=new int[tabTotaux.length];

			if(domaine.equals("D"))
			{
				tabPourcent[0]=100; //CA
				tabPourcent[1]=100; //VM
				tabPourcent[7]=100; //PE
				tabPourcent[10]=100; //MBG
				
				//CMV%=CMV*100/VM
				tabPourcent[2]=(tabTotaux[2]*100)/tabTotaux[1];
				
				//MC%=MC*100/VM
				tabPourcent[3]=tabTotaux[3]*100/tabTotaux[1];
				
				//PV%=PV*100/PE
				tabPourcent[4]=tabTotaux[4]*100/tabTotaux[7];
				
				//PS%=PS*100/PE
				tabPourcent[5]=tabTotaux[5]*100/tabTotaux[7];
				
				//PIM%=PIM*100/PE
				tabPourcent[6]=tabTotaux[6]*100/tabTotaux[7];
				
				//MA%=MA*100/PE
				tabPourcent[8]=tabTotaux[8]*100/tabTotaux[7];
				
				//MBP%=MBP*100/PE
				tabPourcent[9]=tabTotaux[9]*100/tabTotaux[7];
			
			}
			
			if(domaine.equals("M"))
			{
				tabPourcent[0]=100; //CA
				tabPourcent[1]=100; //VM
				tabPourcent[4]=100; //MBG
				
				//CMV%=CMV*100/VM
				tabPourcent[2]=tabTotaux[2]*100/tabTotaux[1];
				
				//MC%=MC*100/VM
				tabPourcent[3]=tabTotaux[2]*100/tabTotaux[1];
			
			}
			
			if(domaine.equals("P"))
			{
				tabPourcent[0]=100; //CA
				tabPourcent[1]=100; //PV
				tabPourcent[4]=100; //PE
				tabPourcent[7]=100; //MBG

				
				//PV%=PV*100/PE
				tabPourcent[1]=tabTotaux[1]*100/tabTotaux[4];
				
				//PS%=PS*100/PE
				tabPourcent[2]=tabTotaux[2]*100/tabTotaux[4];
				
				//PIM%=PIM*100/PE
				tabPourcent[3]=tabTotaux[3]*100/tabTotaux[4];
				
				//MA%=MA*100/PE
				tabPourcent[5]=tabTotaux[5]*100/tabTotaux[4];
				
				//MBP%=MBP*100/PE
				tabPourcent[6]=tabTotaux[6]*100/tabTotaux[4];
			
			}
	
	
	}
	
	public void separerLaListe()
	{
		
		
		//On enlve le premier ';'
		liste=liste.substring(1);
		String[] parLib=liste.split(";");
		
		
		tabLib=new String[parLib.length];
		tabPrevu=new String[parLib.length][nbMois];
		tabActu=new String[parLib.length][nbMois];
		tabRetenu=new String[parLib.length][nbMois];
		
		
		
		
		for( int lib=0; lib<parLib.length;lib++)
		{
			String temp=new String(parLib[lib]);
			
			String [] laLigne=temp.split("_");

			tabLib[lib]=new String(laLigne[0]);
			String prevuTemp=laLigne[1];
			String actuTemp=laLigne[2];
			String retenuTemp=laLigne[3];
			
			//On enlve la premire ','
			prevuTemp=prevuTemp.substring(1);
			actuTemp=actuTemp.substring(1);
			retenuTemp=retenuTemp.substring(1);
			
			String [] tabPrevuTemp=prevuTemp.split(",");
			String [] tabActuTemp=actuTemp.split(",");
			String [] tabRetenuTemp=retenuTemp.split(",");


			for(int mois=0; mois<nbMois;mois++)
			{
				tabPrevu[lib][mois]=tabPrevuTemp[mois];
				tabActu[lib][mois]=tabActuTemp[mois];
				tabRetenu[lib][mois]=tabRetenuTemp[mois];
			}


		
		}

	}
	

	public void calculeTotaux()
	{
		int total=0;
		
		
			tabTotaux=new int [tabLib.length];
			for(int i=0; i<tabLib.length;i++)
			{
				total=0;
				for (int a=0; a<nbMois;a++)
				{
					total+=	Integer.parseInt(tabRetenu[i][a]);
				}
				
				
				tabTotaux[i]=total;
			
			}
		
	}
	
	
	/* *************** GENERATION Ooo ************************ */
	
	public void genererOoo()
	{


		zeus=new CreateurOpenOffice(chemin+"/openoffice");

		creerLesStyles();
		genererEntete();
		ecrireContenu();
		
		zeus.changerLargeurColonne(0,6.0f);
		zeus.changerLargeurColonne(2,1.3f);
		
		File fichier=zeus.genererDocument(nomFichier);
		fichier.deleteOnExit();
		
	}
	
	
	
	/**
	* Ecris les deux lignes d'entte
	**/
	public void genererEntete()
	{
	
	
		OooLigne ligneEnTete=new OooLigne(zeus.getStyleLigneParDefaut());
		OooCellule truc;


		//*************** 1re ligne ******************
		for (int h=0; h<3; h++)
		{
			//espacement, au dessus du tableau de gauche
			truc=new OooCellule("", zeus.getStyleCelluleParDefaut());
			ligneEnTete.ajouterCellule(truc);
		}
		
		
		for (int g=0; g<nbMois;g++)
		{
			//espacement
			truc=new OooCellule("", zeus.getStyleCelluleParDefaut());
			ligneEnTete.ajouterCellule(truc);
			
			int mois12=((g+decalage)%12)+1;
			
			
			truc=new OooCellule(leMois(mois12), titreStyle);
			truc.setFusion(1, 3);
			ligneEnTete.ajouterCellule(truc);
	
		}
		
		
		zeus.ajouterLigne(ligneEnTete);

		// ********** 2me ligne ***************
		ligneEnTete=new OooLigne(zeus.getStyleLigneParDefaut());


		//tableau de gauche:
		truc=new OooCellule(titre, titreStyle);

		truc.setFusion(1, 3);
		ligneEnTete.ajouterCellule(truc);
		for (int g=0; g<nbMois;g++)
		{
			//espacement
			truc=new OooCellule("", zeus.getStyleCelluleParDefaut());
			ligneEnTete.ajouterCellule(truc);
			truc=new OooCellule("Prev", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			truc=new OooCellule("Actu", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			truc=new OooCellule("Retenu", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			
		}
		

		zeus.ajouterLigne(ligneEnTete);		

	}
	
	
	
	public void ecrireContenu()
	{

			OooCellule vide=new OooCellule("",zeus.getStyleCelluleParDefaut());
			OooLigne enCours;
			OooCellule enCoursAussi;
			String temp;
			int nombre;
			
			OooStyleCellule paschiffreS, ChiffreS;
			
			
			for (int lib=0; lib<tabLib.length;lib++)
			{
				enCours=new OooLigne(zeus.getStyleLigneParDefaut());
				
				//Libell
				if (styleLigneCouleur(lib))
				{
					paschiffreS=titreStyle;
					ChiffreS=titreNombreStyle;
				}
				else
				{
					paschiffreS=caseStyle;
					ChiffreS=caseStyle;
				}
				
	
				enCoursAussi=new OooCellule(tabLib[lib],paschiffreS);
				enCours.ajouterCellule(enCoursAussi);
				
				//Total
				enCoursAussi=new OooCellule(tabTotaux[lib],ChiffreS);
				enCours.ajouterCellule(enCoursAussi);
				
				//pourcent
				temp=""+tabPourcent[lib]+" %";
				enCoursAussi=new OooCellule(temp,paschiffreS);
				enCours.ajouterCellule(enCoursAussi);

				for (int mois=0; mois<nbMois;mois++)
				{
					
					//Prevu
					enCours.ajouterCellule(vide);
					nombre=Integer.parseInt(tabPrevu[lib][mois]);
					enCoursAussi=new OooCellule(nombre,ChiffreS);
					enCours.ajouterCellule(enCoursAussi);

					temp=tabActu[lib][mois];
					//Actu
					if(temp.equals("rien"))
					{
						enCoursAussi=new OooCellule("",ChiffreS);
						enCours.ajouterCellule(enCoursAussi);
					}
					else
					{
						nombre=Integer.parseInt(tabActu[lib][mois]);
						enCoursAussi=new OooCellule(nombre,ChiffreS);
						enCours.ajouterCellule(enCoursAussi);
					}
					

					//Retenu
					nombre=Integer.parseInt(tabRetenu[lib][mois]);
					enCoursAussi=new OooCellule(nombre,ChiffreS);
					enCours.ajouterCellule(enCoursAussi);
				}

				zeus.ajouterLigne(enCours);	

			}
		
	}
	

	
	
	public void creerLesStyles()
	{

		titreStyle=zeus.creerNewStyleCellule();
		titreStyle.setGras(true); 
		titreStyle.setCouleurFond("#FCD9AF");
		titreStyle.setBordure(true);
		titreStyle.setAlignement(OooStyleCellule.H_CENTRE,OooStyleCellule.V_MILIEU);
		titreStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		titreNombreStyle=zeus.creerNewStyleCellule();
		titreNombreStyle.setGras(true); 
		titreNombreStyle.setCouleurFond("#FCD9AF");
		titreNombreStyle.setBordure(true);
		titreNombreStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		caseStyle=zeus.creerNewStyleCellule();
		caseStyle.setBordure(true);
		caseStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);

	}
	
	
	//Retourne vrai si la ligne doit tre colore, faux sinon
	public boolean styleLigneCouleur(int numLigne)
	{
		boolean resultat=false;
		
		if(numLigne==0) {resultat=true;}
		
		if(domaine.equals("P") && (numLigne==4 || numLigne==6 || numLigne==7)){resultat=true;}
		if(domaine.equals("M") && (numLigne==3 || numLigne==4 )){resultat=true;}
		if(domaine.equals("D") && (numLigne==3 || numLigne==7 || numLigne==9 || numLigne==10)){resultat=true;}
	
		return resultat;
	
	
	}
	


	
	public String leMois(int lemois)
	{
		String resultat="";
		
		switch (lemois)
		{
			case 1: resultat="Janvier";break;
			case 2: resultat="Fvrier";break;
			case 3: resultat="Mars";break;
			case 4: resultat="Avril";break;
			case 5: resultat="Mai";break;
			case 6: resultat="Juin";break;
			case 7: resultat="Juillet";break;
			case 8: resultat="Aout";break;
			case 9: resultat="Septembre";break;
			case 10: resultat="Octobre";break;
			case 11: resultat="Novembre";break;
			case 12: resultat="Dcembre";break;
			default: resultat="";
		
		}
		
		return resultat;
	}


	
	
}



		
			
			










