/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.compta.actions.etats;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.Arrondi;
import org.opensi.util.tools.DateTime;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;


public class GenPdfResultat extends Action {


	class MyPageEvent implements PdfPageEvent {


	private String dateCourante;

	private String dossierId;
	private String raisonSociale;
	private String adresse;
	private String compAdresse;
	private String codePostal;
	private String ville;
	private String monnaie;

	private String debutExercice;
	private String finExercice;
	private String finPeriodeStr;
	private String finExerciceN1Str;
	private boolean dateHeure;
	private boolean numDossier;
	private boolean projet;


		public MyPageEvent(String dossierId, String debutExercice, String finExercice, String dateHeure, String numDossier, String projet) throws SQLException {

			this.dossierId = dossierId;
			this.dateHeure = dateHeure.equalsIgnoreCase("y");
			this.numDossier = numDossier.equalsIgnoreCase("n");
			this.projet = projet.equalsIgnoreCase("y");

			String reqLeDossier = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Code_Postal, s.Ville, d.Intitule as Devise from "+ baseDossier +".SOCIETE s join DEVISE d on s.Monnaie_Tenue=d.Devise_Id";

			Statement stt = con.createStatement();
			ResultSet rset = stt.executeQuery(reqLeDossier);

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse = rset.getString("Adresse_1");
			this.compAdresse = rset.getString("Adresse_2");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.monnaie = rset.getString("Devise");

			rset.close();

			stt.close();

			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			this.finPeriodeStr = formatDate.format(new Date(finPeriode));
			this.debutExercice = formatDate.format(new Date(Long.parseLong(debutExercice)));
			this.finExercice = formatDate.format(new Date(Long.parseLong(finExercice)));
			this.finExerciceN1Str = formatDate.format(new Date(finExerciceN1));

		}

    public void onStartPage(PdfWriter writer, Document document) {

    	try {

				if (projet) {
					try {
						PdfContentByte dcu = writer.getDirectContentUnder();
						Image fond = Image.getInstance(cheminImages +"projet.jpg");
						fond.scaleAbsolute(324, 468);
						fond.setAbsolutePosition(135,100);
						dcu.addImage(fond);
					}
					catch(java.net.MalformedURLException mfue) { System.err.println(mfue.getMessage()); }
					catch(IOException ioe) { System.err.println(ioe.getMessage()); }
				}

				// Entete Gnrale


				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);

				cellEntete.setPhrase(new Phrase(numDossier?"Dossier : "+this.dossierId:"", fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase(dateHeure?"Date : "+this.dateCourante:"", fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.adresse, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("Exercice du " + this.debutExercice + " au " + this.finExercice, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.compAdresse, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.codePostal + " " + this.ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(detailRES?"D\u00E9tail du Compte de R\u00E9sultat":"Compte de R\u00E9sultat", new Font(Font.HELVETICA, 16, Font.BOLD)));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(""));
				cellEntete.setFixedHeight(10);
				entete.addCell(cellEntete);


				cellEntete.setPhrase(new Phrase("Au " + this.finPeriodeStr, fontGen));
				cellEntete.setMinimumHeight(0);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);


				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);

				// fin Entete Gnrale


				// Titres de colonnes

				PdfPTable titresColonnes = new PdfPTable(nbColListing);
				titresColonnes.setWidthPercentage(100);
				titresColonnes.setWidths(widthsListing);
				PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

				cellTitre.setFixedHeight(10);
				cellTitre.setBorder(PdfPCell.NO_BORDER);
				cellTitre.setPhrase(new Phrase(""));
				cellTitre.setColspan(nbColListing);
				titresColonnes.addCell(cellTitre);

				cellTitre.setColspan(1);
				cellTitre.setMinimumHeight(16);
				cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
				cellTitre.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

				if (!detailRES && document.getPageNumber()==1) {

					cellTitre.setBorder(PdfPCell.BOX - PdfPCell.BOTTOM);
					cellTitre.setPhrase(new Phrase(""));
					titresColonnes.addCell(cellTitre);

					cellTitre.setBorder(PdfPCell.BOX);
					cellTitre.setColspan(3);
					Phrase exon = new Phrase("Exercice N  "+ this.finPeriodeStr, fontLine);
					exon.add(new Chunk("\n("+ dureeN +" mois)", fontMini));

					cellTitre.setPhrase(exon);
					titresColonnes.addCell(cellTitre);

					if (compareN1) {
						cellTitre.setBorder(PdfPCell.BOX - PdfPCell.BOTTOM);
						cellTitre.setColspan(1);
						Phrase exon1 = new Phrase("Exercice N-1", fontLine);
						exon1.add(new Chunk("\n("+ dureeN1 +" mois)", fontMini));

						cellTitre.setPhrase(exon1);
						titresColonnes.addCell(cellTitre);

						cellTitre.setColspan(2);
						cellTitre.setBorder(PdfPCell.BOX);
						Phrase enn1 = new Phrase("Ecart N / N-1", fontLine);

						if (proratisation) {
							enn1.add(new Chunk("\n(proratis\u00E9)", fontMini));
						}

						cellTitre.setPhrase(enn1);
						titresColonnes.addCell(cellTitre);
					}

					cellTitre.setColspan(1);
					cellTitre.setBorder(PdfPCell.BOX - PdfPCell.TOP);

					cellTitre.setPhrase(new Phrase("", fontLine));
					titresColonnes.addCell(cellTitre);

					cellTitre.setPhrase(new Phrase("France", fontLine));
					titresColonnes.addCell(cellTitre);

					cellTitre.setPhrase(new Phrase("Exportation", fontLine));
					titresColonnes.addCell(cellTitre);

					cellTitre.setPhrase(new Phrase("Total", fontLine));
					titresColonnes.addCell(cellTitre);

					if (compareN1) {
						cellTitre.setPhrase(new Phrase(this.finExerciceN1Str, fontLine));
						titresColonnes.addCell(cellTitre);

						cellTitre.setBorder(PdfPCell.BOX);
						cellTitre.setPhrase(new Phrase(this.monnaie.toUpperCase() + "S", fontLine));
						titresColonnes.addCell(cellTitre);

						cellTitre.setPhrase(new Phrase("%", fontLine));
						titresColonnes.addCell(cellTitre);
					}

				}
				else {

					cellTitre.setColspan(3);
					cellTitre.setBorder(PdfPCell.BOX - PdfPCell.BOTTOM);
					cellTitre.setPhrase(new Phrase(""));
					titresColonnes.addCell(cellTitre);

					cellTitre.setColspan(1);
					Phrase exon = new Phrase("Exercice N", fontLine);
					exon.add(new Chunk("\n("+ dureeN +" mois)", fontMini));

					cellTitre.setPhrase(exon);
					titresColonnes.addCell(cellTitre);

					if (compareN1) {
						Phrase exon1 = new Phrase("Exercice N-1", fontLine);
						exon1.add(new Chunk("\n("+ dureeN1 +" mois)", fontMini));

						cellTitre.setPhrase(exon1);
						titresColonnes.addCell(cellTitre);

						cellTitre.setColspan(2);
						cellTitre.setBorder(PdfPCell.BOX);
						Phrase enn1 = new Phrase("Ecart N / N-1", fontLine);

						if (proratisation) {
							enn1.add(new Chunk("\n(proratis\u00E9)", fontMini));
						}

						cellTitre.setPhrase(enn1);
						titresColonnes.addCell(cellTitre);
					}

					cellTitre.setColspan(3);
					cellTitre.setBorder(PdfPCell.BOX - PdfPCell.TOP);
					cellTitre.setPhrase(new Phrase("", fontLine));
					titresColonnes.addCell(cellTitre);

					cellTitre.setColspan(1);
					cellTitre.setPhrase(new Phrase(this.finPeriodeStr, fontLine));
					titresColonnes.addCell(cellTitre);

					if (compareN1) {
						cellTitre.setPhrase(new Phrase(this.finExerciceN1Str, fontLine));
						titresColonnes.addCell(cellTitre);

						cellTitre.setBorder(PdfPCell.BOX);
						cellTitre.setPhrase(new Phrase(this.monnaie.toUpperCase() + "S", fontLine));
						titresColonnes.addCell(cellTitre);

						cellTitre.setPhrase(new Phrase("%", fontLine));
						titresColonnes.addCell(cellTitre);
					}

				}

				document.add(titresColonnes);

				// fin Titres de colonnes

			}
			catch(DocumentException de) {	de.printStackTrace(); }

		}

		public void onEndPage(PdfWriter writer, Document document) {}
		public void onOpenDocument(PdfWriter writer, Document document) {}
    public void onCloseDocument(PdfWriter writer, Document document) {}
    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
    public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
    public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
    public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

	}


private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);		// font pour lignes d'entete
private static final Font fontLine = new Font(Font.HELVETICA , 9, Font.NORMAL);		// font pour lignes de listing
private static final Font fontMini = new Font(Font.HELVETICA , 7, Font.NORMAL);		// font pour prcisions
private DecimalFormat numFormat = new DecimalFormat("0");
private DecimalFormat numFormat2 = new DecimalFormat("0.00");

private int widthsListing[];

private String base;
private String baseN1;
private String baseDossier;
private boolean detailRES;
private boolean compareN1;
private boolean proratisation;
private long finExerciceN1;
private long debutPeriode;
private long finPeriode;
private int nbColListing;
private int dureeN1 = 0;
private int dureeN = 0;

private Connection con;
private String cheminImages;


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		con = s.getConnection(null);


		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);

		numFormat2.setDecimalFormatSymbols(dfs);
		numFormat2.setGroupingUsed(true);
		numFormat2.setGroupingSize(3);

		String dossierId = s.getCookie().get("Dossier_Id");
		String debutExercice = r.getParameter("Debut_Exercice");
		String finExercice = r.getParameter("Fin_Exercice");
		String dateFin = r.getParameter("Date_Fin");
		String base = s.getCookie().get("BaseExo");
		baseDossier = s.getCookie().get("BaseDossier");
		String type = r.getParameter("Type");
		String numDossier = r.getParameter("Num_Dossier");
		String dateHeure = r.getParameter("Date_Heure");
		String comparatif = r.getParameter("Comparatif");
		String proratiser = r.getParameter("Proratisation");
		String projet = r.getParameter("Projet");
		String detail = r.getParameter("Detail");
		int numExerciceN1 = Integer.parseInt(r.getParameter("Num_Exercice"))-1;

		PdfPTable listing;


		int widthsListing4[] = {34,13,13,40};         // largeurs colonnes sans comparatif N-1
		int widthsListing7[] = {31,12,12,13,13,11,8}; // largeurs de colonnes avec comparatif N-1


		if (type.equalsIgnoreCase("D")) {
			this.finPeriode = DateTime.parseDate(dateFin, "dd/MM/yy");
		}
		else {
			this.finPeriode = Long.parseLong(finExercice);
		}

		this.debutPeriode = Long.parseLong(debutExercice);
		this.base = base;
		this.detailRES = detail.equalsIgnoreCase("y");
		this.compareN1 = comparatif.equalsIgnoreCase("n");
		this.proratisation = proratiser.equalsIgnoreCase("y");

		// base si comparatif et exercice n-1 existe

		String reqExoN1 = "select Nom_Base, Duree_Exercice, Fin_Exercice from "+ baseDossier +".EXERCICE where Num_Exercice="+ numExerciceN1;


		Statement stt = con.createStatement();
		ResultSet rsetN1 = stt.executeQuery(reqExoN1);

		if (rsetN1.next()) {
			baseN1 = rsetN1.getString("Nom_Base");
			dureeN1 = rsetN1.getInt("Duree_Exercice");
			finExerciceN1 = rsetN1.getLong("Fin_Exercice");
			Arrondi rd = new Arrondi(0);
			dureeN = (int)rd.round((((double)finPeriode-debutPeriode)/86400000)/30);
		}
		else {
			this.compareN1 = false; // on force a faux si pas d'exo precedent
		}

		rsetN1.close();

		stt.close();


		if (compareN1) {
			this.nbColListing = 7;
			this.widthsListing = widthsListing7;
		}
		else {
			this.nbColListing = 4;
			this.widthsListing = widthsListing4;
		}

		Document document = new Document(PageSize.A4, 25, 25, 25, 25);

		String chemin = s.getAppConfiguration().get("opensi.absdir") +"/pdf/";

		this.cheminImages = s.getAppConfiguration().get("opensi.absdir") +"/images/";

		String fichierPdf = r.getParameter("FichierPDF");

		PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));

		MyPageEvent event = new MyPageEvent(dossierId, debutExercice, finExercice, dateHeure, numDossier, projet);

		writer.setPageEvent(event);


		document.open();

		listing = new PdfPTable(this.nbColListing);
		listing.setWidthPercentage(100);
		listing.setWidths(widthsListing);

		putResultat(listing);

		document.add(listing);

		document.close();

		s.closeConnection(con, null);


		try {
			File filePdf = new File(chemin, fichierPdf);
			filePdf.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier  supprimer");
			se.printStackTrace();
		}


		return true;


	} // fin service


	private void putResultat(PdfPTable listing) throws SQLException, Exception {

		double valN = 0;
		double valN1 = 0;
		double totalN = 0;
		double totalN1 = 0;
		double valEXP = 0;
		double totalEXP = 0;

		if (detailRES) {
			putEspacement(listing, 5);
			putTitreSection(listing, "PRODUITS D'EXPLOITATION");
			putEspacement(listing, 5);
		}
		else {
			putEspacementFE(listing, 5);
			putTitreSectionFE(listing, "PRODUITS D'EXPLOITATION");
			putEspacementFE(listing, 4);
		}

		valN = getSumCompte("707%")
				 + getSumCompte("7097%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1("707%")
				 	  + getSumCompteN1("7097%");

			totalN1 += valN1;
		}

		if (detailRES) {
			putLigneRES(listing, "Ventes de marchandises", valN, valN1);
			putDetailSection(listing, "707%");
			putDetailSection(listing, "7097%");
			putEspacement(listing, 5);
		}
		else {
			valEXP = getSumCompte("707_2%")
				 		 + getSumCompte("70972%");

			totalEXP += valEXP;

			putLigneRES(listing, "Ventes de marchandises", valEXP, valN, valN1);
		}

		valN = getSumCompte("700%")
				 + getSumCompte("701%")
				 + getSumCompte("702%")
				 + getSumCompte("703%")
				 + getSumCompte("7090%")
				 + getSumCompte("7091%")
				 + getSumCompte("7092%")
				 + getSumCompte("7093%")
				 + getSumCompte("7099%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1("700%")
				 		+ getSumCompteN1("701%")
				 		+ getSumCompteN1("702%")
				 		+ getSumCompteN1("703%")
				 		+ getSumCompteN1("7090%")
				 		+ getSumCompteN1("7091%")
				 		+ getSumCompteN1("7092%")
				 		+ getSumCompteN1("7093%")
				 		+ getSumCompteN1("7099%");

			totalN1 += valN1;
		}

		if (detailRES) {
			putLigneRES(listing, "Production vendue de biens", valN, valN1);
			putDetailSection(listing, "700%");
			putDetailSection(listing, "701%");
			putDetailSection(listing, "702%");
			putDetailSection(listing, "703%");
			putDetailSection(listing, "7090%");
			putDetailSection(listing, "7091%");
			putDetailSection(listing, "7092%");
			putDetailSection(listing, "7093%");
			putDetailSection(listing, "7099%");
			putEspacement(listing, 5);
		}
		else {
			valEXP = getSumCompte("700_2%")
				 		 + getSumCompte("701_2%")
				 		 + getSumCompte("702_2%")
				 		 + getSumCompte("703_2%")
				 		 + getSumCompte("70902%")
				 		 + getSumCompte("70912%")
				 	   + getSumCompte("70922%")
				 		 + getSumCompte("70932%")
						 + getSumCompte("70992%");

			totalEXP += valEXP;

			putLigneRES(listing, "Production vendue de biens", valEXP, valN, valN1);
		}

		valN = getSumCompte("704%")
				 + getSumCompte("705%")
				 + getSumCompte("706%")
				 + getSumCompte("708%")
				 + getSumCompte("7094%")
				 + getSumCompte("7095%")
				 + getSumCompte("7096%")
				 + getSumCompte("7098%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1("704%")
					 	+ getSumCompteN1("705%")
					 	+ getSumCompteN1("706%")
					 	+ getSumCompteN1("708%")
					 	+ getSumCompteN1("7094%")
					 	+ getSumCompteN1("7095%")
					 	+ getSumCompteN1("7096%")
					 	+ getSumCompteN1("7098%");

			totalN1 += valN1;
		}

		if (detailRES) {
			putLigneRES(listing, "Production vendue de services", valN, valN1);
			putDetailSection(listing, "704%");
			putDetailSection(listing, "705%");
			putDetailSection(listing, "706%");
			putDetailSection(listing, "708%");
			putDetailSection(listing, "7094%");
			putDetailSection(listing, "7095%");
			putDetailSection(listing, "7096%");
			putDetailSection(listing, "7098%");
			putEspacement(listing, 5);
			putEspacement(listing, 5);
			putSection(listing, "CHIFFRE D'AFFAIRES NET", totalN, totalN1);
		}
		else {
			valEXP = getSumCompte("704_2%")
				 		 + getSumCompte("705_2%")
				 		 + getSumCompte("706_2%")
				 		 + getSumCompte("708_2%")
				 		 + getSumCompte("70942%")
				 		 + getSumCompte("70952%")
				 		 + getSumCompte("70962%")
				 		 + getSumCompte("70982%");

			totalEXP += valEXP;

			putLigneRES(listing, "Production vendue de services", valEXP, valN, valN1);
			putEspacementFE(listing, 5);
			putCA(listing, totalEXP, totalN, totalN1);
			putEspacement(listing, 3);
		}

		putEspacement(listing, 5);

		valN = getSumCompte("71%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1("71%");
			totalN1 += valN1;
		}

		putLigneRES(listing, "Production stock\u00E9e", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "71%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte("72%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1("72%");
			totalN1 += valN1;
		}

		putLigneRES(listing, "Production immobilis\u00E9e", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "72%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte("74%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1("74%");
			totalN1 += valN1;
		}

		putLigneRES(listing, "Subventions d'exploitation", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "74%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte("78%")
				 + getSumCompte("79%")
				 - getSumCompte("786%")
				 - getSumCompte("787%")
				 - getSumCompte("789%")
				 - getSumCompte("796%")
				 - getSumCompte("797%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1("78%")
					 	+ getSumCompteN1("79%")
					 	- getSumCompteN1("786%")
					 	- getSumCompteN1("787%")
						- getSumCompteN1("789%")
					 	- getSumCompteN1("796%")
					 	- getSumCompteN1("797%");

			totalN1 += valN1;
		}

		putLigneRES(listing, "Reprises sur amortissements et provisions, transferts de charges", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "78%' and c.Numero_Compte not like '786%' and c.Numero_Compte not like '787%' and c.Numero_Compte not like '789%");
			putDetailSection(listing, "79%' and c.Numero_Compte not like '796%' and c.Numero_Compte not like '797%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte("73%")
				 + getSumCompte("75%")
				 - getSumCompte("755%");

		totalN += valN;
		double totalI = totalN;

		if (compareN1) {
			valN1 = getSumCompteN1("73%")
				 		+ getSumCompteN1("75%")
				 		- getSumCompteN1("755%");

			totalN1 += valN1;
		}

		double totalIN1 = totalN1;

		putLigneRES(listing, "Autres produits", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "73%");
			putDetailSection(listing, "75%' and c.Numero_Compte not like '755%");
			putEspacement(listing, 5);
		}

		putEspacement(listing, 5);

		putSection(listing, "TOTAL DES PRODUITS D'EXPLOITATION (I)", totalI, totalIN1);

		putEspacement(listing, 5);
		putTitreSection(listing, "CHARGES D'EXPLOITATION");
		putEspacement(listing, 4);

		valN = -(getSumCompte("607%")
				 + getSumCompte("6087%")
				 + getSumCompte("6097%"));

		totalN = valN;

		if (compareN1) {
			valN1 = -(getSumCompteN1("607%")
				 		+ getSumCompteN1("6087%")
				 		+ getSumCompteN1("6097%"));

			totalN1 = valN1;
		}

		putLigneRES(listing, "Achats de marchandises", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "607%");
			putDetailSection(listing, "6087%");
			putDetailSection(listing, "6097%");
			putEspacement(listing, 5);
		}

		valN = - getSumCompte("6037%");

		totalN += valN;

		if (compareN1) {
			valN1 = - getSumCompteN1("6037%");
			totalN1 += valN1;
		}

		putLigneRES(listing, "Variation de stock (marchandises)", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "6037%");
			putEspacement(listing, 5);
		}

		valN = -(getSumCompte("600%")
				 + getSumCompte("601%")
				 + getSumCompte("602%")
				 + getSumCompte("6080%")
				 + getSumCompte("6081%")
				 + getSumCompte("6082%")
				 + getSumCompte("6090%")
				 + getSumCompte("6091%")
				 + getSumCompte("6092%"));

		totalN += valN;

		if (compareN1) {
			valN1 = -(getSumCompteN1("600%")
					 	+ getSumCompteN1("601%")
					 	+ getSumCompteN1("602%")
					 	+ getSumCompteN1("6080%")
					 	+ getSumCompteN1("6081%")
					 	+ getSumCompteN1("6082%")
					 	+ getSumCompteN1("6090%")
					 	+ getSumCompteN1("6091%")
					 	+ getSumCompteN1("6092%"));

			totalN1 += valN1;
		}

		putLigneRES(listing, "Achats de mati\u00E8res premi\u00E8res et autres approvisionnements", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "600%");
			putDetailSection(listing, "601%");
			putDetailSection(listing, "602%");
			putDetailSection(listing, "6080%");
			putDetailSection(listing, "6081%");
			putDetailSection(listing, "6082%");
			putDetailSection(listing, "6090%");
			putDetailSection(listing, "6091%");
			putDetailSection(listing, "6092%");
			putEspacement(listing, 5);
		}

		valN = -(getSumCompte("603%")
				 - getSumCompte("6037%"));

		totalN += valN;

		if (compareN1) {
			valN1 = -(getSumCompteN1("603%")
				 		- getSumCompteN1("6037%"));

			totalN1 += valN1;
		}

		putLigneRES(listing, "Variation de stock (mati\u00E8res premi\u00E8res et approvisionnements)", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "603%' and c.Numero_Compte not like '6037%");
			putEspacement(listing, 5);
		}

		valN = -(getSumCompte("60%")
				 + getSumCompte("61%")
				 + getSumCompte("62%")
				 - getSumCompte("600%")
				 - getSumCompte("601%")
				 - getSumCompte("602%")
				 - getSumCompte("603%")
				 - getSumCompte("607%")
				 - getSumCompte("6080%")
				 - getSumCompte("6081%")
				 - getSumCompte("6082%")
				 - getSumCompte("6087%")
				 - getSumCompte("6090%")
				 - getSumCompte("6091%")
				 - getSumCompte("6092%")
				 - getSumCompte("6097%"));

		totalN += valN;

		if (compareN1) {
			valN1 = -(getSumCompteN1("60%")
					 + getSumCompteN1("61%")
					 + getSumCompteN1("62%")
					 - getSumCompteN1("600%")
					 - getSumCompteN1("601%")
					 - getSumCompteN1("602%")
					 - getSumCompteN1("603%")
					 - getSumCompteN1("607%")
					 - getSumCompteN1("6080%")
					 - getSumCompteN1("6081%")
					 - getSumCompteN1("6082%")
					 - getSumCompteN1("6087%")
					 - getSumCompteN1("6090%")
					 - getSumCompteN1("6091%")
					 - getSumCompteN1("6092%")
					 - getSumCompteN1("6097%"));

			totalN1 += valN1;
		}

		putLigneRES(listing, "Autres achats, charges externes", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "60%' and c.Numero_Compte not like '600%' and c.Numero_Compte not like '601%' and c.Numero_Compte not like '602%' and c.Numero_Compte not like '603%' and c.Numero_Compte not like '607%' and c.Numero_Compte not like '6080%' and c.Numero_Compte not like '6081%' and c.Numero_Compte not like '6082%' and c.Numero_Compte not like '6087%' and c.Numero_Compte not like '6090%' and c.Numero_Compte not like '6091%' and c.Numero_Compte not like '6092%' and c.Numero_Compte not like '6097%");
			putDetailSection(listing, "61%");
			putDetailSection(listing, "62%");
			putEspacement(listing, 5);
		}

		valN = - getSumCompte("63%");

		totalN += valN;

		if (compareN1) {
			valN1 = - getSumCompteN1("63%");
			totalN1 += valN1;
		}

		putLigneRES(listing, "Impts, taxes et versements assimil\u00E9s", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "63%");
			putEspacement(listing, 5);
		}

		valN = -(getSumCompte("640%")
				 + getSumCompte("641%")
				 + getSumCompte("642%")
				 + getSumCompte("643%")
				 + getSumCompte("644%"));

		totalN += valN;

		if (compareN1) {
			valN1 = -(getSumCompteN1("640%")
					 	+ getSumCompteN1("641%")
						+ getSumCompteN1("642%")
						+ getSumCompteN1("643%")
					 	+ getSumCompteN1("644%"));

			totalN1 += valN1;
		}

		putLigneRES(listing, "Salaires et traitements", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "640%");
			putDetailSection(listing, "641%");
			putDetailSection(listing, "642%");
			putDetailSection(listing, "643%");
			putDetailSection(listing, "644%");
			putEspacement(listing, 5);
		}

		valN = -(getSumCompte("64%")
				 - getSumCompte("640%")
				 - getSumCompte("641%")
				 - getSumCompte("642%")
				 - getSumCompte("643%")
				 - getSumCompte("644%"));

		totalN += valN;

		if (compareN1) {
			valN1 = -(getSumCompteN1("64%")
					 	- getSumCompteN1("640%")
					 	- getSumCompteN1("641%")
						- getSumCompteN1("642%")
						- getSumCompteN1("643%")
					 	- getSumCompteN1("644%"));

			totalN1 += valN1;
		}

		putLigneRES(listing, "Charges sociales", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "64%' and c.Numero_Compte not like '640%' and c.Numero_Compte not like '641%' and c.Numero_Compte not like '642%' and c.Numero_Compte not like '643%' and c.Numero_Compte not like '644%");
			putEspacement(listing, 5);
		}

		valN = -(getSumCompte("68%")
				 - getSumCompte("6815%")
				 - getSumCompte("6816%")
				 - getSumCompte("6817%")
				 - getSumCompte("686%")
				 - getSumCompte("687%")
				 - getSumCompte("689%"));

		totalN += valN;

		if (compareN1) {
			valN1 = -(getSumCompteN1("68%")
					 - getSumCompteN1("6815%")
					 - getSumCompteN1("6816%")
					 - getSumCompteN1("6817%")
					 - getSumCompteN1("686%")
					 - getSumCompteN1("687%")
					 - getSumCompteN1("689%"));

			totalN1 += valN1;
		}

		putLigneRES(listing, "Dotations aux amortissements", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "68%' and c.Numero_Compte not like '6815%' and c.Numero_Compte not like '6816%' and c.Numero_Compte not like '6817%' and c.Numero_Compte not like '686%' and c.Numero_Compte not like '687%' and c.Numero_Compte not like '689%");
			putEspacement(listing, 5);
		}

		valN = - getSumCompte("6816%");

		totalN += valN;

		if (compareN1) {
			valN1 = - getSumCompteN1("6816%");
			totalN1 += valN1;
		}

		putLigneRES(listing, "Dotations aux provisions sur immobilisations", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "6816%");
			putEspacement(listing, 5);
		}

		valN = - getSumCompte("6817%");

		totalN += valN;

		if (compareN1) {
			valN1 = - getSumCompteN1("6817%");
			totalN1 += valN1;
		}

		putLigneRES(listing, "Dotations aux provisions sur actif circulant", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "6817%");
			putEspacement(listing, 5);
		}

		valN = - getSumCompte("6815%");

		totalN += valN;

		if (compareN1) {
			valN1 = - getSumCompteN1("6815%");
			totalN1 += valN1;
		}

		putLigneRES(listing, "Dotations aux provisions pour risques et charges", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "6815%");
			putEspacement(listing, 5);
		}

		valN = -(getSumCompte("65%")
				 - getSumCompte("655%"));

		totalN += valN;
		double totalII = totalN;

		if (compareN1) {
			valN1 = -(getSumCompteN1("65%")
					 	- getSumCompteN1("655%"));

			totalN1 += valN1;
		}

		double totalIIN1 = totalN1;

		putLigneRES(listing, "Autres charges", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "65%' and c.Numero_Compte not like '655%");
			putEspacement(listing, 5);
		}

		putEspacement(listing, 5);

		putSection(listing, "TOTAL DES CHARGES D'EXPLOITATION (II)", totalII, totalIIN1);

		putTotalSection(listing, "1 - RESULTAT D'EXPLOITATION (I-II)", totalI-totalII, totalIN1-totalIIN1);

		putEspacement(listing, 5);
		putTitreSection(listing, "QUOTES-PARTS DE RESULTAT SUR OPERATIONS FAITES EN COMMUN");
		putEspacement(listing, 4);

		valN = getSumCompte("755%");

		totalN = valN;
		double totalIII = totalN;

		if (compareN1) {
			valN1 = getSumCompteN1("755%");
			totalN1 = valN1;
		}

		double totalIIIN1 = totalN1;

		putLigneRES(listing, "B\u00E9n\u00E9fice attribu\u00E9 ou perte transf\u00E9r\u00E9e (III)", totalIII, totalIIIN1);

		if (detailRES) {
			putDetailSection(listing, "755%");
			putEspacement(listing, 5);
		}

		valN = - getSumCompte("655%");

		totalN = valN;
		double totalIV = totalN;

		if (compareN1) {
			valN1 = - getSumCompteN1("655%");
			totalN1 = valN1;
		}

		double totalIVN1 = totalN1;

		putLigneRES(listing, "Perte support\u00E9e ou b\u00E9n\u00E9fice transf\u00E9r\u00E9 (IV)", totalIV, totalIVN1);

		if (detailRES) {
			putDetailSection(listing, "655%");
			putEspacement(listing, 5);
		}

		putEspacement(listing, 5);
		putTitreSection(listing, "PRODUITS FINANCIERS");
		putEspacement(listing, 4);

		valN = getSumCompte("761%");

		totalN = valN;

		if (compareN1) {
			valN1 = getSumCompteN1("761%");
			totalN1 = valN1;
		}

		putLigneRES(listing, "Produits financiers de participations", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "761%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte("762%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1("762%");
			totalN1 += valN1;
		}

		putLigneRES(listing, "Produits des autres valeurs mobili\u00E8res et cr\u00E9ances de l'actif immobilis\u00E9", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "762%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte("76%")
				 - getSumCompte("761%")
				 - getSumCompte("762%")
				 - getSumCompte("766%")
				 - getSumCompte("767%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1("76%")
					 	- getSumCompteN1("761%")
					 	- getSumCompteN1("762%")
					 	- getSumCompteN1("766%")
					 	- getSumCompteN1("767%");

			totalN1 += valN1;
		}

		putLigneRES(listing, "Autres int\u00E9r\u00EAts et produits assimil\u00E9s", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "76%' and c.Numero_Compte not like '761%' and c.Numero_Compte not like '762%' and c.Numero_Compte not like '766%' and c.Numero_Compte not like '767%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte("786%")
				 + getSumCompte("796%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1("786%")
					 	+ getSumCompteN1("796%");

			totalN1 += valN1;
		}

		putLigneRES(listing, "Reprises sur provisions et transferts de charges", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "786%");
			putDetailSection(listing, "796%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte("766%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1("766%");
			totalN1 += valN1;
		}

		putLigneRES(listing, "Diff\u00E9rences positives de change", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "766%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte("767%");

		totalN += valN;
		double totalV = totalN;

		if (compareN1) {
			valN1 = getSumCompteN1("767%");
			totalN1 += valN1;
		}

		double totalVN1 = totalN1;

		putLigneRES(listing, "Produits nets sur cessions de valeurs mobili\u00E8res de placement", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "767%");
			putEspacement(listing, 5);
		}

		putEspacement(listing, 5);
		putSection(listing, "TOTAL V", totalV, totalVN1);

		putEspacement(listing, 5);
		putTitreSection(listing, "CHARGES FINANCIERES");
		putEspacement(listing, 4);

		valN = - getSumCompte("686%");

		totalN = valN;

		if (compareN1) {
			valN1 = - getSumCompteN1("686%");
			totalN1 = valN1;
		}

		putLigneRES(listing, "Dotations financi\u00E8res aux amortissements et provisions", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "686%");
			putEspacement(listing, 5);
		}

		valN = -(getSumCompte("66%")
				 - getSumCompte("666%")
				 - getSumCompte("667%"));

		totalN += valN;

		if (compareN1) {
			valN1 = -(getSumCompteN1("66%")
					 	- getSumCompteN1("666%")
					 	- getSumCompteN1("667%"));

			totalN1 += valN1;
		}

		putLigneRES(listing, "Int\u00E9r\u00EAts et charges assimil\u00E9es", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "66%' and c.Numero_Compte not like '666%' and c.Numero_Compte not like '667%");
			putEspacement(listing, 5);
		}

		valN = - getSumCompte("666%");

		totalN += valN;

		if (compareN1) {
			valN1 = - getSumCompteN1("666%");
			totalN1 += valN1;
		}

		putLigneRES(listing, "Diff\u00E9rences n\u00E9gatives de change", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "666%");
			putEspacement(listing, 5);
		}

		valN = - getSumCompte("667%");

		totalN += valN;
		double totalVI = totalN;

		if (compareN1) {
			valN1 = - getSumCompteN1("667%");
			totalN1 += valN1;
		}

		double totalVIN1 = totalN1;

		putLigneRES(listing, "Charges nettes sur cessions de valeurs mobili\u00E8res de placement", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "667%");
			putEspacement(listing, 5);
		}

		putEspacement(listing, 5);
		putSection(listing, "TOTAL VI", totalVI, totalVIN1);

		putTotalSection(listing, "2 - RESULTAT FINANCIER (V-VI)", totalV-totalVI, totalVN1-totalVIN1);
		putTotalSection(listing, "3 - RESULTAT COURANT AVANT IMPOTS (I-II+III-IV+V-VI)", totalI-totalII+totalIII-totalIV+totalV-totalVI, totalIN1-totalIIN1+totalIIIN1-totalIVN1+totalVN1-totalVIN1);

		putEspacement(listing, 5);
		putTitreSection(listing, "PRODUITS EXCEPTIONNELS");
		putEspacement(listing, 4);

		valN = getSumCompte("77%")
				 - getSumCompte("775%")
				 - getSumCompte("777%")
				 - getSumCompte("778%");

		totalN = valN;

		if (compareN1) {
			valN1 = getSumCompteN1("77%")
				 		- getSumCompteN1("775%")
				 		- getSumCompteN1("777%")
				 		- getSumCompteN1("778%");

			totalN1 = valN1;
		}

		putLigneRES(listing, "Produits exceptionnels sur op\u00E9rations de gestion", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "77%' and c.Numero_Compte not like '775%' and c.Numero_Compte not like '777%' and c.Numero_Compte not like '778%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte("775%")
				 + getSumCompte("777%")
				 + getSumCompte("778%");

		totalN += valN;

		if (compareN1) {
			valN1 = getSumCompteN1("775%")
					 	+ getSumCompteN1("777%")
					 	+ getSumCompteN1("778%");

			totalN1 += valN1;
		}

		putLigneRES(listing, "Produits exceptionnels sur op\u00E9rations en capital", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "775%");
			putDetailSection(listing, "777%");
			putDetailSection(listing, "778%");
			putEspacement(listing, 5);
		}

		valN = getSumCompte("787%")
				 + getSumCompte("797%");

		totalN += valN;
		double totalVII = totalN;

		if (compareN1) {
			valN1 = getSumCompteN1("787%")
					 	+ getSumCompteN1("797%");

			totalN1 += valN1;
		}

		double totalVIIN1 = totalN1;

		putLigneRES(listing, "Reprises sur provisions et transferts de charges", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "787%");
			putDetailSection(listing, "797%");
			putEspacement(listing, 5);
		}

		putEspacement(listing, 5);
		putSection(listing, "TOTAL VII", totalVII, totalVIIN1);

		putEspacement(listing, 5);
		putTitreSection(listing, "CHARGES EXCEPTIONNELLES");
		putEspacement(listing, 4);

		valN = -(getSumCompte("67%")
				 - getSumCompte("675%")
				 - getSumCompte("678%"));

		totalN = valN;

		if (compareN1) {
			valN1 = -(getSumCompteN1("67%")
				 		- getSumCompteN1("675%")
				 		- getSumCompteN1("678%"));

			totalN1 = valN1;
		}

		putLigneRES(listing, "Charges exceptionnelles sur op\u00E9rations de gestion", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "67%' and c.Numero_Compte not like '675%' and c.Numero_Compte not like '678%");
			putEspacement(listing, 5);
		}

		valN = -(getSumCompte("675%")
				 + getSumCompte("678%"));

		totalN += valN;

		if (compareN1) {
			valN1 = -(getSumCompteN1("675%")
					 	+ getSumCompteN1("678%"));

			totalN1 += valN1;
		}

		putLigneRES(listing, "Charges exceptionnelles sur op\u00E9rations en capital", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "675%");
			putDetailSection(listing, "678%");
			putEspacement(listing, 5);
		}

		valN = - getSumCompte("687%");

		totalN += valN;
		double totalVIII = totalN;

		if (compareN1) {
			valN1 = - getSumCompteN1("687%");
			totalN1 += valN1;
		}

		double totalVIIIN1 = totalN1;

		putLigneRES(listing, "Dotations exceptionnelles aux amortissements et provisions", valN, valN1);

		if (detailRES) {
			putDetailSection(listing, "687%");
			putEspacement(listing, 5);
		}

		putEspacement(listing, 5);
		putSection(listing, "TOTAL VIII", totalVIII, totalVIIIN1);

		putTotalSection(listing, "4 - RESULTAT EXCEPTIONNEL (VII-VIII)", totalVII-totalVIII, totalVIIN1-totalVIIIN1);
		putEspacement(listing, 5);

		valN = -(getSumCompte("69%")
				 - getSumCompte("695%")
				 - getSumCompte("696%")
				 - getSumCompte("697%")
				 - getSumCompte("698%")
				 - getSumCompte("699%"));

		totalN = valN;
		double totalIX = totalN;

		if (compareN1) {
			valN1 = -(getSumCompteN1("69%")
					 	- getSumCompteN1("695%")
					 	- getSumCompteN1("696%")
					 	- getSumCompteN1("697%")
						- getSumCompteN1("698%")
					 	- getSumCompteN1("699%"));

			totalN1 = valN1;
		}

		double totalIXN1 = totalN1;

		putLigneRES(listing, "Participation des salari\u00E9s aux r\u00E9sultats de l'entreprise (IX)", totalIX, totalIXN1);

		if (detailRES) {
			putDetailSection(listing, "69%' and c.Numero_Compte not like '695%' and c.Numero_Compte not like '696%' and c.Numero_Compte not like '697%' and c.Numero_Compte not like '698%' and c.Numero_Compte not like '699%");
			putEspacement(listing, 5);
		}

		valN = -(getSumCompte("689%")
				 + getSumCompte("695%")
				 + getSumCompte("696%")
				 + getSumCompte("697%")
				 + getSumCompte("698%")
				 + getSumCompte("699%")
				 + getSumCompte("789%"));

		totalN += valN;
		double totalX = totalN;

		if (compareN1) {
			valN1 = -(getSumCompteN1("689%")
						+	getSumCompteN1("695%")
					 	+ getSumCompteN1("696%")
					 	+ getSumCompteN1("697%")
						+ getSumCompteN1("698%")
					 	+ getSumCompteN1("699%")
						+ getSumCompteN1("789%"));

			totalN1 += valN1;
		}

		double totalXN1 = totalN1;

		putLigneRES(listing, "Impts sur les b\u00E9n\u00E9fices (X)", totalX, totalXN1);

		if (detailRES) {
			putDetailSection(listing, "689%");
			putDetailSection(listing, "695%");
			putDetailSection(listing, "696%");
			putDetailSection(listing, "697%");
			putDetailSection(listing, "698%");
			putDetailSection(listing, "699%");
			putDetailSection(listing, "789%");
			putEspacement(listing, 5);
		}

		putEspacement(listing, 10);

		putSection(listing, "TOTAL DES PRODUITS (I+III+V+VII)", totalI+totalIII+totalV+totalVII, totalIN1+totalIIIN1+totalVN1+totalVIIN1);
		putSection(listing, "TOTAL DES CHARGES (II+IV+VI+VIII+IX+X)", totalII+totalIV+totalVI+totalVIII+totalIX+totalX, totalIIN1+totalIVN1+totalVIN1+totalVIIIN1+totalIXN1+totalXN1);

		putTotalSection(listing, "5 - BENEFICE OU PERTE (Total des produits - Total des charges)", totalI+totalIII+totalV+totalVII-totalII-totalIV-totalVI-totalVIII-totalIX-totalX, totalIN1+totalIIIN1+totalVN1+totalVIIN1-totalIIN1-totalIVN1-totalVIN1-totalVIIIN1-totalIXN1-totalXN1);

	}

	private double getSumCompte(String like) throws SQLException, Exception {

		double val = 0;
		String request = "select sum(Montant_D) as debit, sum(Montant_C) as credit from "+ baseDossier +".COMPTE c,"+ base +".OPERATION o where o.Date_Op>="+ debutPeriode +" and o.Date_Op<="+ finPeriode +" and c.Numero_Compte=o.Numero_Compte and c.Numero_Compte like '"+ like +"'";


		Statement stt = con.createStatement();
		ResultSet rset = stt.executeQuery(request);

		if (rset.next()) {

			val = rset.getDouble("credit") - rset.getDouble("debit");
		}
		rset.close();

		stt.close();

		return val;

	}

	private double getSumCompteN1(String like) throws SQLException, Exception {

		double val = 0;
		String request = "select sum(Total_Debit) as debit, sum(Total_Credit) as credit from "+ baseN1 +".SOLDE_COMPTE where Numero_Compte like '"+ like +"'";


		Statement stt = con.createStatement();
		ResultSet rset = stt.executeQuery(request);

		if (rset.next()) {

			val = rset.getDouble("credit") - rset.getDouble("debit");
		}
		rset.close();

		stt.close();

		return val;
	}


	private void putDetailSection(PdfPTable listing, String like) throws SQLException, Exception {

		double solde = 0;
		double soldeN1 = 0;
		String libelle;
		String numero;
		ResultSet rsetN1;
		ResultSet rsetN;

		String request = "select Intitule, Numero_Compte from "+ baseDossier +".COMPTE c where Numero_Compte like '"+ like +"'";

		Statement stt = con.createStatement();

		PreparedStatement ps = con.prepareStatement("select sum(Montant_D) as debit, sum(Montant_C) as credit from "+ baseDossier +".COMPTE c,"+ base +".OPERATION o where o.Date_Op>="+ debutPeriode +" and o.Date_Op<="+ finPeriode +" and c.Numero_Compte=o.Numero_Compte and c.Numero_Compte=?");
		PreparedStatement ps1 = con.prepareStatement("select Total_Debit, Total_Credit from "+ baseN1 +".SOLDE_COMPTE where Numero_Compte=?");

		ResultSet rset = stt.executeQuery(request);

		while (rset.next()) {
			libelle = rset.getString("Intitule");
			numero = rset.getString("Numero_Compte");

			ps.clearParameters();
			ps.setString(1, numero);

			rsetN = ps.executeQuery();

			if (rsetN.next()) {

				solde = rsetN.getDouble("credit") - rsetN.getDouble("debit");
				solde = numero.charAt(0)=='6'?-solde:solde;
			}
			rsetN.close();

			if (compareN1) {

				ps1.clearParameters();
				ps1.setString(1, numero);

				rsetN1 = ps1.executeQuery();

				if (rsetN1.next()) {

					soldeN1 = rsetN1.getDouble("Total_Credit") - rsetN1.getDouble("Total_Debit");
					soldeN1 = numero.charAt(0)=='6'?-soldeN1:soldeN1;
				}
				rsetN1.close();
			}

			solde = (solde>=0.01 || solde<=-0.01)?solde:0;
			soldeN1 = (soldeN1>=0.01 || soldeN1<=-0.01)?soldeN1:0;

			if (solde!=0 || soldeN1!=0) {
				putLigneDetail(listing, numero, libelle, solde, soldeN1);
			}
		}
		rset.close();

		stt.close();
		ps.close();
		ps1.close();
	}


	private void putLigneDetail(PdfPTable listing, String numero, String libelle, double soldeN, double soldeN1) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cellListing.setColspan(3);
		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cellListing.setPaddingLeft(30);
		cellListing.setPhrase(new Phrase(numero +" "+ libelle, fontLine));
		listing.addCell(cellListing);

		cellListing.setPaddingLeft(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setColspan(1);

		cellListing.setPhrase(new Phrase(soldeN==0?"":numFormat.format(soldeN), fontLine));
		listing.addCell(cellListing);

		if (this.compareN1) {
			cellListing.setPhrase(new Phrase(soldeN1==0?"":numFormat.format(soldeN1), fontLine));
			listing.addCell(cellListing);

			double soldeN1P = soldeN1;

			if (proratisation) {
				soldeN1P = soldeN1*dureeN/dureeN1;
			}

			double ecart = soldeN - soldeN1P;
			double ecartP = (ecart/soldeN1P)*100;

			ecart = ((ecart<=-0.01 || ecart>=0.01)?ecart:0);
			ecartP = ((ecartP<=-0.01 || ecartP>=0.01)?ecartP:0);

			cellListing.setPhrase(new Phrase(ecart==0?"":numFormat.format(ecart), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(ecartP==0?"":numFormat2.format(ecartP), fontLine));
			listing.addCell(cellListing);
		}

	}


	private void putLigneRES(PdfPTable listing, String intitule, double soldeN, double soldeN1) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		if (this.detailRES) {
			intitule = intitule.toUpperCase();
		}

		cellListing.setPaddingLeft(15);
		cellListing.setColspan(3);
		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase(intitule, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setColspan(1);
		cellListing.setPaddingLeft(0);

		if (this.detailRES) {
			cellListing.setBackgroundColor(new Color(210,210,210));
		}

		cellListing.setPhrase(new Phrase(soldeN==0?"":numFormat.format(soldeN), fontLine));
		listing.addCell(cellListing);

		if (this.compareN1) {
			cellListing.setPhrase(new Phrase(soldeN1==0?"":numFormat.format(soldeN1), fontLine));
			listing.addCell(cellListing);

			double soldeN1P = soldeN1;

			if (proratisation) {
				soldeN1P = soldeN1*dureeN/dureeN1;
			}

			double ecart = soldeN - soldeN1P;
			double ecartP = (ecart/soldeN1P)*100;

			ecart = ((ecart<=-0.01 || ecart>=0.01)?ecart:0);
			ecartP = ((ecartP<=-0.01 || ecartP>=0.01)?ecartP:0);

			cellListing.setPhrase(new Phrase(ecart==0?"":numFormat.format(ecart), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(ecartP==0?"":numFormat2.format(ecartP), fontLine));
			listing.addCell(cellListing);
		}

	}

	private void putLigneRES(PdfPTable listing, String intitule, double soldeEXP, double soldeN, double soldeN1) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cellListing.setPaddingLeft(15);
		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase(intitule, fontLine));
		listing.addCell(cellListing);

		cellListing.setPaddingLeft(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);

		cellListing.setPhrase(new Phrase(soldeN-soldeEXP==0?"":numFormat.format(soldeN-soldeEXP), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(soldeEXP==0?"":numFormat.format(soldeEXP), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(soldeN==0?"":numFormat.format(soldeN), fontLine));
		listing.addCell(cellListing);

		if (this.compareN1) {
			cellListing.setPhrase(new Phrase(soldeN1==0?"":numFormat.format(soldeN1), fontLine));
			listing.addCell(cellListing);

			double soldeN1P = soldeN1;

			if (proratisation) {
				soldeN1P = soldeN1*dureeN/dureeN1;
			}

			double ecart = soldeN - soldeN1P;
			double ecartP = (ecart/soldeN1P)*100;

			ecart = ((ecart<=-0.01 || ecart>=0.01)?ecart:0);
			ecartP = ((ecartP<=-0.01 || ecartP>=0.01)?ecartP:0);

			cellListing.setPhrase(new Phrase(ecart==0?"":numFormat.format(ecart), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(ecartP==0?"":numFormat2.format(ecartP), fontLine));
			listing.addCell(cellListing);
		}

	}


	private void putTotalSection(PdfPTable listing, String intitule, double soldeN, double soldeN1) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(Color.LIGHT_GRAY);
		cellListing.setMinimumHeight(20);

		cellListing.setColspan(3);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPhrase(new Phrase(intitule, new Font(Font.HELVETICA, 9, Font.BOLD)));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setColspan(1);

		cellListing.setPhrase(new Phrase(soldeN==0?"":numFormat.format(soldeN), fontLine));
		listing.addCell(cellListing);

		if (this.compareN1) {
			cellListing.setPhrase(new Phrase(soldeN1==0?"":numFormat.format(soldeN1), fontLine));
			listing.addCell(cellListing);

			double soldeN1P = soldeN1;

			if (proratisation) {
				soldeN1P = soldeN1*dureeN/dureeN1;
			}

			double ecart = soldeN - soldeN1P;
			double ecartP = (ecart/soldeN1P)*100;

			ecart = ((ecart<=-0.01 || ecart>=0.01)?ecart:0);
			ecartP = ((ecartP<=-0.01 || ecartP>=0.01)?ecartP:0);

			cellListing.setPhrase(new Phrase(ecart==0?"":numFormat.format(ecart), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(ecartP==0?"":numFormat2.format(ecartP), fontLine));
			listing.addCell(cellListing);
		}

	}

	private void putSection(PdfPTable listing, String intitule, double soldeN, double soldeN1) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setMinimumHeight(20);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(30);

		cellListing.setColspan(3);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.TOP);
		cellListing.setPhrase(new Phrase(intitule, new Font(Font.HELVETICA, 9, Font.BOLD)));
		listing.addCell(cellListing);

		cellListing.setBackgroundColor(Color.LIGHT_GRAY);
		cellListing.setPaddingRight(5);
		cellListing.setColspan(1);

		cellListing.setPhrase(new Phrase(soldeN==0?"":numFormat.format(soldeN), fontLine));
		listing.addCell(cellListing);

		if (this.compareN1) {
			cellListing.setPhrase(new Phrase(soldeN1==0?"":numFormat.format(soldeN1), fontLine));
			listing.addCell(cellListing);

			double soldeN1P = soldeN1;

			if (proratisation) {
				soldeN1P = soldeN1*dureeN/dureeN1;
			}

			double ecart = soldeN - soldeN1P;
			double ecartP = (ecart/soldeN1P)*100;

			ecart = ((ecart<=-0.01 || ecart>=0.01)?ecart:0);
			ecartP = ((ecartP<=-0.01 || ecartP>=0.01)?ecartP:0);

			cellListing.setPhrase(new Phrase(ecart==0?"":numFormat.format(ecart), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(ecartP==0?"":numFormat2.format(ecartP), fontLine));
			listing.addCell(cellListing);
		}

	}

	private void putCA(PdfPTable listing, double soldeEXP, double soldeN, double soldeN1) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setMinimumHeight(20);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(30);

		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase("CHIFFRE D'AFFAIRES NET", new Font(Font.HELVETICA, 9, Font.BOLD)));
		listing.addCell(cellListing);

		cellListing.setBackgroundColor(Color.LIGHT_GRAY);
		cellListing.setPaddingRight(5);

		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT + PdfPCell.BOTTOM);
		cellListing.setPhrase(new Phrase(soldeN-soldeEXP==0?"":numFormat.format(soldeN-soldeEXP), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(soldeEXP==0?"":numFormat.format(soldeEXP), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(soldeN==0?"":numFormat.format(soldeN), fontLine));
		listing.addCell(cellListing);

		if (this.compareN1) {
			cellListing.setPhrase(new Phrase(soldeN1==0?"":numFormat.format(soldeN1), fontLine));
			listing.addCell(cellListing);

			double soldeN1P = soldeN1;

			if (proratisation) {
				soldeN1P = soldeN1*dureeN/dureeN1;
			}

			double ecart = soldeN - soldeN1P;
			double ecartP = (ecart/soldeN1P)*100;

			ecart = ((ecart<=-0.01 || ecart>=0.01)?ecart:0);
			ecartP = ((ecartP<=-0.01 || ecartP>=0.01)?ecartP:0);

			cellListing.setPhrase(new Phrase(ecart==0?"":numFormat.format(ecart), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(ecartP==0?"":numFormat2.format(ecartP), fontLine));
			listing.addCell(cellListing);
		}

	}


	private void putTitreSection(PdfPTable listing, String intitule) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setMinimumHeight(20);
		cellListing.setPaddingLeft(10);

		cellListing.setColspan(3);
		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase(intitule, new Font(Font.HELVETICA, 9, Font.BOLD)));
		listing.addCell(cellListing);

		cellListing.setColspan(1);
		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);

		if (this.compareN1) {
			listing.addCell(cellListing);
			listing.addCell(cellListing);
			listing.addCell(cellListing);
		}

	}

	private void putTitreSectionFE(PdfPTable listing, String intitule) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setMinimumHeight(20);
		cellListing.setPaddingLeft(10);

		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase(intitule, new Font(Font.HELVETICA, 9, Font.BOLD)));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);
		listing.addCell(cellListing);
		listing.addCell(cellListing);

		if (this.compareN1) {
			listing.addCell(cellListing);
			listing.addCell(cellListing);
			listing.addCell(cellListing);
		}

	}

	private void putEspacement(PdfPTable listing, int space) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(space);
		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase("", fontLine));

		cellListing.setColspan(3);
		listing.addCell(cellListing);
		cellListing.setColspan(1);
		listing.addCell(cellListing);

		if (this.compareN1) {
			listing.addCell(cellListing);
			listing.addCell(cellListing);
			listing.addCell(cellListing);
		}

	}

	private void putEspacementFE(PdfPTable listing, int space) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(space);
		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase("", fontLine));

		listing.addCell(cellListing);
		listing.addCell(cellListing);
		listing.addCell(cellListing);
		listing.addCell(cellListing);

		if (this.compareN1) {
			listing.addCell(cellListing);
			listing.addCell(cellListing);
			listing.addCell(cellListing);
		}

	}

} // fin GenPdfResultat
