/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un avoir standard
 */

package org.opensi.compta.actions.etats;


import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;


public class DataRechEcriture {


	private DecimalFormatSymbols dfs2 = new DecimalFormatSymbols();
	
	private DecimalFormat numFormatQte = new DecimalFormat("0.##");
	// les lignes d'ecriture
	protected ArrayList<LigneEcriture> lignes = new ArrayList<LigneEcriture>();
	


	// coordonnes socit mettrice

	protected String raisonSociale;
	protected String adresse;	
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	
	protected int numClasse;
	protected String libClasse;
	protected int Niveau;
	protected int code;
	
	String Numero_Compte="";
  String lettrage="";
  String commentaire="";
  double debit=0;
  double debitinf=0;
  double debitsup=0;
  double credit=0;
  double creditinf =0;
  double creditsup= 0;
  long date=0;
  long dateinf=0;
  long datesup=0;
  long echeance=0;
  String libelle="";
  String numpiece="";
  String codejournal="";

	
	public DataRechEcriture(Session s,  ServletRequest r) {	
		try {
		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
				String dossierId = s.getCookie().get("Dossier_Id");
				String base = s.getCookie().get("BaseExo");
				String basedossier=s.getCookie().get("BaseDossier");		
		
				Numero_Compte=r.getParameter("Numero_Compte");
			   	lettrage=r.getParameter("Lettrage");
			   	
			   	if (!r.getParameter("debit").equals("")){
			   		debit=new Double( r.getParameter("debit"));
			   	}
			   	if (!r.getParameter("debitinf").equals("")){
			   		debitinf=new Double( r.getParameter("debitinf"));
			   	}
			   	if (!r.getParameter("debitsup").equals("")){
			   		debitsup=new Double(r.getParameter("debitsup"));
			   	}
			   	if (!r.getParameter("credit").equals("")){
			   		credit=new Double(r.getParameter("credit"));
			   	}
			   	if (!r.getParameter("creditinf").equals("")){
			   		creditinf = new Double(r.getParameter("creditinf"));
			   	}
			 	if (!r.getParameter("creditsup").equals("")){
			 		creditsup= new Double(r.getParameter("creditsup"));
			   	}
			 	if (!r.getParameter("creditinf").equals("")){
			   		creditinf = new Double(r.getParameter("creditinf"));
			   	}
			 
			 	if (!r.getParameter("date").equals("0")){
			 		date= DateTime.parseDate(r.getParameter("date"), "yyyy:MM:dd");
			   	}
			 	if (!r.getParameter("dateinf").equals("0")){
			 		dateinf= DateTime.parseDate(r.getParameter("dateinf"),"yyyy:MM:dd");
			   	}
			 	if (!r.getParameter("datesup").equals("0")){
			 		datesup=DateTime.parseDate(r.getParameter("datesup"),"yyyy:MM:dd");
			   	}
			 	if (!r.getParameter("Libelle").equals("")){
			 		libelle=r.getParameter("Libelle");
			   	}
			 	if (!r.getParameter("Num_Piece").equals("")){
			 		numpiece=r.getParameter("Num_Piece");
			   	}
			 	if (!r.getParameter("Code_Journal").equals("")){
			 		codejournal=r.getParameter("Code_Journal");	  	
			   	}
			   	
			   	
			   	ResultSet rset;
			
			dfs2.setDecimalSeparator('.');
			numFormatQte.setDecimalFormatSymbols(dfs2);
			
			// Paramtres dossier
      
			String reqCom = "select * from "+ basedossier +".SOCIETE";
			
			rset = stt.executeQuery(reqCom);
						
			if (rset.next()) {
				
				this.raisonSociale = rset.getString("Denomination");
				this.adresse = rset.getString("Adresse_1");				
				this.codePostal = rset.getString("Code_Postal");
				this.ville = rset.getString("Ville");
				this.tel = rset.getString("Telephone");
				this.fax = rset.getString("Fax");
				this.email = rset.getString("Email");
			
			}		
	
			// selection des lignes du plan comptable gnral
			ResultSet rset2;
			Statement stt2 = con.createStatement();
			
			
			String reqRech = "select * from "+base+".OPERATION o, "+base+".ECRITURE e where o.Ecriture_Id=e.Ecriture_Id";

			  if(!Numero_Compte.equals("")){
				  reqRech +=  " and Numero_Compte like '"+Numero_Compte+"%'";
			   
			  }
			  if(debit!=0){
				  reqRech +=  " and Montant_D="+debit;
			   
			  }
			  if(debitsup!=0){
				  reqRech +=  " and Montant_D<="+debitsup;
			   
			  }
			  if(debitinf!=0){
				  reqRech +=  " and Montant_D>="+debitinf;
			   
			  }
			  if(credit!=0){
				  reqRech +=  " and Montant_C="+credit;
			   
			  }
			  if(creditsup!=0){
				  reqRech +=  " and Montant_C<="+creditsup;
			   
			  }
			  if(creditinf!=0){
				  reqRech +=  " and Montant_C>="+creditinf;
			   
			  }
			  if(date!=0){
				  reqRech +=  " and Date_Op="+date;
			   
			  }
			  if(datesup!=0){
				  reqRech +=  " and Date_Op<="+datesup;
			   
			  }
			  if(dateinf!=0){
				  reqRech +=  " and Date_Op>="+dateinf;
			   
			  }
			
			  if(!libelle.equals("")){
				  reqRech +=  " and Libelle like  '%"+libelle+"%'";
			   
			  }

			  if(!numpiece.equals("")){
				  reqRech +=  " and Num_Piece='"+numpiece+"'";
			   
			  }
			  if(!codejournal.equals("")){
				  reqRech +=  " and Code_Journal='"+codejournal+"'";
			   
			  }
			  if(lettrage.equals("L")){
				  reqRech +=  " and Lettre<>''";
			   
			  }
			  if(lettrage.equals("N")){
				  reqRech +=  " and Lettre=''";
			   
			  }
			  reqRech +=" order by Date_Op, Op_Id";
			
			  
		
			rset2 = stt2.executeQuery(reqRech);
			 SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
				
			while(rset2.next()) {	
				
				LigneEcriture le=new LigneEcriture();	
				
				if (rset2.getLong("Date_Op")!=0){
					le.date =formatDate.format(new Date(rset2.getLong("Date_Op")));
				}
				else{
					le.date ="";
				}
				le.codejournal = rset2.getString("Code_Journal");
				
				le.Numero_Compte = rset2.getString("Numero_Compte");	
				le.lettrage =rset2.getString("Lettre");				
				le.commentaire =rset2.getString("Commentaire");
				le.libelle =rset2.getString("Libelle");

				if (rset2.getLong("Date_Echeance")!=0){
					le.echeance=formatDate.format(new Date(rset2.getLong("Date_Echeance")));
				}
				else{
					le.echeance="";
				}
				
				le.debit =rset2.getDouble("Montant_D");
				
				le.credit=rset2.getDouble("Montant_C");
				le.numpiece =rset2.getString("Num_Piece");
				lignes.add(le);
			}
			rset.close();
			stt.close();			
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	
	public int getNbLignes() {
		return lignes.size();
	}
	

	

	
	
} 
