/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.bo;


import java.sql.*;

import java.util.ArrayList;

import org.opensi.dbm.dossier.DBM_Journal;
import org.opensi.dbm.dossier.DBM_Exercice;
import org.opensi.dbm.general.DBM_Dossier;
import org.opensi.dbm.dossier.DBM_Compte;
import org.opensi.data.dossier.Journal;



public class BO_Journaux {

	private Connection con;
	private String baseDossier;


	public BO_Journaux(Connection con, String baseDossier) {
		
		this.con = con;
		this.baseDossier = baseDossier;
	}


	public boolean isAssignableJournal(String codeJournal) throws SQLException {
		
		DBM_Journal dbmJournal = new DBM_Journal(con, baseDossier);
		Journal journal = dbmJournal.load(codeJournal);

		return journal!=null && journal.getTypeJournal()!="AN";
	}
	
	
	public boolean isUsed(String codeJournal) throws SQLException {
		
		boolean ok = false;
		
		String reqJournal = "select 1 from PROFIL_DOSSIER_JOURNAL where Code_Journal=?";
		reqJournal += " union select 2 from "+ baseDossier +".MODE_REGLEMENT where Code_Journal=?";
		reqJournal += " union select 3 from "+ baseDossier +".BANQUE where Code_Journal=?";
		reqJournal += " union select 4 from "+ baseDossier +".RAPPROCHEMENT where Code_Journal=?";
		reqJournal += " union select 5 from "+ baseDossier +".PARAM_DOSSIER where Code_Journal_Achat=? or Code_Journal_Vente=? or Code_Journal_Regul=? or Code_Journal_AN=? or Code_Journal_Acpte=?";
		PreparedStatement psJournalUsed = con.prepareStatement(reqJournal);
		psJournalUsed.setString(1, codeJournal);
		psJournalUsed.setString(2, codeJournal);
		psJournalUsed.setString(3, codeJournal);
		psJournalUsed.setString(4, codeJournal);
		psJournalUsed.setString(5, codeJournal);
		psJournalUsed.setString(6, codeJournal);
		psJournalUsed.setString(7, codeJournal);
		psJournalUsed.setString(8, codeJournal);
		psJournalUsed.setString(9, codeJournal);
		ResultSet rset = psJournalUsed.executeQuery();
		if (rset.next()) { ok = true; }
		rset.close();
		psJournalUsed.close();
		
		DBM_Exercice dbmExercice = new DBM_Exercice(con, baseDossier);
		ArrayList<String> listeBE = dbmExercice.getBasesExercices();
		int i=0;
		int nbExercices = listeBE.size();

		while (!ok && i<nbExercices) {
			String reqJournalCpta = "select 1 from "+ listeBE.get(i) +".ECRITURE where Code_Journal=?";
			reqJournalCpta += " union select 2 from "+ listeBE.get(i) +".NB_OP_JOURNAUX where Code_Journal=?";
			PreparedStatement psJournalCptaUsed = con.prepareStatement(reqJournalCpta);
			psJournalCptaUsed.setString(1, codeJournal);
			psJournalCptaUsed.setString(2, codeJournal);
			ResultSet rsJU = psJournalCptaUsed.executeQuery();
			if (rsJU.next()) { ok = true; }
			rsJU.close();
			psJournalCptaUsed.close();
			i++;
		}
		
		return ok;
	}	
	
	
	public void deleteJournal(String codeJournal) throws SQLException {

		DBM_Journal dbmJournal = new DBM_Journal(con, baseDossier);
		dbmJournal.delete(codeJournal);
	}
	
	
	public void saveJournal(Journal journal) throws SQLException {
	
		if (journal.isValid()) {		
			
			DBM_Journal dbmJournal = new DBM_Journal(con, baseDossier);
			
			if (dbmJournal.exist(journal.getCodeJournal())) {				
				dbmJournal.update(journal);
			}
			else {
				dbmJournal.insert(journal);
			}
		}
	}
	
	
	public void copyJournauxFromDossier(String dossierSrc) throws SQLException {
				
		DBM_Dossier dbmDossier = new DBM_Dossier(con);
		
		String fromBase = dbmDossier.getBase(dossierSrc);
		
		DBM_Journal dbmJournal = new DBM_Journal(con, fromBase);
		DBM_Compte dbmCompte = new DBM_Compte(con, baseDossier);
		
		PreparedStatement psJournaux = con.prepareStatement("select a.Code_Journal from "+ fromBase +".JOURNAL a left join "+ baseDossier +".JOURNAL b on a.Code_Journal=b.Code_Journal where b.Code_Journal is null");
		ResultSet rset = psJournaux.executeQuery();
		
		while (rset.next()) {
			Journal journal = dbmJournal.load(rset.getString(1));
			if (!dbmCompte.exist(journal.getContrepartie())) {
				journal.setContrepartie(null);
			}			
			this.saveJournal(journal);
		}		
	}
	
	
	public boolean isJournalAN(String codeJournal) throws SQLException {
	
		DBM_Journal dbmJournal = new DBM_Journal(con, baseDossier);
		String typeJournal = dbmJournal.getTypeJournal(codeJournal);
		
		return typeJournal!=null && typeJournal.equalsIgnoreCase("AN");
	}
	
	
	public boolean isJournalOD(String codeJournal) throws SQLException {
	
		DBM_Journal dbmJournal = new DBM_Journal(con, baseDossier);
		String typeJournal = dbmJournal.getTypeJournal(codeJournal);
		
		return typeJournal!=null && typeJournal.equalsIgnoreCase("OD");
	}
	
	
	public static boolean checkStxCodeJournal(String codeJournal) {
	
		return codeJournal!=null && java.util.regex.Pattern.matches("[a-zA-Z][a-zA-Z0-9]{1,2}", codeJournal);
	}

	
	public static boolean isTypeJournal(String typeJournal) {
	
		return typeJournal!=null && java.util.regex.Pattern.matches("(TR)|(AC)|(AN)|(VE)|(OD)", typeJournal);
	}
	

} // fin BO_Journaux
