/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.ecritures;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.bo.BO_Ecritures;
import org.opensi.bo.BO_Journaux;
import org.opensi.util.sql.SqlUtils;
import org.opensi.util.tools.DateTime;


public class DeleteEcrituresJournal implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();	
		
		
		int numExerciceSrc = param.getIntParameter("ExerciceSrc");
		String journalSrc = param.getParameter("JournalSrc");	
		
		long periodeDebut = param.getPeriodeParameter("PeriodeDebut");
		long periodeFin = param.getPeriodeParameter("PeriodeFin");
		
		String choix = param.getParameter("TypeSel");
		
		int numEcrDebut = 0;
		int numEcrFin = 0;
		int jourDebut = 0;
		int jourFin = 0;
		
		if (choix.equals("B")) {
			numEcrDebut = param.getIntParameter("NumEcrDebut");
			numEcrFin = param.getIntParameter("NumEcrFin");
		} else if (choix.equals("C")) {
			jourDebut = param.getIntParameter("JourDebut");
			jourFin = param.getIntParameter("JourFin");
		}
		
		Statement stt = con.createStatement();
		ResultSet rset = stt.executeQuery("select Nom_Base from "+ baseDossier +".EXERCICE where Num_Exercice="+ numExerciceSrc);

		rset.next();
		
		String baseSrc = rset.getString("Nom_Base");
		stt.close();
		
		
		String reqEcr = "select distinct e.Ecriture_Id from "+ baseSrc +".ECRITURE e"
									+" join "+ baseSrc +".OPERATION o on e.Ecriture_Id=o.Ecriture_Id"
									+" left join "+ baseDossier +".LIGNE_RAPPROCHEMENT r on o.Op_Id=r.Op_Id and r.Nom_Base='"+ baseSrc +"'"
									+" where r.Op_Id is null and e.Date_Ecriture>=? and e.Date_Ecriture<=?";
		
		if (choix.equals("B")) {
			reqEcr += " and e.Numero>=? and e.Numero<=?";
		}
		else if (choix.equals("C")) {			
			
			reqEcr += " and (";
			
			DateTime currentPeriode = new DateTime(periodeDebut);
		
			while (currentPeriode.getDateInMillis()<=periodeFin) {				
				
				int maxDay = currentPeriode.currentMaxDay();				
				    	 	
				currentPeriode.setDay(jourDebut<maxDay?jourDebut:maxDay);

				long dateDebut = currentPeriode.getDateInMillis();

				currentPeriode.setDay(jourFin<maxDay?jourFin:maxDay);
				
				long dateFin = currentPeriode.getDateFullTime();
				
				currentPeriode.addMonth(1);
				
				reqEcr += "(o.Date_Op>="+ dateDebut +" and o.Date_Op<="+ dateFin +") or ";
			}
			
			reqEcr += "false)";	
		}
		
		if (!journalSrc.equals("Tous")) {
			reqEcr += " and Code_Journal=?";
		}
		
		PreparedStatement psEcr = con.prepareStatement(reqEcr);
		
		psEcr.setLong(1, periodeDebut);
		psEcr.setLong(2, periodeFin);
		
		if (choix.equals("B")) {
			psEcr.setInt(3, numEcrDebut);
			psEcr.setInt(4, numEcrFin);
			if (!journalSrc.equals("Tous")) {
				psEcr.setString(5, journalSrc);
			}
		}
		else if (!journalSrc.equals("Tous")) {
			psEcr.setString(3, journalSrc);
		}
		
		String listeEcr = "";
		
		rset = psEcr.executeQuery();
		while (rset.next()) {
			listeEcr += rset.getInt(1) +",";
		}
		
		listeEcr = SqlUtils.normalizeCSList(listeEcr);
		
		psEcr.close();
		
		BO_Ecritures boEcritures = new BO_Ecritures(con, baseDossier, baseSrc);
		BO_Journaux boJournaux = new BO_Journaux(con, baseDossier);
		
		if (listeEcr.equals("")) {
			error.addError(1, "Il n'existe pas d'\u00E9critures dans la s\u00E9lection !");
		}
		else if (!journalSrc.equals("Tous") && boJournaux.isJournalAN(journalSrc)) {
			error.addError(1, "Vous ne pouvez pas supprimer des \u00E9critures d'\u00E0 nouveau !");
		}
		else if (!boEcritures.checkEcrNonLettrees(listeEcr)) {		  
			error.addError(1, "Impossible de supprimer les \u00E9critures car il existe des \u00E9critures lettr\u00E9es sur la s\u00E9lection !");
		}
		else {
			
			String ids[] = listeEcr.split(",");			
	       
	    for (int i=0; i<ids.length; i++) {
			     
				boEcritures.deleteEcriture(Integer.parseInt(ids[i]));
	    }
	    			
			result.addEntity("NbEcrSup", ids.length);
			result.addEntity("NonTransRB", boEcritures.getNbEcrInRB(listeEcr));
		}
		
	}
	

} // fin DeleteEcrituresJournal

