/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.commandeclient;


import java.sql.Connection;

import org.opensi.api.ActionError;
import org.opensi.api.ActionOSI;
import org.opensi.api.LeevElement;
import org.opensi.api.Parameters;
import org.opensi.api.SessionOSI;
import org.opensi.bo.commandeclient.BOCommandeClient;
import org.opensi.data.dossier.CommandeClient;
import org.opensi.data.dossier.HistoriqueCommandeClient;
import org.opensi.data.dossier.LigneCommandeClient;
import org.opensi.dbm.dossier.DBM_CommandeClient;
import org.opensi.dbm.dossier.DBM_HistoriqueCommandeClient;
import org.opensi.dbm.dossier.DBM_LigneCommandeClient;
import org.opensi.facturation.StockManager;
import org.opensi.util.tools.DateTime;



public class DeleteLigneCommande implements ActionOSI {
	
	DBM_LigneCommandeClient dbmLigneComCli = null;
	BOCommandeClient boComCli = null;
	
	public void processAction(SessionOSI sosi, Parameters param,LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();
		int user = sosi.getUtilisateurId();
		
		int ligneId = param.getIntParameter("Ligne_Id");
		
		DBM_CommandeClient dbmComCli = new DBM_CommandeClient(con, baseDossier); 
		DBM_HistoriqueCommandeClient dbmHistComCli = new DBM_HistoriqueCommandeClient(con, baseDossier); 
		dbmLigneComCli = new DBM_LigneCommandeClient(con, baseDossier); 
		boComCli = new BOCommandeClient(con,baseDossier);
		
		LigneCommandeClient ligneCommandeClient = dbmLigneComCli.load(ligneId);
		int commandeId = boComCli.getLigneCommandeId(ligneId);
		CommandeClient commandeClient = dbmComCli.load(commandeId);

		if (commandeClient.getBloque()) {
			error.addError(1001, "Impossible de modifier la commande car celle-ci est bloqu\u00E9e !");
		}
		if (boComCli.isCloturee(commandeClient)) {
			error.addError(1002, "Impossible de modifier la commande car celle-ci est cl\u00F4tur\u00E9e !");
		}
		if (boComCli.hasDocumentEnCours(commandeClient.getCommandeId())) {
			error.addError(1003, "Impossible de modifier la commande car celle-ci est li\u00E9e \u00E0 des documents en cours !");
		}
		if ((commandeClient.getEtat().equals("T")) && (boComCli.getLigneQuantiteLivree(ligneId)>0)) {
			error.addError(1025, "Impossible de supprimer l'article car celui-ci a d\u00E9j\u00E0 \u00E9t\u00E9 livr\u00E9 !");
		}
		if (error.isEmpty()) {
			if (commandeClient.getEtat().equals("T")) {
				HistoriqueCommandeClient histComCli = new HistoriqueCommandeClient(0,new DateTime().getTimeInMillis(),"",commandeClient.getCommandeId(),user, ligneCommandeClient.getLigneId());
				histComCli.setLibelle("Suppression de l'article "+ligneCommandeClient.getReference());
				dbmHistComCli.save(histComCli);
		
				ligneCommandeClient.setStatut("A");
				dbmLigneComCli.update(ligneCommandeClient);
				StockManager stock = new StockManager (con,baseDossier);
				if (ligneCommandeClient.getTypeLigne().equals("S")) {
					stock.decComClients(ligneCommandeClient.getReference(), ligneCommandeClient.getQuantite(),commandeClient.getNumero(),"Modification Commande");
				}
				boComCli.majStatuts(commandeId, user);
			}
			else {
				dbmLigneComCli.delete(ligneId);
			}
			boComCli.majTotaux(commandeId);
			dbmComCli.majModifCommande(commandeId, user);
		}
	}
	
} // fin

