/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.gencode;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Category;
import org.experlog.db.ESDBDataSet;
import org.experlog.openeas.api.VectorDataSet;

public class UserObject {
    String name_;
    Class aclass_;
    Object obj_;
    String type_;
    Category logger_ = null;
    String sessionId_;
    boolean persist_ = false;

    public UserObject(Object obj, String name, Category logger) throws Exception {
        this.obj_ = obj;
        this.name_ = name;
        this.logger_ = logger;
        try {
            if (obj == null) {
                this.type_ = name;
                this.aclass_ = Class.forName(name);
            } else {
                this.type_ = this.obj_.getClass().getName();
                this.aclass_ = Class.forName(this.type_);
            }
        }
        catch (Exception e) {
            this.logger_.debug((Object)("UserObject(" + obj + "," + name + "): can't guess class name, default java.lang.Object: " + e));
            this.type_ = "java.lang.Object";
            this.aclass_ = Class.forName(this.type_);
        }
    }

    public UserObject(String line, int lnb, Hashtable uObjects, Hashtable sObjects, Category logger) throws Exception {
        String className;
        this.logger_ = logger;
        line = line.trim();
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line, lnb));
        }
        String persist = st.nextToken();
        if (persist.equalsIgnoreCase("isPersist")) {
            this.persist_ = true;
            this.name_ = st.nextToken();
        } else {
            this.name_ = persist;
        }
        if (!st.hasMoreTokens()) {
            throw new IOException(this.syntaxError(line, lnb));
        }
        String c = line.substring(line.indexOf(this.name_) + this.name_.length(), line.length()).trim();
        c = c.substring(1, c.length() - 1);
        this.type_ = className = c.substring(0, c.indexOf(40));
        String listParams = c.substring(c.indexOf(40) + 1, c.lastIndexOf(41));
        this.logger_.debug((Object)("className =<" + className + ">, listParams=<" + listParams + ">"));
        if (className.compareTo("String") == 0) {
            className = "java.lang.String";
        }
        if (className.compareTo("Boolean") == 0) {
            className = "java.lang.Boolean";
        }
        if (className.compareTo("Byte") == 0) {
            className = "java.lang.Byte";
        }
        if (className.compareTo("Character") == 0) {
            className = "java.lang.Character";
        }
        if (className.compareTo("Class") == 0) {
            className = "java.lang.Class";
        }
        if (className.compareTo("Double") == 0) {
            className = "java.lang.Double";
        }
        if (className.compareTo("Float") == 0) {
            className = "java.lang.Float";
        }
        if (className.compareTo("Integer") == 0) {
            className = "java.lang.Integer";
        }
        if (className.compareTo("Long") == 0) {
            className = "java.lang.Long";
        }
        if (className.compareTo("Number") == 0) {
            className = "java.lang.Number";
        }
        if (className.compareTo("Short") == 0) {
            className = "java.lang.Short";
        }
        this.aclass_ = Class.forName(className);
        StringTokenizer pst = new StringTokenizer(listParams, "|");
        Vector vparamType = new Vector();
        Vector vparamValue = new Vector();
        this.updateVector(vparamType, vparamValue, pst);
        Class[] intArgsClass = new Class[vparamType.size()];
        Object[] pars = new Object[vparamValue.size()];
        this.updateArrays(intArgsClass, pars, vparamType, vparamValue, uObjects, sObjects);
        Constructor construct = this.aclass_.getConstructor(intArgsClass);
        this.obj_ = construct.newInstance(pars);
    }

    public Object invoke(String line, int lnb, Hashtable uObjects, Hashtable sObjects) throws Exception {
        block11: {
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            this.logger_.debug((Object)("line=<" + line + ">"));
            if (!st.hasMoreTokens()) {
                throw new IOException(this.syntaxError(line, lnb));
            }
            String rObj = st.nextToken();
            String c = line.substring(line.indexOf(rObj) + rObj.length(), line.length()).trim();
            c = c.substring(1, c.length() - 1);
            int opar = c.indexOf(40);
            int dotp = c.substring(0, opar).lastIndexOf(46);
            String initObj = c.substring(0, dotp);
            String methodName = c.substring(dotp + 1, opar);
            String paramsList = c.substring(opar + 1, c.length() - 1);
            this.logger_.debug((Object)("initObj=[" + initObj + "] methodName=[" + methodName + "] paramsList=[" + paramsList + "]"));
            StringTokenizer pst = new StringTokenizer(paramsList, "|");
            Vector vparamType = new Vector();
            Vector vparamValue = new Vector();
            this.updateVector(vparamType, vparamValue, pst);
            Class[] intArgsClass = new Class[vparamType.size()];
            Object[] pars = new Object[vparamValue.size()];
            this.updateArrays(intArgsClass, pars, vparamType, vparamValue, uObjects, sObjects);
            try {
                Method m = this.aclass_.getMethod(methodName, intArgsClass);
                Object r = m.invoke(this.obj_, pars);
                if (r instanceof ResultSet) {
                    this.logger_.debug((Object)"r instanceof ResultSet");
                    ESDBDataSet ds = new ESDBDataSet((ResultSet)r, null, null, null, null);
                    return ds;
                }
                if (r instanceof Collection) {
                    this.logger_.debug((Object)"r instanceof Collection");
                    VectorDataSet vec = null;
                    if (r instanceof Vector) {
                        vec = new VectorDataSet(1, (Vector)r);
                    } else {
                        Iterator iter = ((Collection)r).iterator();
                        Vector newvec = new Vector();
                        while (iter.hasNext()) {
                            newvec.add(iter.next());
                        }
                        vec = new VectorDataSet(1, newvec);
                    }
                    return vec;
                }
                this.logger_.debug((Object)"r instanceof <nothing> :-)");
                if (r == null) {
                    this.logger_.debug((Object)"r is null :-(");
                }
                return r;
            }
            catch (NoSuchMethodException nsme) {
                this.logger_.error((Object)("NoSuchMethodException (invoke):" + nsme + " - initObj=[" + initObj + "] methodName=[" + methodName + "] paramsList=[" + paramsList + "]"));
            }
            catch (IllegalAccessException iae) {
                this.logger_.error((Object)("IllegalAccessException (invoke):" + iae + " - initObj=[" + initObj + "] methodName=[" + methodName + "] paramsList=[" + paramsList + "]"));
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                this.logger_.error((Object)("InvocationTargetException (invoke):" + ite + " - cause: " + cause + " initObj=[" + initObj + "] methodName=[" + methodName + "] paramsList=[" + paramsList + "]"));
                if (cause == null) break block11;
                cause.printStackTrace(System.err);
            }
        }
        return null;
    }

    private void updateVector(Vector vparamType, Vector vparamValue, StringTokenizer pst) {
        while (pst.hasMoreTokens()) {
            String param = pst.nextToken().trim();
            String atype = null;
            String avalue = null;
            if (param.indexOf(40) != -1) {
                atype = param.substring(1, param.indexOf(41)).trim();
                avalue = param.substring(param.indexOf(41) + 1, param.length()).trim();
            } else {
                atype = null;
                avalue = param;
            }
            this.logger_.debug((Object)("param[" + param + "] atype=[" + atype + "] avalue=[" + avalue + "]"));
            vparamType.add(atype);
            vparamValue.add(avalue);
        }
    }

    private void updateArrays(Class[] intArgsClass, Object[] pars, Vector vparamType, Vector vparamValue, Hashtable uObjects, Hashtable sObjects) {
        int i;
        try {
            for (i = 0; i < vparamType.size(); ++i) {
                String atype = (String)vparamType.get(i);
                if (atype == null) {
                    UserObject uo = null;
                    uo = (UserObject)uObjects.get((String)vparamValue.get(i));
                    if (uo == null) {
                        uo = (UserObject)sObjects.get((String)vparamValue.get(i));
                    }
                    if (uo == null) {
                        String val = (String)vparamValue.get(i);
                        if (val.indexOf(34) != -1) {
                            intArgsClass[i] = Class.forName("java.lang.String");
                            vparamType.setElementAt("java.lang.String", i);
                        } else {
                            this.logger_.debug((Object)"we do nothing else...");
                        }
                    } else {
                        intArgsClass[i] = uo.getObjectClass();
                        vparamType.setElementAt(uo.getStringType(), i);
                        pars[i] = uo.getObject();
                    }
                } else if (atype.compareTo("String") == 0) {
                    intArgsClass[i] = Class.forName("java.lang.String");
                } else if (atype.compareTo("int") == 0) {
                    intArgsClass[i] = Integer.TYPE;
                } else if (atype.compareTo("boolean") == 0) {
                    intArgsClass[i] = Boolean.TYPE;
                } else if (atype.compareTo("float") == 0) {
                    intArgsClass[i] = Float.TYPE;
                } else if (atype.compareTo("double") == 0) {
                    intArgsClass[i] = Double.TYPE;
                } else if (atype.compareTo("char") == 0) {
                    intArgsClass[i] = Character.TYPE;
                } else if (atype.compareTo("byte") == 0) {
                    intArgsClass[i] = Byte.TYPE;
                } else if (atype.compareTo("long") == 0) {
                    intArgsClass[i] = Long.TYPE;
                } else if (atype.compareTo("short") == 0) {
                    intArgsClass[i] = Short.TYPE;
                } else {
                    this.logger_.debug((Object)"We have a properly defined object !!!!");
                    intArgsClass[i] = Class.forName(atype);
                }
                this.logger_.debug((Object)("intArgsClass[i]=<" + intArgsClass[i] + ">"));
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        for (i = 0; i < vparamValue.size(); ++i) {
            UserObject uo;
            String param = (String)vparamValue.get(i);
            String atype = (String)vparamType.get(i);
            if (atype == null) {
                uo = null;
                uo = (UserObject)uObjects.get((String)vparamValue.get(i));
                if (uo != null) {
                    pars[i] = uo.getObject();
                } else {
                    uo = (UserObject)sObjects.get((String)vparamValue.get(i));
                    if (uo != null) {
                        pars[i] = uo.getObject();
                    }
                }
            } else if (param.indexOf("\"") == 0 && param.lastIndexOf("\"") == param.length()) {
                pars[i] = new String(param.substring(1, param.length() - 1));
            } else if (((String)vparamType.get(i)).compareTo("int") == 0) {
                pars[i] = new Integer(param);
            } else if (((String)vparamType.get(i)).compareTo("boolean") == 0) {
                pars[i] = new Boolean(param);
            } else if (((String)vparamType.get(i)).compareTo("float") == 0) {
                pars[i] = new Float(param);
            } else if (((String)vparamType.get(i)).compareTo("double") == 0) {
                pars[i] = new Double(param);
            } else if (((String)vparamType.get(i)).compareTo("char") == 0) {
                pars[i] = new Character(param.charAt(0));
            } else if (((String)vparamType.get(i)).compareTo("byte") == 0) {
                pars[i] = new Byte(param);
            } else if (((String)vparamType.get(i)).compareTo("long") == 0) {
                pars[i] = new Long(param);
            } else if (((String)vparamType.get(i)).compareTo("short") == 0) {
                pars[i] = new Short(param);
            } else {
                this.logger_.debug((Object)"updateArrays: we try to get the UserObject");
                uo = null;
                if (uObjects != null) {
                    uo = (UserObject)uObjects.get((String)vparamValue.get(i));
                }
                if (uo != null) {
                    this.logger_.debug((Object)"updateArrays: uo is not null, we get it in uObjects");
                    pars[i] = uo.getObject();
                } else {
                    if (sObjects != null) {
                        uo = (UserObject)sObjects.get((String)vparamValue.get(i));
                    }
                    if (uo != null) {
                        this.logger_.debug((Object)"updateArrays: uo is not null, we get it in sObjects");
                        pars[i] = uo.getObject();
                    } else {
                        this.logger_.debug((Object)"updateArrays: uo is null, we only use the word as a string");
                        pars[i] = new String(param.substring(0, param.length()));
                    }
                }
            }
            this.logger_.debug((Object)("parse value=<" + pars[i] + ">"));
        }
    }

    public void close() {
        this.logger_ = null;
        this.type_ = null;
        this.name_ = null;
        this.aclass_ = null;
        this.obj_ = null;
    }

    protected String getName() {
        return this.name_;
    }

    protected String getStringType() {
        return this.type_;
    }

    protected Class getObjectClass() {
        return this.aclass_;
    }

    protected Object getObject() {
        return this.obj_;
    }

    private String syntaxError(String msg, int lnb) {
        return "Syntax error line " + lnb + ": " + msg;
    }

    public boolean isPersist() {
        return this.persist_;
    }
}

