/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.actions;

import org.experlog.base.ESAction;
import org.experlog.base.ESServletRequest;
import org.experlog.gencode.DynHtml;
import org.experlog.util.Client;

public class MessageDigest
implements ESAction {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public boolean serverSide() {
        return true;
    }

    public boolean processRequest(Client session, ESServletRequest req, DynHtml page, Object info) throws Exception {
        String msg = req.getParameter("MDMessage");
        if (msg == null) {
            req.addParameter("MissingField", "MDMessage");
            return false;
        }
        String algorithm = req.getParameter("MDAlgorithm");
        if (algorithm == null) {
            algorithm = "MD5";
        }
        java.security.MessageDigest md = java.security.MessageDigest.getInstance(algorithm);
        md.update(msg.getBytes());
        req.addParameter("MDDigest", this.hexString(md.digest()));
        return true;
    }

    private String hexString(byte[] b) {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            res.append(HEX_CHARS[(b[i] & 0xF0) >>> 4]);
            res.append(HEX_CHARS[b[i] & 0xF]);
        }
        return res.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: org.experlog.actions.MessageDigest message [algorithm]");
            System.exit(1);
        }
        String algorithm = args.length > 1 ? args[1] : "MD5";
        java.security.MessageDigest md = java.security.MessageDigest.getInstance(algorithm);
        md.update(args[0].getBytes());
        System.out.println(algorithm + " digest for message is: [" + new MessageDigest().hexString(md.digest()) + "]");
    }
}

