/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import com.sun.management.jmx.Trace;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.management.loading.MLet;

public class DefaultLoaderRepository
implements Serializable {
    protected static Vector loaders = new Vector();
    private static Hashtable search = new Hashtable();
    private static final String dbgTag = "DefaultLoaderRepository";

    private static void debug(String string, String string2) {
        DefaultLoaderRepository.debug(dbgTag, string, string2);
    }

    private static void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)1, (String)string, (String)string2, (String)string3);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)1);
    }

    private static boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)1);
    }

    public static Class loadClass(String string) throws ClassNotFoundException {
        return DefaultLoaderRepository.loadClass((Vector)loaders.clone(), string);
    }

    private static Class loadClass(Vector vector, String string) throws ClassNotFoundException {
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            try {
                ClassLoader classLoader = (ClassLoader)iterator.next();
                if (DefaultLoaderRepository.isTraceOn()) {
                    DefaultLoaderRepository.trace("loadClass", "trying loader = " + classLoader);
                }
                if (classLoader instanceof MLet) {
                    return ((MLet)classLoader).loadClassCalledFromDLR(string);
                }
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        throw new ClassNotFoundException(string);
    }

    public static Class loadClassWithout(ClassLoader classLoader, String string) throws ClassNotFoundException {
        Class clazz;
        if (DefaultLoaderRepository.isTraceOn()) {
            DefaultLoaderRepository.trace("loadClassWithout", String.valueOf(string) + "\twithout " + classLoader);
        }
        Vector vector = (Vector)loaders.clone();
        if (classLoader == null) {
            return DefaultLoaderRepository.loadClass(vector, string);
        }
        vector.removeElement(classLoader);
        DefaultLoaderRepository.startValidSearch(classLoader, string);
        try {
            clazz = DefaultLoaderRepository.loadClass(vector, string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DefaultLoaderRepository.stopValidSearch(classLoader, string);
            throw throwable;
        }
        DefaultLoaderRepository.stopValidSearch(classLoader, string);
        return clazz;
    }

    private static synchronized void startValidSearch(ClassLoader classLoader, String string) throws ClassNotFoundException {
        Vector<ClassLoader> vector = (Vector<ClassLoader>)search.get(string);
        if (vector != null && vector.contains(classLoader)) {
            if (DefaultLoaderRepository.isTraceOn()) {
                DefaultLoaderRepository.trace("startValidSearch", "already requested loader=" + classLoader + " class= " + string);
            }
            throw new ClassNotFoundException(string);
        }
        if (vector == null) {
            vector = new Vector<ClassLoader>(1);
            search.put(string, vector);
        }
        vector.addElement(classLoader);
        if (DefaultLoaderRepository.isTraceOn()) {
            DefaultLoaderRepository.trace("startValidSearch", "loader=" + classLoader + " class= " + string);
        }
    }

    private static synchronized void stopValidSearch(ClassLoader classLoader, String string) {
        Vector vector = (Vector)search.get(string);
        if (vector != null) {
            vector.removeElement(classLoader);
            if (DefaultLoaderRepository.isTraceOn()) {
                DefaultLoaderRepository.trace("stopValidSearch", "loader=" + classLoader + " class= " + string);
            }
        }
    }

    private static void trace(String string, String string2) {
        DefaultLoaderRepository.trace(dbgTag, string, string2);
    }

    private static void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)1, (String)string, (String)string2, (String)string3);
    }
}

