/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Requetes multiples d'insertion ou de suppression d'articles web.
 */

package org.opensi.webmanager.init_vente;

import java.sql.Connection;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

/**
 * Modifie le prix web de tout un groupe d'articles pour un site.
 */
public class ModifPrixGroupeArticles extends Action {

	/**
	 * 
	 * @return
	 */
	public boolean serverSide() {
		return true;
	}

	/**
	 * 
	 * @param s
	 * @param r
	 * @param info
	 * @throws java.lang.Exception
	 * @return
	 */
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		String id_article = r.getParameter("id_article");
		String famille1 = r.getParameter("famille1");
		String famille2 = r.getParameter("famille2");
		String marque = r.getParameter("marque");
		String collection = r.getParameter("collection");
		String reference = r.getParameter("reference");
		String designation = r.getParameter("designation");
		String couleur = r.getParameter("couleur");
		String taille = r.getParameter("taille");
		String typeCalcul = r.getParameter("typeCalcul");
		String valeur = r.getParameter("valeur");
		double valeur_db = Double.parseDouble(valeur);

		String base = r.getParameter("base");
		String site_id = r.getParameter("site_id");

		Connection con = s.getConnection(null);
		// Constitution de la liste des articles auquels il faut affecter un
		// prix
		// Selon le mode de calcul, on n'as pas besoin des memes infos

		String condWhere = "";

		if (id_article.equals("")) {

			// On regarde les filtres  appliquer  la requete
			if (!marque.equals("0")) {
				condWhere += " AND Marque_Id=" + marque;
			}

			if (!famille2.equals("0")) {
				condWhere += " AND Famille_2=" + famille2;
			}

			if (!famille1.equals("0")) {
				condWhere += " AND Famille_1=" + famille1;
			}

			if (!couleur.equals("0")) {
				condWhere += " AND Couleur_Id=" + couleur;
			}

			if (!collection.equals("0")) {
				condWhere += " AND Collection_Id=" + collection;
			}

			if (!taille.equals("0")) {
				condWhere += " AND Taille_Id=" + taille;
			}

			if (!reference.equals("")) {
				condWhere += " AND w.Article_Id LIKE '%" + s.sqlEncode(reference) + "%'";
			}

			if (!designation.equals("[toutes]")) {
				condWhere += " AND Designation LIKE '%" + s.sqlEncode(designation) + "%'";
			}
		}
		else {
			condWhere = " AND w.Article_Id='" + s.sqlEncode(id_article) + "'";
		}

		String calcul = "";
		String typeCalculBD = "";
		if (typeCalcul.equals("PV_WEB")) {
			calcul = "" + valeur;
			typeCalculBD = "F";
		}
		else if (typeCalcul.equals("MARGE")) {
			calcul = "a.Prix_Achat+" + valeur;
			typeCalculBD = "M";
		}
		else if (typeCalcul.equals("MARGE_PC")) {
			calcul = "a.Prix_Achat*(100/(100-" + valeur + "))";
			typeCalculBD = "MP";

		}
		else if (typeCalcul.equals("COEF_PA")) {
			calcul = "a.Prix_Achat*" + valeur;
			typeCalculBD = "PA";
		}
		else if (typeCalcul.equals("COEF_PV")) {
			calcul = "a.Tarif_1*" + valeur + "";
			typeCalculBD = "PV";
		}

		String reqMultiple = "UPDATE " + base + ".FICHE_ARTICLE_WEB w," + base + ".FICHE_ARTICLE a SET w.Prix_Web=" + calcul;
		reqMultiple += ", w.Calcul_Prix='" + typeCalculBD + "', w.Valeur_Prix=" + valeur_db
				+ " , w.Prix_Modifie=1 , w.Date_Prix_Ref=a.Date_M";
		reqMultiple += " WHERE w.Article_Id=a.Article_Id and a.Supprime=0 AND Site_Id=" + site_id + " " + condWhere;

		System.out.println("[Req qui tue]" + reqMultiple);

		Statement state = con.createStatement();
		state.executeUpdate(reqMultiple);

		s.closeConnection(con, null);

		return true;

	}

}
