/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.webmanager.fonctions_periodiques;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;

/**
 * Le manager de mise  jour permet de grer les mises  jour automatiques.
 */
public class ManagerMAJAuto {

	/**
	 * Lance le service de mise  jour automatique.
	 * 
	 * @param port
	 *          port du serveur de mise  jour automatique
	 * @param maj_id
	 *          identifiant de la mise  jour (de la table MAJ_AUTO)
	 * @param base
	 *          nom de la base de donne FACT_qquechose
	 * @param dossier
	 *          identifiant du dossier concern
	 * @param timeout
	 *          temps maximal lde rponse du webservice
	 * @param nbRapports
	 *          nombre de rapports maximum du webservice.
	 * @param taillePaquets
	 *          nombre maximum d'articles par envoi.
	 */
	public static void lancerService(int port, int maj_id, String base, String dossier, int timeout, int nbRapports, int taillePaquets) {

		try {

			Socket socket = new Socket("localhost", port);

			ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());

			out.writeObject("AJOUTJOB");
			out.writeObject("" + maj_id);
			out.writeObject(base);
			out.writeObject(dossier);
			out.writeObject("" + timeout);
			out.writeObject("" + nbRapports);
			out.writeObject("" + taillePaquets);

			socket.close();

			Thread.sleep(1000);

		}
		catch (Exception e) {
			e.printStackTrace();
		}

	}

	/**
	 * Arrete un service de mise  jour automatique.
	 * 
	 * @param port
	 *          port du serveur de mise  jour automatique
	 * @param nomJob
	 *          nom du service de mise  jour automatique. C'est son identifiant
	 *          pour le serveur de mise  jour.
	 * @param groupe_job
	 *          nom du groupe du service
	 */
	public static void arreterService(int port, String nomJob, String groupe_job) {
		try {

			Socket socket = new Socket("localhost", port);

			ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());

			out.writeObject("RETRAITJOB");
			out.writeObject(nomJob);
			out.writeObject(groupe_job);

			socket.close();

			Thread.sleep(1000);

		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Pour tester si un service de mise  jour automatique est lanc.
	 * 
	 * @param port
	 *          port du serveur de mise  jour automatique
	 * @param nom_job
	 *          Nom du service
	 * @param groupe_job
	 *          groupe du service
	 * @return vrai si le service est demarr
	 */
	public static boolean estServiceDemarre(int port, String nom_job, String groupe_job) {
		boolean rep = false;

		try {

			Socket socket = new Socket("localhost", port);

			ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
			ObjectInputStream in = new ObjectInputStream(socket.getInputStream());

			out.writeObject("ESTDEMARRE");
			out.writeObject(nom_job);
			out.writeObject(groupe_job);

			String reponse = (String) in.readObject();

			socket.close();

			rep = reponse.equals("OUI");

		}
		catch (Exception e) {
			rep = false;
		}

		return rep;

	}

	/* Retourne vrai si le service est demarr, faux sinon */
	/**
	 * Pour tester si un service est lanc
	 * 
	 * @param port
	 *          port du serveur de mise  jour automatique
	 * @return vrai si le service est en cours d'execution (pas forcment en train
	 *         d'executer la mise  jour mais lanc)
	 */
	public static boolean serveurDemarre(int port) {
		boolean estDemarre = false;
		ServerSocket ss = null;
		try {
			ss = new ServerSocket(port);

		}
		catch (Exception e) {
			estDemarre = true; // la socket est prise, il est dmarr
			System.out.println("[Manager](serveurDemarre) Erreur normale:" + e);
		}

		try {
			if (estDemarre) {
				System.out.println("[Manager](serveurDemarre)Il dmarr, Je ne le close pas");
			}
			else {
				System.out.println("[Manager](serveurDemarre)Il est pas dmarr, Je le close");
				ss.close();
			}

		}
		catch (Exception e) {
			e.printStackTrace();
		}

		return estDemarre;

	}

	/*
	 * Lance une instance du serveur de mise  jour coutant sur le port donn, si
	 * le port n'est pas pris
	 */
	/**
	 * Pour dmarrer un service automatique
	 * 
	 * @param dossier_maj
	 *          chemin vers le dossier "maj_automatiques"
	 * @param port
	 *          port du serveur de mise  jour automatique
	 * @param url_bd
	 *          url de la base de donne de OpenSi
	 * @param driver_bd
	 *          Driver de la base de donne de OpenSi
	 * @param login_bd
	 *          login pour se connecter  la base de donne de OpenSi
	 * @param mdp_bd
	 *          mot de passe pour se connecter  la base de donne de OpenSi
	 * @param dossier_root
	 *          chemin absolu vers la base du serveur de OpenSi (opensi-serveur)
	 */
	public static void demarrerServeur(int port, String url_bd, String driver_bd, String login_bd, String mdp_bd, String dossier_root,
			String dossier_maj) {
		try {

			LancementServeur lance = new LancementServeur(dossier_root, url_bd, driver_bd, login_bd, mdp_bd, port, dossier_maj);
			lance.setDaemon(false);
			lance.start();

			Thread.sleep(5000);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void stopperServeur(int port) {
		try {

			Socket socket = new Socket("localhost", port);

			ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
			out.writeObject("FIN");

			socket.close();

		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

}
