/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Permet de contruire une table globale en concatnant plusieurs PdfPTable
 */

package org.opensi.util.pdf;


import com.lowagie.text.DocumentException;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;


public class TableBuilder {


	private PdfPTable pptGlobal;


	public TableBuilder() {

		pptGlobal = new PdfPTable(1);
		pptGlobal.setWidthPercentage(100);
	}


	public TableBuilder(int []widths) throws DocumentException {

		pptGlobal = new PdfPTable(widths.length);
		pptGlobal.setWidths(widths);
		pptGlobal.setWidthPercentage(100);
	}
	

	public void add(PdfPTable ppt) {

		pptGlobal.addCell(makeCell(ppt));
	}


	public PdfPTable getTable() {

		return pptGlobal;
	}


 	public static PdfPCell makeCell(PdfPTable ppt) {

		PdfPCell cell = new PdfPCell(ppt);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPadding(0);

		return cell;
	}
	
	
	public static PdfPTable makeEmptyTable() {
	
		PdfPTable pptSpace = new PdfPTable(1);
		
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPhrase(new Phrase(""));
	
		pptSpace.addCell(cell);
	
		return pptSpace;
	}
	
	
	public static PdfPTable makeVSpace(int vSpace) {
	
		PdfPTable pptSpace = new PdfPTable(1);
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setFixedHeight(vSpace);
		cell.setPhrase(new Phrase(""));
	
		pptSpace.addCell(cell);
	
		return pptSpace;
	}


} // fin TableBuilder
