/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.util.openoffice;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

/**
 * Une cellule du tableau openoffice
 * ATTENTION le style de la cellule doit exister dans le crateur openoffice
 * La cellule ne peut tre que de deux types: string ou float
 */
public class OooCellule
{
	/**
	 * le type du contenu de la cellule est float
	 */
	public final int TYPE_FLOAT=0;
	/**
	 * le type du contenu de la cellule est String
	 */
	public final int TYPE_STRING=1;
	
	
	 
	private int type;
	private String valeur;
	private boolean estFusion;
	private int nbreColFu, nbreLigFu; //nombre de ligne et de colonnes fusionnes
	private String nomStyle;
	
	/**
	 * Constructeur d'une cellule de type String, affiche avec le style donn en paramtre.
	 * @param laValeur texte de la cellule
	 * @param leStyle style de la cellule
	 */
	public OooCellule(String laValeur, OooStyleCellule leStyle)
	{
		init(leStyle.getNomStyle());
		type=TYPE_STRING;
		valeur=laValeur;
		valeur=valeur.replaceAll("<", "&lt;");
		valeur=valeur.replaceAll(">", "&gt;");
		valeur=valeur.replaceAll("", "°");
		valeur=valeur.replaceAll("&", "&ampe;");
		valeur=valeur.replaceAll("", "é");
		valeur=valeur.replaceAll("", "è");
		valeur=valeur.replaceAll("", "ô");
		valeur=valeur.replaceAll("", "à");
		valeur=valeur.replaceAll("", "ç");
	}
	
	/**
	 * Constructeur d'une cellule de type float, affiche avec le style donn en paramtre.
	 * @param laValeur valeur de la cellule
	 * @param leStyle style de la cellule
	 */
	public OooCellule(float laValeur, OooStyleCellule leStyle)
	{
		init(leStyle.getNomStyle());
		type=TYPE_FLOAT;
		valeur=""+laValeur;
	}
	
	/**
	 * Constructeur d'une cellule de type float, affiche avec le style donn en paramtre.
	 * @param laValeur valeur de la cellule
	 * @param leStyle style de la cellule
	 */
	public OooCellule(double laValeur, OooStyleCellule leStyle)
	{
		init(leStyle.getNomStyle());
		type=TYPE_FLOAT;
		valeur=""+laValeur;
	}
	
	/**
	 * Constructeur d'une cellule de type float, affiche avec le style donn en paramtre.
	 * @param laValeur valeur de la cellule
	 * @param leStyle style de la cellule
	 */
	public OooCellule(int laValeur, OooStyleCellule leStyle)
	{
		init(leStyle.getNomStyle());
		type=TYPE_FLOAT;
		valeur=""+laValeur;
	}
	
	private void init(String leStyle)
	{
		nomStyle=leStyle;
		estFusion=false;
		nbreColFu=0;
		nbreLigFu=0;
	}
	
	/**
	 * Retourne la valeur de la cellule.
	 * @return la valeur de la cellule
	 */
	public String getValeur()
	{
		return valeur;
	}
	
	/**
	 * Retourne le type de la cellule
	 * @return la constante representant le type de la cellule
	 */
	
	public int getType()
	{
		return type;
	}
	
	
	
	/**
	 * Pour fusionner des cellules.
	 * @param nbreLignes nombre de lignes  fusionner
	 * @param nbreColonnes nbre de colones  fusionner
	 */
	public void setFusion(int nbreLignes, int nbreColonnes)
	{
		if(nbreLignes>0 && nbreColonnes>0)
		{
			estFusion=true;
			nbreLigFu=nbreLignes;
			nbreColFu=nbreColonnes;
		}
		
	}
	
	
	/**
	 * Cre la chaine de caractre  crire formate en openoffice.
	 * @return la chaine de caractre dcrivant la cellule en format openoffice
	 */
	public String toStringOoo()
	{
	String result="";
	String floate="";
	String fusion="";
	String affichage=""+valeur;
	String style="";
	
	if (type==TYPE_FLOAT)
	{
		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator(',');
		dfs.setGroupingSeparator(' ');
		
		DecimalFormat format = new DecimalFormat("0.00");
		format.setDecimalFormatSymbols(dfs);
		format.setGroupingUsed(true);
		format.setGroupingSize(3);
		
		affichage=format.format(Double.parseDouble(valeur));
		floate=" table:value-type=\"float\" table:value=\""+valeur+"\" ";
	}
	else
	{
		affichage=valeur;
	}

	if (estFusion)
	{
		fusion=" table:number-columns-spanned=\""+nbreColFu+"\" table:number-rows-spanned=\""+nbreLigFu+"\"";
	
	}
	
		style=" table:style-name=\""+nomStyle+"\"";

		result+="<table:table-cell"+style+" "+floate+" "+fusion+" >";
		
		
		result+="<text:p>"+affichage+"</text:p>";
		
		result+="</table:table-cell>";
		
		if (estFusion)
		{
			result+="<table:covered-table-cell";
			if (nbreColFu>1) result+=" table:number-columns-repeated=\""+(nbreColFu-1)+"\"";
			if (nbreLigFu>1) result+=" table:number-rows-repeated=\""+(nbreColFu-1)+"\"";
			result+=" />";
		}
		
		return result;
	}
	
}
