/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.util.calcul;

import org.opensi.util.tools.Arrondi;


public abstract class CalculVentilTVARemise {

	protected double tauxTVA;
	protected double montantBaseRemise = 0;
	protected double montantTVA = 0;
	protected double montantHT = 0;
	protected double montantTTC = 0;
	protected double montantHTRistourne = 0;
	protected double montantTTCRistourne = 0;
	protected double montantTVARemise = 0;
	protected double montantHTRemise = 0;
	protected double montantTTCRemise = 0;
	protected boolean npr = false;
	
	protected Arrondi r2 = new Arrondi(2);
	
	public CalculVentilTVARemise() {
	}
	
	public void addLigne(double tauxTVA, double montantBase, double ristourne, double pRemise, boolean ttc) {

		this.tauxTVA = tauxTVA;
		this.add(montantBase,ristourne, pRemise, ttc);
	}
	
	public abstract void add(double montantBase, double ristourne,double pRemise, boolean ttc);	
	
	public void setNPR(boolean npr) {
		this.npr = npr;
	}
	
	public double getMontantHT() { return montantHT; }   
 	public double getMontantTTC() { return montantTTC; }    
 	public double getMontantTVA() { return montantTVA; }    
	public double getMontantHTRemise() { return montantHTRemise; }   
 	public double getMontantTTCRemise() { return montantTTCRemise; }    
 	public double getMontantTVARemise() { return montantTVARemise; }    
	public double getTauxTVA() { return tauxTVA; }    
 	public boolean getNPR() { return npr; }    

} // fin VentilTVA
	

	
