/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.reglements.fournisseurs;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;


public class GenPdfEcheancesFournisseur extends Action {


	class MyPageEvent implements PdfPageEvent {

	private String dateCourante;

	private String dossierId;
	private String raisonSociale;
	private String adresse1;
	private String adresse2;
	private String adresse3;
	private String codePostal;
	private String ville;

	private long finExerciceLong;
	private long debutExerciceLong;

	private String finExerciceStr;
	private String debutExerciceStr;
	private String Fournisseur_Id;
	private String Mode_R;
	private String Raison_Soc;
	private boolean Histo;
	private boolean Detail;


		public MyPageEvent(String dossierId, String debutExercice, String finExercice,String Fournisseur,int Mode,String Raison,boolean Histo,boolean Detail) throws SQLException {

			this.dossierId = dossierId;

			Statement stt = con.createStatement();
			ResultSet rset = stt.executeQuery("select * from "+ base +".SOCIETE");

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.Histo=Histo;
			this.Detail=Detail;

			rset.close();

			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			debutExerciceLong = Long.parseLong(debutExercice);
			finExerciceLong = Long.parseLong(finExercice);
			Fournisseur_Id = Fournisseur;
			if (Mode==0) { Mode_R=""; }
			else {
				rset = stt.executeQuery("select Libelle from "+ base +".MODE_REGLEMENT where Mode_Reg_Id="+Mode);
				rset.next();
				Mode_R = rset.getString("Libelle");
				rset.close();
			}
			Raison_Soc=Raison;
			debutExerciceStr = formatDate.format(new Date(debutExerciceLong));
			finExerciceStr = formatDate.format(new Date(finExerciceLong));

			stt.close();
		}


    public void onStartPage(PdfWriter writer, Document document) {

    	try {

				// Entete G\u00E9n\u00E9rale


				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);

				cellEntete.setPhrase(new Phrase("Dossier : " + this.dossierId, fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Date : " + this.dateCourante, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(adresse1, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("", fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(adresse2, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);
				
				if (!adresse3.equals("")) {
					cellEntete.setPhrase(new Phrase(adresse3, fontGen));
					cellEntete.setColspan(2);
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
					entete.addCell(cellEntete);
					cellEntete.setColspan(1);
					
					cellEntete.setPhrase(new Phrase("", fontGen));
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
					entete.addCell(cellEntete);
				}

				cellEntete.setPhrase(new Phrase(codePostal + " " + ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("Ech\u00E9ancier des r\u00E8glements", new Font(Font.HELVETICA, 16, Font.BOLD)));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				if (Histo) {
					cellEntete.setPhrase(new Phrase("Historique - Fournisseurs", new Font(Font.HELVETICA, 14, Font.BOLD)));
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
					entete.addCell(cellEntete);
				}
				else {
					cellEntete.setPhrase(new Phrase("En cours - Fournisseurs", new Font(Font.HELVETICA, 14, Font.BOLD)));
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
					entete.addCell(cellEntete);
				}

				if (Detail) {
					cellEntete.setPhrase(new Phrase("D\u00E9taill\u00E9", new Font(Font.HELVETICA, 14, Font.BOLD)));
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
					entete.addCell(cellEntete);
				}

				cellEntete.setPhrase(new Phrase(""));
				cellEntete.setFixedHeight(10);
				entete.addCell(cellEntete);

        String periode = "";
        if (debutExerciceLong > 0) {
          if (finExerciceLong > 0) {
            periode = "P\u00E9riode du " + this.debutExerciceStr + " au " + this.finExerciceStr;
          } else {
            periode = "depuis le " + this.debutExerciceStr;
          }
        } else if (finExerciceLong > 0) {
          periode = "jusqu'au " + this.finExerciceStr;
        }
				cellEntete.setPhrase(new Phrase(periode, fontGen));
				cellEntete.setMinimumHeight(0);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				String Fournisseur = "";
        if (!Fournisseur_Id.equals("")) {
          Fournisseur = "Pour le fournisseur N\u00B0 " + this.Fournisseur_Id +" - "+this.Raison_Soc;
				}
				cellEntete.setPhrase(new Phrase(Fournisseur, fontGen));
				cellEntete.setMinimumHeight(0);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

        String Mode = "";
        if (!Mode_R.equals("")) {
          Mode = "Mode de r\u00E8glement : " + this.Mode_R;
				}
				cellEntete.setPhrase(new Phrase(Mode, fontGen));
				cellEntete.setMinimumHeight(0);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);


				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);

				// fin Entete G\u00E9n\u00E9rale


				// Titres de colonnes
				PdfPTable titresColonnes;
				if (Histo) {
					titresColonnes = new PdfPTable(7);
					titresColonnes.setWidthPercentage(100);
					titresColonnes.setWidths(widthsHisto);
				}
				else {
					titresColonnes = new PdfPTable(9);
					titresColonnes.setWidthPercentage(100);
					titresColonnes.setWidths(widths);
				}

				PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

				cellTitre.setFixedHeight(6);
				cellTitre.setBorder(PdfPCell.NO_BORDER);
				cellTitre.setPhrase(new Phrase(""));
				cellTitre.setPhrase(new Phrase(""));
				if (Histo)
					cellTitre.setColspan(7);
				else
					cellTitre.setColspan(9);
				titresColonnes.addCell(cellTitre);
				cellTitre.setColspan(1);

				cellTitre.setFixedHeight(20);
				cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
				cellTitre.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setPhrase(new Phrase("ECHEANCE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
				cellTitre.setPhrase(new Phrase(""));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				cellTitre.setPhrase(new Phrase("FOURNISSEUR", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("DATE DOC.", fontLine));
				titresColonnes.addCell(cellTitre);
				cellTitre.setPhrase(new Phrase("N\u00B0 PIECE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("MODE REG.", fontLine));
				titresColonnes.addCell(cellTitre);

				if (Histo) {
					cellTitre.setBorder(PdfPCell.BOX);
					cellTitre.setPhrase(new Phrase("MONTANT", fontLine));
					titresColonnes.addCell(cellTitre);
				}
				else {
					cellTitre.setPhrase(new Phrase("MONTANT", fontLine));
					titresColonnes.addCell(cellTitre);

					cellTitre.setPhrase(new Phrase("REGLE", fontLine));
					titresColonnes.addCell(cellTitre);

					cellTitre.setBorder(PdfPCell.BOX);
					cellTitre.setPhrase(new Phrase("RESTANT DU", fontLine));
					titresColonnes.addCell(cellTitre);
				}
				document.add(titresColonnes);

				// fin Titres de colonnes

			} catch(DocumentException de) {
        de.printStackTrace();
			}
		}

		public void onEndPage(PdfWriter writer, Document document) {}
		public void onOpenDocument(PdfWriter writer, Document document) {}
    public void onCloseDocument(PdfWriter writer, Document document) {}
    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
    public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
    public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
    public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

	}


private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);		// font pour lignes d'entete
private static final Font fontTotal = new Font(Font.HELVETICA , 8, Font.BOLD);		// font pour lignes de listing
private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);		// font pour lignes de listing
private static final Font fontDetail = new Font(Font.HELVETICA , 7, Font.NORMAL);		// font pour lignes de listing
private DecimalFormat numFormat = new DecimalFormat("0.00");

private int widths[] = {9,9,14,11,13,11,11,11,11}; // largeurs des colonnes du listing
private int widthsHisto[] = {9,9,14,11,11,11,13}; // largeurs des colonnes du listing de l'historique

private Connection con;
private String base;


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		try {
		con = s.getConnection(null);


		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("-");
		numFormat.setNegativePrefix("");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);

		String dossierId = s.getCookie().get("Dossier_Id");
		String id = r.getParameter("id");
		String debutExercice = r.getParameter("Date_Deb");
		String finExercice = r.getParameter("Date_Fin");
		String Fournisseur = r.getParameter("Fournisseur");
		int Mode = Integer.parseInt(r.getParameter("Mode"));
		base = s.getCookie().get("BaseDossier");
		String hist = r.getParameter("Hist");
		String det = r.getParameter("Detail");
		String tri = r.getParameter("Tri");
		boolean soustot=r.getParameter("Sous").equals("true");

		ResultSet rset;  // reglements

		PdfPTable listing;


		Document document = new Document(PageSize.A4, 20, 20, 20, 20);

		String chemin = s.getAppConfiguration().get("opensi.absdir") + "/pdf/";

		String fichierPdf = "echeances_"+ id +".pdf";

		PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));
		
		String reqReglements = "select e.*, mr.Libelle as Mode_Reglement, coalesce(if(e.Provenance='Facture',f.Date_Facture,cf.Date_Commande),0) as Date_Doc from "+ base +".ECHEANCE_FOURNISSEUR e";
		reqReglements += " left join "+ base +".FACTURE_FOURNISSEUR f on e.Provenance='Facture' and e.Document_Id=f.Facture_Id";
		reqReglements += " left join "+ base +".COMMANDE_FOURNISSEUR cf on e.Provenance='Commande' and e.Document_Id=cf.Commande_Id";
		reqReglements += " join "+ base +".MODE_REGLEMENT mr on e.Mode_Reg_Id=mr.Mode_Reg_Id";
		reqReglements += " where 1";

		boolean Histo=false;
		boolean Detail=false;
    if (det.equals("true")) {
    	Detail=true;
		}

    if (hist.equals("true")) {
    	Histo=true;
      reqReglements += " and e.Etat='R'";
     	listing = new PdfPTable(7);
   		listing.setWidthPercentage(100);
			listing.setWidths(widthsHisto);
    }
		else {
      reqReglements += " and e.Etat!='R'";
     	listing = new PdfPTable(9);
   		listing.setWidthPercentage(100);
			listing.setWidths(widths);
		}
    if (! debutExercice.equals("0")) {
      reqReglements += " and e.Date_Echeance >= " + debutExercice;
    }
    if (! finExercice.equals("0")) {
      reqReglements += " and e.Date_Echeance <= " + finExercice;
    }
    if (! Fournisseur.equals("")) {
      reqReglements += " and e.Fournisseur_Id='" + Fournisseur +"'";
    }
    if (Mode != 0) {
      reqReglements += " and e.Mode_Reg_Id=" + Mode;
    }
		if (tri.equals("Date")) {
			reqReglements += " order by e.Date_Echeance";
		}
		else if (tri.equals("Fournisseur")) {
			reqReglements += " order by e.Fournisseur_Id";
		}
		else if (tri.equals("Piece")) {
			reqReglements += " order by e.Numero";
		}
		else if (tri.equals("Mode")) {
			reqReglements += " order by Mode_Reglement";
		}
		else if (tri.equals("Montant")) {
			reqReglements += " order by e.Montant_Du";
		}
    Statement stt = con.createStatement();
    rset = stt.executeQuery(reqReglements);
		MyPageEvent event;
    if (! Fournisseur.equals("")) {
   		String reqRaison = "select Denomination from "+ base +".FICHE_FOURNISSEUR ";
    	reqRaison += " where Fournisseur_Id='"+Fournisseur+"'";
    	Statement stt2 = con.createStatement();
    	ResultSet rset2 = stt2.executeQuery(reqRaison);
			String Raison="";

			rset2.next();
			Raison = rset2.getString("Denomination");

			event = new MyPageEvent(dossierId,debutExercice,finExercice,Fournisseur,Mode,Raison,Histo,Detail);
    }
		else {
			event = new MyPageEvent(dossierId,debutExercice,finExercice,Fournisseur,Mode,"",Histo,Detail);
		}
		writer.setPageEvent(event);

    double total = 0;
    double totalRegle = 0;
    double totalRest = 0;
    double tempMont = 0;
    double tempRegle = 0;
    double tempRest = 0;
		long anc_echeance=0;
		String anc_fournisseur="";
		String anc_raisonsociale="";
		String anc_modeReg="";
		Calendar DateMois=Calendar.getInstance();
		Calendar DateAncMois=Calendar.getInstance();
		boolean premier=true;

    while (rset.next()) {
      int Ech_Id = rset.getInt("Echeance_Id");
      long echeance = rset.getLong("Date_Echeance");
      String raisonSociale = rset.getString("Denomination");
      long dateDoc = rset.getLong("Date_Doc");
      String numFact = rset.getString("Numero");
      double montant = rset.getDouble("Montant_Du");
      double montantRegl = rset.getDouble("Montant_Regle");
      double montantRest = rset.getDouble("Montant_Restant");
      String fournisseurId = rset.getString("Fournisseur_Id");
			String modeReg = rset.getString("Mode_Reglement");

      DateMois.setTimeInMillis(echeance);

			if (!premier && soustot) {
				if (tri.equals("Date") && (DateMois.get(Calendar.MONTH)!=DateAncMois.get(Calendar.MONTH))) {
					putLigneTotalMois(listing,anc_echeance,tempMont,tempRegle,tempRest,Histo);
					tempMont =0;
					tempRegle=0;
					tempRest =0;
				}
				else if (tri.equals("Fournisseur") && (!anc_fournisseur.equals(fournisseurId) || (anc_fournisseur.equals(fournisseurId) && !anc_raisonsociale.equals(raisonSociale) ))) {
					putLigneTotalFournisseur(listing,anc_fournisseur,anc_raisonsociale,tempMont,tempRegle,tempRest,Histo);
					tempMont =0;
					tempRegle=0;
					tempRest =0;
				}
				else if (tri.equals("Mode") && (!anc_modeReg.equals(modeReg))) {
					putLigneTotalMode(listing,anc_modeReg,tempMont,tempRegle,tempRest,Histo);
					tempMont =0;
					tempRegle=0;
					tempRest =0;
				}
			}
			else {
				premier=false;
			}
			DateAncMois=(Calendar)DateMois.clone();
			anc_echeance=echeance;
			anc_fournisseur=fournisseurId;
			anc_raisonsociale=raisonSociale;
			anc_modeReg=modeReg;

			tempMont += montant;
      tempRegle += montantRegl;
      tempRest += montantRest;
			double Regulariser = 0;

			if (Detail) {
				String reqDetails = "(select Date_Reg,Num_Piece,mr.Libelle as Mode_Reglement,er.Montant as Montant "+
														"from "+base+".REGLEMENT_FOURNISSEUR r join "+ base +".MODE_REGLEMENT mr on r.Mode_Reg_Id=mr.Mode_Reg_Id,"+
														base+".ECHEANCE_REGLEMENT_FOURNISSEUR er where "+
														"er.Echeance_Id="+Ech_Id+" and "+
														"er.Reglement_Id=r.Reglement_Id) UNION ("+
														"select Date_Avoir as Date_Reg,Numero as Num_Piece,"+
														"'avoir' as Mode_Reglement,ea.Montant as Montant "+
														"from "+base+".AVOIR_FOURNISSEUR a,"+base+".ECHEANCE_AVOIR_FOURNISSEUR ea where "+
														"ea.Echeance_Id="+Ech_Id+" and "+
														"ea.Avoir_Id=a.Avoir_Id"+
														") order by Date_Reg";

				String reqDetailsRegul ="select Regulariser "+
										"from "+base+".ECHEANCE_FOURNISSEUR where "+
										"Echeance_Id="+Ech_Id+";";
	    	Statement stt2 = con.createStatement();
	    	ResultSet rset2 = stt2.executeQuery(reqDetailsRegul);
				if (rset2.next()) {
        	Regulariser = rset2.getDouble("Regulariser");
				}

	    	stt2 = con.createStatement();
	    	rset2 = stt2.executeQuery(reqDetails);

				putLigneReglements(listing,echeance,fournisseurId,raisonSociale,dateDoc,numFact,modeReg,montant,montantRegl,montantRest,Histo,true);
				while (rset2.next()) {
		      long reglement = rset2.getLong("Date_Reg");
    		  numFact = rset2.getString("Num_Piece");
        	double montantregle = rset2.getDouble("Montant");
					modeReg = rset2.getString("Mode_Reglement");
					if (rset2.isLast() && Regulariser==0) {
						putLigneDetailEch(listing,reglement,numFact,modeReg,montantregle,Histo,true);
					}
					else {
						putLigneDetailEch(listing,reglement,numFact,modeReg,montantregle,Histo,false);
					}
				}
				if (Regulariser!=0) {
					putLigneDetailRegul(listing,Regulariser,Histo,true);
				}
			}
			else {
				putLigneReglements(listing,echeance,fournisseurId,raisonSociale,dateDoc,numFact,modeReg,montant,montantRegl,montantRest,Histo,false);
			}

      total += montant;
      totalRegle += montantRegl;
      totalRest += montantRest;
		}


		if (tempMont!=0 && soustot) {
			if (tri.equals("Date")) {
				putLigneTotalMois(listing,anc_echeance,tempMont,tempRegle,tempRest,Histo);
			}
			else if (tri.equals("Fournisseur")) {
				putLigneTotalFournisseur(listing,anc_fournisseur,anc_raisonsociale,tempMont,tempRegle,tempRest,Histo);
			}
			else if (tri.equals("Mode")) {
				putLigneTotalMode(listing,anc_modeReg,tempMont,tempRegle,tempRest,Histo);
			}
		}

    putTotalPeriode(listing,total,totalRegle,totalRest,Histo);

    if (!document.isOpen()) {
      document.open();
    }

		document.add(listing);

		s.closeConnection(con, null);

		if (document.isOpen()) {
			document.close();
		}

		try {
			File filePdf = new File(chemin, fichierPdf);
			filePdf.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier \u00E0 supprimer");
			se.printStackTrace();
		}

    } catch (Exception e) {
      e.printStackTrace();
    }
		return true;


	} // fin service



	/** Ajoute une ligne d'operation au listing */

	private void putLigneReglements(PdfPTable listing,
                                   long dateEch,
                                   String fournisseurId,
                                   String raisonSociale,
                                   long dateDoc,
                                   String numFact,
								String modeReg,
                                   double montant,
                                   double regle,
																	 double rest,
																	 boolean Histo,
																	boolean Encadre) {

		SimpleDateFormat formatDatePoint = new SimpleDateFormat("dd.MM.yy");

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		if (Encadre) {
			cellListing.setBorder(PdfPCell.LEFT+PdfPCell.TOP);
		}
		else {
			cellListing.setBorder(PdfPCell.LEFT);
		}
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cellListing.setPaddingRight(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(formatDatePoint.format(new Date(dateEch)), fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase(fournisseurId, fontLine));
		listing.addCell(cellListing);

		if (Encadre) {
			cellListing.setBorder(PdfPCell.RIGHT+PdfPCell.TOP);
		}
		else {
			cellListing.setBorder(PdfPCell.RIGHT);
		}

		cellListing.setPhrase(new Phrase(raisonSociale, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(dateDoc!=0?formatDatePoint.format(new Date(dateDoc)):"", fontLine));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(numFact, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase(modeReg, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(montant==0?PdfPCell.ALIGN_LEFT:PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(montant), fontLine));
		listing.addCell(cellListing);

		if (!Histo) {
			cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cellListing.setPhrase(new Phrase(regle!=0?numFormat.format(regle):"", fontLine));
			listing.addCell(cellListing);

			cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cellListing.setPhrase(new Phrase(rest!=0?numFormat.format(rest):"", fontLine));
			listing.addCell(cellListing);
		}
	}

	private void putLigneDetailEch(PdfPTable listing,
                                   long date,
                                   String numFact,
																	 String modeReg,
                                   double montant,
																	 boolean Histo,
																	 boolean Encadre) {

		SimpleDateFormat formatDatePoint = new SimpleDateFormat("dd.MM.yy");

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		if (Encadre) {
			cellListing.setBorder(PdfPCell.LEFT+PdfPCell.BOTTOM);
		}
		else {
			cellListing.setBorder(PdfPCell.LEFT);
		}
		cellListing.setPaddingRight(0);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setColspan(1);
		cellListing.setPhrase(new Phrase("", fontDetail));
		listing.addCell(cellListing);

		cellListing.setColspan(1);
		cellListing.setPhrase(new Phrase("", fontDetail));
		listing.addCell(cellListing);

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		if (Encadre) {
			cellListing.setBorder(PdfPCell.RIGHT+PdfPCell.BOTTOM);
		}
		else {
			cellListing.setBorder(PdfPCell.RIGHT);
		}

		cellListing.setColspan(1);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(10);
		cellListing.setPhrase(new Phrase(formatDatePoint.format(new Date(date)), fontDetail));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPaddingRight(0);
		cellListing.setPhrase(new Phrase("", fontDetail));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(numFact, fontDetail));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase(modeReg, fontDetail));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(montant==0?PdfPCell.ALIGN_LEFT:PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(montant), fontDetail));
		listing.addCell(cellListing);

		if (!Histo) {
			cellListing.setPhrase(new Phrase("", fontDetail));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase("", fontDetail));
			listing.addCell(cellListing);
		}
	}

	private void putLigneDetailRegul(PdfPTable listing,
                                   double montant,
																	 boolean Histo,
																	 boolean Encadre) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		if (Encadre) {
			cellListing.setBorder(PdfPCell.LEFT+PdfPCell.BOTTOM);
		}
		else {
			cellListing.setBorder(PdfPCell.LEFT);
		}

		cellListing.setPaddingRight(0);
		cellListing.setColspan(1);
		cellListing.setPhrase(new Phrase("", fontDetail));
		listing.addCell(cellListing);

		cellListing.setColspan(1);
		cellListing.setPhrase(new Phrase("", fontDetail));
		listing.addCell(cellListing);

		if (Encadre) {
			cellListing.setBorder(PdfPCell.RIGHT+PdfPCell.BOTTOM);
		}
		else {
			cellListing.setBorder(PdfPCell.RIGHT);
		}
		cellListing.setColspan(1);
		cellListing.setPaddingRight(10);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase("Regularis\u00E9", fontDetail));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPaddingRight(0);
		cellListing.setPhrase(new Phrase("", fontDetail));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase("", fontDetail));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase("", fontDetail));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(montant==0?PdfPCell.ALIGN_LEFT:PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(montant), fontDetail));
		listing.addCell(cellListing);

		if (!Histo) {
			cellListing.setPhrase(new Phrase("", fontDetail));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase("", fontDetail));
			listing.addCell(cellListing);
		}
	}

	private void putLigneTotalMois(PdfPTable listing,
                                   long mois,
                                   double montant,
                                   double regle,
																	 double rest,
																	 boolean Histo) {

		SimpleDateFormat formatDatePoint = new SimpleDateFormat("MM.yy");

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPaddingRight(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase("",fontTotal));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
		cellListing.setPhrase(new Phrase("",fontTotal));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setColspan(1);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase("Total "+formatDatePoint.format(new Date(mois)), fontTotal));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase("", fontTotal));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase("", fontTotal));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase("", fontTotal));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(montant==0?PdfPCell.ALIGN_LEFT:PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(montant),fontTotal ));
		listing.addCell(cellListing);

		if (!Histo) {
			cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cellListing.setPhrase(new Phrase(regle!=0?numFormat.format(regle):"", fontTotal));
			listing.addCell(cellListing);

			cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cellListing.setPhrase(new Phrase(rest!=0?numFormat.format(rest):"", fontTotal));
			listing.addCell(cellListing);
		}
	}
		/** Ajoute une ligne de total de la periode d'edition du journal au listing */
	private void putLigneTotalFournisseur(PdfPTable listing,
                                   String Fournisseur_Id,
                                   String Denomination,
                                   double montant,
                                   double regle,
																	 double rest,
																	 boolean Histo) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPaddingRight(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase("",fontTotal));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setColspan(2);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPhrase(new Phrase("Total "+Fournisseur_Id+" - "+Denomination, fontTotal));
		listing.addCell(cellListing);

		cellListing.setColspan(1);
		cellListing.setPhrase(new Phrase("", fontTotal));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase("", fontTotal));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase("", fontTotal));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(montant==0?PdfPCell.ALIGN_LEFT:PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(montant),fontTotal ));
		listing.addCell(cellListing);

		if (!Histo) {
			cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cellListing.setPhrase(new Phrase(regle!=0?numFormat.format(regle):"", fontTotal));
			listing.addCell(cellListing);

			cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cellListing.setPhrase(new Phrase(rest!=0?numFormat.format(rest):"", fontTotal));
			listing.addCell(cellListing);
		}
	}


	private void putLigneTotalMode(PdfPTable listing,
                                   String Mode_Reg,
                                   double montant,
                                   double regle,
																	 double rest,
																	 boolean Histo) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPaddingRight(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase("",fontTotal));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
		cellListing.setPhrase(new Phrase("",fontTotal));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setColspan(1);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase("Total "+Mode_Reg, fontTotal));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase("", fontTotal));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase("", fontTotal));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase("", fontTotal));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(montant==0?PdfPCell.ALIGN_LEFT:PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(montant),fontTotal ));
		listing.addCell(cellListing);

		if (!Histo) {
			cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cellListing.setPhrase(new Phrase(regle!=0?numFormat.format(regle):"", fontTotal));
			listing.addCell(cellListing);

			cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cellListing.setPhrase(new Phrase(rest!=0?numFormat.format(rest):"", fontTotal));
			listing.addCell(cellListing);
		}
	}


	private void putTotalPeriode(PdfPTable listing, double totalTTC, double totalRegle, double totalRest,boolean Histo) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(new Color(210,210,210));
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setColspan(2);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);

		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);

		cellListing.setColspan(4);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase("Total p\u00E9riode", fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setColspan(1);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(totalTTC), fontLine));
		listing.addCell(cellListing);

		if (!Histo) {
			cellListing.setPhrase(new Phrase(numFormat.format(totalRegle), fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase(numFormat.format(totalRest), fontLine));
			listing.addCell(cellListing);
		}
	}

} // fin GenPdfReglements




