/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'une liste d'chances
 */

package org.opensi.facturation.reglements.clients;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.opensi.api.SessionOSI;
import org.opensi.util.tools.DateTime;

public class DataEcheances {
	
	protected String dateCourante;

	protected String dossierId;
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;

	protected String debutExerciceStr = "";
	protected String finExerciceStr = "";
	
	protected String clientId = "";
	protected String modeReglement = "";
	protected String denominationClient = "";
	protected boolean detail;
	protected boolean sousTotaux;
	protected String tri;
	protected boolean historique;
	
	protected ArrayList<LigneEcheances> lignes = new ArrayList<LigneEcheances>(10);
	
	
	public DataEcheances(SessionOSI sosi, String etat, long dateDebut, long dateFin, int modeReglement, String clientId, boolean detail, String tri, boolean sousTotaux) {

		try {
			Connection con = sosi.getConnection();
			Statement stt = con.createStatement();
			String base = sosi.getBaseDossier();
			this.dossierId = sosi.getDossierId();
			this.dateCourante = DateTime.formatTime(new DateTime().getTimeInMillis(), "dd/MM/yyyy");
			if (dateDebut!=0) { this.debutExerciceStr = DateTime.formatTime(dateDebut, "dd/MM/yyyy"); }
			if (dateFin!=0) { this.finExerciceStr = DateTime.formatTime(dateFin, "dd/MM/yyyy"); }
			this.detail = detail;
			this.tri = tri;
			this.sousTotaux = sousTotaux;
			this.historique = (etat.equals("T"));
			
			// coordonnes de l'entreprise
			String reqSociete = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville";
			reqSociete += " from "+ base +".SOCIETE s";
			ResultSet rset = stt.executeQuery(reqSociete);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			rset.close();
			
			if (modeReglement != 0) {
				String reqModeReglement = "select Libelle from "+ base +".MODE_REGLEMENT where Mode_Reg_Id="+modeReglement;
				rset = stt.executeQuery(reqModeReglement);
				rset.next();
				this.modeReglement = rset.getString("Libelle");
				rset.close();
			}
			
			if (!clientId.equals("")) {
		 		String reqDenomination = "select Denomination from "+ base +".FICHE_CLIENT where Client_Id=?";
		 		PreparedStatement psDenomination = con.prepareStatement(reqDenomination);
				psDenomination.setString(1, clientId);
				rset = psDenomination.executeQuery();
				if (rset.next()) {
					this.clientId = clientId;
					this.denominationClient = rset.getString("Denomination");
				}
				rset.close();
				psDenomination.close();
			}
			
			
			String listeEcheances = "select if(fec.Facture_Id is null,'A','F') as Type, coalesce(f.Num_Entier, ac.Numero) as Num_Piece, coalesce(ec.Client_Id,'') as Client_Id, ec.Denomination,";
			listeEcheances += " ec.Date_Echeance, ec.Mode_Reg_Id, mr.Libelle as Mode_Reglement, ec.Montant as Montant_Du, ec.Montant_Restant, (ec.Montant-ec.Montant_Restant) as Montant_Regle,";
			listeEcheances += " ec.Commentaires, ec.Echeance_Id, ec.Etat, coalesce(f.Date_Facture, ac.Date_Acompte) as Date_Piece";
			listeEcheances += " from "+ base +".ECHEANCE_CLIENT ec join "+ base +".MODE_REGLEMENT mr on ec.Mode_Reg_Id=mr.Mode_Reg_Id";
			listeEcheances += " left join "+ base +".FACTURE_ECHEANCE_CLIENT fec on ec.Echeance_Id=fec.Echeance_Id left join "+ base +".FACTURE f on fec.Facture_Id=f.Facture_Id";
			listeEcheances += " left join "+ base +".ACOMPTE_ECHEANCE_CLIENT aec on ec.Echeance_Id=aec.Echeance_Id left join "+ base +".ACOMPTE_CLIENT ac on aec.Acompte_Id=ac.Acompte_Id and ac.Statut='V'";
			listeEcheances += " where (fec.Facture_Id is not null or ac.Acompte_Id is not null)";
			if (!etat.equals("0")) {
				if (etat.equals("N")) { listeEcheances += " and ec.Etat in ('N', 'P')"; }
				else { listeEcheances += " and ec.Etat='T'"; }
			}
			if (!clientId.equals("")) {
				if (this.clientId.equals("")) { listeEcheances += " and ec.Client_Id like ?"; }
				else { listeEcheances += " and ec.Client_Id=?"; }
			}
			if (dateDebut != 0) { listeEcheances += " and ec.Date_Echeance>=?"; }
			if (dateFin != 0) { listeEcheances += " and ec.Date_Echeance<=?"; }
			if (modeReglement != 0) { listeEcheances += " and ec.Mode_Reg_Id=?"; }
			
			if (tri.equals("Date")) { listeEcheances += " order by ec.Date_Echeance"; }
			else if (tri.equals("Client")) { listeEcheances += " order by Client_Id, Denomination"; }
			else if (tri.equals("Piece")) { listeEcheances += " order by Num_Piece"; }
			else if (tri.equals("Mode")) { listeEcheances += " order by Mode_Reglement"; }
			else if (tri.equals("Montant")) { listeEcheances += " order by Montant_Du"; }
			
			PreparedStatement psListeEcheances = con.prepareStatement(listeEcheances);
			int numPos = 0;
			if (!clientId.equals("")) {
				if (this.clientId.equals("")) { psListeEcheances.setString(++numPos, "%"+clientId+"%"); }
				else { psListeEcheances.setString(++numPos, clientId); }
			}
			if (dateDebut != 0) { psListeEcheances.setLong(++numPos, dateDebut); }
			if (dateFin != 0) { psListeEcheances.setLong(++numPos, dateFin); }
			if (modeReglement != 0) { psListeEcheances.setInt(++numPos, modeReglement); }
			rset = psListeEcheances.executeQuery();
			
			double total = 0;
			double totalRegle = 0;
			double totalRestant = 0;
			
			double montantTemp = 0;
			double montantRegleTemp = 0;
			double montantRestantTemp = 0;
			long ancDateEcheance=0;
			String ancClientId="";
			String ancDenomination="";
			String ancModeReglement="";
			String moisEchPrec = "";
			boolean premier=true;
			
			String reqDetails = "select Type, Date_Reg as Date_Piece, Mode_Reglement, Num_Piece, Montant, Montant_Impute, Montant_Restant from (";
			reqDetails += " select 'R' as Type, rc.Date_Reg, mr.Libelle as Mode_Reglement, rc.Num_Piece, iec.Montant, 0 as Montant_Impute, 0 as Montant_Restant";
			reqDetails += " from "+ base +".REGLEMENT_CLIENT rc join "+ base +".MODE_REGLEMENT mr on rc.Mode_Reg_Id=mr.Mode_Reg_Id";
			reqDetails += " join "+ base +".IMPUTATION_ECHEANCE_REGLEMENT_CLIENT ierc on rc.Reglement_Id=ierc.Reglement_Id";
			reqDetails += " join "+ base +".IMPUTATION_ECHEANCE_CLIENT iec on ierc.Imputation_Id=iec.Imputation_Id";
			reqDetails += " where rc.Statut='V' and iec.Echeance_Id=?";
			reqDetails += " union";
			reqDetails += " select 'A' as Type, a.Date_Avoir as Date_Piece, 'Avoir' as Mode_Reglement, a.Num_Entier as Num_Piece, iec.Montant, 0 as Montant_Impute, 0 as Montant_Restant";
			reqDetails += " from "+ base +".AVOIR a";
			reqDetails += " join "+ base +".IMPUTATION_ECHEANCE_AVOIR_CLIENT ieac on a.Avoir_Id=ieac.Avoir_Id";
			reqDetails += " join "+ base +".IMPUTATION_ECHEANCE_CLIENT iec on ieac.Imputation_Id=iec.Imputation_Id";
			reqDetails += " where a.Numero<>0 and iec.Echeance_Id=?";
			reqDetails += " ) as t order by Date_Reg";
			PreparedStatement psDetails = con.prepareStatement(reqDetails);
			
			String reqRegularisation = "select coalesce(sum(rec.Montant),0) as Regularisation";
			reqRegularisation += " from "+ base +".IMPUTATION_ECHEANCE_CLIENT iec join "+ base +".REGULARISATION_ECHEANCE_CLIENT rec on iec.Imputation_Id=rec.Imputation_Id";
			reqRegularisation += " where iec.Echeance_Id=?";
			PreparedStatement psRegularisation = con.prepareStatement(reqRegularisation);
			
			while (rset.next()) {
				int echeanceId = rset.getInt("Echeance_Id");
				
				long curDateEcheance = rset.getLong("Date_Echeance");
				String curDenomination = rset.getString("Denomination");
				String curClientId = rset.getString("Client_Id");
				String curModeReglement = rset.getString("Mode_Reglement");
				String moisEchCourant = DateTime.formatTime(curDateEcheance,"MMyy");
				
				double curMontant = rset.getDouble("Montant_Du");
				double curMontantRegle = rset.getDouble("Montant_Regle");
				double curMontantRestant = rset.getDouble("Montant_Restant");

				if (!premier && sousTotaux) {
					if (tri.equals("Date") && (!moisEchCourant.equals(moisEchPrec))) {
						LigneEcheances le = new LigneEcheances();
						le.setType('T');
						le.setDateEcheance(ancDateEcheance);
						le.setMontant(montantTemp);
						le.setMontantRegle(montantRegleTemp);
						le.setMontantRestant(montantRestantTemp);
						lignes.add(le);

						montantTemp = 0;
						montantRegleTemp = 0;
						montantRestantTemp = 0;
					}
					else if (tri.equals("Client") && (!ancClientId.equalsIgnoreCase(curClientId) || (curClientId.equalsIgnoreCase("") && !ancDenomination.equalsIgnoreCase(curDenomination) ))) {
						LigneEcheances le = new LigneEcheances();
						le.setType('T');
						le.setClientId(ancClientId);
						le.setDenomination(ancDenomination);
						le.setMontant(montantTemp);
						le.setMontantRegle(montantRegleTemp);
						le.setMontantRestant(montantRestantTemp);
						lignes.add(le);

						montantTemp = 0;
						montantRegleTemp = 0;
						montantRestantTemp = 0;
					}
					else if (tri.equals("Mode") && (!ancModeReglement.equals(curModeReglement))) {
						LigneEcheances le = new LigneEcheances();
						le.setType('T');
						le.setModeReglement(ancModeReglement);
						le.setDenomination(ancDenomination);
						le.setMontant(montantTemp);
						le.setMontantRegle(montantRegleTemp);
						le.setMontantRestant(montantRestantTemp);
						lignes.add(le);
						
						montantTemp = 0;
						montantRegleTemp = 0;
						montantRestantTemp = 0;
					}
				}
				else {
					premier=false;
				}
				moisEchPrec = moisEchCourant;
				ancDateEcheance = curDateEcheance;
				ancClientId = curClientId;
				ancDenomination=curDenomination;
				ancModeReglement=curModeReglement;

				montantTemp += curMontant;
				montantRegleTemp += curMontantRegle;
				montantRestantTemp += curMontantRestant;
				
				LigneEcheances le = new LigneEcheances();
				le.setDateEcheance(curDateEcheance);
				le.setDenomination(curDenomination);
				le.setNumPiece(rset.getString("Num_Piece"));
				le.setDatePiece(rset.getLong("Date_Piece"));
				le.setMontant(curMontant);
				le.setMontantRegle(curMontantRegle);
				le.setMontantRestant(curMontantRestant);
				le.setClientId(curClientId);
				le.setModeReglement(curModeReglement);
				le.setType('L');
				lignes.add(le);
				
				if (detail) {
					psDetails.setInt(1, echeanceId);
					psDetails.setInt(2, echeanceId);
					ResultSet rset2 = psDetails.executeQuery();
					while (rset2.next()) {
						LigneEcheances le2 = new LigneEcheances();
						le2.setNumPiece(rset2.getString("Num_Piece"));
						le2.setDatePiece(rset2.getLong("Date_Piece"));
						le2.setMontant(rset2.getDouble("Montant"));
						le2.setModeReglement(rset2.getString("Mode_Reglement"));
						le2.setType('D');
						lignes.add(le2);
					}
					rset2.close();

					double regularisation = 0;
					psRegularisation.setInt(1, echeanceId);
					rset2 = psRegularisation.executeQuery();
					if (rset2.next()) {
						regularisation = rset2.getDouble("Regularisation");
					}
					rset2.close();
					if (regularisation != 0) {
						LigneEcheances le2 = new LigneEcheances();
						le2.setMontant(regularisation);
						le2.setType('R');
						lignes.add(le2);
					}
				}

				total += curMontant;
				totalRegle += curMontantRegle;
				totalRestant += curMontantRestant;
			}
			rset.close();
			psListeEcheances.close();
			psDetails.close();
			psRegularisation.close();
			
			if (sousTotaux) {
				if (tri.equals("Date")) {
					LigneEcheances le = new LigneEcheances();
					le.setType('T');
					le.setDateEcheance(ancDateEcheance);
					le.setMontant(montantTemp);
					le.setMontantRegle(montantRegleTemp);
					le.setMontantRestant(montantRestantTemp);
					lignes.add(le);
				}
				else if (tri.equals("Client")) {
					LigneEcheances le = new LigneEcheances();
					le.setType('T');
					le.setClientId(ancClientId);
					le.setDenomination(ancDenomination);
					le.setMontant(montantTemp);
					le.setMontantRegle(montantRegleTemp);
					le.setMontantRestant(montantRestantTemp);
					lignes.add(le);
				}
				else if (tri.equals("Mode")) {
					LigneEcheances le = new LigneEcheances();
					le.setType('T');
					le.setModeReglement(ancModeReglement);
					le.setDenomination(ancDenomination);
					le.setMontant(montantTemp);
					le.setMontantRegle(montantRegleTemp);
					le.setMontantRestant(montantRestantTemp);
					lignes.add(le);
				}
			}
			
			LigneEcheances le = new LigneEcheances();
			le.setType('G');
			le.setMontant(total);
			le.setMontantRegle(totalRegle);
			le.setMontantRestant(totalRestant);
			lignes.add(le);
			
			stt.close();

		}
		catch(Exception e) {
			e.printStackTrace();
		}			
	}
	
	
	public int getNbLignes() {
		return lignes.size();
	}


} // fin DataEcheances
