/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.reglements.clients;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;

import org.experlog.openeas.api.Session;



public class CalculReglement {

	private String clientId;
	private String denomination;
	private double montant;
	private double montantInitial;
	private double montantReglement;
	private String base;
	private Session s;
	private int nbLignes;
	private HashMap<String, String> tabReglements=new HashMap<String, String>();
	private HashMap<String, String> tabAvoirs=new HashMap<String, String>();
	private ResultSet rset;
	private Statement st;



	public CalculReglement (String sess, String base, String clientId, String denomination, double montant, double montantReglement) {
		try {
			this.base=base;
			this.clientId=clientId;
			this.denomination=denomination;
			this.montant=montant;
			this.montantInitial=montant;
			this.montantReglement=montantReglement;
			
			this.nbLignes=0;
			this.s = Session.findClient(sess);
			Connection c = s.getConnection(null);
			st = c.createStatement();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public boolean liste() {
		try {

			String sqlCountRegl = "select sum(nb) as nbLignes from (";
			sqlCountRegl += "select 'R' as Type, count(Reglement_Id) as nb from " + base + ".REGLEMENT_CLIENT where Statut='V' and Etat in ('N','P')";
			if (clientId.equals("")) {
				sqlCountRegl += " and Client_Id is null and Denomination = '"+s.sqlEncode(denomination)+"'";
			} else {
				sqlCountRegl += " and Client_Id = '"+s.sqlEncode(clientId)+"'";
			}
			sqlCountRegl += " union";
			sqlCountRegl += " select 'A' as Type, count(Avoir_Id) as nb from " + base + ".AVOIR where Numero<>0 and Etat in ('N','P')";
			if (clientId.equals("")) {
				sqlCountRegl += " and Client_Id='' and Denomination = '"+s.sqlEncode(denomination)+"'";
			} else {
				sqlCountRegl += " and Client_Id = '"+s.sqlEncode(clientId)+"'";
			}
			sqlCountRegl += ") as t";
			rset = st.executeQuery(sqlCountRegl);
			if (rset.next()) {
				nbLignes=rset.getInt("nbLignes");
			}
			
			String sqlListeRegl = "select Reglement_Id, Date_Reglement, Montant_Restant, Type from (";
			sqlListeRegl += " select Reglement_Id, Date_Reg as Date_Reglement, Montant_Restant, 'R' as Type";
			sqlListeRegl += " from " + base + ".REGLEMENT_CLIENT where Statut='V' and Etat in ('N','P')";
			if (clientId.equals("")) {
				sqlListeRegl += " and Client_Id is null and Denomination = '"+s.sqlEncode(denomination)+"'";
			} else {
				sqlListeRegl += " and Client_Id = '"+s.sqlEncode(clientId)+"'";
			}
			sqlListeRegl += " union";
			sqlListeRegl += " select Avoir_Id as Reglement_Id, Date_Avoir as Date_Reglement, Montant_Restant, 'A' as Type";
			sqlListeRegl += " from " + base + ".AVOIR where Numero<>0 and Etat in ('N','P')";
			if (clientId.equals("")) {
				sqlListeRegl += " and Client_Id='' and Denomination = '"+s.sqlEncode(denomination)+"'";
			} else {
				sqlListeRegl += " and Client_Id = '"+s.sqlEncode(clientId)+"'";
			}
			sqlListeRegl += ") as t order by Type, Date_Reglement";
			rset = st.executeQuery(sqlListeRegl);

			
			while (rset.next()) {
				String tree[]=new String [4];
				tree[0]=rset.getString("Reglement_Id");
				tree[1]=rset.getString("Type");
				tree[2]=rset.getString("Montant_Restant");
				tree[3]=rset.getString("Date_Reglement");
				if (tree[1].equals("R")) {
					tabReglements.put(tree[0],"0.00");
				} else {
					tabAvoirs.put(tree[0],"0.00");
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
		return true;
	}

	
	public String getMontant_Impute(String reglementId, String type) {
		String montantImpute;
		if (type.equals("R")) { montantImpute = tabReglements.get(reglementId); }
		else { montantImpute = tabAvoirs.get(reglementId); }
		return montantImpute;
	}
}
