/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.transcompta;

import java.sql.*;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.api.SessionOSI;


public class TransfertAnnulRegulEcheancesFournisseur extends TransfertCompta {

	private String compteFournisseursDivers;

	private PreparedStatement psCpteFournisseur;

	private String codeJournal;
	private int echeanceId;


	public TransfertAnnulRegulEcheancesFournisseur(SessionOSI sosi, String codeJournal, int echeanceId) throws Exception {

		super(sosi);
		this.codeJournal = codeJournal;
		this.echeanceId = echeanceId;
	}


	public void transfert() throws Exception {

		Statement stt = con.createStatement();

		ResultSet rset = stt.executeQuery("select Numero_Compte_Fournisseurs, Numero_Compte_Regul_AC from "+ baseDossier +".PARAM_DOSSIER");
		rset.next();

		compteFournisseursDivers = rset.getString("Numero_Compte_Fournisseurs");
		String compteRegul = rset.getString("Numero_Compte_Regul_AC");

		psCpteFournisseur = con.prepareStatement("select c.Numero_Compte from "+ baseDossier +".FICHE_FOURNISSEUR e,"+ baseDossier +".COMPTE c where e.Fournisseur_Id=? and e.Numero_Compte=c.Numero_Compte");

		rset = stt.executeQuery("select * from "+ baseDossier +".ECHEANCE_FOURNISSEUR where Echeance_Id="+ echeanceId);

		if (rset.next()) {
			String fournisseurId = rset.getString("Fournisseur_Id");
			String numPiece = rset.getString("Numero");
			double regul = rset.getDouble("Montant_Restant");

			long dateOp = System.currentTimeMillis();

			Ecriture ecriture = new Ecriture();
			ecriture.setCodeJournal(codeJournal);
			ecriture.setDateEcriture(dateOp);

			if (regul>0) {
				String compteFournisseur = getCompteFournisseur(fournisseurId);

				Operation op = new Operation();
				op.setDateOp(dateOp);
				op.setNumPiece(numPiece);
				op.setNumeroCompte(compteFournisseur);
				op.setLibelle(getIntitule(compteFournisseur));
				op.setMontantC(regul);

				ecriture.addOperation(op);

				op = new Operation();
				op.setDateOp(dateOp);
				op.setNumPiece(numPiece);
				op.setNumeroCompte(compteRegul);
				op.setLibelle(getIntitule(compteRegul));
				op.setMontantD(regul);

				ecriture.addOperation(op);
			}

			validerEcriture(ecriture, echeanceId, dateOp);
		}
	}


	protected void marquerDocument(int voidId) throws SQLException {

	}

	private String getCompteFournisseur(String fournisseurId) throws SQLException {

		if (fournisseurId.equals("")) {
			return compteFournisseursDivers;
		}
		else {
			psCpteFournisseur.setString(1, fournisseurId);
			ResultSet rset = psCpteFournisseur.executeQuery();

			if (rset.next()) {
				return rset.getString("Numero_Compte");
			}
			else {
				return compteFournisseursDivers;
			}
		}
	}


} // fin TransfertAnnulRegulEcheancesFournisseur
