/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.transcompta;

import java.sql.*;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.api.SessionOSI;

import org.opensi.util.sql.SqlUtils;


public class TransfertAnnulRegulAvoirsClient extends TransfertCompta {

	private String codeJournal;
	private String listeId;
	private String compteClientsDivers;

	private PreparedStatement psCpteClient;
	private PreparedStatement psMarqueRegul;


	public TransfertAnnulRegulAvoirsClient(SessionOSI sosi, String codeJournal, String listeId) throws Exception {

		super(sosi);
		this.codeJournal = codeJournal;
		this.listeId = (listeId.length()==0?"-1":SqlUtils.normalizeCSList(listeId));
	}


	public void transfert() throws Exception {

		Statement stt = con.createStatement();

		ResultSet rset = stt.executeQuery("select Numero_Compte_Clients, Numero_Compte_Regul_VE from "+ baseDossier +".PARAM_DOSSIER");
		rset.next();

		compteClientsDivers = rset.getString("Numero_Compte_Clients");
		String compteRegul = rset.getString("Numero_Compte_Regul_VE");

		psCpteClient = con.prepareStatement("select c.Numero_Compte from "+ baseDossier +".FICHE_CLIENT e,"+ baseDossier +".COMPTE c where e.Client_Id=? and e.Numero_Compte=c.Numero_Compte");

		psMarqueRegul = con.prepareStatement("update "+ baseDossier +".REGULARISATION_AVOIR_CLIENT set Compta_Annul=1 where Regularisation_Id=?");

		rset = stt.executeQuery("select ra.*, a.Num_Entier as Num_Piece, coalesce(a.Client_Id,'') as Client_Id from "+ baseDossier +".REGULARISATION_AVOIR_CLIENT ra join "+ baseDossier +".IMPUTATION_AVOIR_CLIENT i on ra.Imputation_Id=i.Imputation_Id"
														+" join "+ baseDossier +".AVOIR a on a.Avoir_Id=i.Avoir_Id where ra.Comptabilise=1 and ra.Compta_Annul=0 and ra.Regularisation_Id in ("+ listeId +")");

		if (rset.next()) {

			String clientId = rset.getString("Client_Id");
			String numPiece = rset.getString("Num_Piece");
			double montant = rset.getDouble("Montant");
			int regularisationId = rset.getInt("Regularisation_Id");
			long dateAnnul = rset.getLong("Date_Annul");

			Ecriture ecriture = new Ecriture();
			ecriture.setCodeJournal(codeJournal);
			ecriture.setDateEcriture(dateAnnul);

			if (montant>0) {
				String compteClient = getCompteClient(clientId);

				Operation op = new Operation();
				op.setDateOp(dateAnnul);
				op.setNumPiece(numPiece);
				op.setNumeroCompte(compteClient);
				op.setLibelle(getIntitule(compteClient));
				op.setMontantC(montant);

				ecriture.addOperation(op);

				op = new Operation();
				op.setDateOp(dateAnnul);
				op.setNumPiece(numPiece);
				op.setNumeroCompte(compteRegul);
				op.setLibelle(getIntitule(compteRegul));
				op.setMontantD(montant);

				ecriture.addOperation(op);

				validerEcriture(ecriture, regularisationId, dateAnnul);
			}
		}
	}


	protected void marquerDocument(int regularisationId) throws SQLException {

		psMarqueRegul.setInt(1, regularisationId);
		psMarqueRegul.executeUpdate();
	}


	private String getCompteClient(String clientId) throws SQLException {

		if (clientId.equals("")) {
			return compteClientsDivers;
		}
		else {
			psCpteClient.setString(1, clientId);
			ResultSet rset = psCpteClient.executeQuery();

			if (rset.next()) {
				return rset.getString("Numero_Compte");
			}
			else {
				return compteClientsDivers;
			}
		}
	}


} // fin TransfertAnnulRegulAvoirsClient
