/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un inventaire au format standard
 */

package org.opensi.facturation.actions.inventaire;


import org.opensi.util.pdf.MultiPagesDocument;
import org.opensi.util.pdf.PdfWidths;
import org.opensi.util.pdf.TableBuilder;
import org.opensi.util.tools.Formatter;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;


public class InventaireStd extends MultiPagesDocument {


private static final Font font9N = new Font(Font.HELVETICA, 9, Font.NORMAL);
private static final Font font9G = new Font(Font.HELVETICA, 9, Font.BOLD);
private static final Font fontTotaux = new Font(Font.HELVETICA, 10, Font.BOLD);

private Formatter ftQte = new Formatter("0.###");
private Formatter ftInv = new Formatter("00000");

private DataInventaire id;	   // les donnes dynamiques de l'inventaire

private float[] widthsCols;
private int nbCols;


  public InventaireStd(String tempdir, DataInventaire id) throws Exception {

		super(tempdir);		
		
		this.id = id;
		
		PdfWidths pw = new PdfWidths();		
		pw.addColonneFixe(25);
		pw.addColonneVariableMinMax(2, 30, 40);
		pw.addColonneFixe(5);
		pw.addColonneVariableMinMax(1, 10, 15);
		pw.addColonneVariableMinMax(1, 10, 15);
		if (id.typeEdition.equals("R"))	pw.addColonneVariableMinMax(1, 10, 15);
		nbCols = pw.getNbCols();
		widthsCols = pw.getWidthsCols();
	
	}

	
	/* implmentation des fonctions de MultiPagesDocument */
	
	public PdfPTable firstHeader() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();		
		tb.add(makeEntete());
		tb.add(makeSpace(10));
		tb.add(makeEntetesColonnes());
		tb.add(makeSpace(5));
		
		return tb.getTable();	
	}
	
	
	public PdfPTable middleHeader(int lastLine) throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(firstHeader());
		
		return tb.getTable();
	}
	
	
	public PdfPTable lastFooter() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		if (id.typeEdition.equals("R")) {
			tb.add(makeCadreTotal());
			tb.add(makeSpace(40));
		}
		
		return tb.getTable();
	}	
	
	
	public PdfPTable middleFooter(int nbLinesPage, int lastLine) throws DocumentException {
	
		TableBuilder tb = new TableBuilder();
		
		return tb.getTable();		
	}
	
	
	public PdfPTable bodyLine(int numLine) throws DocumentException {
	
		LigneInventaire li = id.lignes.get(numLine);
	
		return makeLineInventaire(li);
	}
	
	
	public PdfPTable emptyLine(float emptyHeight) throws DocumentException {
		
		PdfPTable pptSpace = new PdfPTable(nbCols);
		pptSpace.setWidthPercentage(100);
		pptSpace.setWidths(widthsCols);
		
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPaddingBottom(0);
		cell.setPaddingTop(0);
		cell.setFixedHeight(emptyHeight);		
		cell.setPhrase(new Phrase(""));		
	
		for (int i=0; i<nbCols; i++) {
			pptSpace.addCell(cell);
		}
	
		return pptSpace;
	}
	
	
	public int nbLines() {
	
		return id.getNbLignes();
	}
	
	
	public int nbEx() {
	
		return 1;
	}
	
	
	public Image imageFond() {
		return null;
	}



	/* mthodes internes */

	private PdfPTable makeSpace(int space) {
	
		PdfPTable pptSpace = new PdfPTable(1);
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setFixedHeight(space);
		cell.setPhrase(new Phrase(""));
	
		pptSpace.addCell(cell);
	
		return pptSpace;
	}
	

	private PdfPTable makeEntete() throws DocumentException {
	
		PdfPTable pptEntete = new PdfPTable(3);
		pptEntete.setWidthPercentage(100);
		
		PdfPCell cellEntete = new PdfPCell(pptEntete.getDefaultCell());
		cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellEntete.setBorder(PdfPCell.NO_BORDER);
		cellEntete.setMinimumHeight(10);

		cellEntete.setPhrase(new Phrase("Dossier : "+ id.dossierId, font9N));
		pptEntete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(id.raisonSociale, font9N));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		pptEntete.addCell(cellEntete);
		cellEntete.setColspan(1);

		cellEntete.setPhrase(new Phrase("Date : "+ id.dateCourante, font9N));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		pptEntete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(id.adresse1, font9N));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		pptEntete.addCell(cellEntete);
		cellEntete.setColspan(1);

		cellEntete.setPhrase(new Phrase("", font9N));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		pptEntete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(id.adresse2, font9N));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		pptEntete.addCell(cellEntete);
		cellEntete.setColspan(1);

		cellEntete.setPhrase(new Phrase("Page : "+ currentPage, font9N));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		pptEntete.addCell(cellEntete);
		
		if (!id.adresse3.equals("")) {
			cellEntete.setPhrase(new Phrase(id.adresse3, font9N));
			cellEntete.setColspan(2);
			cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			pptEntete.addCell(cellEntete);
			cellEntete.setColspan(1);
			
			cellEntete.setPhrase(new Phrase("", font9N));
			cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			pptEntete.addCell(cellEntete);
		}

		cellEntete.setPhrase(new Phrase(id.codePostal +" "+ id.ville, font9N));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		pptEntete.addCell(cellEntete);

		if (id.typeEdition.equals("E")) {
			cellEntete.setPhrase(new Phrase("Edition des carts pour l'Inventaire "+ (id.typeInventaire.equalsIgnoreCase("C")?"Complet":"Partiel") +" N\u00B0 "+ ftInv.get(id.inventaireId), new Font(Font.HELVETICA, 16, Font.BOLD)));
		} else {
			cellEntete.setPhrase(new Phrase("Inventaire "+ (id.typeInventaire.equalsIgnoreCase("C")?"Complet":"Partiel") +" N\u00B0 "+ ftInv.get(id.inventaireId), new Font(Font.HELVETICA, 16, Font.BOLD)));
		}
		cellEntete.setColspan(3);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		pptEntete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(""));
		cellEntete.setFixedHeight(10);
		pptEntete.addCell(cellEntete);
		
		if (id.criteres.length()>0) {
			cellEntete.setPhrase(new Phrase(id.criteres, font9N));
			cellEntete.setMinimumHeight(0);
			cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
			pptEntete.addCell(cellEntete);
		}
		
		PdfPTable pptCadre = new PdfPTable(1);
		pptCadre.setWidthPercentage(100);
		pptCadre.addCell(new PdfPCell(pptEntete));

		return pptCadre;
	}
	
	
	private PdfPTable makeEntetesColonnes() throws DocumentException {
	
		PdfPTable pptCols = new PdfPTable(nbCols);
		pptCols.setWidthPercentage(100);
		pptCols.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptCols.getDefaultCell());
		cell.setMinimumHeight(30);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

		cell.setPhrase(new Phrase("R\u00E9f\u00E9rence", font9G));
		pptCols.addCell(cell);

		cell.setPhrase(new Phrase("D\u00E9signation", font9G));
		pptCols.addCell(cell);
		
		cell.setPhrase(new Phrase("Unit\u00E9", font9G));
		pptCols.addCell(cell);

		cell.setPhrase(new Phrase("Quantit\u00E9\ninformatique", font9G));
		pptCols.addCell(cell);

		cell.setPhrase(new Phrase("Quantit\u00E9\nphysique", font9G));
		pptCols.addCell(cell);
		
		if (id.typeEdition.equals("R")) {
			cell.setPhrase(new Phrase("Valorisation", font9G));
			pptCols.addCell(cell);
		}

		return pptCols;
	}	
	
	
	private PdfPTable makeLineInventaire(LigneInventaire li) throws DocumentException {
		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		
		cell.setPaddingLeft(5);
		cell.setPaddingRight(0);
		cell.setPhrase(new Phrase(li.refArticle, font9N));
		pptLine.addCell(cell);

		cell.setPhrase(new Phrase(li.designation, font9N));
		pptLine.addCell(cell);
		
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPaddingLeft(0);
		cell.setPaddingRight(0);
		cell.setPhrase(new Phrase(li.unite, font9N));
		pptLine.addCell(cell);

		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setPaddingRight(5);
		cell.setPhrase(new Phrase(ftQte.get((li.stockInfo<0?0:li.stockInfo)), font9N));
		pptLine.addCell(cell);

		if (id.typeEdition.equals("V")) {
			cell.setPhrase(new Phrase("", font9N));
		} else {
			cell.setPhrase(new Phrase(ftQte.get((li.stockPhysique<0?0:li.stockPhysique)), font9N));
		}
		pptLine.addCell(cell);
		
		if (id.typeEdition.equals("R")) {
			cell.setPhrase(new Phrase(ftQte.get(li.valorisation), font9N));
			pptLine.addCell(cell);
		}

		return pptLine;
	}
	
	
	private PdfPTable makeCadreTotal() throws DocumentException {
		PdfPTable pptLine = new PdfPTable(1);
		pptLine.setWidthPercentage(100);

		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setBorder(PdfPCell.NO_BORDER);
		
		cell.setPaddingLeft(5);
		cell.setPaddingRight(5);
		cell.setPhrase(new Phrase("Total Valorisation : "+ ftQte.get(id.totalValorisation), fontTotaux));
		pptLine.addCell(cell);

		return pptLine;
	}

} // fin InventaireStd
