/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *   Export des donnes pour IDEP
 */

package org.opensi.facturation.actions.idep;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;


public class GenExportIdep extends Action {
		
public boolean serverSide() { return true; }
	
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {
		
		String fichier = r.getParameter("Fichier");
		String format = r.getParameter("Format");
		String absdir = s.getAppConfiguration().get("opensi.absdir");
		
		String periode = r.getParameter("Periode");
		String typeExport = r.getParameter("TypeExport");
		
		long debutPeriode = 0;
		long finPeriode = 0;
		long dateReedition = Long.parseLong(r.getParameter("DateReedition"));

		if (periode.equals("DD")) {
			debutPeriode = DateTime.parseDate(r.getParameter("DateDebut"), "yyyy:MM:dd");
			finPeriode = DateTime.parseDate(r.getParameter("DateFin"), "yyyy:MM:dd");
		}
		else {
			DateTime cd = new DateTime();
			int currentYear = cd.getYear();
			int currentMonth = cd.getMonth();

			DateTime dtDeb = new DateTime();
			DateTime dtFin = new DateTime();

			if (periode.equals("MC")) {
				dtDeb = new DateTime(1, currentMonth, currentYear);
				dtFin = new DateTime();
			}
			else if (periode.equals("MP")) {
				dtDeb = new DateTime(1, currentMonth-1, currentYear);
				dtFin = new DateTime(cd.previousMaxDay(), currentMonth-1, currentYear);
			}

			debutPeriode = dtDeb.getDateInMillis();
			finPeriode = dtFin.getDateFullTime();
		}
		
		DataExportIdep dei = new DataExportIdep(s, debutPeriode, finPeriode, dateReedition, typeExport);
		
		String action_error = "";
		if (dei.getNbLignes() != 0) {
			String buffer = absdir +"/iobuffer/";
			if (format.equals("INTR")) {
				new TxtExportIntracom(buffer, fichier, dei);
			} else {
				new CsvExportDeclaration(buffer, fichier, dei);
			}
		} else {
			action_error = "Aucun rsultat !";
		}
		
		r.addParameter("ActionError", action_error);
		
		return true;
	}
	
	
} // fin GenExportIdep
